/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java_cup.runtime.Symbol;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SqlScanner;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TStringLiteral;

public class StringLiteral
extends LiteralExpr {
    private final String value_;
    public static int MAX_STRING_LEN = Integer.MAX_VALUE;
    private final boolean needsUnescaping_;

    public StringLiteral(String value) {
        this(value, ScalarType.STRING, true);
    }

    public StringLiteral(String value, Type type, boolean needsUnescaping) {
        this.value_ = value;
        this.type_ = type;
        this.needsUnescaping_ = needsUnescaping;
    }

    protected StringLiteral(StringLiteral other) {
        super(other);
        this.value_ = other.value_;
        this.needsUnescaping_ = other.needsUnescaping_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        StringLiteral other = (StringLiteral)that;
        return this.needsUnescaping_ == other.needsUnescaping_ && this.type_.equals(other.type_) && this.value_.equals(other.value_);
    }

    @Override
    public int hashCode() {
        return this.value_.hashCode();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return "'" + this.getNormalizedValue() + "'";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.STRING_LITERAL;
        String val = this.needsUnescaping_ ? this.getUnescapedValue() : this.value_;
        msg.string_literal = new TStringLiteral(val);
    }

    public String getValueWithOriginalEscapes() {
        return this.value_;
    }

    public String getUnescapedValue() {
        return MetastoreShim.unescapeSQLString("'" + this.getNormalizedValue() + "'");
    }

    private String getNormalizedValue() {
        int len = this.value_.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char currentChar = this.value_.charAt(i);
            if (currentChar == '\\' && i + 1 < len) {
                char nextChar = this.value_.charAt(i + 1);
                if (nextChar == '\"' || nextChar == '\'' || nextChar == '\\') {
                    if (nextChar != '\"') {
                        sb.append(currentChar);
                    }
                    sb.append(nextChar);
                    ++i;
                    continue;
                }
                sb.append(currentChar);
                continue;
            }
            if (currentChar == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    @Override
    public String getStringValue() {
        return this.getValueWithOriginalEscapes();
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value_).toString();
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        Preconditions.checkState((targetType.isNumericType() || targetType.isDateOrTimeType() || targetType.equals(this.type_) || targetType.isStringType() ? 1 : 0) != 0);
        if (targetType.equals(this.type_)) {
            return this;
        }
        if (targetType.isStringType()) {
            this.type_ = targetType;
        } else {
            if (targetType.isNumericType()) {
                return this.convertToNumber(targetType);
            }
            if (targetType.isDateOrTimeType()) {
                return new CastExpr(targetType, (Expr)this, compatibility);
            }
        }
        return this;
    }

    public LiteralExpr convertToNumber(Type targetType) throws AnalysisException {
        Symbol sym;
        StringReader reader = new StringReader(this.value_);
        SqlScanner scanner = new SqlScanner(reader);
        boolean negative = false;
        try {
            sym = scanner.next_token();
            while (sym.sym == 246) {
                negative = !negative;
                sym = scanner.next_token();
            }
        }
        catch (IOException e) {
            throw new AnalysisException("Failed to convert string literal to number.", e);
        }
        if (sym.sym == 262) {
            throw new AnalysisException("Number too large: " + this.value_);
        }
        if (sym.sym == 263) {
            BigDecimal val = (BigDecimal)sym.value;
            if (negative) {
                val = val.negate();
            }
            return new NumericLiteral(val, targetType);
        }
        if (sym.sym == 264) {
            BigDecimal val = (BigDecimal)sym.value;
            if (negative) {
                val = val.negate();
            }
            return new NumericLiteral(val, targetType);
        }
        throw new AnalysisException("Failed to convert string literal '" + this.value_ + "' to number.");
    }

    @Override
    public int compareTo(LiteralExpr o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        StringLiteral other = (StringLiteral)o;
        String thisValue = this.needsUnescaping_ ? this.getUnescapedValue() : this.value_;
        String otherValue = other.needsUnescaping_ ? other.getUnescapedValue() : other.getStringValue();
        return thisValue.compareTo(otherValue);
    }

    @Override
    public Expr clone() {
        return new StringLiteral(this);
    }
}

