/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.impala.common.AnalysisException;

public class StorageHandlerUri {
    public static final ImmutableSet<String> supportedStorageTypes = ImmutableSet.of((Object)"kudu");
    private String storageType_;
    private String storageUrl_;

    public StorageHandlerUri(String storageHandlerUri) throws AnalysisException, URISyntaxException {
        if (storageHandlerUri.equals("*://*")) {
            this.storageType_ = "*";
            this.storageUrl_ = "*";
            return;
        }
        String[] res = storageHandlerUri.split(":\\/\\/", 2);
        if (res.length == 2 && supportedStorageTypes.contains((Object)res[0].toLowerCase()) && res[1].equals("*")) {
            this.storageType_ = res[0];
            this.storageUrl_ = "*";
            return;
        }
        URI uri = new URI(storageHandlerUri);
        if (!supportedStorageTypes.contains((Object)uri.getScheme())) {
            throw new AnalysisException("The storage type \"" + uri.getScheme() + "\" is not supported. A storage handler URI should be in the form of <storage_type>://<hostname>[:<port>]/<path_to_resource>.");
        }
        if (uri.getHost() == null) {
            throw new AnalysisException("A storage handler URI should be in the form of <storage_type>://<hostname>[:<port>]/<path_to_resource>.");
        }
        this.storageType_ = uri.getScheme();
        this.storageUrl_ = uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort()) + uri.getPath();
    }

    String getStorageType() {
        return this.storageType_;
    }

    String getStoreUrl() {
        return this.storageUrl_;
    }
}

