/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.ResetMetadataStmt;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.TableMask;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeIncompleteTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.catalog.Table;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.Frontend;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.TUniqueIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmtMetadataLoader {
    private static final Logger LOG = LoggerFactory.getLogger(StmtMetadataLoader.class);
    private final long DEBUG_LOGGING_NUM_CATALOG_UPDATES = 10L;
    private final long RETRY_LOAD_NUM_CATALOG_UPDATES = 20L;
    private final Frontend fe_;
    private final String sessionDb_;
    private final EventSequence timeline_;
    private final User user_;
    private final TUniqueId queryId_;
    private final Set<String> dbs_ = new HashSet<String>();
    private final Map<TableName, FeTable> loadedOrFailedTbls_ = new HashMap<TableName, FeTable>();
    private int numLoadRequestsSent_ = 0;
    private int numCatalogUpdatesReceived_ = 0;

    public StmtMetadataLoader(Frontend fe, String sessionDb, EventSequence timeline, User user, TUniqueId queryId) {
        this.fe_ = (Frontend)Preconditions.checkNotNull((Object)fe);
        this.sessionDb_ = (String)Preconditions.checkNotNull((Object)sessionDb);
        this.timeline_ = timeline;
        this.user_ = user;
        this.queryId_ = queryId;
    }

    public StmtMetadataLoader(Frontend fe, String sessionDb, EventSequence timeline) {
        this(fe, sessionDb, timeline, null, null);
    }

    public EventSequence getTimeline() {
        return this.timeline_;
    }

    public int getNumLoadRequestsSent() {
        return this.numLoadRequestsSent_;
    }

    public int getNumCatalogUpdatesReceived() {
        return this.numCatalogUpdatesReceived_;
    }

    public StmtTableCache loadTables(StatementBase stmt) throws InternalException {
        Set<TableName> requiredTables = this.collectTableCandidates(stmt);
        return this.loadTables(requiredTables);
    }

    public StmtTableCache loadTables(Set<TableName> tbls) throws InternalException {
        Preconditions.checkState((this.dbs_.isEmpty() && this.loadedOrFailedTbls_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.numLoadRequestsSent_ == 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.numCatalogUpdatesReceived_ == 0 ? 1 : 0) != 0);
        FeCatalog catalog = this.fe_.getCatalog();
        HashMap<TableName, FeTable> missingTblsSnapshot = new HashMap<TableName, FeTable>();
        Set<TableName> missingTbls = this.getMissingTables(catalog, tbls, missingTblsSnapshot);
        if (missingTbls.isEmpty()) {
            if (this.timeline_ != null) {
                this.timeline_.markEvent(String.format("Metadata of all %d tables cached", this.loadedOrFailedTbls_.size()));
            }
            this.fe_.getImpaladTableUsageTracker().recordTableUsage(this.loadedOrFailedTbls_.keySet());
            return new StmtTableCache(catalog, this.dbs_, this.loadedOrFailedTbls_);
        }
        if (this.timeline_ != null) {
            this.timeline_.markEvent("Metadata load started");
        }
        long startTimeMs = System.currentTimeMillis();
        HashSet<TableName> requestedTbls = new HashSet<TableName>();
        boolean issueLoadRequest = true;
        while (!missingTbls.isEmpty()) {
            FeCatalog currCatalog;
            boolean hasCatalogRestarted;
            if (issueLoadRequest) {
                catalog.prioritizeLoad(missingTbls, this.queryId_);
                ++this.numLoadRequestsSent_;
                requestedTbls.addAll(missingTbls);
            }
            boolean bl = hasCatalogRestarted = (currCatalog = this.fe_.getCatalog()) != catalog;
            if (hasCatalogRestarted && LOG.isWarnEnabled()) {
                LOG.warn(String.format("Catalog restart detected while waiting for table metadata. Current catalog service id: %s. Previous catalog service id: %s", TUniqueIdUtil.PrintId(currCatalog.getCatalogServiceId()), TUniqueIdUtil.PrintId(catalog.getCatalogServiceId())));
            }
            catalog = currCatalog;
            if ((hasCatalogRestarted || this.numCatalogUpdatesReceived_ > 0 && (long)this.numCatalogUpdatesReceived_ % 10L == 0L) && LOG.isInfoEnabled()) {
                long endTimeMs = System.currentTimeMillis();
                LOG.info(String.format("Waiting for table metadata. Waited for %d catalog updates and %dms. Tables remaining: %s", this.numCatalogUpdatesReceived_, endTimeMs - startTimeMs, missingTbls));
            }
            catalog.waitForCatalogUpdate(2000L);
            Set<TableName> newMissingTbls = this.getMissingTables(catalog, missingTbls, missingTblsSnapshot);
            boolean bl2 = issueLoadRequest = hasCatalogRestarted || !missingTbls.containsAll(newMissingTbls);
            if (!issueLoadRequest && this.numCatalogUpdatesReceived_ > 0 && (long)this.numCatalogUpdatesReceived_ % 20L == 0L) {
                issueLoadRequest = true;
                if (LOG.isInfoEnabled()) {
                    long endTimeMs = System.currentTimeMillis();
                    LOG.info(String.format("Re-sending prioritized load request. Waited for %d catalog updates and %dms.", this.numCatalogUpdatesReceived_, endTimeMs - startTimeMs));
                }
            }
            missingTbls = newMissingTbls;
            ++this.numCatalogUpdatesReceived_;
        }
        if (this.timeline_ != null) {
            long storageLoadTimeNano = 0L;
            storageLoadTimeNano = this.loadedOrFailedTbls_.values().stream().filter(Table.class::isInstance).map(Table.class::cast).filter(loadedTbl -> requestedTbls.contains(loadedTbl.getTableName())).mapToLong(Table::getStorageLoadTime).sum();
            this.timeline_.markEvent(String.format("Metadata load finished. loaded-tables=%d/%d load-requests=%d catalog-updates=%d storage-load-time=%dms", requestedTbls.size(), this.loadedOrFailedTbls_.size(), this.numLoadRequestsSent_, this.numCatalogUpdatesReceived_, TimeUnit.MILLISECONDS.convert(storageLoadTimeNano, TimeUnit.NANOSECONDS)));
            if (MetastoreShim.getMajorVersion() > 2L) {
                StringBuilder validIdsBuf = new StringBuilder("Loaded ValidWriteIdLists");
                validIdsBuf.append(" for transactional tables: ");
                boolean hasAcidTbls = false;
                for (FeTable iTbl : this.loadedOrFailedTbls_.values()) {
                    if (iTbl instanceof FeIncompleteTable || !AcidUtils.isTransactionalTable(iTbl.getMetaStoreTable().getParameters())) continue;
                    validIdsBuf.append("\n");
                    validIdsBuf.append("           ");
                    validIdsBuf.append(iTbl.getValidWriteIds().writeToString());
                    hasAcidTbls = true;
                }
                validIdsBuf.append("\n");
                validIdsBuf.append("             ");
                if (hasAcidTbls) {
                    this.timeline_.markEvent(validIdsBuf.toString());
                }
            }
        }
        this.fe_.getImpaladTableUsageTracker().recordTableUsage(this.loadedOrFailedTbls_.keySet());
        return new StmtTableCache(catalog, this.dbs_, this.loadedOrFailedTbls_);
    }

    private Set<TableName> getMissingTables(FeCatalog catalog, Set<TableName> tbls, Map<TableName, FeTable> missingTblsSnapshot) {
        HashSet<TableName> missingTbls = new HashSet<TableName>();
        HashSet<TableName> viewTbls = new HashSet<TableName>();
        for (TableName tblName : tbls) {
            FeDb db;
            if (this.loadedOrFailedTbls_.containsKey(tblName) || (db = catalog.getDb(tblName.getDb())) == null) continue;
            this.dbs_.add(tblName.getDb());
            FeTable tbl = db.getTable(tblName.getTbl());
            if (tbl == null) continue;
            if (!tbl.isLoaded() || tbl instanceof FeIncompleteTable && ((FeIncompleteTable)tbl).isLoadFailedByRecoverableError()) {
                missingTblsSnapshot.putIfAbsent(tblName, tbl);
            }
            if (!tbl.isLoaded() || missingTblsSnapshot.get(tblName) == tbl) {
                missingTbls.add(tblName);
                continue;
            }
            this.loadedOrFailedTbls_.put(tblName, tbl);
            if (tbl instanceof FeView) {
                viewTbls.addAll(this.collectTableCandidates(((FeView)tbl).getQueryStmt()));
            } else if (tbl instanceof MaterializedViewHdfsTable) {
                Set<TableName> mvSrcTableNames = this.collectTableCandidates(((MaterializedViewHdfsTable)tbl).getQueryStmt());
                ((MaterializedViewHdfsTable)tbl).addSrcTables(mvSrcTableNames);
                viewTbls.addAll(mvSrcTableNames);
            }
            if (tbl instanceof FeIncompleteTable || !this.fe_.getAuthzFactory().getAuthorizationConfig().isEnabled() || !this.fe_.getAuthzFactory().supportsTableMasking() || this.user_ == null) continue;
            try {
                viewTbls.addAll(this.collectPolicyTables(tbl));
            }
            catch (Exception e) {
                LOG.error("Failed to collect policy tables for {}", (Object)tblName, (Object)e);
            }
        }
        if (!viewTbls.isEmpty()) {
            missingTbls.addAll(this.getMissingTables(catalog, viewTbls, missingTblsSnapshot));
        }
        return missingTbls;
    }

    private Set<TableName> collectTableCandidates(StatementBase stmt) {
        Preconditions.checkNotNull((Object)stmt);
        ArrayList<TableRef> tblRefs = new ArrayList<TableRef>();
        if (stmt instanceof ResetMetadataStmt && this.fe_.getAuthzFactory().getAuthorizationConfig().isEnabled() && this.fe_.getAuthzFactory().supportsTableMasking() && !BackendConfig.INSTANCE.allowCatalogCacheOpFromMaskedUsers()) {
            TableName tableName = ((ResetMetadataStmt)stmt).getTableName();
            if (tableName != null) {
                tblRefs.add(new TableRef(tableName.toPath(), null));
            }
        } else {
            stmt.collectTableRefs(tblRefs);
        }
        HashSet<TableName> tableNames = new HashSet<TableName>();
        for (TableRef ref : tblRefs) {
            tableNames.addAll(Path.getCandidateTables(ref.getPath(), this.sessionDb_));
        }
        return tableNames;
    }

    @VisibleForTesting
    Set<TableName> collectPolicyTables(FeTable tbl) throws InternalException, AnalysisException {
        if (tbl instanceof FeIncompleteTable) {
            return Collections.emptySet();
        }
        HashSet<TableName> tableNames = new HashSet<TableName>();
        String dbName = tbl.getDb().getName();
        String tblName = tbl.getName();
        List<Column> columns = tbl.getColumnsInHiveOrder();
        TableMask tableMask = new TableMask(this.fe_.getAuthzChecker(), dbName, tblName, columns, this.user_);
        if (tableMask.needsMaskingOrFiltering()) {
            for (Column col : columns) {
                SelectStmt stmt = tableMask.createColumnMaskStmt(col.getName(), col.getType(), null);
                if (stmt == null) continue;
                tableNames.addAll(this.collectTableCandidates(stmt));
            }
            SelectStmt filterStmt = tableMask.createRowFilterStmt(null);
            if (filterStmt != null) {
                tableNames.addAll(this.collectTableCandidates(filterStmt));
            }
        }
        return tableNames;
    }

    public static final class StmtTableCache {
        public final FeCatalog catalog;
        public final Set<String> dbs;
        public final Map<TableName, FeTable> tables;

        public StmtTableCache(FeCatalog catalog, Set<String> dbs, Map<TableName, FeTable> tables) {
            this.catalog = (FeCatalog)Preconditions.checkNotNull((Object)catalog);
            this.dbs = (Set)Preconditions.checkNotNull(dbs);
            this.tables = (Map)Preconditions.checkNotNull(tables);
            this.validate();
        }

        private void validate() {
            for (TableName tbl : this.tables.keySet()) {
                Preconditions.checkState((boolean)this.dbs.contains(tbl.getDb()));
            }
        }
    }
}

