/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.NotImplementedException;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriter;

public abstract class StatementBase
extends StmtNode {
    protected boolean isExplain_ = false;
    protected Analyzer analyzer_;

    protected StatementBase() {
    }

    protected StatementBase(StatementBase other) {
        this.analyzer_ = other.analyzer_;
        this.isExplain_ = other.isExplain_;
    }

    public void collectTableRefs(List<TableRef> tblRefs) {
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        if (this.isExplain_) {
            analyzer.setIsExplain();
        }
        this.analyzer_ = analyzer;
    }

    public List<String> getColLabels() {
        return Collections.emptyList();
    }

    public void setColLabels(List<String> colLabels) {
        List<String> oldLabels = this.getColLabels();
        if (oldLabels == colLabels) {
            return;
        }
        oldLabels.clear();
        oldLabels.addAll(colLabels);
    }

    public List<Expr> getResultExprs() {
        return Collections.emptyList();
    }

    public void castResultExprs(List<Type> types) throws AnalysisException {
        List<Expr> resultExprs = this.getResultExprs();
        Preconditions.checkNotNull(resultExprs);
        Preconditions.checkState((resultExprs.size() == types.size() ? 1 : 0) != 0);
        for (int i = 0; i < types.size(); ++i) {
            if (resultExprs.get(i).getType().equals(types.get(i))) continue;
            resultExprs.set(i, resultExprs.get(i).castTo(types.get(i)));
        }
    }

    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        throw new IllegalStateException("rewriteExprs() not implemented for this stmt: " + this.getClass().getSimpleName());
    }

    public Analyzer getAnalyzer() {
        return this.analyzer_;
    }

    public boolean isAnalyzed() {
        return this.analyzer_ != null;
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return "";
    }

    public void setIsExplain() {
        this.isExplain_ = true;
    }

    public boolean isExplain() {
        return this.isExplain_;
    }

    public StatementBase clone() {
        throw new NotImplementedException("Clone() not implemented for " + this.getClass().getSimpleName());
    }

    public void reset() {
        this.analyzer_ = null;
    }

    public static Expr checkTypeCompatibility(String dstTableName, Column dstCol, Expr srcExpr, Analyzer analyzer, Expr widestTypeSrcExpr) throws AnalysisException {
        if (widestTypeSrcExpr != null && widestTypeSrcExpr.isImplicitCast()) {
            Expr exprWithoutImplicitCast = widestTypeSrcExpr.ignoreImplicitCast();
            if (srcExpr.getType().isVarchar() && exprWithoutImplicitCast.getType().isChar()) {
                ScalarType varcharType = (ScalarType)srcExpr.getType();
                ScalarType charType = (ScalarType)exprWithoutImplicitCast.getType();
                Preconditions.checkState((varcharType.getLength() >= charType.getLength() ? 1 : 0) != 0);
                ScalarType newCharType = ScalarType.createCharType(varcharType.getLength());
                CastExpr newCharExpr = new CastExpr(newCharType, srcExpr);
                return StatementBase.checkTypeCompatibilityHelper(dstTableName, dstCol, newCharExpr, analyzer, null);
            }
        }
        return StatementBase.checkTypeCompatibilityHelper(dstTableName, dstCol, srcExpr, analyzer, widestTypeSrcExpr);
    }

    private static Expr checkTypeCompatibilityHelper(String dstTableName, Column dstCol, Expr srcExpr, Analyzer analyzer, Expr widestTypeSrcExpr) throws AnalysisException {
        Type dstColType = dstCol.getType();
        Type srcExprType = srcExpr.getType();
        if (widestTypeSrcExpr == null) {
            widestTypeSrcExpr = srcExpr;
        }
        if (dstColType.equals(srcExprType) && !dstColType.isComplexType()) {
            return srcExpr;
        }
        TypeCompatibility permissiveCompatibility = analyzer.getPermissiveCompatibilityLevel();
        TypeCompatibility compatibilityLevel = analyzer.getRegularCompatibilityLevel();
        Type compatType = Type.getAssignmentCompatibleType(srcExprType, dstColType, compatibilityLevel);
        if (compatType.isInvalid() && permissiveCompatibility.isUnsafe()) {
            Optional<Expr> expr = srcExpr.getFirstNonConstSourceExpr();
            if (expr.isPresent()) {
                throw new AnalysisException(String.format("Unsafe implicit cast is prohibited for non-const expression: %s ", expr.get().toSql()));
            }
            compatType = Type.getAssignmentCompatibleType(srcExprType, dstColType, permissiveCompatibility);
            compatibilityLevel = permissiveCompatibility;
        }
        if (!compatType.isValid()) {
            throw new AnalysisException(String.format("Target table '%s' is incompatible with source expressions.\nExpression '%s' (type: %s) is not compatible with column '%s' (type: %s)", dstTableName, srcExpr.toSql(), srcExprType.toSql(), dstCol.getName(), dstColType.toSql()));
        }
        if (!(compatType.equals(dstColType) || compatType.isNull() || permissiveCompatibility.isUnsafe())) {
            throw new AnalysisException(String.format("Possible loss of precision for target table '%s'.\nExpression '%s' (type: %s) would need to be cast to %s for column '%s'", dstTableName, widestTypeSrcExpr.toSql(), srcExprType.toSql(), dstColType.toSql(), dstCol.getName()));
        }
        return srcExpr.castTo(compatType, compatibilityLevel);
    }
}

