/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.ExprUtil;

public class SortInfo {
    private static final float SORT_MATERIALIZATION_COST_THRESHOLD = 10.0f;
    private List<Expr> sortExprs_;
    private List<Expr> origSortExprs_;
    private final List<Boolean> isAscOrder_;
    private final List<Boolean> nullsFirstParams_;
    private TupleDescriptor sortTupleDesc_;
    private final List<Expr> materializedExprs_;
    private final ExprSubstitutionMap outputSmap_;
    private final TSortingOrder sortingOrder_;
    private int numLexicalKeysInZOrder_ = 0;

    public SortInfo(List<Expr> sortExprs, List<Boolean> isAscOrder, List<Boolean> nullsFirstParams) {
        this(sortExprs, isAscOrder, nullsFirstParams, TSortingOrder.LEXICAL);
    }

    public SortInfo(List<Expr> sortExprs, List<Boolean> isAscOrder, List<Boolean> nullsFirstParams, TSortingOrder sortingOrder) {
        Preconditions.checkArgument((sortExprs.size() == isAscOrder.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((sortExprs.size() == nullsFirstParams.size() ? 1 : 0) != 0);
        this.sortExprs_ = sortExprs;
        this.origSortExprs_ = Expr.cloneList(this.sortExprs_);
        this.isAscOrder_ = isAscOrder;
        this.nullsFirstParams_ = nullsFirstParams;
        this.materializedExprs_ = new ArrayList<Expr>();
        this.outputSmap_ = new ExprSubstitutionMap();
        this.sortingOrder_ = sortingOrder;
    }

    private SortInfo(SortInfo other) {
        this.sortExprs_ = Expr.cloneList(other.sortExprs_);
        this.isAscOrder_ = Lists.newArrayList(other.isAscOrder_);
        this.nullsFirstParams_ = Lists.newArrayList(other.nullsFirstParams_);
        this.materializedExprs_ = Expr.cloneList(other.materializedExprs_);
        this.sortTupleDesc_ = other.sortTupleDesc_;
        this.outputSmap_ = other.outputSmap_.clone();
        this.sortingOrder_ = other.sortingOrder_;
        this.numLexicalKeysInZOrder_ = other.numLexicalKeysInZOrder_;
    }

    public List<Expr> getSortExprs() {
        return this.sortExprs_;
    }

    public List<Expr> getOrigSortExprs() {
        return this.origSortExprs_;
    }

    public List<Boolean> getIsAscOrder() {
        return this.isAscOrder_;
    }

    public List<Boolean> getNullsFirstParams() {
        return this.nullsFirstParams_;
    }

    public List<Expr> getMaterializedExprs() {
        return this.materializedExprs_;
    }

    public TupleDescriptor getSortTupleDescriptor() {
        return this.sortTupleDesc_;
    }

    public ExprSubstitutionMap getOutputSmap() {
        return this.outputSmap_;
    }

    public TSortingOrder getSortingOrder() {
        return this.sortingOrder_;
    }

    public int getNumLexicalKeysInZOrder() {
        return this.numLexicalKeysInZOrder_;
    }

    public void setNumLexicalKeysInZOrder(int numLexicalKeysInZOrder) {
        this.numLexicalKeysInZOrder_ = numLexicalKeysInZOrder;
    }

    public List<Boolean> getNullsFirst() {
        Preconditions.checkState((this.sortExprs_.size() == this.nullsFirstParams_.size() ? 1 : 0) != 0);
        ArrayList<Boolean> nullsFirst = new ArrayList<Boolean>();
        for (int i = 0; i < this.sortExprs_.size(); ++i) {
            nullsFirst.add(OrderByElement.nullsFirst(this.nullsFirstParams_.get(i), this.isAscOrder_.get(i)));
        }
        return nullsFirst;
    }

    public void materializeRequiredSlots(Analyzer analyzer, ExprSubstitutionMap smap) {
        Preconditions.checkNotNull((Object)this.sortTupleDesc_);
        Preconditions.checkState((boolean)this.sortTupleDesc_.isMaterialized());
        analyzer.materializeSlots(this.sortExprs_);
        List<SlotDescriptor> sortTupleSlotDescs = this.sortTupleDesc_.getSlots();
        ArrayList<Expr> materializedExprs = new ArrayList<Expr>();
        for (int i = 0; i < sortTupleSlotDescs.size(); ++i) {
            if (!sortTupleSlotDescs.get(i).isMaterialized()) continue;
            materializedExprs.add(this.materializedExprs_.get(i));
        }
        List<Expr> substMaterializedExprs = Expr.substituteList(materializedExprs, smap, analyzer, false);
        analyzer.materializeSlots(substMaterializedExprs);
    }

    public void substituteSortExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.sortExprs_ = Expr.substituteList(this.sortExprs_, smap, analyzer, false);
    }

    public void checkConsistency() {
        Preconditions.checkState((this.materializedExprs_.size() == this.sortTupleDesc_.getSlots().size() ? 1 : 0) != 0);
        for (Expr sortExpr : this.sortExprs_) {
            Preconditions.checkState((boolean)sortExpr.isBound(this.sortTupleDesc_.getId()));
        }
    }

    public SortInfo clone() {
        return new SortInfo(this);
    }

    public void createSortTupleInfo(List<Expr> resultExprs, Analyzer analyzer) {
        Preconditions.checkState((this.sortTupleDesc_ == null ? 1 : 0) != 0);
        Preconditions.checkState((this.outputSmap_.size() == 0 ? 1 : 0) != 0);
        this.sortTupleDesc_ = analyzer.getDescTbl().createTupleDescriptor("sort");
        this.sortTupleDesc_.setIsMaterialized(true);
        this.addMaterializedExprs(this.getMaterializedSortExprs(), analyzer);
        LinkedHashSet inputSlotRefs = new LinkedHashSet();
        IsInputSlotRefPred pred = new IsInputSlotRefPred(this.sortTupleDesc_.getId());
        TreeNode.collect(Expr.substituteList(resultExprs, this.outputSmap_, analyzer, false), pred, inputSlotRefs);
        TreeNode.collect(Expr.substituteList(this.sortExprs_, this.outputSmap_, analyzer, false), pred, inputSlotRefs);
        this.addMaterializedExprs(inputSlotRefs, analyzer);
        ArrayList tupleIsNullPreds = new ArrayList();
        TreeNode.collect(resultExprs, Predicates.instanceOf(TupleIsNullPredicate.class), tupleIsNullPreds);
        Expr.removeDuplicates(tupleIsNullPreds);
        this.addMaterializedExprs(tupleIsNullPreds, analyzer);
        this.substituteSortExprs(this.outputSmap_, analyzer);
        this.checkConsistency();
    }

    public <T extends Expr> void addMaterializedExprs(Collection<T> exprs, Analyzer analyzer) {
        Preconditions.checkNotNull((Object)this.sortTupleDesc_);
        for (Expr srcExpr : exprs) {
            SlotDescriptor dstSlotDesc;
            if (srcExpr instanceof SlotRef) {
                SlotDescriptor srcSlotDesc = ((SlotRef)srcExpr).getDesc();
                dstSlotDesc = analyzer.copySlotDescriptor(srcSlotDesc, this.sortTupleDesc_);
            } else {
                dstSlotDesc = analyzer.addSlotDescriptor(this.sortTupleDesc_);
                dstSlotDesc.initFromExpr(srcExpr);
            }
            dstSlotDesc.setSourceExpr(srcExpr);
            SlotRef dstExpr = new SlotRef(dstSlotDesc);
            Type dstType = dstSlotDesc.getType();
            if (dstType.isStructType() && dstSlotDesc.getItemTupleDesc() != null) {
                try {
                    dstExpr.reExpandStruct(analyzer);
                }
                catch (AnalysisException ex) {
                    Preconditions.checkNotNull(null);
                }
            } else if (dstType.isCollectionType()) {
                dstSlotDesc.setShouldMaterializeRecursively(true);
            }
            this.outputSmap_.put(srcExpr.clone(), dstExpr);
            this.materializedExprs_.add(srcExpr);
        }
    }

    public long estimateTopNMaterializedSize(long cardinality, long offset) {
        long totalRows = PlanNode.checkedAdd(cardinality, offset);
        return this.estimateMaterializedSize(totalRows);
    }

    public long estimateMaterializedSize(long totalRows) {
        this.getSortTupleDescriptor().computeMemLayout();
        return (long)Math.ceil(this.getSortTupleDescriptor().getAvgSerializedSize() * (float)totalRows);
    }

    private List<Expr> getMaterializedSortExprs() {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr sortExpr : this.sortExprs_) {
            if (sortExpr.hasCost() && !(sortExpr.getCost() > 10.0f) && !sortExpr.contains(Expr.IS_NONDETERMINISTIC_BUILTIN_FN_PREDICATE) && !sortExpr.contains(Expr.IS_UDF_PREDICATE)) continue;
            result.add(sortExpr);
        }
        return result;
    }

    public ProcessingCost computeProcessingCost(String label, long inputCardinality) {
        float weight = ExprUtil.computeExprsTotalCost(this.getSortExprs());
        return ProcessingCost.basicCost(label, inputCardinality, weight);
    }

    public static boolean isValidInSortingTuple(Type type) {
        if (type.isCollectionType()) {
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return SortInfo.isValidInSortingTuple(arrayType.getItemType());
            }
            Preconditions.checkState((boolean)(type instanceof MapType));
            MapType mapType = (MapType)type;
            if (!SortInfo.isValidInSortingTuple(mapType.getKeyType())) {
                return false;
            }
            return SortInfo.isValidInSortingTuple(mapType.getValueType());
        }
        if (type.isStructType()) {
            StructType structType = (StructType)type;
            return SortInfo.isValidStructInSortingTuple(structType);
        }
        return true;
    }

    private static boolean isValidStructInSortingTuple(StructType structType) {
        for (StructField field : structType.getFields()) {
            Type fieldType = field.getType();
            if (!(fieldType.isStructType() ? !SortInfo.isValidStructInSortingTuple((StructType)fieldType) : fieldType.isCollectionType())) continue;
            return false;
        }
        return true;
    }

    private class IsInputSlotRefPred
    implements Predicate<Expr> {
        private final TupleId sortTid_;

        public IsInputSlotRefPred(TupleId sortTid) {
            this.sortTid_ = sortTid;
        }

        public boolean apply(Expr e) {
            return e instanceof SlotRef && !e.isBound(this.sortTid_);
        }
    }
}

