/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TSlotRef;

public class SlotRef
extends Expr {
    protected List<String> rawPath_;
    protected final String label_;
    protected SlotDescriptor desc_;
    protected Path resolvedPath_ = null;
    protected boolean isZippingUnnest_ = false;
    static final Comparator SLOTREF_EQ_CMP = new Comparator(){

        @Override
        public boolean matches(SlotRef a, SlotRef b) {
            return a.localEquals(b);
        }
    };

    public SlotRef(List<String> rawPath) {
        this.rawPath_ = rawPath;
        this.label_ = ToSqlUtils.getPathSql(this.rawPath_);
    }

    public SlotRef(String alias) {
        this.rawPath_ = null;
        this.label_ = ToSqlUtils.getIdentSql(alias.toLowerCase());
    }

    public SlotRef(SlotDescriptor desc) {
        if (desc.isScanSlot()) {
            this.resolvedPath_ = desc.getPath();
            this.rawPath_ = this.resolvedPath_.getRawPath();
        } else {
            this.rawPath_ = null;
        }
        this.desc_ = desc;
        this.type_ = desc.getType();
        this.evalCost_ = 1.0f;
        String alias = desc.getParent().getAlias();
        this.label_ = (alias != null ? alias + "." : "") + desc.getLabel();
        this.numDistinctValues_ = this.adjustNumDistinctValues();
        if (this.type_.isStructType()) {
            this.addStructChildrenAsSlotRefs();
        }
        this.analysisDone();
    }

    protected SlotRef(SlotRef other) {
        super(other);
        this.resolvedPath_ = other.resolvedPath_;
        if (other.rawPath_ != null) {
            this.rawPath_ = new ArrayList<String>();
            this.rawPath_.addAll(other.rawPath_);
        } else {
            this.rawPath_ = null;
        }
        this.label_ = other.label_;
        this.desc_ = other.desc_;
        this.isZippingUnnest_ = other.isZippingUnnest_;
    }

    private long adjustNumDistinctValues() {
        Preconditions.checkNotNull((Object)this.desc_);
        Preconditions.checkNotNull((Object)this.desc_.getStats());
        long numDistinctValues = this.desc_.getStats().getNumDistinctValues();
        if (numDistinctValues == 0L && this.desc_.getIsNullable() && (this.desc_.getStats().hasNulls() || !this.desc_.getStats().hasNullsStats())) {
            numDistinctValues = 1L;
        }
        return numDistinctValues;
    }

    @Override
    public SlotRef reset() {
        if (this.type_.isStructType()) {
            this.clearChildren();
        }
        super.reset();
        return this;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.rawPath_ != null ? 1 : 0) != 0);
        try {
            this.resolvedPath_ = analyzer.resolvePathWithMasking(this.rawPath_, Path.PathType.SLOT_REF);
        }
        catch (TableLoadingException e) {
            Preconditions.checkState((boolean)false);
        }
        Preconditions.checkNotNull((Object)this.resolvedPath_);
        this.desc_ = analyzer.registerSlotRef(this.resolvedPath_, false);
        this.type_ = this.desc_.getType();
        if (!this.type_.isSupported()) {
            throw new UnsupportedFeatureException("Unsupported type '" + this.type_.toSql() + "' in '" + this.toSql() + "'.");
        }
        if (this.type_.isInvalid()) {
            throw new UnsupportedFeatureException("Unsupported type in '" + this.toSql() + "'.");
        }
        if (!this.resolvedPath_.getMatchedTypes().isEmpty()) {
            analyzer.registerColumnForMasking(this.desc_);
        }
        this.numDistinctValues_ = this.adjustNumDistinctValues();
        FeTable rootTable = this.resolvedPath_.getRootTable();
        if (rootTable != null && rootTable.getNumRows() > 0L) {
            this.numDistinctValues_ = Math.min(this.numDistinctValues_, rootTable.getNumRows());
        }
        if (this.type_.isStructType()) {
            this.addStructChildrenAsSlotRefs();
            this.checkForUnsupportedStructFeatures();
        }
    }

    public void reExpandStruct(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.type_ != null && this.type_.isStructType() ? 1 : 0) != 0);
        this.desc_.clearItemTupleDesc();
        this.children_.clear();
        analyzer.createStructTuplesAndSlotDescs(this.desc_);
        this.addStructChildrenAsSlotRefs();
        this.checkForUnsupportedStructFeatures();
    }

    public void checkForUnsupportedStructFeatures() throws AnalysisException {
        FeTable rootTable;
        Preconditions.checkState((boolean)(this.type_ instanceof StructType));
        for (Expr child : this.getChildren()) {
            Type fieldType = child.getType();
            if (!fieldType.isSupported()) {
                throw new AnalysisException("Unsupported type '" + fieldType.toSql() + "' in '" + this.toSql() + "'.");
            }
            if (!fieldType.isStructType()) continue;
            Preconditions.checkState((boolean)(child instanceof SlotRef));
            ((SlotRef)child).checkForUnsupportedStructFeatures();
        }
        if (this.resolvedPath_ != null && (rootTable = this.resolvedPath_.getRootTable()) != null) {
            this.checkTableTypeSupportsStruct(rootTable);
            if (rootTable instanceof FeFsTable) {
                this.checkFileFormatSupportsStruct((FeFsTable)rootTable);
            }
        }
    }

    private void checkTableTypeSupportsStruct(FeTable feTable) throws AnalysisException {
        if (!(feTable instanceof FeFsTable) && !(feTable instanceof IcebergMetadataTable)) {
            throw new AnalysisException(String.format("%s is not supported when querying STRUCT type %s", feTable, this.type_.toSql()));
        }
    }

    private void checkFileFormatSupportsStruct(FeFsTable feFsTable) throws AnalysisException {
        for (HdfsFileFormat format : feFsTable.getFileFormats()) {
            if (format == HdfsFileFormat.PARQUET || format == HdfsFileFormat.ORC || format == HdfsFileFormat.ICEBERG) continue;
            throw new AnalysisException("Querying STRUCT is only supported for ORC and Parquet file formats.");
        }
    }

    private void addStructChildrenAsSlotRefs() {
        Preconditions.checkState((boolean)this.desc_.getType().isStructType());
        TupleDescriptor structTuple = this.desc_.getItemTupleDesc();
        Preconditions.checkState((structTuple != null ? 1 : 0) != 0);
        for (SlotDescriptor childSlot : structTuple.getSlots()) {
            SlotRef childSlotRef = new SlotRef(childSlot);
            this.children_.add(childSlotRef);
        }
    }

    @Override
    protected boolean shouldCollectRecursively() {
        return this.desc_ == null || !this.desc_.getType().isStructType();
    }

    @Override
    protected float computeEvalCost() {
        return 1.0f;
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    public boolean hasDesc() {
        return this.desc_ != null;
    }

    public SlotDescriptor getDesc() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        Preconditions.checkNotNull((Object)this.desc_);
        return this.desc_;
    }

    public List<String> getRawPath() {
        return this.rawPath_;
    }

    public SlotId getSlotId() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        Preconditions.checkNotNull((Object)this.desc_);
        return this.desc_.getId();
    }

    public Path getResolvedPath() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        return this.desc_.getPath();
    }

    public void setIsZippingUnnest(boolean b) {
        this.isZippingUnnest_ = b;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.label_ != null) {
            return this.label_;
        }
        if (this.rawPath_ != null) {
            return ToSqlUtils.getPathSql(this.rawPath_);
        }
        return "<slot " + Integer.toString(this.desc_.getId().asInt()) + ">";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((boolean)false, (Object)"Unexpected use of old toThrift() signature");
    }

    @Override
    protected void toThrift(TExprNode msg, ThriftSerializationCtx serialCtx) {
        msg.node_type = TExprNodeType.SLOT_REF;
        msg.slot_ref = new TSlotRef(serialCtx.translateSlotId(this.desc_.getId()).asInt());
        Preconditions.checkState((boolean)this.desc_.isMaterialized(), (Object)String.format("Illegal reference to non-materialized slot: tid=%s sid=%s", this.desc_.getParent().getId(), this.desc_.getId()));
        Preconditions.checkState((this.desc_.getByteOffset() >= 0 ? 1 : 0) != 0);
        this.desc_.getParent().checkIsExecutable();
        if (this.desc_.getItemTupleDesc() != null) {
            this.desc_.getItemTupleDesc().checkIsExecutable();
        }
    }

    @Override
    public String debugString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper((Object)this);
        if (this.label_ != null) {
            toStrHelper.add("label", (Object)this.label_);
        }
        if (this.rawPath_ != null) {
            toStrHelper.add("path", (Object)Joiner.on((char)'.').join(this.rawPath_));
        }
        toStrHelper.add("type", (Object)this.type_.toSql());
        String idStr = this.desc_ == null ? "null" : Integer.toString(this.desc_.getId().asInt());
        toStrHelper.add("id", (Object)idStr);
        return toStrHelper.toString();
    }

    @Override
    public int hashCode() {
        if (this.desc_ != null) {
            return this.desc_.getId().hashCode();
        }
        if (this.label_ != null) {
            return this.label_.toLowerCase().hashCode();
        }
        return super.localHash();
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        SlotRef other = (SlotRef)that;
        if (this.desc_ != null && other.desc_ != null) {
            return this.desc_.getId().equals(other.desc_.getId());
        }
        return this.label_ == null ? other.label_ == null : this.label_.equalsIgnoreCase(other.label_);
    }

    @Override
    protected Expr substituteImpl(ExprSubstitutionMap smap, Analyzer analyzer) {
        Expr substExpr;
        if (smap != null && (substExpr = smap.get(this)) != null) {
            return substExpr.clone();
        }
        this.substituteImplOnChildren(smap, analyzer);
        return this;
    }

    @Override
    public boolean isBoundByTupleIds(List<TupleId> tids) {
        Preconditions.checkState((this.desc_ != null ? 1 : 0) != 0);
        if (this.isZippingUnnest_ && this.desc_.getParent() != null && this.desc_.getParent().getRootDesc() != null) {
            TupleId parentId = this.desc_.getParent().getRootDesc().getId();
            for (TupleId tid : tids) {
                if (!tid.equals(parentId)) continue;
                return true;
            }
        }
        for (TupleDescriptor enclosingTupleDesc : this.desc_.getEnclosingTupleDescs()) {
            if (!tids.contains(enclosingTupleDesc.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBoundBySlotIds(List<SlotId> slotIds) {
        Preconditions.checkState((boolean)this.isAnalyzed());
        if (slotIds.contains(this.desc_.getId())) {
            return true;
        }
        for (SlotDescriptor enclosingSlotDesc : this.desc_.getEnclosingStructSlotDescs()) {
            if (!slotIds.contains(enclosingSlotDesc.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getIdsHelper(Set<TupleId> tupleIds, Set<SlotId> slotIds) {
        Preconditions.checkState((boolean)this.type_.isValid());
        Preconditions.checkState((this.desc_ != null ? 1 : 0) != 0);
        if (slotIds != null) {
            slotIds.add(this.desc_.getId());
        }
        if (tupleIds != null) {
            tupleIds.add(this.desc_.getParent().getId());
        }
        if (this.desc_.getType().isStructType() && slotIds != null) {
            TupleDescriptor itemTupleDesc = this.desc_.getItemTupleDesc();
            Preconditions.checkState((itemTupleDesc != null ? 1 : 0) != 0);
            itemTupleDesc.getSlotsRecursively().stream().forEach(slotDesc -> slotIds.add(slotDesc.getId()));
        }
    }

    @Override
    public boolean referencesTuple(TupleId tid) {
        Preconditions.checkState((boolean)this.type_.isValid());
        Preconditions.checkState((this.desc_ != null ? 1 : 0) != 0);
        return this.desc_.getParent().getId() == tid;
    }

    @Override
    public Expr clone() {
        return new SlotRef(this);
    }

    @Override
    public String toString() {
        boolean closeParen;
        StringBuilder buf = new StringBuilder();
        if (this.rawPath_ != null) {
            buf.append(String.join((CharSequence)".", this.rawPath_));
        } else if (this.label_ != null) {
            buf.append(this.label_);
        }
        boolean bl = closeParen = buf.length() > 0;
        if (closeParen) {
            buf.append(" (");
        }
        if (this.desc_ != null) {
            buf.append("tid=").append(this.desc_.getParent().getId()).append(" sid=").append(this.desc_.getId());
        } else {
            buf.append("no desc set");
        }
        if (closeParen) {
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        if (this.type_.isNull()) {
            return NullLiteral.create(targetType);
        }
        return super.uncheckedCastTo(targetType, compatibility);
    }

    @Override
    public boolean shouldConvertToCNF() {
        return true;
    }

    static interface Comparator {
        public boolean matches(SlotRef var1, SlotRef var2);
    }
}

