/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.CollectionStructType;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.thrift.TSlotDescriptor;
import org.apache.impala.thrift.TVirtualColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(SlotDescriptor.class);
    private final SlotId id_;
    private final TupleDescriptor parent_;
    private Path path_;
    private Type type_;
    private TupleDescriptor itemTupleDesc_;
    private String label_;
    private List<Expr> sourceExprs_ = new ArrayList<Expr>();
    private boolean isMaterialized_ = false;
    private boolean shouldMaterializeRecursively_ = false;
    private boolean isNullable_ = true;
    private int byteSize_;
    private int byteOffset_;
    private int nullIndicatorByte_;
    private int nullIndicatorBit_;
    private int slotIdx_;
    private ColumnStats stats_;

    SlotDescriptor(SlotId id, TupleDescriptor parent) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)parent);
        this.id_ = id;
        this.parent_ = parent;
        this.byteOffset_ = -1;
    }

    SlotDescriptor(SlotId id, TupleDescriptor parent, SlotDescriptor src) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)parent);
        this.id_ = id;
        this.parent_ = parent;
        this.type_ = src.type_;
        this.itemTupleDesc_ = src.itemTupleDesc_;
        if (this.itemTupleDesc_ != null) {
            this.itemTupleDesc_.setParentSlotDesc(this);
        }
        this.path_ = src.path_;
        this.label_ = src.label_;
        this.sourceExprs_ = src.sourceExprs_;
        this.isMaterialized_ = src.isMaterialized_;
        this.isNullable_ = src.isNullable_;
        this.byteSize_ = src.byteSize_;
        this.byteOffset_ = src.byteOffset_;
        this.nullIndicatorByte_ = src.nullIndicatorByte_;
        this.nullIndicatorBit_ = src.nullIndicatorBit_;
        this.slotIdx_ = src.slotIdx_;
        this.stats_ = src.stats_;
    }

    public int getNullIndicatorByte() {
        return this.nullIndicatorByte_;
    }

    public void setNullIndicatorByte(int nullIndicatorByte) {
        this.nullIndicatorByte_ = nullIndicatorByte;
    }

    public int getNullIndicatorBit() {
        return this.nullIndicatorBit_;
    }

    public void setNullIndicatorBit(int nullIndicatorBit) {
        this.nullIndicatorBit_ = nullIndicatorBit;
    }

    public SlotId getId() {
        return this.id_;
    }

    public TupleDescriptor getParent() {
        return this.parent_;
    }

    public Type getType() {
        return this.type_;
    }

    public void setType(Type type) {
        this.type_ = type;
    }

    public TupleDescriptor getItemTupleDesc() {
        return this.itemTupleDesc_;
    }

    public void setItemTupleDesc(TupleDescriptor t) {
        Preconditions.checkState((this.itemTupleDesc_ == null ? 1 : 0) != 0, (Object)"Item tuple descriptor already set.");
        this.itemTupleDesc_ = t;
    }

    public void clearItemTupleDesc() {
        Preconditions.checkState((this.itemTupleDesc_ != null ? 1 : 0) != 0);
        this.itemTupleDesc_ = null;
    }

    public boolean isMaterialized() {
        return this.isMaterialized_;
    }

    public void setIsMaterialized(boolean value) {
        if (this.isMaterialized_ == value) {
            return;
        }
        this.isMaterialized_ = value;
        LOG.trace("Mark slot(sid={}) of tuple(tid={}) as {}materialized", new Object[]{this.id_, this.parent_.getId(), this.isMaterialized_ ? "" : "non-"});
        if (this.shouldMaterializeRecursively_) {
            Preconditions.checkState((this.itemTupleDesc_ != null ? 1 : 0) != 0);
            this.itemTupleDesc_.materializeSlots();
        }
    }

    public boolean shouldMaterializeRecursively() {
        return this.shouldMaterializeRecursively_;
    }

    public void setShouldMaterializeRecursively(boolean value) {
        this.shouldMaterializeRecursively_ = value;
    }

    public boolean isFullyMaterialized() {
        if (!this.isMaterialized()) {
            return false;
        }
        if (this.itemTupleDesc_ != null) {
            Preconditions.checkState((boolean)this.type_.isComplexType());
            for (SlotDescriptor childSlotDesc : this.itemTupleDesc_.getSlots()) {
                if (childSlotDesc.isFullyMaterialized()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean getIsNullable() {
        return this.isNullable_;
    }

    public void setIsNullable(boolean value) {
        this.isNullable_ = value;
    }

    public int getByteSize() {
        return this.byteSize_;
    }

    public void setByteSize(int byteSize) {
        this.byteSize_ = byteSize;
    }

    public int getByteOffset() {
        return this.byteOffset_;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset_ = byteOffset;
    }

    public void setSlotIdx(int slotIdx) {
        this.slotIdx_ = slotIdx;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String label) {
        this.label_ = label;
    }

    public void setSourceExprs(List<Expr> exprs) {
        this.sourceExprs_ = exprs;
    }

    public void setSourceExpr(Expr expr) {
        this.sourceExprs_ = Collections.singletonList(expr);
    }

    public void addSourceExpr(Expr expr) {
        this.sourceExprs_.add(expr);
    }

    public List<Expr> getSourceExprs() {
        return this.sourceExprs_;
    }

    public void setStats(ColumnStats stats) {
        this.stats_ = stats;
    }

    public void setPath(Path path) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkState((boolean)path.isRootedAtTuple());
        Preconditions.checkState((path.getRootDesc() == this.parent_ || this.parent_.getType().isStructType() ? 1 : 0) != 0);
        this.path_ = path;
        this.type_ = this.path_.destType();
        this.label_ = Joiner.on((String)".").join(path.getRawPath());
        if (this.path_.destColumn() instanceof KuduColumn) {
            KuduColumn kuduColumn = (KuduColumn)this.path_.destColumn();
            this.isNullable_ = kuduColumn.isNullable();
        } else if (this.path_.destColumn() instanceof IcebergColumn) {
            IcebergColumn icebergColumn = (IcebergColumn)this.path_.destColumn();
            this.isNullable_ = icebergColumn.isNullable();
        }
    }

    public Path getPath() {
        return this.path_;
    }

    public boolean isScanSlot() {
        return this.path_ != null && this.path_.isRootedAtTable();
    }

    public Column getColumn() {
        return !this.isScanSlot() ? null : this.path_.destColumn();
    }

    protected boolean collectColumns(Set<Column> sourceColumns) {
        Column c = this.getColumn();
        if (c != null) {
            sourceColumns.add(c);
            return true;
        }
        if (!this.sourceExprs_.isEmpty()) {
            HashSet<Column> thisSourceColumns = new HashSet<Column>();
            for (int i = 0; i < this.sourceExprs_.size(); ++i) {
                SlotRef slotRef = this.sourceExprs_.get(i).unwrapSlotRef(false);
                if (slotRef != null && slotRef.hasDesc() && slotRef.getDesc() != this && slotRef.getDesc().collectColumns(thisSourceColumns)) continue;
                return false;
            }
            sourceColumns.addAll(thisSourceColumns);
            return true;
        }
        return false;
    }

    public boolean isVirtualColumn() {
        if (this.path_ == null) {
            return false;
        }
        return this.path_.getVirtualColumnType() != TVirtualColumnType.NONE;
    }

    public TVirtualColumnType getVirtualColumnType() {
        if (this.path_ == null) {
            return TVirtualColumnType.NONE;
        }
        return this.path_.getVirtualColumnType();
    }

    public ColumnStats getStats() {
        if (this.stats_ == null) {
            Column c = this.getColumn();
            this.stats_ = c != null ? c.getStats() : new ColumnStats(this.type_);
        }
        return this.stats_;
    }

    public ColumnStats getStats(Set<Column> ignoreColumns) {
        Preconditions.checkNotNull(ignoreColumns);
        ColumnStats thisStats = this.getStats();
        if (!thisStats.hasNumDistinctValues()) {
            return thisStats;
        }
        HashSet<Column> sourceColumns = new HashSet<Column>();
        boolean allHasSourceColumn = this.collectColumns(sourceColumns);
        if (!allHasSourceColumn) {
            return thisStats;
        }
        long ndv = 0L;
        for (Column column : sourceColumns) {
            if (!column.getStats().hasNumDistinctValues()) {
                return thisStats;
            }
            if (ignoreColumns.contains(column)) continue;
            ndv += column.getStats().getNumDistinctValues();
        }
        if (thisStats.getNumDistinctValues() > ndv) {
            thisStats = thisStats.clone();
            thisStats.setNumDistinctValues(ndv);
        }
        return thisStats;
    }

    private void getEnclosingStructSlotAndTupleDescs(List<SlotDescriptor> slotDescs, List<TupleDescriptor> tupleDescs) {
        TupleDescriptor tupleDesc = this.getParent();
        while (tupleDesc != null) {
            SlotDescriptor parentStructSlotDesc;
            if (tupleDescs != null) {
                tupleDescs.add(tupleDesc);
            }
            if ((parentStructSlotDesc = tupleDesc.getParentSlotDesc()) != null && slotDescs != null) {
                slotDescs.add(parentStructSlotDesc);
            }
            tupleDesc = parentStructSlotDesc != null ? parentStructSlotDesc.getParent() : null;
        }
    }

    public List<SlotDescriptor> getEnclosingStructSlotDescs() {
        ArrayList<SlotDescriptor> result = new ArrayList<SlotDescriptor>();
        this.getEnclosingStructSlotAndTupleDescs(result, null);
        return result;
    }

    public List<TupleDescriptor> getEnclosingTupleDescs() {
        ArrayList<TupleDescriptor> result = new ArrayList<TupleDescriptor>();
        this.getEnclosingStructSlotAndTupleDescs(null, result);
        return result;
    }

    public TupleDescriptor getTopEnclosingTupleDesc() {
        List<TupleDescriptor> enclosingTuples = this.getEnclosingTupleDescs();
        if (enclosingTuples.isEmpty()) {
            Preconditions.checkState((this.getParent() == null ? 1 : 0) != 0);
            return null;
        }
        return enclosingTuples.get(enclosingTuples.size() - 1);
    }

    public int getMaterializedSlotSize() {
        if (!this.isMaterialized()) {
            return 0;
        }
        if (!this.getType().isStructType()) {
            return this.getType().getSlotSize();
        }
        Preconditions.checkNotNull((Object)this.itemTupleDesc_);
        int size = 0;
        for (SlotDescriptor d : this.itemTupleDesc_.getSlots()) {
            size += d.getMaterializedSlotSize();
        }
        return size;
    }

    public boolean isArrayPosRef() {
        if (this.parent_ == null) {
            return false;
        }
        StructType parentType = this.parent_.getType();
        return parentType instanceof CollectionStructType && ((CollectionStructType)parentType).isArrayStruct() && this.label_.equals("pos");
    }

    public boolean isKuduStringSlot() {
        if (this.getParent() == null) {
            return false;
        }
        if (!(this.getParent().getTable() instanceof FeKuduTable)) {
            return false;
        }
        return this.getType().isStringType();
    }

    public List<Integer> getMaterializedPath() {
        Preconditions.checkNotNull((Object)this.parent_);
        if (!this.isScanSlot() || this.parent_.getPath() == null) {
            return Collections.emptyList();
        }
        Preconditions.checkState((boolean)this.path_.isResolved());
        ArrayList materializedPath = Lists.newArrayList(this.path_.getAbsolutePath());
        if (this.type_.isScalarType() || this.type_.isStructType()) {
            return materializedPath;
        }
        Preconditions.checkState((boolean)this.type_.isCollectionType());
        Preconditions.checkState((this.path_.getFirstCollectionIndex() != -1 ? 1 : 0) != 0);
        int offset = !this.path_.isRootedAtTuple() ? 0 : this.path_.getRootDesc().getPath().getAbsolutePath().size();
        materializedPath.subList(offset + this.path_.getFirstCollectionIndex() + 1, materializedPath.size()).clear();
        return materializedPath;
    }

    public void initFromExpr(Expr expr) {
        this.setLabel(expr.toSql());
        Preconditions.checkState((boolean)this.sourceExprs_.isEmpty());
        this.setSourceExpr(expr);
        this.setStats(ColumnStats.fromExpr(expr));
        Preconditions.checkState((boolean)expr.getType().isValid());
        this.setType(expr.getType());
    }

    public boolean LayoutEquals(SlotDescriptor other) {
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (this.isNullable_ != other.isNullable_) {
            return false;
        }
        if (this.getByteSize() != other.getByteSize()) {
            return false;
        }
        if (this.getByteOffset() != other.getByteOffset()) {
            return false;
        }
        if (this.getNullIndicatorByte() != other.getNullIndicatorByte()) {
            return false;
        }
        return this.getNullIndicatorBit() == other.getNullIndicatorBit();
    }

    public TSlotDescriptor toThrift(ThriftSerializationCtx serialCtx) {
        Preconditions.checkState((boolean)this.isMaterialized_);
        List<Integer> materializedPath = this.getMaterializedPath();
        TSlotDescriptor result = new TSlotDescriptor(serialCtx.translateSlotId(this.id_).asInt(), serialCtx.translateTupleId(this.parent_.getId()).asInt(), this.type_.toThrift(), materializedPath, this.byteOffset_, this.nullIndicatorByte_, this.nullIndicatorBit_, this.slotIdx_, this.getVirtualColumnType());
        if (this.itemTupleDesc_ != null) {
            Preconditions.checkState((!this.isScanSlot() || this.itemTupleDesc_.getId().asInt() > this.parent_.getId().asInt() ? 1 : 0) != 0);
            result.setItemTupleId(serialCtx.translateTupleId(this.itemTupleDesc_.getId()).asInt());
        }
        return result;
    }

    public static String debugString(Collection<SlotDescriptor> slots) {
        if (slots == null || slots.isEmpty()) {
            return "";
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (SlotDescriptor slot : slots) {
            strings.add(slot.debugString());
        }
        return Joiner.on((String)"\n").join(strings);
    }

    public String debugString() {
        String pathStr = this.path_ == null ? "null" : this.path_.toString();
        String typeStr = this.type_ == null ? "null" : this.type_.toString();
        String parentTupleId = this.parent_ == null ? "null" : String.valueOf(this.parent_.getId().asInt());
        return MoreObjects.toStringHelper((Object)this).add("id", this.id_.asInt()).add("path", (Object)pathStr).add("label", (Object)this.label_).add("type", (Object)typeStr).add("materialized", this.isMaterialized_).add("shouldMaterializeRecursively", this.shouldMaterializeRecursively_).add("byteSize", this.byteSize_).add("byteOffset", this.byteOffset_).add("nullable", this.isNullable_).add("nullIndicatorByte", this.nullIndicatorByte_).add("nullIndicatorBit", this.nullIndicatorBit_).add("slotIdx", this.slotIdx_).add("stats", (Object)this.stats_).add("itemTupleDesc", (Object)this.itemTupleDesc_).add("parent_tuple_id", (Object)parentTupleId).toString();
    }

    public String toString() {
        return this.debugString();
    }
}

