/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.planner.PlanNode;

public class SingularRowSrcTableRef
extends TableRef {
    private final List<TupleId> tblRefIds_;
    private final List<TupleId> tupleIds_;

    public SingularRowSrcTableRef(PlanNode subplanInput) {
        super(null, "singular-row-src-tblref");
        Preconditions.checkNotNull((Object)subplanInput);
        Preconditions.checkState((this.sampleParams_ == null ? 1 : 0) != 0);
        this.desc_ = null;
        this.isAnalyzed_ = true;
        this.tblRefIds_ = Lists.newArrayList(subplanInput.getTblRefIds());
        this.tupleIds_ = Lists.newArrayList(subplanInput.getTupleIds());
    }

    @Override
    public void setLeftTblRef(TableRef leftTblRef) {
        super.setLeftTblRef(leftTblRef);
        this.tblRefIds_.clear();
        this.tupleIds_.clear();
        this.tblRefIds_.addAll(this.leftTblRef_.getAllTableRefIds());
        this.tupleIds_.addAll(this.leftTblRef_.getAllMaterializedTupleIds());
    }

    @Override
    public TupleId getId() {
        return this.tblRefIds_.get(this.tblRefIds_.size() - 1);
    }

    @Override
    public List<TupleId> getAllTableRefIds() {
        return this.tblRefIds_;
    }

    @Override
    public List<TupleId> getAllMaterializedTupleIds() {
        return this.tupleIds_;
    }
}

