/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TShowTablesParams;

public abstract class ShowTablesOrViewsStmt
extends StatementBase {
    private final String pattern_;
    private final String parsedDb_;
    private String postAnalysisDb_;

    public ShowTablesOrViewsStmt() {
        this(null, null);
    }

    public ShowTablesOrViewsStmt(String pattern) {
        this(null, pattern);
    }

    public ShowTablesOrViewsStmt(String database, String pattern) {
        this.parsedDb_ = database;
        this.pattern_ = pattern;
        this.postAnalysisDb_ = null;
    }

    public String getParsedDb() {
        return this.parsedDb_;
    }

    public String getPattern() {
        return this.pattern_;
    }

    public String getDb() {
        Preconditions.checkNotNull((Object)this.postAnalysisDb_);
        return this.postAnalysisDb_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        String string = this.postAnalysisDb_ = this.parsedDb_ == null ? analyzer.getDefaultDb() : this.parsedDb_;
        if (analyzer.getDb(this.postAnalysisDb_, Privilege.ANY) == null) {
            throw new AnalysisException("Database does not exist: " + this.postAnalysisDb_);
        }
    }

    public TShowTablesParams toThrift() {
        TShowTablesParams params = new TShowTablesParams();
        params.setShow_pattern(this.getPattern());
        params.setDb(this.getDb());
        return params;
    }
}

