/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.ShowTablesOrViewsStmt;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TShowTablesParams;

public class ShowMetadataTablesStmt
extends ShowTablesOrViewsStmt {
    private final String tbl_;

    public ShowMetadataTablesStmt(String database, String tbl, String pattern) {
        super(database, pattern);
        Preconditions.checkNotNull((Object)tbl);
        this.tbl_ = tbl;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        List<String> rawPath = this.createRawPath();
        tblRefs.add(new TableRef(rawPath, null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        Path resolvedPath;
        Preconditions.checkNotNull((Object)this.tbl_);
        super.analyze(analyzer);
        String db = this.getDb();
        analyzer.registerPrivReq(builder -> builder.onTableUnknownOwner(db, this.tbl_).any().build());
        try {
            List<String> rawPath = this.createRawPath();
            resolvedPath = analyzer.resolvePath(rawPath, Path.PathType.ANY);
        }
        catch (TableLoadingException tle) {
            throw new AnalysisException(tle.getMessage(), tle);
        }
        FeTable table = resolvedPath.getRootTable();
        if (!(table instanceof FeIcebergTable)) {
            throw new AnalysisException("The SHOW METADATA TABLES statement is only valid for Iceberg tables: '" + db + "." + this.tbl_ + "' is not an Iceberg table.");
        }
    }

    @Override
    public TShowTablesParams toThrift() {
        TShowTablesParams params = super.toThrift();
        params.setTbl(this.tbl_);
        return params;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("SHOW METADATA TABLES IN ");
        String parsedDb = this.getParsedDb();
        if (parsedDb != null) {
            sb.append(parsedDb).append(".");
        }
        sb.append(this.tbl_);
        String pattern = this.getPattern();
        if (pattern != null) {
            sb.append(" LIKE '").append(pattern).append("'");
        }
        return sb.toString();
    }

    private List<String> createRawPath() {
        String dbName;
        ArrayList<String> res = new ArrayList<String>();
        String string = dbName = this.isAnalyzed() ? this.getDb() : this.getParsedDb();
        if (dbName != null) {
            res.add(dbName);
        }
        res.add(this.tbl_);
        return res;
    }
}

