/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AuthorizationStmt;
import org.apache.impala.analysis.PrivilegeSpec;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Principal;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TShowGrantPrincipalParams;

public class ShowGrantPrincipalStmt
extends AuthorizationStmt {
    private final PrivilegeSpec privilegeSpec_;
    private final String name_;
    private final TPrincipalType principalType_;

    public ShowGrantPrincipalStmt(String name, TPrincipalType principalType, PrivilegeSpec privilegeSpec) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)principalType));
        this.name_ = name;
        this.principalType_ = principalType;
        this.privilegeSpec_ = privilegeSpec;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.name_)) {
            throw new AnalysisException(String.format("%s name in SHOW GRANT %s cannot be empty.", Principal.toString(this.principalType_), Principal.toString(this.principalType_).toUpperCase()));
        }
        if (this.privilegeSpec_ != null) {
            this.privilegeSpec_.analyze(analyzer);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder(String.format("SHOW GRANT %s ", Principal.toString(this.principalType_).toUpperCase()));
        sb.append(this.name_);
        if (this.privilegeSpec_ != null) {
            sb.append(String.format(" ON %s", this.privilegeSpec_.getScope().name()));
            switch (this.privilegeSpec_.getScope()) {
                case SERVER: {
                    break;
                }
                case DATABASE: {
                    sb.append(String.format(" %s", this.privilegeSpec_.getDbName()));
                    break;
                }
                case TABLE: {
                    sb.append(String.format(" %s", this.privilegeSpec_.getTableName()));
                    break;
                }
                case URI: {
                    sb.append(String.format(" '%s'", this.privilegeSpec_.getUri()));
                    break;
                }
                case STORAGE_TYPE: {
                    sb.append(String.format(" '%s'", this.privilegeSpec_.getStorageType()));
                    break;
                }
                case STORAGEHANDLER_URI: {
                    sb.append(String.format(" '%s'", this.privilegeSpec_.getStorageUri()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected privilege spec scope: " + (Object)((Object)this.privilegeSpec_.getScope()));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        if (this.privilegeSpec_ != null) {
            this.privilegeSpec_.collectTableRefs(tblRefs);
        }
    }

    public TShowGrantPrincipalParams toThrift() throws InternalException {
        TShowGrantPrincipalParams params = new TShowGrantPrincipalParams();
        params.setName(this.name_);
        params.setPrincipal_type(this.principalType_);
        params.setRequesting_user(this.requestingUser_.getShortName());
        if (this.privilegeSpec_ != null) {
            params.setPrivilege(this.privilegeSpec_.toThrift().get(0));
        }
        return params;
    }
}

