/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TShowFunctionsParams;

public class ShowFunctionsStmt
extends StatementBase {
    private final String pattern_;
    private final String parsedDb_;
    private final TFunctionCategory fnCategory_;
    private String postAnalysisDb_;

    public ShowFunctionsStmt(String db, String pattern, TFunctionCategory fnCategory) {
        Preconditions.checkNotNull((Object)((Object)fnCategory));
        this.parsedDb_ = db;
        this.pattern_ = pattern;
        this.fnCategory_ = fnCategory;
    }

    public String getDb() {
        Preconditions.checkNotNull((Object)this.postAnalysisDb_);
        return this.postAnalysisDb_;
    }

    public String getPattern() {
        return this.pattern_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        String fnCategory;
        String string = fnCategory = this.fnCategory_ == null ? "" : this.fnCategory_.toString() + " ";
        if (this.pattern_ == null) {
            return "SHOW " + fnCategory + "FUNCTIONS";
        }
        return "SHOW " + fnCategory + "FUNCTIONS LIKE '" + this.pattern_ + "'";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        String string = this.postAnalysisDb_ = this.parsedDb_ == null ? analyzer.getDefaultDb() : this.parsedDb_;
        if (analyzer.getDb(this.postAnalysisDb_, Privilege.ANY) == null) {
            throw new AnalysisException("Database does not exist: " + this.postAnalysisDb_);
        }
    }

    public TShowFunctionsParams toThrift() {
        TShowFunctionsParams params = new TShowFunctionsParams();
        params.setCategory(this.fnCategory_);
        params.setDb(this.getDb());
        params.setShow_pattern(this.getPattern());
        return params;
    }
}

