/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TShowFilesParams;
import org.apache.impala.thrift.TTableName;

public class ShowFilesStmt
extends StatementBase {
    private final TableName tableName_;
    private final PartitionSet partitionSet_;
    protected FeTable table_;

    public ShowFilesStmt(TableName tableName, PartitionSet partitionSet) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.partitionSet_ = partitionSet;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SHOW FILES IN " + this.tableName_.toString());
        if (this.partitionSet_ != null) {
            strBuilder.append(" " + this.partitionSet_.toSql(options));
        }
        return strBuilder.toString();
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        TableRef tableRef = new TableRef(this.tableName_.toPath(), null, Privilege.VIEW_METADATA);
        if ((tableRef = analyzer.resolveTableRef(tableRef)) instanceof InlineViewRef || tableRef instanceof CollectionTableRef) {
            throw new AnalysisException(String.format("SHOW FILES not applicable to a non hdfs table: %s", this.tableName_));
        }
        this.table_ = tableRef.getTable();
        Preconditions.checkNotNull((Object)this.table_);
        if (!(this.table_ instanceof FeFsTable)) {
            throw new AnalysisException("SHOW FILES is applicable only to a HDFS table");
        }
        tableRef.analyze(analyzer);
        if (this.partitionSet_ != null) {
            this.partitionSet_.setTableName(this.table_.getTableName());
            this.partitionSet_.setPartitionShouldExist();
            this.partitionSet_.setPrivilegeRequirement(Privilege.VIEW_METADATA);
            this.partitionSet_.analyze(analyzer);
        }
    }

    public TShowFilesParams toThrift() {
        TShowFilesParams params = new TShowFilesParams();
        params.setTable_name(new TTableName(this.table_.getDb().getName(), this.table_.getName()));
        if (this.partitionSet_ != null) {
            params.setPartition_set(this.partitionSet_.toThrift());
        }
        return params;
    }
}

