/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TTableName;

public class ShowCreateTableStmt
extends StatementBase {
    private TableName tableName_;
    private final TCatalogObjectType objectType_;

    public ShowCreateTableStmt(TableName table, TCatalogObjectType objectType) {
        Preconditions.checkNotNull((Object)table);
        this.tableName_ = table;
        this.objectType_ = objectType;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return "SHOW CREATE " + this.objectType_.name() + " " + this.tableName_;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.tableName_ = analyzer.getFqTableName(this.tableName_);
        FeTable table = analyzer.getTable(this.tableName_, Privilege.VIEW_METADATA);
        if (table instanceof FeView) {
            FeView view = (FeView)table;
            Analyzer viewAnalyzer = new Analyzer(analyzer);
            viewAnalyzer.setMaskPrivChecks(String.format("User '%s' does not have privileges to see the definition of view '%s'.", analyzer.getUser().getName(), view.getFullName()));
            QueryStmt viewQuery = view.getQueryStmt().clone();
            viewAnalyzer.setUseHiveColLabels(true);
            viewQuery.analyze(viewAnalyzer);
        }
    }

    public TTableName toThrift() {
        TTableName params = new TTableName();
        params.setTable_name(this.tableName_.getTbl());
        params.setDb_name(this.tableName_.getDb());
        return params;
    }
}

