/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.thrift.TQueryOptionType;
import org.apache.impala.thrift.TSetQueryOptionRequest;

public class SetStmt
extends StatementBase {
    private final String key_;
    private final String value_;
    private final TQueryOptionType queryOptionType_;
    private static final String DEPRECATED_PARQUET_CODEC_KEY = "PARQUET_COMPRESSION_CODEC";
    private static final String COMPRESSION_CODEC_KEY = "COMPRESSION_CODEC";

    private static String resolveThriftKey(String key) {
        if (key.toLowerCase().equals(DEPRECATED_PARQUET_CODEC_KEY.toLowerCase())) {
            return COMPRESSION_CODEC_KEY;
        }
        return key;
    }

    public SetStmt(String key, String value, TQueryOptionType queryOptionType) {
        Preconditions.checkArgument((key == null == (value == null) ? 1 : 0) != 0);
        Preconditions.checkArgument((key == null || !key.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((queryOptionType != TQueryOptionType.SET_ALL || key == null && value == null ? 1 : 0) != 0);
        this.key_ = key;
        this.value_ = value;
        this.queryOptionType_ = queryOptionType;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (this.queryOptionType_ == TQueryOptionType.UNSET_ALL) {
            return "UNSET ALL";
        }
        if (this.key_ == null) {
            if (this.queryOptionType_ == TQueryOptionType.SET_ALL) {
                return "SET ALL";
            }
            return "SET";
        }
        Preconditions.checkNotNull((Object)this.value_);
        return "SET " + ToSqlUtils.getIdentSql(this.key_) + "='" + this.value_ + "'";
    }

    @Override
    public void analyze(Analyzer analyzer) {
    }

    public TSetQueryOptionRequest toThrift() {
        TSetQueryOptionRequest request = new TSetQueryOptionRequest();
        if (this.key_ != null) {
            request.setKey(SetStmt.resolveThriftKey(this.key_));
            request.setValue(this.value_);
        }
        request.setQuery_option_type(this.queryOptionType_);
        return request;
    }
}

