/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.LimitElement;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.UnionStmt;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetOperationStmt
extends QueryStmt {
    private static final Logger LOG = LoggerFactory.getLogger(SetOperationStmt.class);
    protected final List<SetOperand> operands_;
    protected final List<SetOperand> unionDistinctOperands_ = new ArrayList<SetOperand>();
    protected final List<SetOperand> unionAllOperands_ = new ArrayList<SetOperand>();
    protected final List<SetOperand> intersectDistinctOperands_ = new ArrayList<SetOperand>();
    protected final List<SetOperand> exceptDistinctOperands_ = new ArrayList<SetOperand>();
    protected MultiAggregateInfo distinctAggInfo_;
    protected TupleId tupleId_;
    protected String toSqlString_ = null;
    private boolean hasAnalyticExprs_ = false;
    protected List<Expr> setOperationResultExprs_ = new ArrayList<Expr>();
    protected List<Expr> widestExprs_ = new ArrayList<Expr>();
    protected QueryStmt rewrittenStmt_ = null;

    public SetOperationStmt(List<SetOperand> operands, List<OrderByElement> orderByElements, LimitElement limitElement) {
        super(orderByElements, limitElement);
        Preconditions.checkNotNull(operands);
        Preconditions.checkState((operands.size() > 0 ? 1 : 0) != 0);
        this.operands_ = operands;
    }

    protected SetOperationStmt(SetOperationStmt other) {
        super(other.cloneOrderByElements(), other.limitElement_ == null ? null : other.limitElement_.clone());
        this.operands_ = new ArrayList<SetOperand>();
        if (this.analyzer_ != null) {
            for (SetOperand o : other.unionDistinctOperands_) {
                this.unionDistinctOperands_.add(o.clone());
            }
            for (SetOperand o : other.unionAllOperands_) {
                this.unionAllOperands_.add(o.clone());
            }
            for (SetOperand o : other.exceptDistinctOperands_) {
                this.exceptDistinctOperands_.add(o.clone());
            }
            for (SetOperand o : other.intersectDistinctOperands_) {
                this.intersectDistinctOperands_.add(o.clone());
            }
        }
        for (SetOperand operand : other.operands_) {
            this.operands_.add(operand.clone());
        }
        this.analyzer_ = other.analyzer_;
        this.distinctAggInfo_ = other.distinctAggInfo_ != null ? other.distinctAggInfo_.clone() : null;
        this.tupleId_ = other.tupleId_;
        this.toSqlString_ = other.toSqlString_ != null ? new String(other.toSqlString_) : null;
        this.hasAnalyticExprs_ = other.hasAnalyticExprs_;
        this.withClause_ = other.withClause_ != null ? other.withClause_.clone() : null;
        this.setOperationResultExprs_ = Expr.cloneList(other.setOperationResultExprs_);
        this.widestExprs_ = other.widestExprs_;
        this.rewrittenStmt_ = other.rewrittenStmt_;
    }

    public static QueryStmt createUnionOrSetOperation(List<SetOperand> operands, List<OrderByElement> orderByElements, LimitElement limitElement) {
        boolean unionOnly = true;
        for (SetOperand op : operands) {
            if (op.getSetOperator() == null || op.getSetOperator() == SetOperator.UNION) continue;
            unionOnly = false;
            break;
        }
        if (unionOnly) {
            return new UnionStmt(operands, orderByElements, limitElement);
        }
        return new SetOperationStmt(operands, orderByElements, limitElement);
    }

    public List<SetOperand> getOperands() {
        return this.operands_;
    }

    public List<SetOperand> getUnionDistinctOperands() {
        return this.unionDistinctOperands_;
    }

    public boolean hasUnionDistinctOps() {
        return !this.unionDistinctOperands_.isEmpty();
    }

    public List<SetOperand> getUnionAllOperands() {
        return this.unionAllOperands_;
    }

    public boolean hasUnionAllOps() {
        return !this.unionAllOperands_.isEmpty();
    }

    public List<SetOperand> getExceptDistinctOperands() {
        return this.exceptDistinctOperands_;
    }

    public boolean hasExceptDistinctOps() {
        return !this.exceptDistinctOperands_.isEmpty();
    }

    public List<SetOperand> getIntersectDistinctOperands() {
        return this.intersectDistinctOperands_;
    }

    public boolean hasIntersectDistinctOps() {
        return !this.intersectDistinctOperands_.isEmpty();
    }

    public boolean hasOnlyUnionOps() {
        return (this.hasUnionDistinctOps() || this.hasUnionAllOps()) && !this.hasIntersectDistinctOps() && !this.hasExceptDistinctOps();
    }

    public boolean hasOnlyUnionDistinctOps() {
        return this.hasUnionDistinctOps() && !this.hasUnionAllOps() && !this.hasIntersectDistinctOps() && !this.hasExceptDistinctOps();
    }

    public boolean hasOnlyUnionAllOps() {
        return this.hasUnionAllOps() && !this.hasUnionDistinctOps() && !this.hasIntersectDistinctOps() && !this.hasExceptDistinctOps();
    }

    public boolean hasOnlyIntersectDistinctOps() {
        return this.hasIntersectDistinctOps() && !this.hasUnionDistinctOps() && !this.hasUnionAllOps() && !this.hasExceptDistinctOps();
    }

    public boolean hasOnlyExceptDistinctOps() {
        return this.hasExceptDistinctOps() && !this.hasUnionDistinctOps() && !this.hasUnionAllOps() && !this.hasIntersectDistinctOps();
    }

    public MultiAggregateInfo getDistinctAggInfo() {
        return this.distinctAggInfo_;
    }

    public boolean hasAnalyticExprs() {
        return this.hasAnalyticExprs_;
    }

    public TupleId getTupleId() {
        return this.tupleId_;
    }

    public boolean hasRewrittenStmt() {
        return this.rewrittenStmt_ != null;
    }

    public QueryStmt getRewrittenStmt() {
        return this.rewrittenStmt_;
    }

    public void removeUnionAllOperands() {
        this.operands_.removeAll(this.unionAllOperands_);
        this.unionAllOperands_.clear();
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChanges = false;
        for (SetOperand op : this.operands_) {
            hasChanges |= op.getQueryStmt().resolveTableMask(analyzer);
        }
        return hasChanges;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        TQueryOptions query_options = analyzer.getQueryCtx().client_request.query_options;
        if (query_options.values_stmt_avoid_lossy_char_padding && query_options.allow_unsafe_casts) {
            throw new AnalysisException("Query options ALLOW_UNSAFE_CASTS and VALUES_STMT_AVOID_LOSSY_CHAR_PADDING are not allowed to be set at the same time if the query contains set operation(s).");
        }
        this.propagateDistinct();
        this.analyzeOperands(analyzer);
        this.toSqlString_ = this.toSql();
        if (this.origSqlString_ == null) {
            this.origSqlString_ = this.toSqlString_;
        }
        this.unnestOperands(analyzer);
        this.hasAnalyticExprs_ = false;
        for (SetOperand setOperand : this.operands_) {
            if (!setOperand.hasAnalyticExprs()) continue;
            this.hasAnalyticExprs_ = true;
            break;
        }
        ArrayList<List<Expr>> resultExprLists = new ArrayList<List<Expr>>();
        for (SetOperand op : this.operands_) {
            resultExprLists.add(op.getQueryStmt().getResultExprs());
        }
        this.widestExprs_ = analyzer.castToSetOpCompatibleTypes(resultExprLists, this.shouldAvoidLossyCharPadding(analyzer));
        if (!this.hasOnlyUnionAllOps()) {
            for (Expr expr : this.widestExprs_) {
                Preconditions.checkState((!expr.getType().isCollectionType() ? 1 : 0) != 0, (Object)"UNION, EXCEPT and INTERSECT are not supported for collection types");
            }
        }
        this.createMetadata(analyzer);
        this.createSortInfo(analyzer);
        for (SetOperand operand : this.operands_) {
            this.setOperandSmap(operand, analyzer);
        }
        if (!this.unionDistinctOperands_.isEmpty()) {
            List<Expr> list = Expr.cloneList(this.resultExprs_);
            try {
                this.distinctAggInfo_ = MultiAggregateInfo.createDistinct(list, analyzer.getTupleDesc(this.tupleId_), analyzer);
            }
            catch (AnalysisException e) {
                throw new IllegalStateException("Error creating agg info in SetOperationStmt.analyze()", e);
            }
        }
        this.setOperationResultExprs_ = Expr.cloneList(this.resultExprs_);
        if (this.evaluateOrderBy_) {
            this.createSortTupleInfo(analyzer);
        }
        this.baseTblResultExprs_ = this.resultExprs_;
    }

    protected boolean shouldAvoidLossyCharPadding(Analyzer analyzer) {
        return false;
    }

    protected void analyzeOperands(Analyzer analyzer) throws AnalysisException {
        for (int i = 0; i < this.operands_.size(); ++i) {
            this.operands_.get(i).analyze(analyzer);
            QueryStmt firstQuery = this.operands_.get(0).getQueryStmt();
            List<Expr> firstExprs = this.operands_.get(0).getQueryStmt().getResultExprs();
            QueryStmt query2 = this.operands_.get(i).getQueryStmt();
            List<Expr> exprs = query2.getResultExprs();
            if (firstExprs.size() == exprs.size()) continue;
            throw new AnalysisException("Operands have unequal number of columns:\n'" + this.queryStmtToSql(firstQuery) + "' has " + firstExprs.size() + " column(s)\n'" + this.queryStmtToSql(query2) + "' has " + exprs.size() + " column(s)");
        }
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer) {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().getTupleDesc(this.tupleId_);
        if (!this.unionDistinctOperands_.isEmpty()) {
            tupleDesc.materializeSlots();
        }
        if (this.evaluateOrderBy_) {
            this.sortInfo_.materializeRequiredSlots(analyzer, null);
        }
        List<SlotDescriptor> outputSlots = tupleDesc.getSlots();
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (int i = 0; i < outputSlots.size(); ++i) {
            SlotDescriptor slotDesc = outputSlots.get(i);
            if (!slotDesc.isMaterialized()) continue;
            for (SetOperand op : this.operands_) {
                exprs.add(op.getQueryStmt().getBaseTblResultExprs().get(i));
            }
        }
        if (this.distinctAggInfo_ != null) {
            this.distinctAggInfo_.materializeRequiredSlots(analyzer, null);
        }
        this.materializeSlots(analyzer, exprs);
        for (SetOperand op : this.operands_) {
            op.getQueryStmt().materializeRequiredSlots(analyzer);
        }
    }

    protected String queryStmtToSql(QueryStmt queryStmt) {
        return queryStmt.toSql();
    }

    protected void propagateDistinct() {
        int lastDistinctPos = -1;
        for (int i = this.operands_.size() - 1; i > 0; --i) {
            SetOperand operand = this.operands_.get(i);
            if (lastDistinctPos != -1) {
                operand.setQualifier(Qualifier.DISTINCT);
                continue;
            }
            if (operand.getQualifier() != Qualifier.DISTINCT) continue;
            lastDistinctPos = i;
        }
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        for (SetOperand op : this.operands_) {
            op.getQueryStmt().rewriteExprs(rewriter);
        }
        if (this.orderByElements_ != null) {
            for (OrderByElement orderByElem : this.orderByElements_) {
                orderByElem.setExpr(rewriter.rewrite(orderByElem.getExpr(), this.analyzer_));
            }
        }
    }

    @Override
    public void getMaterializedTupleIds(List<TupleId> tupleIdList) {
        if (this.evaluateOrderBy_) {
            tupleIdList.add(this.sortInfo_.getSortTupleDescriptor().getId());
        } else {
            tupleIdList.add(this.tupleId_);
        }
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs, boolean fromClauseOnly) {
        super.collectTableRefs(tblRefs, fromClauseOnly);
        for (SetOperand op : this.operands_) {
            op.getQueryStmt().collectTableRefs(tblRefs, fromClauseOnly);
        }
    }

    @Override
    public void collectInlineViews(Set<FeView> inlineViews) {
        super.collectInlineViews(inlineViews);
        for (SetOperand operand : this.operands_) {
            operand.getQueryStmt().collectInlineViews(inlineViews);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (!options.showRewritten() && this.toSqlString_ != null) {
            return this.toSqlString_;
        }
        StringBuilder strBuilder = new StringBuilder();
        Preconditions.checkState((this.operands_.size() > 0 ? 1 : 0) != 0);
        if (this.withClause_ != null) {
            strBuilder.append(this.withClause_.toSql(options));
            strBuilder.append(" ");
        }
        this.operandsToSql(options, strBuilder);
        if (this.hasOrderByClause()) {
            strBuilder.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements_.size(); ++i) {
                strBuilder.append(((OrderByElement)this.orderByElements_.get(i)).toSql(options));
                strBuilder.append(i + 1 != this.orderByElements_.size() ? ", " : "");
            }
        }
        strBuilder.append(this.limitElement_.toSql(options));
        return strBuilder.toString();
    }

    private void operandsToSql(ToSqlOptions options, StringBuilder strBuilder) {
        strBuilder.append(this.operands_.get(0).getQueryStmt().toSql(options));
        if (this.operands_.size() == 1) {
            return;
        }
        for (int i = 1; i < this.operands_.size() - 1; ++i) {
            String opName = this.operands_.get(i).getSetOperator() != null ? this.operands_.get(i).getSetOperator().name() : "UNION";
            strBuilder.append(" " + opName + " " + (this.operands_.get(i).getQualifier() == Qualifier.ALL ? "ALL " : ""));
            if (this.operands_.get(i).getQueryStmt() instanceof SetOperationStmt) {
                strBuilder.append("(");
            }
            strBuilder.append(this.operands_.get(i).getQueryStmt().toSql(options));
            if (!(this.operands_.get(i).getQueryStmt() instanceof SetOperationStmt)) continue;
            strBuilder.append(")");
        }
        SetOperand lastOperand = this.operands_.get(this.operands_.size() - 1);
        QueryStmt lastQueryStmt = lastOperand.getQueryStmt();
        strBuilder.append(" " + lastOperand.getSetOperator().name() + " " + (lastOperand.getQualifier() == Qualifier.ALL ? "ALL " : ""));
        if (lastQueryStmt instanceof SetOperationStmt || (this.hasOrderByClause() || this.hasLimit() || this.hasOffset()) && !lastQueryStmt.hasLimit() && !lastQueryStmt.hasOffset() && !lastQueryStmt.hasOrderByClause()) {
            strBuilder.append("(");
            strBuilder.append(lastQueryStmt.toSql(options));
            strBuilder.append(")");
        } else {
            strBuilder.append(lastQueryStmt.toSql(options));
        }
    }

    @Override
    public List<String> getColLabels() {
        Preconditions.checkState((this.operands_.size() > 0 ? 1 : 0) != 0);
        return this.operands_.get(0).getQueryStmt().getColLabels();
    }

    public List<Expr> getSetOperationResultExprs() {
        return this.setOperationResultExprs_;
    }

    public List<Expr> getWidestExprs() {
        return this.widestExprs_;
    }

    @Override
    public SetOperationStmt clone() {
        return new SetOperationStmt(this);
    }

    @Override
    public void reset() {
        super.reset();
        for (SetOperand op : this.operands_) {
            op.reset();
        }
        this.unionDistinctOperands_.clear();
        this.unionAllOperands_.clear();
        this.intersectDistinctOperands_.clear();
        this.exceptDistinctOperands_.clear();
        this.distinctAggInfo_ = null;
        this.tupleId_ = null;
        this.toSqlString_ = null;
        this.hasAnalyticExprs_ = false;
        this.setOperationResultExprs_.clear();
        this.widestExprs_ = null;
        this.rewrittenStmt_ = null;
    }

    private void createMetadata(Analyzer analyzer) throws AnalysisException {
        int i;
        TupleDescriptor tupleDesc = analyzer.getDescTbl().createTupleDescriptor("union");
        tupleDesc.setIsMaterialized(true);
        this.tupleId_ = tupleDesc.getId();
        if (LOG.isTraceEnabled()) {
            LOG.trace("SetOperationStmt.createMetadata: tupleId=" + this.tupleId_.toString());
        }
        List<Expr> firstSelectExprs = this.operands_.get(0).getQueryStmt().getResultExprs();
        ArrayList<ColumnStats> columnStats = new ArrayList<ColumnStats>();
        ArrayList sourceColumns = new ArrayList();
        for (i = 0; i < this.operands_.size(); ++i) {
            List<Expr> selectExprs = this.operands_.get(i).getQueryStmt().getResultExprs();
            for (int j = 0; j < selectExprs.size(); ++j) {
                SlotRef slotRef;
                ColumnStats statsToAdd;
                if (i == 0) {
                    statsToAdd = ColumnStats.fromExpr(selectExprs.get(j));
                    columnStats.add(statsToAdd);
                    sourceColumns.add(new HashSet());
                } else {
                    statsToAdd = ((ColumnStats)columnStats.get(j)).hasNumDistinctValues() ? ColumnStats.fromExpr(selectExprs.get(j), (Set)sourceColumns.get(j)) : ColumnStats.fromExpr(selectExprs.get(j));
                    ((ColumnStats)columnStats.get(j)).add(statsToAdd);
                }
                if (!((ColumnStats)columnStats.get(j)).hasNumDistinctValues() || (slotRef = selectExprs.get(j).unwrapSlotRef(false)) == null || !slotRef.hasDesc()) continue;
                slotRef.getDesc().collectColumns((Set)sourceColumns.get(j));
            }
        }
        for (i = 0; i < firstSelectExprs.size(); ++i) {
            Expr expr = firstSelectExprs.get(i);
            SlotDescriptor slotDesc = analyzer.addSlotDescriptor(tupleDesc);
            slotDesc.setLabel(this.getColLabels().get(i));
            slotDesc.setType(expr.getType());
            if (expr.getType().isCollectionType()) {
                slotDesc.setItemTupleDesc(((SlotRef)expr).getDesc().getItemTupleDesc());
            }
            slotDesc.setStats((ColumnStats)columnStats.get(i));
            SlotRef outputSlotRef = new SlotRef(slotDesc);
            this.resultExprs_.add(outputSlotRef);
            if (this.orderByElements_ != null) {
                SlotRef aliasRef = new SlotRef(this.getColLabels().get(i));
                if (this.aliasSmap_.containsMappingFor(aliasRef)) {
                    this.ambiguousAliasList_.add(aliasRef);
                } else {
                    this.aliasSmap_.put(aliasRef, outputSlotRef);
                }
            }
            boolean isNullable = false;
            for (SetOperand op : this.operands_) {
                Expr resultExpr = op.getQueryStmt().getResultExprs().get(i);
                slotDesc.addSourceExpr(resultExpr);
                SlotRef slotRef = resultExpr.unwrapSlotRef(false);
                if (slotRef == null || slotRef.getDesc().getIsNullable()) {
                    isNullable = true;
                }
                if (op.hasAnalyticExprs() || (slotRef = resultExpr.unwrapSlotRef(true)) == null) continue;
                analyzer.registerValueTransfer(outputSlotRef.getSlotId(), slotRef.getSlotId());
            }
            slotDesc.setIsNullable(isNullable);
        }
        this.baseTblResultExprs_ = this.resultExprs_;
    }

    private void unnestOperands(Analyzer analyzer) throws AnalysisException {
        int i;
        if (this.operands_.size() == 1) {
            this.unionAllOperands_.add(this.operands_.get(0));
            return;
        }
        int firstUnionAllIdx = this.operands_.size();
        for (int i2 = 1; i2 < this.operands_.size(); ++i2) {
            SetOperand operand = this.operands_.get(i2);
            if (operand.getQualifier() != Qualifier.ALL) continue;
            firstUnionAllIdx = i2 == 1 ? 0 : i2;
            break;
        }
        ArrayList<SetOperand> localOps = new ArrayList<SetOperand>();
        ArrayList<SetOperand> tempOps = new ArrayList<SetOperand>();
        Preconditions.checkState((firstUnionAllIdx != 1 ? 1 : 0) != 0);
        for (i = 0; i < firstUnionAllIdx; ++i) {
            tempOps.clear();
            SetOperator setOperator = this.operands_.get(i).getSetOperator();
            if (setOperator == null || setOperator == SetOperator.UNION) {
                this.unnestOperand(tempOps, Qualifier.DISTINCT, this.operands_.get(i));
                localOps.addAll(tempOps);
                this.unionDistinctOperands_.addAll(tempOps);
                continue;
            }
            if (setOperator == SetOperator.EXCEPT) {
                this.unnestOperand(tempOps, Qualifier.DISTINCT, this.operands_.get(i));
                localOps.addAll(tempOps);
                this.exceptDistinctOperands_.addAll(tempOps);
                continue;
            }
            if (setOperator == SetOperator.INTERSECT) {
                this.unnestOperand(tempOps, Qualifier.DISTINCT, this.operands_.get(i));
                localOps.addAll(tempOps);
                this.intersectDistinctOperands_.addAll(tempOps);
                continue;
            }
            throw new AnalysisException("Invalid operand in SetOperationStmt: " + this.queryStmtToSql(this));
        }
        for (i = firstUnionAllIdx; i < this.operands_.size(); ++i) {
            tempOps.clear();
            this.unnestOperand(tempOps, Qualifier.ALL, this.operands_.get(i));
            localOps.addAll(tempOps);
            this.unionAllOperands_.addAll(tempOps);
        }
        for (SetOperand setOperand : this.unionDistinctOperands_) {
            setOperand.setSetOperator(SetOperator.UNION);
            setOperand.setQualifier(Qualifier.DISTINCT);
        }
        for (SetOperand setOperand : this.intersectDistinctOperands_) {
            setOperand.setSetOperator(SetOperator.INTERSECT);
            setOperand.setQualifier(Qualifier.DISTINCT);
        }
        for (SetOperand setOperand : this.exceptDistinctOperands_) {
            setOperand.setSetOperator(SetOperator.EXCEPT);
            setOperand.setQualifier(Qualifier.DISTINCT);
        }
        for (SetOperand setOperand : this.unionAllOperands_) {
            setOperand.setSetOperator(SetOperator.UNION);
            setOperand.setQualifier(Qualifier.ALL);
        }
        this.operands_.clear();
        this.operands_.addAll(localOps);
    }

    private void unnestOperand(List<SetOperand> target, Qualifier targetQualifier, SetOperand operand) {
        Preconditions.checkState((boolean)operand.isAnalyzed());
        QueryStmt queryStmt = operand.getQueryStmt();
        if (queryStmt instanceof SelectStmt) {
            target.add(operand);
            return;
        }
        Preconditions.checkState((boolean)(queryStmt instanceof SetOperationStmt));
        SetOperationStmt stmt = (SetOperationStmt)queryStmt;
        if (stmt.hasLimit() || stmt.hasOffset()) {
            target.add(operand);
            return;
        }
        SetOperator targetOperator = operand.getSetOperator();
        if (targetOperator == SetOperator.INTERSECT && stmt.hasOnlyIntersectDistinctOps()) {
            target.addAll(stmt.getIntersectDistinctOperands());
        } else if (targetOperator == SetOperator.EXCEPT && stmt.hasOnlyExceptDistinctOps()) {
            target.add(operand);
        } else if (targetOperator == SetOperator.UNION && stmt.hasOnlyUnionOps()) {
            if (targetQualifier == Qualifier.DISTINCT || !stmt.hasUnionDistinctOps()) {
                target.addAll(stmt.getUnionDistinctOperands());
                target.addAll(stmt.getUnionAllOperands());
            } else {
                target.addAll(stmt.getUnionAllOperands());
                stmt.removeUnionAllOperands();
                target.add(operand);
            }
        } else if (targetOperator == null && targetQualifier == Qualifier.ALL) {
            target.addAll(stmt.getUnionAllOperands());
            if (stmt.hasUnionDistinctOps() || stmt.hasExceptDistinctOps() || stmt.hasIntersectDistinctOps()) {
                stmt.removeUnionAllOperands();
                target.add(operand);
            }
        } else if (targetOperator == null && targetQualifier == Qualifier.DISTINCT) {
            if (stmt.hasOnlyUnionOps()) {
                target.addAll(stmt.getUnionDistinctOperands());
                target.addAll(stmt.getUnionAllOperands());
            } else {
                target.add(operand);
            }
        } else {
            target.add(operand);
        }
    }

    private void setOperandSmap(SetOperand operand, Analyzer analyzer) {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().getTupleDesc(this.tupleId_);
        operand.getSmap().clear();
        List<Expr> resultExprs = operand.getQueryStmt().getResultExprs();
        Preconditions.checkState((resultExprs.size() == tupleDesc.getSlots().size() ? 1 : 0) != 0);
        for (int i = 0; i < tupleDesc.getSlots().size(); ++i) {
            SlotDescriptor outputSlot = tupleDesc.getSlots().get(i);
            Expr origExpr = resultExprs.get(i).unwrapExpr(true).clone();
            operand.getSmap().put(new SlotRef(outputSlot), origExpr);
        }
    }

    public static class SetOperand {
        private Qualifier qualifier_;
        private SetOperator operator_;
        private QueryStmt queryStmt_;
        private Analyzer analyzer_;
        private final ExprSubstitutionMap smap_;

        public SetOperand(QueryStmt queryStmt, SetOperator operator, Qualifier qualifier) {
            this.queryStmt_ = queryStmt;
            this.operator_ = operator;
            this.qualifier_ = qualifier;
            this.smap_ = new ExprSubstitutionMap();
        }

        public void analyze(Analyzer parent) throws AnalysisException {
            if (this.isAnalyzed()) {
                return;
            }
            if (this.operator_ == SetOperator.INTERSECT || this.operator_ == SetOperator.EXCEPT) {
                parent.setSetOpNeedsRewrite();
            }
            this.analyzer_ = new Analyzer(parent);
            this.queryStmt_.analyze(this.analyzer_);
        }

        public boolean isAnalyzed() {
            return this.analyzer_ != null;
        }

        public QueryStmt getQueryStmt() {
            return this.queryStmt_;
        }

        public Qualifier getQualifier() {
            return this.qualifier_;
        }

        public SetOperator getSetOperator() {
            return this.operator_;
        }

        public void setQualifier(Qualifier qualifier) {
            this.qualifier_ = qualifier;
        }

        public void setSetOperator(SetOperator operator) {
            this.operator_ = operator;
        }

        public void setQueryStmt(QueryStmt stmt) {
            this.queryStmt_ = stmt;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer_;
        }

        public ExprSubstitutionMap getSmap() {
            return this.smap_;
        }

        public boolean hasAnalyticExprs() {
            if (this.queryStmt_ instanceof SelectStmt) {
                return ((SelectStmt)this.queryStmt_).hasAnalyticInfo();
            }
            Preconditions.checkState((boolean)(this.queryStmt_ instanceof SetOperationStmt));
            return ((SetOperationStmt)this.queryStmt_).hasAnalyticExprs();
        }

        private SetOperand(SetOperand other) {
            this.queryStmt_ = other.queryStmt_.clone();
            this.qualifier_ = other.qualifier_;
            this.operator_ = other.operator_;
            this.analyzer_ = other.analyzer_;
            this.smap_ = other.smap_.clone();
        }

        public void reset() {
            this.queryStmt_.reset();
            this.analyzer_ = null;
            this.smap_.clear();
        }

        public SetOperand clone() {
            return new SetOperand(this);
        }
    }

    public static enum SetOperator {
        EXCEPT,
        INTERSECT,
        UNION;

    }

    public static enum Qualifier {
        ALL,
        DISTINCT;

    }
}

