/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.Table;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.AnalyticInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.CollectionStructType;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.ColumnLineageGraph;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.GroupByClause;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.IsNotEmptyPredicate;
import org.apache.impala.analysis.LimitElement;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ColumnAliasGenerator;
import org.apache.impala.common.Pair;
import org.apache.impala.common.TableAliasGenerator;
import org.apache.impala.common.TreeNode;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStmt
extends QueryStmt {
    private static final Logger LOG = LoggerFactory.getLogger(SelectStmt.class);
    protected SelectList selectList_;
    protected final List<String> colLabels_;
    protected final FromClause fromClause_;
    protected Expr whereClause_;
    protected List<Expr> groupingExprs_;
    private GroupByClause groupByClause_;
    protected Expr havingClause_;
    private Expr havingPred_;
    private MultiAggregateInfo multiAggInfo_;
    private AnalyticInfo analyticInfo_;
    private ExprSubstitutionMap baseTblSmap_ = new ExprSubstitutionMap();
    protected String sqlString_;
    private ColumnAliasGenerator columnAliasGenerator_ = null;
    private TableAliasGenerator tableAliasGenerator_ = null;

    SelectStmt(SelectList selectList, FromClause fromClause, Expr wherePredicate, GroupByClause groupByClause, Expr havingPredicate, List<OrderByElement> orderByElements, LimitElement limitElement) {
        super(orderByElements, limitElement);
        this.selectList_ = selectList;
        this.fromClause_ = fromClause == null ? new FromClause() : fromClause;
        this.whereClause_ = wherePredicate;
        this.groupByClause_ = groupByClause;
        this.groupingExprs_ = groupByClause != null ? Expr.cloneList(groupByClause.getOrigGroupingExprs()) : null;
        this.havingClause_ = havingPredicate;
        this.colLabels_ = new ArrayList<String>();
        this.havingPred_ = null;
        this.multiAggInfo_ = null;
        this.sortInfo_ = null;
    }

    public SelectList getSelectList() {
        return this.selectList_;
    }

    public Expr getHavingPred() {
        return this.havingPred_;
    }

    @Override
    public List<String> getColLabels() {
        return this.colLabels_;
    }

    public List<TableRef> getTableRefs() {
        return this.fromClause_.getTableRefs();
    }

    public boolean hasWhereClause() {
        return this.whereClause_ != null;
    }

    public boolean hasGroupByClause() {
        return this.groupingExprs_ != null;
    }

    public Expr getWhereClause() {
        return this.whereClause_;
    }

    public void setWhereClause(Expr whereClause) {
        this.whereClause_ = whereClause;
    }

    public MultiAggregateInfo getMultiAggInfo() {
        return this.multiAggInfo_;
    }

    public boolean hasMultiAggInfo() {
        return this.multiAggInfo_ != null;
    }

    public AnalyticInfo getAnalyticInfo() {
        return this.analyticInfo_;
    }

    public boolean hasAnalyticInfo() {
        return this.analyticInfo_ != null;
    }

    public boolean hasHavingClause() {
        return this.havingClause_ != null;
    }

    public ExprSubstitutionMap getBaseTblSmap() {
        return this.baseTblSmap_;
    }

    public void addToFromClause(TableRef ref) {
        this.fromClause_.add(ref);
    }

    public Pair<Boolean, Long> checkSimpleLimitStmt() {
        if (!(!this.hasSimpleLimitEligibleTableRefs() || this.hasGroupByClause() || this.hasOrderByClause() || this.hasMultiAggInfo() || this.hasAnalyticInfo())) {
            if (this.hasWhereClause() && !Expr.IS_ALWAYS_TRUE_PREDICATE.apply((Object)this.getWhereClause())) {
                return null;
            }
            if (this.hasLimit()) {
                return new Pair<Boolean, Long>(true, this.getLimit());
            }
            return new Pair<Boolean, Object>(false, null);
        }
        return null;
    }

    protected void addGroupingExprs(List<Expr> addtlGroupingExprs) {
        if (this.groupingExprs_ == null) {
            this.groupByClause_ = new GroupByClause(Collections.emptyList(), GroupByClause.GroupingSetsType.NONE);
            this.groupingExprs_ = new ArrayList<Expr>();
        }
        this.groupingExprs_.addAll(addtlGroupingExprs);
    }

    private boolean hasSimpleLimitEligibleTableRefs() {
        if (this.getTableRefs().size() == 1) {
            return true;
        }
        for (TableRef ref : this.getTableRefs()) {
            if (!ref.hasConvertLimitToSampleHint()) continue;
            return true;
        }
        return false;
    }

    protected void removeGroupBy() {
        this.groupByClause_ = null;
        this.groupingExprs_ = null;
    }

    public ColumnAliasGenerator getColumnAliasGenerator() {
        if (this.columnAliasGenerator_ == null) {
            this.columnAliasGenerator_ = new ColumnAliasGenerator(this.colLabels_, null);
        }
        return this.columnAliasGenerator_;
    }

    public TableAliasGenerator getTableAliasGenerator() {
        if (this.tableAliasGenerator_ == null) {
            this.tableAliasGenerator_ = new TableAliasGenerator(this.analyzer_, null);
        }
        return this.tableAliasGenerator_;
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChanges = super.resolveTableMask(analyzer);
        hasChanges |= this.fromClause_.resolveTableMask(analyzer);
        for (SelectListItem item : this.selectList_.getItems()) {
            if (item.isStar()) continue;
            hasChanges |= item.getExpr().resolveTableMask(analyzer);
        }
        if (this.whereClause_ != null) {
            hasChanges |= this.whereClause_.resolveTableMask(analyzer);
        }
        if (this.havingClause_ != null) {
            hasChanges |= this.havingClause_.resolveTableMask(analyzer);
        }
        return hasChanges;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        new SelectAnalyzer(analyzer).analyze();
        this.optimizePlainCountStarQueryForIcebergTable();
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer) {
        List<Expr> unassigned = analyzer.getUnassignedConjuncts(this.getTableRefIds(), true);
        ArrayList<Expr> unassignedJoinConjuncts = new ArrayList<Expr>();
        for (Expr e : unassigned) {
            if (!analyzer.evalAfterJoin(e)) continue;
            unassignedJoinConjuncts.add(e);
        }
        List<Expr> baseTblJoinConjuncts = Expr.substituteList(unassignedJoinConjuncts, this.baseTblSmap_, analyzer, false);
        this.materializeSlots(analyzer, baseTblJoinConjuncts);
        if (this.evaluateOrderBy_) {
            this.sortInfo_.materializeRequiredSlots(analyzer, this.baseTblSmap_);
        }
        if (this.hasAnalyticInfo()) {
            ArrayList<TupleId> tids = new ArrayList<TupleId>();
            this.getMaterializedTupleIds(tids);
            List<Expr> conjuncts = analyzer.getUnassignedConjuncts(tids, false);
            for (TupleId tid : tids) {
                if (!(analyzer.getTupleDesc(tid).getTable() instanceof FeKuduTable)) continue;
                Iterator<Expr> iterator = conjuncts.iterator();
                while (iterator.hasNext()) {
                    Expr e = iterator.next();
                    ArrayList<TupleId> etids = new ArrayList<TupleId>();
                    e.getIds(etids, null);
                    if (1 != etids.size() || etids.get(0) != tid) continue;
                    iterator.remove();
                }
            }
            this.materializeSlots(analyzer, conjuncts);
            this.analyticInfo_.materializeRequiredSlots(analyzer, this.baseTblSmap_);
        }
        if (this.multiAggInfo_ != null) {
            List<Expr> conjuncts = this.multiAggInfo_.collectConjuncts(analyzer, false);
            this.materializeSlots(analyzer, conjuncts);
            this.multiAggInfo_.materializeRequiredSlots(analyzer, this.baseTblSmap_);
        }
    }

    public List<TupleId> getTableRefIds() {
        ArrayList<TupleId> result = new ArrayList<TupleId>();
        for (TableRef ref : this.fromClause_) {
            result.add(ref.getId());
        }
        return result;
    }

    private Expr rewriteCheckOrdinalResult(ExprRewriter rewriter, Expr expr) throws AnalysisException {
        Expr rewrittenExpr = rewriter.rewrite(expr, this.analyzer_);
        if (Expr.IS_LITERAL.apply((Object)rewrittenExpr) && rewrittenExpr.getType().isIntegerType()) {
            return expr;
        }
        return rewrittenExpr;
    }

    public void optimizePlainCountStarQueryForIcebergTable() throws AnalysisException {
        FeTable table;
        if (this.analyzer_.hasWithClause()) {
            return;
        }
        if (this.hasWhereClause()) {
            return;
        }
        if (this.hasGroupByClause()) {
            return;
        }
        if (this.hasHavingClause()) {
            return;
        }
        List<TableRef> tables = this.getTableRefs();
        if (tables.size() != 1) {
            return;
        }
        TableRef tableRef = tables.get(0);
        if (!(tableRef instanceof BaseTableRef)) {
            return;
        }
        if (tableRef.getSampleParams() != null) {
            return;
        }
        TableName tableName = tableRef.getDesc().getTableName();
        try {
            table = this.analyzer_.getCatalog().getTable(tableName.getDb(), tableName.getTbl());
        }
        catch (DatabaseNotFoundException e) {
            throw new AnalysisException("Database does not exist: " + tableName.getDb(), e);
        }
        if (!(table instanceof FeIcebergTable)) {
            return;
        }
        if (this.analyzer_.getQueryOptions().iceberg_disable_count_star_optimization) {
            return;
        }
        this.analyzer_.checkStmtExprLimit();
        FeIcebergTable iceTable = (FeIcebergTable)table;
        if (FeIcebergTable.Utils.hasDeleteFiles(iceTable, tableRef.getTimeTravelSpec())) {
            this.optimizePlainCountStarQueryV2(tableRef, iceTable);
        } else {
            this.optimizePlainCountStarQueryV1(tableRef, iceTable.getIcebergApiTable());
        }
    }

    private void optimizePlainCountStarQueryV2(TableRef tableRef, FeIcebergTable table) throws AnalysisException {
        for (SelectListItem selectItem : this.getSelectList().getItems()) {
            Expr expr = selectItem.getExpr();
            if (expr == null) {
                return;
            }
            if (expr.isConstant() || FunctionCallExpr.isCountStarFunctionCallExpr(expr)) continue;
            return;
        }
        long num = FeIcebergTable.Utils.getRecordCountV2(table, tableRef.getTimeTravelSpec());
        if (num > 0L) {
            this.analyzer_.getQueryCtx().setOptimize_count_star_for_iceberg_v2(true);
            this.analyzer_.setTotalRecordsNumV2(num);
        }
    }

    private void optimizePlainCountStarQueryV1(TableRef tableRef, Table iceTable) {
        boolean hasCountStarFunc = false;
        boolean hasAggFunc = false;
        for (SelectListItem selectItem : this.getSelectList().getItems()) {
            Expr expr = selectItem.getExpr();
            if (expr == null) {
                return;
            }
            if (expr.isConstant()) continue;
            if (FunctionCallExpr.isCountStarFunctionCallExpr(expr)) {
                hasCountStarFunc = true;
                continue;
            }
            if (expr.isAggregate()) {
                hasAggFunc = true;
                continue;
            }
            return;
        }
        if (!hasCountStarFunc) {
            return;
        }
        long num = FeIcebergTable.Utils.getRecordCountV1(iceTable, tableRef.getTimeTravelSpec());
        if (num <= 0L) {
            return;
        }
        this.analyzer_.setTotalRecordsNumV1(num);
        if (hasAggFunc) {
            return;
        }
        this.fromClause_.getTableRefs().clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.selectList_.rewriteExprs(rewriter, this.analyzer_);
        for (TableRef tableRef : this.fromClause_.getTableRefs()) {
            tableRef.rewriteExprs(rewriter, this.analyzer_);
        }
        ArrayList subqueryExprs = new ArrayList();
        if (this.whereClause_ != null) {
            this.whereClause_ = rewriter.rewrite(this.whereClause_, this.analyzer_);
            this.whereClause_.collect(Subquery.class, subqueryExprs);
        }
        if (this.havingClause_ != null) {
            this.havingClause_ = this.rewriteCheckOrdinalResult(rewriter, this.havingClause_);
            this.havingClause_.collect(Subquery.class, subqueryExprs);
        }
        for (Subquery s : subqueryExprs) {
            s.getStatement().rewriteExprs(rewriter);
        }
        if (this.groupingExprs_ != null) {
            void var3_6;
            boolean bl = false;
            while (var3_6 < this.groupingExprs_.size()) {
                this.groupingExprs_.set((int)var3_6, this.rewriteCheckOrdinalResult(rewriter, this.groupingExprs_.get((int)var3_6)));
                ++var3_6;
            }
        }
        if (this.orderByElements_ != null) {
            for (OrderByElement orderByElem : this.orderByElements_) {
                orderByElem.setExpr(this.rewriteCheckOrdinalResult(rewriter, orderByElem.getExpr()));
            }
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        int i;
        if (!options.showRewritten() && this.sqlString_ != null) {
            return this.sqlString_;
        }
        StringBuilder strBuilder = new StringBuilder();
        if (this.withClause_ != null) {
            strBuilder.append(this.withClause_.toSql(options));
            strBuilder.append(" ");
        }
        strBuilder.append("SELECT ");
        if (this.selectList_.isDistinct()) {
            strBuilder.append("DISTINCT ");
        }
        if (this.selectList_.hasPlanHints()) {
            strBuilder.append(ToSqlUtils.getPlanHintsSql(options, this.selectList_.getPlanHints())).append(" ");
        }
        for (i = 0; i < this.selectList_.getItems().size(); ++i) {
            strBuilder.append(this.selectList_.getItems().get(i).toSql(options));
            strBuilder.append(i + 1 != this.selectList_.getItems().size() ? ", " : "");
        }
        if (!this.fromClause_.isEmpty()) {
            strBuilder.append(this.fromClause_.toSql(options));
        }
        if (this.whereClause_ != null) {
            strBuilder.append(" WHERE ");
            List<PlanHint> predHints = this.whereClause_.getPredicateHints();
            if (predHints != null && predHints.size() > 0) {
                strBuilder.append(ToSqlUtils.getPlanHintsSql(options, predHints)).append(" ");
            }
            strBuilder.append(this.whereClause_.toSql(options));
        }
        if (this.groupByClause_ != null) {
            List<Expr> groupingExprs = this.multiAggInfo_ == null ? this.groupingExprs_ : this.multiAggInfo_.getGroupingExprs();
            strBuilder.append(this.groupByClause_.toSql(groupingExprs, options));
        }
        if (this.havingClause_ != null) {
            strBuilder.append(" HAVING ");
            strBuilder.append(this.havingClause_.toSql(options));
        }
        if (this.orderByElements_ != null) {
            strBuilder.append(" ORDER BY ");
            for (i = 0; i < this.orderByElements_.size(); ++i) {
                strBuilder.append(((OrderByElement)this.orderByElements_.get(i)).toSql(options));
                strBuilder.append(i + 1 != this.orderByElements_.size() ? ", " : "");
            }
        }
        strBuilder.append(this.limitElement_.toSql(options));
        return strBuilder.toString();
    }

    @Override
    public void getMaterializedTupleIds(List<TupleId> tupleIdList) {
        if (this.evaluateOrderBy_) {
            tupleIdList.add(this.sortInfo_.getSortTupleDescriptor().getId());
        } else if (this.multiAggInfo_ != null) {
            tupleIdList.add(this.multiAggInfo_.getResultTupleId());
        } else {
            for (TableRef tblRef : this.fromClause_) {
                if (tblRef.getJoinOp().isLeftSemiJoin()) continue;
                if (tblRef.getJoinOp().isRightSemiJoin()) {
                    tupleIdList.clear();
                }
                tupleIdList.addAll(tblRef.getMaterializedTupleIds());
            }
        }
        if (this.hasAnalyticInfo() && !this.evaluateOrderBy_) {
            tupleIdList.add(this.analyticInfo_.getOutputTupleId());
        }
    }

    private SelectStmt(SelectStmt other) {
        super(other);
        this.selectList_ = other.selectList_.clone();
        this.fromClause_ = other.fromClause_.clone();
        this.whereClause_ = other.whereClause_ != null ? other.whereClause_.clone() : null;
        this.groupingExprs_ = other.groupingExprs_ != null ? Expr.cloneList(other.groupingExprs_) : null;
        this.groupByClause_ = other.groupByClause_ != null ? other.groupByClause_.clone() : null;
        this.havingClause_ = other.havingClause_ != null ? other.havingClause_.clone() : null;
        this.colLabels_ = Lists.newArrayList(other.colLabels_);
        this.multiAggInfo_ = other.multiAggInfo_ != null ? other.multiAggInfo_.clone() : null;
        this.analyticInfo_ = other.analyticInfo_ != null ? other.analyticInfo_.clone() : null;
        this.sqlString_ = other.sqlString_ != null ? new String(other.sqlString_) : null;
        this.baseTblSmap_ = other.baseTblSmap_.clone();
    }

    @Override
    protected void collectTableRefs(List<TableRef> tblRefs, boolean fromClauseOnly) {
        super.collectTableRefs(tblRefs, fromClauseOnly);
        if (fromClauseOnly) {
            this.fromClause_.collectFromClauseTableRefs(tblRefs);
        } else {
            this.fromClause_.collectTableRefs(tblRefs);
            ArrayList subqueries = new ArrayList();
            if (this.whereClause_ != null) {
                this.whereClause_.collect(Subquery.class, subqueries);
            }
            if (this.havingClause_ != null) {
                this.havingClause_.collect(Subquery.class, subqueries);
            }
            for (SelectListItem item : this.selectList_.getItems()) {
                if (item.isStar()) continue;
                item.getExpr().collect(Subquery.class, subqueries);
            }
            for (Subquery sq : subqueries) {
                sq.getStatement().collectTableRefs(tblRefs, fromClauseOnly);
            }
        }
    }

    @Override
    public void collectInlineViews(Set<FeView> inlineViews) {
        super.collectInlineViews(inlineViews);
        List<TableRef> fromTblRefs = this.getTableRefs();
        Preconditions.checkNotNull(inlineViews);
        for (TableRef fromTblRef : fromTblRefs) {
            if (!(fromTblRef instanceof InlineViewRef)) continue;
            InlineViewRef inlineViewRef = (InlineViewRef)fromTblRef;
            inlineViews.add(inlineViewRef.getView());
            inlineViewRef.getViewStmt().collectInlineViews(inlineViews);
        }
        if (this.whereClause_ != null) {
            for (Expr conjunct : this.whereClause_.getConjuncts()) {
                ArrayList whereSubQueries = Lists.newArrayList();
                conjunct.collect(Predicates.instanceOf(Subquery.class), whereSubQueries);
                if (whereSubQueries.size() == 0) continue;
                Preconditions.checkState((whereSubQueries.size() == 1 ? 1 : 0) != 0, (Object)("Invariant violated: Multiple subqueries found in a single expression: " + conjunct.toSql()));
                ((Subquery)whereSubQueries.get(0)).getStatement().collectInlineViews(inlineViews);
            }
        }
        ArrayList subqueries = Lists.newArrayList();
        for (SelectListItem item : this.selectList_.getItems()) {
            if (item.isStar()) continue;
            item.getExpr().collect(Subquery.class, subqueries);
        }
        if (this.havingClause_ != null) {
            this.havingClause_.collect(Subquery.class, subqueries);
        }
        for (Subquery sq : subqueries) {
            sq.getStatement().collectInlineViews(inlineViews);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.selectList_.reset();
        this.colLabels_.clear();
        this.fromClause_.reset();
        if (this.whereClause_ != null) {
            this.whereClause_.reset();
        }
        if (this.groupByClause_ != null) {
            this.groupByClause_.reset();
        }
        if (this.groupingExprs_ != null) {
            Expr.resetList(this.groupingExprs_);
        }
        if (this.havingClause_ != null) {
            this.havingClause_.reset();
        }
        this.havingPred_ = null;
        this.multiAggInfo_ = null;
        this.analyticInfo_ = null;
        this.baseTblSmap_.clear();
    }

    @Override
    public SelectStmt clone() {
        return new SelectStmt(this);
    }

    public boolean returnsAtMostOneRow() {
        return this.returnsSingleRow(false);
    }

    public boolean returnsExactlyOneRow() {
        return this.returnsSingleRow(true);
    }

    private boolean returnsSingleRow(boolean exactlyOne) {
        if (this.limitElement_ != null && this.hasLimit()) {
            if (!exactlyOne && this.limitElement_.getLimit() <= 1L) {
                return true;
            }
            if (exactlyOne && this.limitElement_.getLimit() == 0L) {
                return false;
            }
        }
        if (exactlyOne && this.havingClause_ != null && !this.havingClause_.isTriviallyTrue()) {
            return false;
        }
        if (this.hasMultiAggInfo() && !this.hasGroupByClause() && !this.selectList_.isDistinct()) {
            return true;
        }
        if (exactlyOne && this.whereClause_ != null && !this.whereClause_.isTriviallyTrue()) {
            return false;
        }
        if (this.fromClause_.isEmpty()) {
            return true;
        }
        List<TableRef> tableRefs = this.fromClause_.getTableRefs();
        if (tableRefs.size() == 1 && tableRefs.get(0) instanceof InlineViewRef) {
            InlineViewRef inlineView = (InlineViewRef)tableRefs.get(0);
            if (inlineView.queryStmt_ instanceof SelectStmt) {
                SelectStmt selectStmt = (SelectStmt)inlineView.queryStmt_;
                return selectStmt.returnsSingleRow(exactlyOne);
            }
        }
        return false;
    }

    public boolean hasAggregate(boolean includeDistinct) throws AnalysisException {
        return this.groupingExprs_ != null || includeDistinct && this.selectList_.isDistinct() || TreeNode.contains(this.resultExprs_, Expr.IS_AGGREGATE) || this.havingPred_ != null && this.havingPred_.contains(Expr.IS_AGGREGATE) || this.sortInfo_ != null && TreeNode.contains(this.sortInfo_.getSortExprs(), Expr.IS_AGGREGATE);
    }

    private class SelectAnalyzer {
        private final Analyzer analyzer_;
        private List<Expr> groupingExprsCopy_;
        private List<FunctionCallExpr> aggExprs_;
        private ExprSubstitutionMap countAllMap_;
        private final Map<SelectListItem, List<StarExpandedPathInfo>> starExpandedPaths_ = new HashMap<SelectListItem, List<StarExpandedPathInfo>>();

        private SelectAnalyzer(Analyzer analyzer) {
            this.analyzer_ = analyzer;
        }

        private void analyze() throws AnalysisException {
            SelectStmt.this.fromClause_.analyze(this.analyzer_);
            this.collectStarExpandedPaths();
            this.registerStructSlotRefPathsWithAnalyzer();
            this.analyzeSelectClause();
            this.verifyResultExprs();
            this.registerViewColumnPrivileges();
            this.analyzeWhereClause();
            SelectStmt.this.createSortInfo(this.analyzer_);
            this.setZippingUnnestSlotRefsFromViews();
            this.analyzeHavingClause();
            if (this.checkForAggregates()) {
                this.verifyAggSemantics();
                this.analyzeGroupingExprs();
                this.collectAggExprs();
                this.buildAggregateExprs();
                this.buildResultExprs();
                this.verifyAggregation();
            }
            this.createAnalyticInfo();
            if (SelectStmt.this.evaluateOrderBy_) {
                SelectStmt.this.createSortTupleInfo(this.analyzer_);
            }
            SelectStmt.this.sqlString_ = SelectStmt.this.toSql();
            if (SelectStmt.this.origSqlString_ == null) {
                SelectStmt.this.origSqlString_ = SelectStmt.this.sqlString_;
            }
            this.resolveInlineViewRefs();
            if (this.analyzer_.hasEmptySpjResultSet() && SelectStmt.this.multiAggInfo_ == null) {
                this.analyzer_.setHasEmptyResultSet();
            }
            this.buildColumnLineageGraph();
            this.analyzer_.setSimpleLimitStatus(SelectStmt.this.checkSimpleLimitStmt());
        }

        private void registerStructSlotRefPathsWithAnalyzer() throws AnalysisException {
            Stream<Path> nonStarPaths = this.collectNonStarPaths();
            Stream<Path> starExpandedPaths = this.starExpandedPaths_.values().stream().flatMap(pathList -> pathList.stream()).map(pathInfo -> pathInfo.getExpandedPath());
            Stream<Path> allPaths = Stream.concat(nonStarPaths, starExpandedPaths);
            List structPaths = allPaths.filter(path -> path.destType().isStructType()).collect(Collectors.toList());
            Collections.sort(structPaths, Comparator.comparingInt(path -> path.getMatchedTypes().size()));
            for (Path p : structPaths) {
                this.analyzer_.registerSlotRef(p);
            }
        }

        private Stream<Path> collectNonStarPaths() {
            Preconditions.checkNotNull((Object)SelectStmt.this.selectList_);
            Stream<Expr> selectListExprs = SelectStmt.this.selectList_.getItems().stream().filter(elem -> !elem.isStar()).map(elem -> elem.getExpr());
            Stream<Expr> nonSelectListExprs = this.collectExprsOutsideSelectList();
            Stream<Expr> exprs = Stream.concat(selectListExprs, nonSelectListExprs);
            LinkedHashSet slotRefs = new LinkedHashSet();
            exprs.forEach(expr -> expr.collect(SlotRef.class, slotRefs));
            return slotRefs.stream().map(this::slotRefToResolvedPath).filter(path -> path != null);
        }

        private Stream<Expr> collectExprsOutsideSelectList() {
            Stream<Expr> res = Stream.empty();
            if (SelectStmt.this.whereClause_ != null) {
                res = Stream.concat(res, Stream.of(SelectStmt.this.whereClause_));
            }
            if (SelectStmt.this.havingClause_ != null) {
                res = Stream.concat(res, Stream.of(SelectStmt.this.havingClause_));
            }
            if (SelectStmt.this.groupingExprs_ != null) {
                res = Stream.concat(res, SelectStmt.this.groupingExprs_.stream());
            }
            if (SelectStmt.this.sortInfo_ != null) {
                res = Stream.concat(res, SelectStmt.this.sortInfo_.getSortExprs().stream());
            }
            if (SelectStmt.this.analyticInfo_ != null) {
                res = Stream.concat(res, SelectStmt.this.analyticInfo_.getAnalyticExprs().stream().map(analyticExpr -> analyticExpr));
            }
            return res;
        }

        private Path slotRefToResolvedPath(SlotRef slotRef) {
            try {
                Path resolvedPath = this.analyzer_.resolvePathWithMasking(slotRef.getRawPath(), Path.PathType.SLOT_REF);
                return resolvedPath;
            }
            catch (TableLoadingException e) {
                Preconditions.checkState((boolean)false);
                return null;
            }
            catch (AnalysisException e) {
                return null;
            }
        }

        private void analyzeSelectClause() throws AnalysisException {
            if (!this.analyzer_.hasWithClause()) {
                this.registerIsNotEmptyPredicates();
            }
            SelectStmt.this.selectList_.analyzePlanHints(this.analyzer_);
            LinkedHashMap<String, Expr> existingAliasExprs = new LinkedHashMap<String, Expr>();
            for (int i = 0; i < SelectStmt.this.selectList_.getItems().size(); ++i) {
                SelectListItem item = SelectStmt.this.selectList_.getItems().get(i);
                if (item.isStar()) {
                    this.analyzeStarItem(item);
                    continue;
                }
                this.analyzeNonStarItem(item, existingAliasExprs, i);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Analyzed select clause aliasSmap={}", (Object)SelectStmt.this.aliasSmap_.debugString());
            }
        }

        private void analyzeStarItem(SelectListItem item) throws AnalysisException {
            Preconditions.checkState((boolean)item.isStar());
            List<StarExpandedPathInfo> starExpandedPathInfos = this.starExpandedPaths_.get(item);
            if (starExpandedPathInfos == null) {
                Preconditions.checkState((!this.analyzer_.getQueryCtx().client_request.query_options.expand_complex_types ? 1 : 0) != 0);
                return;
            }
            for (StarExpandedPathInfo pathInfo : starExpandedPathInfos) {
                this.addStarExpandedPathResultExpr(pathInfo);
            }
        }

        private void analyzeNonStarItem(SelectListItem item, Map<String, Expr> existingAliasExprs, int selectListPos) throws AnalysisException {
            item.getExpr().analyze(this.analyzer_);
            ArrayList subqueryExprs = new ArrayList();
            item.getExpr().collect(Subquery.class, subqueryExprs);
            for (Subquery s : subqueryExprs) {
                Preconditions.checkState((boolean)(s.getStatement() instanceof SelectStmt));
                if (!s.returnsScalarColumn()) {
                    throw new AnalysisException("A non-scalar subquery is not supported in the expression: " + item.getExpr().toSql());
                }
                if (s.getStatement().isRuntimeScalar()) {
                    throw new AnalysisException("A subquery which may return more than one row is not supported in the expression: " + item.getExpr().toSql());
                }
                if (((SelectStmt)s.getStatement()).returnsAtMostOneRow()) continue;
                throw new AnalysisException("Only subqueries that are guaranteed to return a single row are supported: " + item.getExpr().toSql());
            }
            SelectStmt.this.resultExprs_.add(item.getExpr());
            String label = item.toColumnLabel(selectListPos, this.analyzer_.useHiveColLabels());
            SlotRef aliasRef = new SlotRef(label);
            Expr existingAliasExpr = existingAliasExprs.get(label);
            if (existingAliasExpr != null && !existingAliasExpr.equals(item.getExpr())) {
                SelectStmt.this.ambiguousAliasList_.add(aliasRef);
            } else {
                existingAliasExprs.put(label, item.getExpr());
            }
            SelectStmt.this.aliasSmap_.put(aliasRef, item.getExpr().clone());
            SelectStmt.this.colLabels_.add(label);
        }

        private void verifyResultExprs() throws AnalysisException {
            if (SelectStmt.this.resultExprs_.isEmpty()) {
                throw new AnalysisException("The star exprs expanded to an empty select list because the referenced tables only have complex-typed columns.\nStar exprs only expand to scalar-typed columns because currently not all complex-typed exprs are supported in the select list.\nAffected select statement:\n" + SelectStmt.this.toSql());
            }
            for (Expr expr : SelectStmt.this.resultExprs_) {
                MapType mapType;
                ArrayType arrayType;
                if (SelectStmt.this.selectList_.isDistinct() && expr.getType().isComplexType()) {
                    throw new AnalysisException("Complex types are not supported in SELECT DISTINCT clauses. Expr: '" + expr.toSql() + "', type: '" + expr.getType().toSql() + "'.");
                }
                if (expr.getType().isArrayType() ? !(arrayType = (ArrayType)expr.getType()).getItemType().isSupported() : expr.getType().isMapType() && (!(mapType = (MapType)expr.getType()).getKeyType().isSupported() || !mapType.getValueType().isSupported())) {
                    throw new AnalysisException("Unsupported type '" + expr.getType().toSql() + "' in '" + expr.toSql() + "'.");
                }
                if (expr.getType().isSupported()) continue;
                throw new AnalysisException("Unsupported type '" + expr.getType().toSql() + "' in '" + expr.toSql() + "'.");
            }
            if (TreeNode.contains(SelectStmt.this.resultExprs_, AnalyticExpr.class)) {
                if (SelectStmt.this.fromClause_.isEmpty()) {
                    throw new AnalysisException("Analytic expressions require FROM clause.");
                }
                if (SelectStmt.this.selectList_.isDistinct()) {
                    throw new AnalysisException("cannot combine SELECT DISTINCT with analytic functions");
                }
            }
        }

        private void analyzeWhereClause() throws AnalysisException {
            if (SelectStmt.this.whereClause_ == null) {
                return;
            }
            SelectStmt.this.whereClause_.analyze(this.analyzer_);
            if (SelectStmt.this.whereClause_.contains(Expr.IS_AGGREGATE)) {
                throw new AnalysisException("aggregate function not allowed in WHERE clause");
            }
            SelectStmt.this.whereClause_.checkReturnsBool("WHERE clause", false);
            Expr e = SelectStmt.this.whereClause_.findFirstOf(AnalyticExpr.class);
            if (e != null) {
                throw new AnalysisException("WHERE clause must not contain analytic expressions: " + e.toSql());
            }
            this.verifyZippingUnnestSlots();
            this.analyzer_.registerConjuncts(SelectStmt.this.whereClause_, false);
        }

        private void verifyZippingUnnestSlots() throws AnalysisException {
            if (this.analyzer_.getNumZippingUnnests() <= 1) {
                return;
            }
            ArrayList zippingUnnestTupleIds = Lists.newArrayList(this.analyzer_.getZippingUnnestTupleIds());
            ArrayList slotRefsInWhereClause = new ArrayList();
            SelectStmt.this.whereClause_.collect(SlotRef.class, slotRefsInWhereClause);
            for (SlotRef slotRef : slotRefsInWhereClause) {
                if (!slotRef.isBoundByTupleIds(zippingUnnestTupleIds)) continue;
                throw new AnalysisException("Not allowed to add a filter on an unnested array under the same select statement: " + slotRef.toSql());
            }
        }

        private void setZippingUnnestSlotRefsFromViews() {
            for (TableRef tblRef : SelectStmt.this.fromClause_.getTableRefs()) {
                if (!tblRef.isFromClauseZippingUnnest()) continue;
                Preconditions.checkState((boolean)(tblRef instanceof CollectionTableRef));
                ExprSubstitutionMap exprSubMap = this.getBaseTableSMapFromTableRef(tblRef);
                if (exprSubMap == null) continue;
                for (SelectListItem item : SelectStmt.this.selectList_.getItems()) {
                    if (item.isStar()) continue;
                    Expr itemExpr = item.getExpr();
                    ArrayList slotRefs = new ArrayList();
                    itemExpr.collect(SlotRef.class, slotRefs);
                    for (SlotRef slotRef : slotRefs) {
                        Expr subbedExpr = exprSubMap.get(slotRef);
                        if (subbedExpr == null || !(subbedExpr instanceof SlotRef)) continue;
                        SlotRef subbedSlotRef = (SlotRef)subbedExpr;
                        CollectionTableRef collTblRef = (CollectionTableRef)tblRef;
                        SlotRef collectionSlotRef = (SlotRef)collTblRef.getCollectionExpr();
                        if (subbedSlotRef.getDesc().getParent().getId() != collectionSlotRef.getDesc().getItemTupleDesc().getId()) continue;
                        slotRef.setIsZippingUnnest(true);
                    }
                }
            }
        }

        private ExprSubstitutionMap getBaseTableSMapFromTableRef(TableRef tblRef) {
            if (tblRef.getResolvedPath().getRootDesc() == null) {
                return null;
            }
            if (tblRef.getResolvedPath().getRootDesc().getSourceView() == null) {
                return null;
            }
            return tblRef.getResolvedPath().getRootDesc().getSourceView().getBaseTblSmap();
        }

        private void registerIsNotEmptyPredicates() throws AnalysisException {
            for (TableRef tblRef : SelectStmt.this.fromClause_.getTableRefs()) {
                CollectionTableRef ref;
                Preconditions.checkState((boolean)tblRef.isResolved());
                if (!(tblRef instanceof CollectionTableRef) || !(ref = (CollectionTableRef)tblRef).isRelative() || ref.isCorrelated() || ref.getJoinOp().isOuterJoin() || ref.getJoinOp().isAntiJoin() || this.analyzer_.isOuterJoined(ref.getResolvedPath().getRootDesc().getId()) || tblRef.isZippingUnnest() && this.analyzer_.getNumZippingUnnests() > 1) continue;
                IsNotEmptyPredicate isNotEmptyPred = new IsNotEmptyPredicate(ref.getCollectionExpr().clone());
                isNotEmptyPred.analyze(this.analyzer_);
                this.analyzer_.registerOnClauseConjuncts(Lists.newArrayList((Object[])new Expr[]{isNotEmptyPred}), ref);
            }
        }

        private void resolveInlineViewRefs() throws AnalysisException {
            for (TableRef tblRef : SelectStmt.this.fromClause_) {
                if (!(tblRef instanceof InlineViewRef)) continue;
                InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
                SelectStmt.this.baseTblSmap_ = ExprSubstitutionMap.combine(SelectStmt.this.baseTblSmap_, inlineViewRef.getBaseTblSmap());
            }
            SelectStmt.this.baseTblResultExprs_ = Expr.trySubstituteList(SelectStmt.this.resultExprs_, SelectStmt.this.baseTblSmap_, this.analyzer_, false);
            if (LOG.isTraceEnabled()) {
                LOG.trace("baseTblSmap_: " + SelectStmt.this.baseTblSmap_.debugString());
                LOG.trace("resultExprs: " + Expr.debugString(SelectStmt.this.resultExprs_));
                LOG.trace("baseTblResultExprs: " + Expr.debugString(SelectStmt.this.baseTblResultExprs_));
            }
        }

        private Path analyzeStarPath(List<String> rawPath, Analyzer analyzer) throws AnalysisException {
            Path resolvedPath = null;
            try {
                resolvedPath = analyzer.resolvePathWithMasking(rawPath, Path.PathType.STAR);
            }
            catch (TableLoadingException e) {
                Preconditions.checkState((boolean)false);
            }
            Preconditions.checkNotNull((Object)resolvedPath);
            return resolvedPath;
        }

        private void expandStar(SelectListItem selectListItem) throws AnalysisException {
            if (SelectStmt.this.fromClause_.isEmpty()) {
                throw new AnalysisException("'*' expression in select list requires FROM clause.");
            }
            for (TableRef tableRef : SelectStmt.this.fromClause_) {
                if (tableRef.isHidden() || this.analyzer_.isSemiJoined(tableRef.getId())) continue;
                Path resolvedPath = new Path(tableRef.getDesc(), Collections.emptyList());
                Preconditions.checkState((boolean)resolvedPath.resolve());
                this.expandStar(selectListItem, resolvedPath);
            }
        }

        private void expandStar(SelectListItem selectListItem, Path resolvedPath) throws AnalysisException {
            Preconditions.checkState((boolean)resolvedPath.isResolved());
            if (resolvedPath.destTupleDesc() != null && resolvedPath.destTupleDesc().getTable() != null && resolvedPath.destTupleDesc().getPath().getMatchedTypes().isEmpty()) {
                TupleDescriptor tupleDesc = resolvedPath.destTupleDesc();
                FeTable table = tupleDesc.getTable();
                for (Column c : table.getColumnsInHiveOrder()) {
                    if (c instanceof KuduColumn && ((KuduColumn)c).isAutoIncrementing()) continue;
                    this.addStarExpandedPath(selectListItem, resolvedPath, c.getName());
                }
            } else {
                Preconditions.checkState((boolean)resolvedPath.destType().isStructType());
                StructType structType = (StructType)resolvedPath.destType();
                Preconditions.checkNotNull((Object)structType);
                if (structType instanceof CollectionStructType) {
                    CollectionStructType cst = (CollectionStructType)structType;
                    if (cst.isMapStruct()) {
                        this.addStarExpandedPath(selectListItem, resolvedPath, "key");
                    }
                    if (cst.getOptionalField().getType().isStructType()) {
                        structType = (StructType)cst.getOptionalField().getType();
                        for (StructField f : structType.getFields()) {
                            this.addStarExpandedPath(selectListItem, resolvedPath, cst.getOptionalField().getName(), f.getName());
                        }
                    } else if (cst.isMapStruct()) {
                        this.addStarExpandedPath(selectListItem, resolvedPath, "value");
                    } else {
                        this.addStarExpandedPath(selectListItem, resolvedPath, "item");
                    }
                } else {
                    for (StructField f : structType.getFields()) {
                        if (f.isHidden()) continue;
                        this.addStarExpandedPath(selectListItem, resolvedPath, f.getName());
                    }
                }
            }
        }

        private void collectStarExpandedPaths() throws AnalysisException {
            for (SelectListItem item : SelectStmt.this.selectList_.getItems()) {
                if (!item.isStar()) continue;
                if (item.getRawPath() != null) {
                    Path resolvedPath = this.analyzeStarPath(item.getRawPath(), this.analyzer_);
                    this.expandStar(item, resolvedPath);
                    continue;
                }
                this.expandStar(item);
            }
        }

        private void addStarExpandedPath(SelectListItem selectListItem, Path resolvedRootPath, String ... relRawPath) throws AnalysisException {
            Path starExpandedPath = Path.createRelPath(resolvedRootPath, relRawPath);
            Preconditions.checkState((boolean)starExpandedPath.resolve());
            if (starExpandedPath.destType().isComplexType() && !starExpandedPath.comesFromIcebergMetadataTable() && !this.analyzer_.getQueryCtx().client_request.query_options.expand_complex_types) {
                return;
            }
            if (!this.starExpandedPaths_.containsKey(selectListItem)) {
                this.starExpandedPaths_.put(selectListItem, new ArrayList());
            }
            List<StarExpandedPathInfo> pathsOfStarItem = this.starExpandedPaths_.get(selectListItem);
            pathsOfStarItem.add(new StarExpandedPathInfo(starExpandedPath, resolvedRootPath));
        }

        private void addStarExpandedPathResultExpr(StarExpandedPathInfo starExpandedPathInfo) throws AnalysisException {
            Preconditions.checkState((boolean)starExpandedPathInfo.getExpandedPath().isResolved());
            SlotDescriptor slotDesc = this.analyzer_.registerSlotRef(starExpandedPathInfo.getExpandedPath(), false);
            SlotRef slotRef = new SlotRef(slotDesc);
            if (slotRef.getType().isStructType()) {
                slotRef.checkForUnsupportedStructFeatures();
            }
            Preconditions.checkState((boolean)slotRef.isAnalyzed(), (Object)"Analysis should be done in constructor");
            if (starExpandedPathInfo.shouldRegisterForColumnMasking()) {
                this.analyzer_.registerColumnForMasking(slotDesc);
            }
            SelectStmt.this.resultExprs_.add(slotRef);
            List<String> starExpandedRawPath = starExpandedPathInfo.getExpandedPath().getRawPath();
            SelectStmt.this.colLabels_.add(starExpandedRawPath.get(starExpandedRawPath.size() - 1));
        }

        private void registerViewColumnPrivileges() {
            for (TableRef tableRef : SelectStmt.this.fromClause_.getTableRefs()) {
                boolean isCatalogView;
                if (!(tableRef instanceof InlineViewRef)) continue;
                InlineViewRef inlineViewRef = (InlineViewRef)tableRef;
                FeView view = inlineViewRef.getView();
                boolean bl = isCatalogView = view != null && !view.isLocalView();
                if (!isCatalogView) continue;
                for (Expr expr : SelectStmt.this.getResultExprs()) {
                    ArrayList slotRefs = new ArrayList();
                    expr.collectAll(Predicates.instanceOf(SlotRef.class), slotRefs);
                    for (Expr e : slotRefs) {
                        SlotRef slotRef = (SlotRef)e;
                        this.analyzer_.registerPrivReq(builder -> builder.allOf(Privilege.SELECT).onColumn(view.getDb().getName(), view.getName(), slotRef.getDesc().getLabel(), view.getOwnerUser()).build());
                    }
                }
            }
        }

        private void analyzeHavingClause() throws AnalysisException {
            if (SelectStmt.this.havingClause_ == null) {
                return;
            }
            ArrayList subqueries = new ArrayList();
            SelectStmt.this.havingClause_.collectAll(Predicates.instanceOf(Subquery.class), subqueries);
            if (subqueries.size() > 1) {
                throw new AnalysisException("Multiple subqueries are not supported in expression: " + SelectStmt.this.havingClause_.toSql());
            }
            SelectStmt.this.havingPred_ = SelectStmt.this.resolveReferenceExpr(SelectStmt.this.havingClause_, "HAVING", this.analyzer_, BackendConfig.INSTANCE.getAllowOrdinalsInHaving());
            Expr analyticExpr = SelectStmt.this.havingPred_.findFirstOf(AnalyticExpr.class);
            if (analyticExpr != null) {
                throw new AnalysisException("HAVING clause must not contain analytic expressions: " + analyticExpr.toSql());
            }
            SelectStmt.this.havingPred_.checkReturnsBool("HAVING clause", true);
        }

        private boolean checkForAggregates() throws AnalysisException {
            if (!SelectStmt.this.hasAggregate(true)) {
                if (SelectStmt.this.havingPred_ != null) {
                    this.analyzer_.registerConjuncts(SelectStmt.this.havingPred_, true);
                }
                return false;
            }
            return true;
        }

        private void verifyAggSemantics() throws AnalysisException {
            if (SelectStmt.this.fromClause_.isEmpty()) {
                throw new AnalysisException("aggregation without a FROM clause is not allowed");
            }
            if (SelectStmt.this.selectList_.isDistinct() && (SelectStmt.this.groupingExprs_ != null || TreeNode.contains(SelectStmt.this.resultExprs_, Expr.IS_AGGREGATE) || SelectStmt.this.havingPred_ != null && SelectStmt.this.havingPred_.contains(Expr.IS_AGGREGATE))) {
                throw new AnalysisException("cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
            }
            if (SelectStmt.this.groupingExprs_ != null || TreeNode.contains(SelectStmt.this.resultExprs_, Expr.IS_AGGREGATE)) {
                for (SelectListItem item : SelectStmt.this.selectList_.getItems()) {
                    if (!item.isStar()) continue;
                    throw new AnalysisException("cannot combine '*' in select list with grouping or aggregation");
                }
            }
            if (SelectStmt.this.groupingExprs_ != null) {
                for (Expr expr : SelectStmt.this.groupingExprs_) {
                    if (!expr.contains(Predicates.instanceOf(Subquery.class))) continue;
                    throw new AnalysisException("Subqueries are not supported in the GROUP BY clause.");
                }
            }
        }

        private void analyzeGroupingExprs() throws AnalysisException {
            if (SelectStmt.this.groupingExprs_ == null) {
                this.groupingExprsCopy_ = new ArrayList<Expr>();
                return;
            }
            this.groupingExprsCopy_ = Expr.cloneList(SelectStmt.this.groupingExprs_);
            SelectStmt.this.substituteOrdinalsAndAliases(this.groupingExprsCopy_, "GROUP BY", this.analyzer_);
            for (int i = 0; i < this.groupingExprsCopy_.size(); ++i) {
                this.groupingExprsCopy_.get(i).analyze(this.analyzer_);
                if (this.groupingExprsCopy_.get(i).contains(Expr.IS_AGGREGATE)) {
                    throw new AnalysisException("GROUP BY expression must not contain aggregate functions: " + SelectStmt.this.groupingExprs_.get(i).toSql());
                }
                if (!this.groupingExprsCopy_.get(i).contains(AnalyticExpr.class)) continue;
                throw new AnalysisException("GROUP BY expression must not contain analytic expressions: " + this.groupingExprsCopy_.get(i).toSql());
            }
            if (SelectStmt.this.groupByClause_ != null && SelectStmt.this.groupByClause_.hasGroupingSets()) {
                SelectStmt.this.groupByClause_.analyzeGroupingSets(this.groupingExprsCopy_);
            }
        }

        private void collectAggExprs() {
            this.aggExprs_ = new ArrayList<FunctionCallExpr>();
            TreeNode.collect(SelectStmt.this.resultExprs_, Expr.IS_AGGREGATE, this.aggExprs_);
            if (SelectStmt.this.havingPred_ != null) {
                SelectStmt.this.havingPred_.collect(Expr.IS_AGGREGATE, this.aggExprs_);
            }
            if (SelectStmt.this.sortInfo_ != null) {
                TreeNode.collect(SelectStmt.this.sortInfo_.getSortExprs(), Expr.IS_AGGREGATE, this.aggExprs_);
            }
        }

        private void buildAggregateExprs() throws AnalysisException {
            this.countAllMap_ = this.createCountAllMap();
            List<Expr> substitutedAggs = Expr.substituteList(this.aggExprs_, this.countAllMap_, this.analyzer_, false);
            this.aggExprs_.clear();
            TreeNode.collect(substitutedAggs, Expr.IS_AGGREGATE, this.aggExprs_);
            List<Expr> groupingExprs = this.groupingExprsCopy_;
            if (SelectStmt.this.selectList_.isDistinct()) {
                Preconditions.checkState((boolean)this.groupingExprsCopy_.isEmpty());
                Preconditions.checkState((boolean)this.aggExprs_.isEmpty());
                groupingExprs = Expr.cloneList(SelectStmt.this.resultExprs_);
            }
            Expr.removeDuplicates(this.aggExprs_);
            Expr.removeDuplicates(groupingExprs);
            List<List<Expr>> groupingSets = SelectStmt.this.groupByClause_ != null && SelectStmt.this.groupByClause_.hasGroupingSets() ? SelectStmt.this.groupByClause_.getAnalyzedGroupingSets() : null;
            SelectStmt.this.multiAggInfo_ = new MultiAggregateInfo(groupingExprs, this.aggExprs_, groupingSets);
            SelectStmt.this.multiAggInfo_.analyze(this.analyzer_);
        }

        private void buildResultExprs() throws AnalysisException {
            ExprSubstitutionMap finalOutputSmap = SelectStmt.this.multiAggInfo_.getOutputSmap();
            ExprSubstitutionMap combinedSmap = ExprSubstitutionMap.compose(this.countAllMap_, finalOutputSmap, this.analyzer_);
            if (LOG.isTraceEnabled()) {
                LOG.trace("combined smap: " + combinedSmap.debugString());
                LOG.trace("desctbl: " + this.analyzer_.getDescTbl().debugString());
                LOG.trace("resultexprs: " + Expr.debugString(SelectStmt.this.resultExprs_));
            }
            SelectStmt.this.resultExprs_ = Expr.substituteList(SelectStmt.this.resultExprs_, combinedSmap, this.analyzer_, false);
            if (LOG.isTraceEnabled()) {
                LOG.trace("post-agg selectListExprs: " + Expr.debugString(SelectStmt.this.resultExprs_));
            }
            if (SelectStmt.this.havingPred_ != null) {
                SelectStmt.this.havingPred_ = SelectStmt.this.havingPred_.substitute(combinedSmap, this.analyzer_, false);
                this.analyzer_.registerConjuncts(SelectStmt.this.havingPred_, true);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("post-agg havingPred: " + SelectStmt.this.havingPred_.debugString());
                }
            }
            if (SelectStmt.this.sortInfo_ != null) {
                SelectStmt.this.sortInfo_.substituteSortExprs(combinedSmap, this.analyzer_);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("post-agg orderingExprs: " + Expr.debugString(SelectStmt.this.sortInfo_.getSortExprs()));
                }
            }
        }

        private void verifyAggregation() throws AnalysisException {
            int i;
            for (i = 0; i < SelectStmt.this.selectList_.getItems().size(); ++i) {
                if (((Expr)SelectStmt.this.resultExprs_.get(i)).isBound(SelectStmt.this.multiAggInfo_.getResultTupleId())) continue;
                SelectListItem selectListItem = SelectStmt.this.selectList_.getItems().get(i);
                throw new AnalysisException("select list expression not produced by aggregation output (missing from GROUP BY clause?): " + selectListItem.toSql());
            }
            if (SelectStmt.this.orderByElements_ != null) {
                for (i = 0; i < SelectStmt.this.orderByElements_.size(); ++i) {
                    if (SelectStmt.this.sortInfo_.getSortExprs().get(i).isBound(SelectStmt.this.multiAggInfo_.getResultTupleId())) continue;
                    throw new AnalysisException("ORDER BY expression not produced by aggregation output (missing from GROUP BY clause?): " + ((OrderByElement)SelectStmt.this.orderByElements_.get(i)).getExpr().toSql());
                }
            }
            if (SelectStmt.this.havingPred_ != null && !SelectStmt.this.havingPred_.isBound(SelectStmt.this.multiAggInfo_.getResultTupleId())) {
                throw new AnalysisException("HAVING clause not produced by aggregation output (missing from GROUP BY clause?): " + SelectStmt.this.havingClause_.toSql());
            }
        }

        private ExprSubstitutionMap createCountAllMap() throws AnalysisException {
            ExprSubstitutionMap scalarCountAllMap = new ExprSubstitutionMap();
            if (SelectStmt.this.groupingExprs_ != null && !SelectStmt.this.groupingExprs_.isEmpty()) {
                return scalarCountAllMap;
            }
            Predicate<FunctionCallExpr> isNotDistinctPred = new Predicate<FunctionCallExpr>(){

                public boolean apply(FunctionCallExpr expr) {
                    return !expr.isDistinct();
                }
            };
            if (Iterables.all(this.aggExprs_, (Predicate)isNotDistinctPred)) {
                return scalarCountAllMap;
            }
            Predicate<FunctionCallExpr> isCountPred = new Predicate<FunctionCallExpr>(){

                public boolean apply(FunctionCallExpr expr) {
                    return expr.getFnName().getFunction().equals("count");
                }
            };
            Iterable countAllAggs = Iterables.filter(this.aggExprs_, (Predicate)Predicates.and((Predicate)isCountPred, (Predicate)isNotDistinctPred));
            for (FunctionCallExpr countAllAgg : countAllAggs) {
                ArrayList zeroIfNullParam = Lists.newArrayList((Object[])new Expr[]{countAllAgg.clone()});
                FunctionCallExpr zeroIfNull = new FunctionCallExpr("zeroifnull", (List<Expr>)zeroIfNullParam);
                zeroIfNull.analyze(this.analyzer_);
                scalarCountAllMap.put(countAllAgg, zeroIfNull);
            }
            return scalarCountAllMap;
        }

        private void createAnalyticInfo() throws AnalysisException {
            ArrayList<AnalyticExpr> analyticExprs = new ArrayList<AnalyticExpr>();
            TreeNode.collect(SelectStmt.this.resultExprs_, AnalyticExpr.class, analyticExprs);
            if (SelectStmt.this.sortInfo_ != null) {
                TreeNode.collect(SelectStmt.this.sortInfo_.getSortExprs(), AnalyticExpr.class, analyticExprs);
            }
            if (analyticExprs.isEmpty()) {
                return;
            }
            ExprSubstitutionMap rewriteSmap = new ExprSubstitutionMap();
            for (Expr expr : analyticExprs) {
                AnalyticExpr toRewrite = (AnalyticExpr)expr;
                Expr newExpr = AnalyticExpr.rewrite(toRewrite);
                if (newExpr == null) continue;
                newExpr.analyze(this.analyzer_);
                if (rewriteSmap.containsMappingFor(toRewrite)) continue;
                rewriteSmap.put(toRewrite, newExpr);
            }
            if (rewriteSmap.size() > 0) {
                List<Expr> updatedAnalyticExprs = Expr.substituteList(analyticExprs, rewriteSmap, this.analyzer_, false);
                analyticExprs.clear();
                TreeNode.collect(updatedAnalyticExprs, AnalyticExpr.class, analyticExprs);
            }
            SelectStmt.this.analyticInfo_ = AnalyticInfo.create(analyticExprs, this.analyzer_);
            ExprSubstitutionMap smap = SelectStmt.this.analyticInfo_.getSmap();
            if (rewriteSmap.size() > 0) {
                smap = ExprSubstitutionMap.compose(rewriteSmap, SelectStmt.this.analyticInfo_.getSmap(), this.analyzer_);
            }
            SelectStmt.this.resultExprs_ = Expr.substituteList(SelectStmt.this.resultExprs_, smap, this.analyzer_, false);
            if (LOG.isTraceEnabled()) {
                LOG.trace("post-analytic selectListExprs: " + Expr.debugString(SelectStmt.this.resultExprs_));
            }
            if (SelectStmt.this.sortInfo_ != null) {
                SelectStmt.this.sortInfo_.substituteSortExprs(smap, this.analyzer_);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("post-analytic orderingExprs: " + Expr.debugString(SelectStmt.this.sortInfo_.getSortExprs()));
                }
            }
        }

        private void buildColumnLineageGraph() {
            ColumnLineageGraph graph = this.analyzer_.getColumnLineageGraph();
            if (SelectStmt.this.multiAggInfo_ != null && SelectStmt.this.multiAggInfo_.hasAggregateExprs()) {
                graph.addDependencyPredicates(SelectStmt.this.multiAggInfo_.getGroupingExprs());
            }
            if (SelectStmt.this.sortInfo_ != null && SelectStmt.this.hasLimit()) {
                graph.addDependencyPredicates(SelectStmt.this.sortInfo_.getSortExprs());
            }
        }

        private class StarExpandedPathInfo {
            private final Path expandedPath_;
            private final Path originalRootPath_;

            public StarExpandedPathInfo(Path expandedPath, Path originalRootPath) {
                this.expandedPath_ = expandedPath;
                this.originalRootPath_ = originalRootPath;
            }

            public Path getExpandedPath() {
                return this.expandedPath_;
            }

            public boolean shouldRegisterForColumnMasking() {
                return this.originalRootPath_.getMatchedTypes().isEmpty();
            }
        }
    }
}

