/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;

public class SelectListItem {
    private Expr expr_;
    private String alias_;
    private final List<String> rawPath_;
    private final boolean isStar_;
    private final boolean isHidden_;

    public SelectListItem(Expr expr, String alias, boolean isHidden) {
        Preconditions.checkNotNull((Object)expr);
        this.expr_ = expr;
        this.alias_ = alias;
        this.isStar_ = false;
        this.rawPath_ = null;
        this.isHidden_ = isHidden;
    }

    public SelectListItem(Expr expr, String alias) {
        this(expr, alias, false);
    }

    public static SelectListItem createStarItem(List<String> rawPath) {
        return new SelectListItem(rawPath);
    }

    private SelectListItem(List<String> path) {
        this.expr_ = null;
        this.isStar_ = true;
        this.rawPath_ = path;
        this.isHidden_ = false;
    }

    public Expr getExpr() {
        return this.expr_;
    }

    public void setExpr(Expr expr) {
        this.expr_ = expr;
    }

    public boolean isStar() {
        return this.isStar_;
    }

    public String getAlias() {
        return this.alias_;
    }

    public List<String> getRawPath() {
        return this.rawPath_;
    }

    public boolean isHidden() {
        return this.isHidden_;
    }

    public String toString() {
        if (!this.isStar_) {
            Preconditions.checkNotNull((Object)this.expr_);
            return this.expr_.toSql() + (this.alias_ != null ? " " + this.alias_ : "");
        }
        if (this.rawPath_ != null) {
            Preconditions.checkState((boolean)this.isStar_);
            return Joiner.on((String)".").join(this.rawPath_) + ".*";
        }
        return "*";
    }

    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    public String toSql(ToSqlOptions options) {
        if (!this.isStar_) {
            Preconditions.checkNotNull((Object)this.expr_);
            String aliasSql = null;
            if (this.alias_ != null) {
                aliasSql = ToSqlUtils.getIdentSql(this.alias_);
            }
            return this.expr_.toSql(options) + (aliasSql != null ? " " + aliasSql : "");
        }
        if (this.rawPath_ != null) {
            Preconditions.checkState((boolean)this.isStar_);
            StringBuilder result = new StringBuilder();
            for (String p : this.rawPath_) {
                if (result.length() > 0) {
                    result.append(".");
                }
                result.append(ToSqlUtils.getIdentSql(p.toLowerCase()));
            }
            result.append(".*");
            return result.toString();
        }
        return "*";
    }

    public String toColumnLabel(int selectListPos, boolean useHiveColLabels) {
        if (this.alias_ != null) {
            return this.alias_.toLowerCase();
        }
        if (this.expr_ instanceof SlotRef) {
            SlotRef slotRef = (SlotRef)this.expr_;
            return Joiner.on((String)".").join(slotRef.getResolvedPath().getRawPath());
        }
        if (useHiveColLabels) {
            return "_c" + selectListPos;
        }
        if (this.expr_ instanceof AnalyticExpr) {
            AnalyticExpr expr = (AnalyticExpr)this.expr_;
            return expr.getFnCall().toSql() + " OVER(...)";
        }
        return this.expr_.toSql().toLowerCase();
    }

    public SelectListItem clone() {
        if (this.isStar_) {
            return SelectListItem.createStarItem(this.rawPath_);
        }
        return new SelectListItem(this.expr_.clone(), this.alias_);
    }
}

