/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.LimitElement;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.WithClause;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.View;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.SqlCastException;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.PlanRootSink;

public abstract class QueryStmt
extends StatementBase {
    protected WithClause withClause_;
    protected List<OrderByElement> orderByElements_;
    protected LimitElement limitElement_;
    protected List<Expr> resultExprs_ = new ArrayList<Expr>();
    protected List<Expr> baseTblResultExprs_ = new ArrayList<Expr>();
    protected final ExprSubstitutionMap aliasSmap_;
    protected final List<Expr> ambiguousAliasList_;
    protected SortInfo sortInfo_;
    protected boolean evaluateOrderBy_;
    protected String origSqlString_ = null;
    protected boolean isRuntimeScalar_ = false;

    QueryStmt(List<OrderByElement> orderByElements, LimitElement limitElement) {
        this.orderByElements_ = orderByElements;
        this.sortInfo_ = null;
        this.limitElement_ = limitElement == null ? new LimitElement(null, null) : limitElement;
        this.aliasSmap_ = new ExprSubstitutionMap();
        this.ambiguousAliasList_ = new ArrayList<Expr>();
    }

    public void collectFromClauseTableRefs(List<TableRef> tblRefs) {
        this.collectTableRefs(tblRefs, true);
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        this.collectTableRefs(tblRefs, false);
    }

    public List<TableRef> collectTableRefs() {
        ArrayList tableRefs = Lists.newArrayList();
        this.collectTableRefs(tableRefs);
        return tableRefs;
    }

    protected void collectTableRefs(List<TableRef> tblRefs, boolean fromClauseOnly) {
        if (!fromClauseOnly && this.withClause_ != null) {
            for (View v : this.withClause_.getViews()) {
                v.getQueryStmt().collectTableRefs(tblRefs, fromClauseOnly);
            }
        }
    }

    public List<FeView> collectInlineViews() {
        HashSet inlineViews = Sets.newHashSet();
        this.collectInlineViews(inlineViews);
        return new ArrayList<FeView>(inlineViews);
    }

    public void collectInlineViews(Set<FeView> inlineViews) {
        if (this.withClause_ != null) {
            List<View> withClauseViews = this.withClause_.getViews();
            for (FeView feView : withClauseViews) {
                inlineViews.add(feView);
                feView.getQueryStmt().collectInlineViews(inlineViews);
            }
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        this.analyzeLimit(analyzer);
        if (this.hasWithClause()) {
            this.withClause_.analyze(analyzer);
        }
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChanges = false;
        if (this.hasWithClause()) {
            hasChanges = this.withClause_.resolveTableMask(analyzer);
        }
        return hasChanges;
    }

    public List<TupleId> getCorrelatedTupleIds() throws AnalysisException {
        ArrayList<TupleId> correlatedTupleIds = new ArrayList<TupleId>();
        TableRef correlatedRef = null;
        TableRef absoluteRef = null;
        HashSet<TupleId> tblRefIds = new HashSet<TupleId>();
        ArrayList<TableRef> tblRefs = new ArrayList<TableRef>();
        this.collectTableRefs(tblRefs, true);
        for (TableRef tblRef : tblRefs) {
            if (absoluteRef == null && !tblRef.isRelative()) {
                absoluteRef = tblRef;
            }
            if (tblRef.isCorrelated()) {
                CollectionTableRef t = (CollectionTableRef)tblRef;
                Preconditions.checkState((boolean)t.getResolvedPath().isRootedAtTuple());
                if (!tblRefIds.contains(t.getResolvedPath().getRootDesc().getId())) {
                    if (correlatedRef == null) {
                        correlatedRef = tblRef;
                    }
                    correlatedTupleIds.add(t.getResolvedPath().getRootDesc().getId());
                }
            }
            if (correlatedRef != null && absoluteRef != null) {
                throw new AnalysisException(String.format("Nested query is illegal because it contains a table reference '%s' correlated with an outer block as well as an uncorrelated one '%s':\n%s", correlatedRef.tableRefToSql(), absoluteRef.tableRefToSql(), this.toSql()));
            }
            tblRefIds.add(tblRef.getId());
        }
        return correlatedTupleIds;
    }

    private void analyzeLimit(Analyzer analyzer) throws AnalysisException {
        if (this.limitElement_.getOffsetExpr() != null && !this.hasOrderByClause()) {
            throw new AnalysisException("OFFSET requires an ORDER BY clause: " + this.limitElement_.toSql().trim());
        }
        this.limitElement_.analyze(analyzer);
    }

    protected void createSortInfo(Analyzer analyzer) throws AnalysisException {
        if (this.orderByElements_ == null) {
            this.evaluateOrderBy_ = false;
            return;
        }
        ArrayList<Expr> orderingExprs = new ArrayList<Expr>();
        ArrayList<Boolean> isAscOrder = new ArrayList<Boolean>();
        ArrayList<Boolean> nullsFirstParams = new ArrayList<Boolean>();
        for (OrderByElement orderByElement : this.orderByElements_) {
            if (orderByElement.getExpr().contains(Predicates.instanceOf(Subquery.class))) {
                throw new AnalysisException("Subqueries are not supported in the ORDER BY clause.");
            }
            orderingExprs.add(orderByElement.getExpr().clone());
            isAscOrder.add(orderByElement.isAsc());
            nullsFirstParams.add(orderByElement.getNullsFirstParam());
        }
        this.substituteOrdinalsAndAliases(orderingExprs, "ORDER BY", analyzer);
        if (!analyzer.isRootAnalyzer() && this.hasOffset() && !this.hasLimit()) {
            throw new AnalysisException("Order-by with offset without limit not supported in nested queries.");
        }
        this.sortInfo_ = new SortInfo(orderingExprs, isAscOrder, nullsFirstParams);
        if (!(this.hasLimit() || this.hasOffset() || analyzer.isRootAnalyzer())) {
            this.evaluateOrderBy_ = false;
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("Ignoring ORDER BY clause without LIMIT or OFFSET: ");
            strBuilder.append("ORDER BY ");
            strBuilder.append(this.orderByElements_.get(0).toSql());
            for (int i = 1; i < this.orderByElements_.size(); ++i) {
                strBuilder.append(", ").append(this.orderByElements_.get(i).toSql());
            }
            strBuilder.append(".\nAn ORDER BY appearing in a view, subquery, union operand, ");
            strBuilder.append("or an insert/ctas statement has no effect on the query result ");
            strBuilder.append("unless a LIMIT and/or OFFSET is used in conjunction ");
            strBuilder.append("with the ORDER BY.");
            analyzer.addWarning(strBuilder.toString());
        } else {
            this.evaluateOrderBy_ = true;
        }
    }

    protected void createSortTupleInfo(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)this.evaluateOrderBy_);
        for (Expr orderingExpr : this.sortInfo_.getSortExprs()) {
            if (!orderingExpr.getType().isComplexType()) continue;
            throw new AnalysisException(String.format("ORDER BY expression '%s' with complex type '%s' is not supported.", orderingExpr.toSql(), orderingExpr.getType().toSql()));
        }
        this.checkTypeValidityForSorting(analyzer);
        this.sortInfo_.createSortTupleInfo(this.resultExprs_, analyzer);
        ExprSubstitutionMap smap = this.sortInfo_.getOutputSmap();
        for (int i = 0; i < smap.size(); ++i) {
            if (!(smap.getLhs().get(i) instanceof SlotRef) || !(smap.getRhs().get(i) instanceof SlotRef)) continue;
            SlotRef inputSlotRef = (SlotRef)smap.getLhs().get(i);
            SlotRef outputSlotRef = (SlotRef)smap.getRhs().get(i);
            if (this.hasLimit()) {
                analyzer.registerValueTransfer(inputSlotRef.getSlotId(), outputSlotRef.getSlotId());
                continue;
            }
            analyzer.createAuxEqPredicate(outputSlotRef, inputSlotRef);
        }
        this.substituteResultExprs(smap, analyzer);
    }

    private void checkTypeValidityForSorting(Analyzer analyzer) throws AnalysisException {
        for (Expr expr : this.getResultExprs()) {
            Type exprType = expr.getType();
            if (SortInfo.isValidInSortingTuple(exprType)) continue;
            String error = "Sorting is not supported if the select list contains collection(s) nested in struct(s).";
            throw new AnalysisException(error);
        }
    }

    protected void substituteOrdinalsAndAliases(List<Expr> exprs, String errorPrefix, Analyzer analyzer) throws AnalysisException {
        for (int i = 0; i < exprs.size(); ++i) {
            exprs.set(i, this.resolveReferenceExpr(exprs.get(i), errorPrefix, analyzer, true));
        }
    }

    protected Expr resolveReferenceExpr(Expr expr, String errorPrefix, Analyzer analyzer, boolean allowOrdinal) throws AnalysisException {
        if (expr instanceof SlotRef) {
            if (this.ambiguousAliasList_.contains(expr)) {
                throw new AnalysisException(errorPrefix + ": ambiguous alias: '" + expr.toSql() + "'");
            }
            return expr.trySubstitute(this.aliasSmap_, this.analyzer_, false);
        }
        boolean wasNumber = expr instanceof NumericLiteral;
        expr.analyze(analyzer);
        if (allowOrdinal && wasNumber && Expr.IS_INT_LITERAL.apply((Object)expr)) {
            long pos = ((NumericLiteral)expr).getLongValue();
            if (pos < 1L) {
                throw new AnalysisException(errorPrefix + ": ordinal must be >= 1: " + expr.toSql());
            }
            if (pos > (long)this.resultExprs_.size()) {
                throw new AnalysisException(errorPrefix + ": ordinal exceeds the number of items in the SELECT list: " + expr.toSql());
            }
            return this.resultExprs_.get((int)pos - 1).clone();
        }
        return expr;
    }

    public abstract void getMaterializedTupleIds(List<TupleId> var1);

    @Override
    public List<Expr> getResultExprs() {
        return this.resultExprs_;
    }

    public void setWithClause(WithClause withClause) {
        this.withClause_ = withClause;
    }

    public boolean hasWithClause() {
        return this.withClause_ != null;
    }

    public WithClause getWithClause() {
        return this.withClause_;
    }

    public boolean hasOrderByClause() {
        return this.orderByElements_ != null;
    }

    public boolean hasLimit() {
        return this.limitElement_.getLimitExpr() != null;
    }

    public String getOrigSqlString() {
        return this.origSqlString_;
    }

    public boolean isRuntimeScalar() {
        return this.isRuntimeScalar_;
    }

    public void setIsRuntimeScalar(boolean isRuntimeScalar) {
        this.isRuntimeScalar_ = isRuntimeScalar;
    }

    public long getLimit() {
        return this.limitElement_.getLimit();
    }

    public boolean hasOffset() {
        return this.limitElement_.getOffsetExpr() != null;
    }

    public long getOffset() {
        return this.limitElement_.getOffset();
    }

    public SortInfo getSortInfo() {
        return this.sortInfo_;
    }

    public boolean evaluateOrderBy() {
        return this.evaluateOrderBy_;
    }

    public List<Expr> getBaseTblResultExprs() {
        return this.baseTblResultExprs_;
    }

    public void setLimit(long limit) throws SqlCastException {
        Preconditions.checkState((limit >= 0L ? 1 : 0) != 0);
        long newLimit = this.hasLimit() ? Math.min(limit, this.getLimit()) : limit;
        this.limitElement_ = new LimitElement(NumericLiteral.create(newLimit, (Type)Type.BIGINT), this.limitElement_.getOffsetExpr());
    }

    public abstract void materializeRequiredSlots(Analyzer var1);

    protected void materializeSlots(Analyzer analyzer, List<Expr> exprs) {
        ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
        for (Expr e : exprs) {
            e.getIds(null, slotIds);
        }
        analyzer.getDescTbl().markSlotsMaterialized(slotIds);
    }

    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.resultExprs_ = Expr.substituteList(this.resultExprs_, smap, analyzer, true);
    }

    public DataSink createDataSink(List<Expr> resultExprs) {
        return new PlanRootSink(resultExprs);
    }

    public List<OrderByElement> cloneOrderByElements() {
        if (this.orderByElements_ == null) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)this.orderByElements_.size());
        for (OrderByElement o : this.orderByElements_) {
            result.add(o.clone());
        }
        return result;
    }

    public WithClause cloneWithClause() {
        return this.withClause_ != null ? this.withClause_.clone() : null;
    }

    protected QueryStmt(QueryStmt other) {
        super(other);
        this.withClause_ = other.cloneWithClause();
        this.orderByElements_ = other.cloneOrderByElements();
        this.limitElement_ = other.limitElement_.clone();
        this.resultExprs_ = Expr.cloneList(other.resultExprs_);
        this.baseTblResultExprs_ = Expr.cloneList(other.baseTblResultExprs_);
        this.aliasSmap_ = other.aliasSmap_.clone();
        this.ambiguousAliasList_ = Expr.cloneList(other.ambiguousAliasList_);
        this.sortInfo_ = other.sortInfo_ != null ? other.sortInfo_.clone() : null;
        this.analyzer_ = other.analyzer_;
        this.evaluateOrderBy_ = other.evaluateOrderBy_;
        this.origSqlString_ = other.origSqlString_;
        this.isRuntimeScalar_ = other.isRuntimeScalar_;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.orderByElements_ != null) {
            for (OrderByElement o : this.orderByElements_) {
                o.getExpr().reset();
            }
        }
        this.limitElement_.reset();
        this.resultExprs_.clear();
        this.baseTblResultExprs_.clear();
        this.aliasSmap_.clear();
        this.ambiguousAliasList_.clear();
        this.sortInfo_ = null;
        this.evaluateOrderBy_ = false;
    }

    @Override
    public abstract QueryStmt clone();
}

