/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.StorageHandlerUri;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TPrivilegeScope;

public class PrivilegeSpec
extends StmtNode {
    private final TPrivilegeScope scope_;
    private final TPrivilegeLevel privilegeLevel_;
    private final TableName tableName_;
    private final HdfsUri uri_;
    private final String storageType_;
    private final String storageUri_;
    private final List<String> columnNames_;
    private final FunctionName functionName_;
    private String dbName_;
    private String serverName_;
    private String ownerName_;

    private PrivilegeSpec(TPrivilegeLevel privilegeLevel, TPrivilegeScope scope, String serverName, String dbName, TableName tableName, HdfsUri uri, String storageType, String storageUri, List<String> columnNames, FunctionName functionName) {
        Preconditions.checkNotNull((Object)((Object)scope));
        Preconditions.checkNotNull((Object)((Object)privilegeLevel));
        this.privilegeLevel_ = privilegeLevel;
        this.scope_ = scope;
        this.serverName_ = serverName;
        this.tableName_ = tableName;
        this.dbName_ = this.tableName_ != null ? this.tableName_.getDb() : dbName;
        this.uri_ = uri;
        this.storageType_ = storageType;
        this.storageUri_ = storageUri;
        this.columnNames_ = columnNames;
        this.functionName_ = functionName;
    }

    public static PrivilegeSpec createServerScopedPriv(TPrivilegeLevel privilegeLevel) {
        return PrivilegeSpec.createServerScopedPriv(privilegeLevel, null);
    }

    public static PrivilegeSpec createServerScopedPriv(TPrivilegeLevel privilegeLevel, String serverName) {
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.SERVER, serverName, null, null, null, null, null, null, null);
    }

    public static PrivilegeSpec createDbScopedPriv(TPrivilegeLevel privilegeLevel, String dbName) {
        Preconditions.checkNotNull((Object)dbName);
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.DATABASE, null, dbName, null, null, null, null, null, null);
    }

    public static PrivilegeSpec createTableScopedPriv(TPrivilegeLevel privilegeLevel, TableName tableName) {
        Preconditions.checkNotNull((Object)tableName);
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.TABLE, null, null, tableName, null, null, null, null, null);
    }

    public static PrivilegeSpec createUdfScopedPriv(TPrivilegeLevel privilegeLevel, FunctionName functionName) {
        Preconditions.checkNotNull((Object)functionName);
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.USER_DEFINED_FN, null, null, null, null, null, null, null, functionName);
    }

    public static PrivilegeSpec createColumnScopedPriv(TPrivilegeLevel privilegeLevel, TableName tableName, List<String> columnNames) {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull(columnNames);
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.COLUMN, null, null, tableName, null, null, null, columnNames, null);
    }

    public static PrivilegeSpec createUriScopedPriv(TPrivilegeLevel privilegeLevel, HdfsUri uri) {
        Preconditions.checkNotNull((Object)uri);
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.URI, null, null, null, uri, null, null, null, null);
    }

    public static PrivilegeSpec createStorageHandlerUriScopedPriv(TPrivilegeLevel privilegeLevel, StorageHandlerUri storageHandlerUri) {
        Preconditions.checkNotNull((Object)storageHandlerUri);
        return new PrivilegeSpec(privilegeLevel, TPrivilegeScope.STORAGEHANDLER_URI, null, null, null, null, storageHandlerUri.getStorageType(), storageHandlerUri.getStoreUrl(), null, null);
    }

    public List<TPrivilege> toThrift() {
        ArrayList<TPrivilege> privileges = new ArrayList<TPrivilege>();
        if (this.scope_ == TPrivilegeScope.COLUMN) {
            for (String column : this.columnNames_) {
                privileges.add(this.createTPrivilege(column));
            }
        } else {
            privileges.add(this.createTPrivilege(null));
        }
        return privileges;
    }

    private TPrivilege createTPrivilege(String columnName) {
        Preconditions.checkState((boolean)(columnName == null ^ this.scope_ == TPrivilegeScope.COLUMN));
        TPrivilege privilege = new TPrivilege();
        privilege.setScope(this.scope_);
        privilege.setServer_name(this.serverName_);
        privilege.setPrivilege_level(this.privilegeLevel_);
        if (this.dbName_ != null) {
            privilege.setDb_name(this.dbName_);
        }
        if (this.tableName_ != null) {
            privilege.setTable_name(this.tableName_.getTbl());
        }
        if (this.uri_ != null) {
            privilege.setUri(this.uri_.toString());
        }
        if (this.storageType_ != null) {
            privilege.setStorage_type(this.storageType_);
        }
        if (this.storageUri_ != null) {
            privilege.setStorage_url(this.storageUri_);
        }
        if (columnName != null) {
            privilege.setColumn_name(columnName);
        }
        if (this.functionName_ != null) {
            privilege.setFn_name(this.functionName_.getFunction());
        }
        privilege.setCreate_time_ms(-1L);
        return privilege;
    }

    public static String getTablePath(TPrivilege privilege) {
        Preconditions.checkState((privilege.getScope() == TPrivilegeScope.COLUMN ? 1 : 0) != 0);
        Joiner joiner = Joiner.on((String)".");
        return joiner.join((Object)privilege.getServer_name(), (Object)privilege.getDb_name(), new Object[]{privilege.getTable_name()});
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder(this.privilegeLevel_.toString());
        if (this.scope_ != TPrivilegeScope.COLUMN) {
            sb.append(" ON ");
            sb.append(this.scope_.toString());
        }
        if (this.scope_ == TPrivilegeScope.SERVER && this.serverName_ != null) {
            sb.append(" " + this.serverName_);
        } else if (this.scope_ == TPrivilegeScope.DATABASE) {
            sb.append(" " + this.dbName_);
        } else if (this.scope_ == TPrivilegeScope.TABLE) {
            sb.append(" " + this.tableName_.toString());
        } else if (this.scope_ == TPrivilegeScope.USER_DEFINED_FN) {
            sb.append(" " + this.functionName_.toString());
        } else if (this.scope_ == TPrivilegeScope.COLUMN) {
            sb.append(" (");
            sb.append(Joiner.on((String)",").join(this.columnNames_));
            sb.append(")");
            sb.append(" ON TABLE " + this.tableName_.toString());
        } else if (this.scope_ == TPrivilegeScope.URI) {
            sb.append(" '" + this.uri_.getLocation() + "'");
        } else if (this.scope_ == TPrivilegeScope.STORAGEHANDLER_URI) {
            sb.append(" '" + this.storageType_ + "://" + this.storageUri_ + "'");
        }
        return sb.toString();
    }

    public void collectTableRefs(List<TableRef> tblRefs) {
        if (this.tableName_ != null) {
            tblRefs.add(new TableRef(this.tableName_.toPath(), null));
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        String configServerName = analyzer.getAuthzConfig().getServerName();
        if (this.serverName_ != null && !this.serverName_.equals(configServerName)) {
            throw new AnalysisException(String.format("Specified server name '%s' does not match the configured server name '%s'", this.serverName_, configServerName));
        }
        this.serverName_ = configServerName;
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.serverName_) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)this.scope_));
        switch (this.scope_) {
            case SERVER: {
                break;
            }
            case DATABASE: {
                this.analyzeTargetDatabase(analyzer);
                break;
            }
            case URI: {
                Preconditions.checkNotNull((Object)this.uri_);
                if (this.privilegeLevel_ != TPrivilegeLevel.ALL) {
                    throw new AnalysisException("Only 'ALL' privilege may be applied at URI scope in privilege spec.");
                }
                this.uri_.analyze(analyzer, Privilege.ALL, false);
                break;
            }
            case STORAGEHANDLER_URI: {
                if (this.privilegeLevel_ == TPrivilegeLevel.RWSTORAGE) break;
                throw new AnalysisException("Only 'RWSTORAGE' privilege may be applied at storage handler URI scope in privilege spec.");
            }
            case TABLE: {
                this.analyzeTargetTable(analyzer);
                break;
            }
            case COLUMN: {
                this.analyzeColumnPrivScope(analyzer);
                break;
            }
            case USER_DEFINED_FN: {
                this.analyzeUdf(analyzer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown TPrivilegeScope in privilege spec: " + this.scope_.toString());
            }
        }
    }

    private void analyzeColumnPrivScope(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.scope_ == TPrivilegeScope.COLUMN ? 1 : 0) != 0);
        Preconditions.checkNotNull(this.columnNames_);
        if (this.columnNames_.isEmpty()) {
            throw new AnalysisException("Empty column list in column privilege spec.");
        }
        if (this.privilegeLevel_ != TPrivilegeLevel.SELECT) {
            throw new AnalysisException("Only 'SELECT' privileges are allowed in a column privilege spec.");
        }
        FeTable table = this.analyzeTargetTable(analyzer);
        if (table instanceof FeDataSourceTable) {
            throw new AnalysisException("Column-level privileges on external data source tables are not supported.");
        }
        for (String columnName : this.columnNames_) {
            if (table.getColumn(columnName) != null) continue;
            throw new AnalysisException(String.format("Error setting/showing column-level privileges for table '%s'. Verify that both table and columns exist and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.", this.tableName_.toString()));
        }
    }

    private FeTable analyzeTargetTable(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.scope_ == TPrivilegeScope.TABLE || this.scope_ == TPrivilegeScope.COLUMN ? 1 : 0) != 0);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.tableName_.getTbl()) ? 1 : 0) != 0);
        if (this.privilegeLevel_ == TPrivilegeLevel.CREATE) {
            throw new AnalysisException("Create-level privileges on tables are not supported.");
        }
        FeTable table = null;
        try {
            this.dbName_ = analyzer.getTargetDbName(this.tableName_);
            Preconditions.checkNotNull((Object)this.dbName_);
            table = analyzer.getTable(this.dbName_, this.tableName_.getTbl(), true);
            this.ownerName_ = table.getOwnerUser();
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(e.getMessage(), e);
        }
        catch (AnalysisException e) {
            throw new AnalysisException(String.format("Error setting/showing privileges for table '%s'. Verify that the table exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.", this.tableName_.toString()));
        }
        Preconditions.checkNotNull((Object)table);
        return table;
    }

    private void analyzeTargetDatabase(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.dbName_) ? 1 : 0) != 0);
        try {
            FeDb db = analyzer.getDb(this.dbName_, true);
            this.ownerName_ = db.getOwnerUser();
        }
        catch (AnalysisException e) {
            throw new AnalysisException(String.format("Error setting/showing privileges for database '%s'. Verify that the database exists and that you have permissions to issue a GRANT/REVOKE/SHOW GRANT statement.", this.dbName_));
        }
    }

    private void analyzeUdf(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.scope_ == TPrivilegeScope.USER_DEFINED_FN ? 1 : 0) != 0);
        List<String> path = this.functionName_.getFnNamePath();
        if (path.size() == 2 && (path.get(0).equals("*") || path.get(1).equals("*"))) {
            this.dbName_ = path.get(0);
            this.functionName_.setDb(path.get(0));
            this.functionName_.setFunction(path.get(1));
            return;
        }
        this.functionName_.analyze(analyzer, false);
        Preconditions.checkArgument((!this.functionName_.getDb().equals("*") ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.functionName_.getFunction().equals("*") ? 1 : 0) != 0);
        this.dbName_ = analyzer.getTargetDbName(this.functionName_);
    }

    public TPrivilegeScope getScope() {
        return this.scope_;
    }

    public TableName getTableName() {
        return this.tableName_;
    }

    public HdfsUri getUri() {
        return this.uri_;
    }

    public String getStorageType() {
        return this.storageType_;
    }

    public String getStorageUri() {
        return this.storageUri_;
    }

    public String getDbName() {
        return this.dbName_;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getOwnerName() {
        return this.ownerName_;
    }
}

