/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.Optional;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;

public abstract class Predicate
extends Expr {
    protected boolean isEqJoinConjunct_;
    protected boolean hasAlwaysTrueHint_;
    protected Optional<Boolean> shouldConvertToCNF_ = Optional.empty();
    protected double selectivityHint_;

    public Predicate() {
        this.isEqJoinConjunct_ = false;
        this.hasAlwaysTrueHint_ = false;
        this.selectivityHint_ = -1.0;
    }

    protected Predicate(Predicate other) {
        super(other);
        this.isEqJoinConjunct_ = other.isEqJoinConjunct_;
        this.hasAlwaysTrueHint_ = other.hasAlwaysTrueHint_;
        this.selectivityHint_ = other.selectivityHint_;
    }

    public void setIsEqJoinConjunct(boolean v) {
        this.isEqJoinConjunct_ = v;
    }

    public void setHasAlwaysTrueHint(boolean v) {
        this.hasAlwaysTrueHint_ = v;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.type_ = Type.BOOLEAN;
        this.numDistinctValues_ = 3L;
        this.analyzeHints(analyzer);
        this.analyzeSelectivityHint(analyzer);
    }

    protected void analyzeSelectivityHint(Analyzer analyzer) {
        if (this.selectivityHint_ >= 0.0) {
            if (this.selectivityHint_ == 0.0 || this.selectivityHint_ > 1.0) {
                analyzer.addWarning("Invalid selectivity hint value: " + this.selectivityHint_ + ", allowed value should be a double value in (0, 1].");
            } else {
                this.selectivity_ = this.selectivityHint_;
            }
        }
    }

    public boolean isSingleColumnPredicate(Reference<SlotRef> slotRefRef, Reference<Integer> idxRef) {
        int i;
        SlotRef slotRef = null;
        for (i = 0; i < this.children_.size() && (slotRef = ((Expr)this.getChild(i)).unwrapSlotRef(false)) == null; ++i) {
        }
        if (slotRef == null) {
            return false;
        }
        for (int j = 0; j < this.children_.size(); ++j) {
            if (i == j || ((Expr)this.getChild(j)).isConstant()) continue;
            return false;
        }
        if (slotRefRef != null) {
            slotRefRef.setRef(slotRef);
        }
        if (idxRef != null) {
            idxRef.setRef(i);
        }
        return true;
    }

    private boolean lookupShouldConvertToCNF() {
        for (int i = 0; i < this.children_.size(); ++i) {
            if (((Expr)this.getChild(i)).shouldConvertToCNF()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldConvertToCNF() {
        if (this.shouldConvertToCNF_.isPresent()) {
            return this.shouldConvertToCNF_.get();
        }
        boolean result = this.lookupShouldConvertToCNF();
        this.shouldConvertToCNF_ = Optional.of(result);
        return result;
    }

    public static boolean isEquivalencePredicate(Expr expr) {
        return expr instanceof BinaryPredicate && ((BinaryPredicate)expr).getOp().isEquivalence();
    }

    public static boolean isSqlEquivalencePredicate(Expr expr) {
        return expr instanceof BinaryPredicate && ((BinaryPredicate)expr).getOp().isSqlEquivalence();
    }

    public static boolean isSingleRangePredicate(Expr expr) {
        return expr instanceof BinaryPredicate && ((BinaryPredicate)expr).getOp().isSingleRange();
    }

    public Pair<SlotId, SlotId> getEqSlots() {
        return null;
    }

    public SlotRef getBoundSlot() {
        return null;
    }

    public boolean hasAlwaysTrueHint() {
        return this.hasAlwaysTrueHint_;
    }

    public void setSelectivityHint(double selectivityHint) {
        this.selectivityHint_ = selectivityHint;
    }

    public boolean hasValidSelectivityHint() {
        return this.selectivityHint_ > 0.0 && this.selectivityHint_ <= 1.0;
    }
}

