/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PlanHint {
    private final String name_;
    private final List<String> args_;

    public PlanHint(String name) {
        this.name_ = name;
        this.args_ = new ArrayList<String>();
    }

    public PlanHint(String name, List<String> args) {
        this.name_ = name;
        this.args_ = args;
    }

    public boolean is(String s) {
        return this.name_.equalsIgnoreCase(s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PlanHint oh = (PlanHint)o;
        return this.name_.equals(oh.name_) && this.args_.equals(oh.args_);
    }

    public int hashCode() {
        return Objects.hash(this.name_, this.args_);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name_);
        if (!this.args_.isEmpty()) {
            sb.append("(");
            sb.append(Joiner.on((String)",").join(this.args_));
            sb.append(")");
        }
        return sb.toString();
    }

    public List<String> getArgs() {
        return this.args_;
    }

    public String toSql() {
        return this.toString();
    }
}

