/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.CollectionStructType;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.VirtualTable;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.thrift.TVirtualColumnType;
import org.apache.impala.util.AcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path {
    private static final Logger LOG = LoggerFactory.getLogger(Path.class);
    public static final String ARRAY_ITEM_FIELD_NAME = "item";
    public static final String ARRAY_POS_FIELD_NAME = "pos";
    public static final String MAP_KEY_FIELD_NAME = "key";
    public static final String MAP_VALUE_FIELD_NAME = "value";
    private final List<String> rawPath_;
    private final TupleDescriptor rootDesc_;
    private final FeTable rootTable_;
    private final Path rootPath_;
    private final List<Type> matchedTypes_ = new ArrayList<Type>();
    private final List<Integer> matchedPositions_ = new ArrayList<Integer>();
    private int firstCollectionPathIdx_ = -1;
    private int firstCollectionTypeIdx_ = -1;
    private boolean isResolved_ = false;
    private List<Integer> absolutePath_ = null;
    private TVirtualColumnType virtualColType_ = TVirtualColumnType.NONE;
    private Path pathBeforeMasking_ = null;

    public Path(TupleDescriptor rootDesc, List<String> rawPath) {
        Preconditions.checkNotNull((Object)rootDesc);
        Preconditions.checkNotNull(rawPath);
        this.rootTable_ = rootDesc.getTable();
        this.rootDesc_ = rootDesc;
        this.rootPath_ = null;
        this.rawPath_ = rawPath;
    }

    public Path(FeTable rootTable, List<String> rawPath) {
        Preconditions.checkNotNull((Object)rootTable);
        Preconditions.checkNotNull(rawPath);
        this.rootTable_ = rootTable;
        this.rootDesc_ = null;
        this.rootPath_ = null;
        this.rawPath_ = rawPath;
    }

    public Path(Path rootPath, List<String> relRawPath) {
        Preconditions.checkNotNull((Object)rootPath);
        Preconditions.checkState((boolean)rootPath.isResolved());
        Preconditions.checkNotNull(relRawPath);
        this.rootTable_ = rootPath.rootTable_;
        this.rootDesc_ = rootPath.rootDesc_;
        this.rootPath_ = rootPath;
        this.rawPath_ = Lists.newArrayListWithCapacity((int)(rootPath.getRawPath().size() + relRawPath.size()));
        this.rawPath_.addAll(rootPath.getRawPath());
        this.rawPath_.addAll(relRawPath);
        this.matchedTypes_.addAll(rootPath.matchedTypes_);
        this.matchedPositions_.addAll(rootPath.matchedPositions_);
        this.firstCollectionPathIdx_ = rootPath.firstCollectionPathIdx_;
        this.firstCollectionTypeIdx_ = rootPath.firstCollectionTypeIdx_;
    }

    public boolean resolve() {
        if (!this.resolveNonVirtualPath()) {
            return this.resolveVirtualColumn();
        }
        return true;
    }

    private boolean resolveNonVirtualPath() {
        if (this.isResolved_) {
            return true;
        }
        Preconditions.checkState((this.rootDesc_ != null || this.rootTable_ != null ? 1 : 0) != 0);
        Type currentType = null;
        int rawPathIdx = 0;
        if (this.rootPath_ != null) {
            currentType = this.rootPath_.destType();
            rawPathIdx = this.rootPath_.getRawPath().size();
        } else {
            currentType = this.rootDesc_ != null ? this.rootDesc_.getType() : this.rootTable_.getType().getItemType();
        }
        while (rawPathIdx < this.rawPath_.size()) {
            if (!currentType.isComplexType()) {
                return false;
            }
            StructType structType = Path.getTypeAsStruct(currentType);
            if (LOG.isTraceEnabled()) {
                LOG.trace("structType: {}", (Object)structType.toSql());
            }
            StructField field = structType.getField(this.rawPath_.get(rawPathIdx));
            if (LOG.isTraceEnabled()) {
                LOG.trace("field: {}", field == null ? null : field.toSql(0));
            }
            if (field == null) {
                if (structType instanceof CollectionStructType) {
                    field = ((CollectionStructType)structType).getOptionalField();
                    if (field.getType().isCollectionType()) {
                        return false;
                    }
                } else {
                    return false;
                }
                this.matchedTypes_.add(field.getType());
                this.matchedPositions_.add(field.getPosition());
                currentType = field.getType();
                continue;
            }
            this.matchedTypes_.add(field.getType());
            this.matchedPositions_.add(field.getPosition());
            if (field.getType().isCollectionType() && this.firstCollectionPathIdx_ == -1) {
                Preconditions.checkState((this.firstCollectionTypeIdx_ == -1 ? 1 : 0) != 0);
                this.firstCollectionPathIdx_ = rawPathIdx;
                this.firstCollectionTypeIdx_ = this.matchedTypes_.size() - 1;
            }
            currentType = field.getType();
            ++rawPathIdx;
        }
        Preconditions.checkState((this.matchedTypes_.size() == this.matchedPositions_.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.matchedTypes_.size() >= this.rawPath_.size() ? 1 : 0) != 0);
        this.isResolved_ = true;
        return true;
    }

    private boolean resolveVirtualColumn() {
        if (this.isResolved_) {
            return true;
        }
        if (this.rootTable_ == null) {
            return false;
        }
        if (this.rootDesc_ != null && this.rootDesc_.getType() != this.rootTable_.getType().getItemType()) {
            return false;
        }
        if (this.rawPath_.size() != 1) {
            return false;
        }
        String colName = this.rawPath_.get(0);
        List<VirtualColumn> virtualColumns = this.rootTable_.getVirtualColumns();
        for (VirtualColumn vCol : virtualColumns) {
            if (!vCol.getName().equalsIgnoreCase(colName)) continue;
            this.virtualColType_ = vCol.getVirtualColumnType();
            this.matchedTypes_.add(vCol.getType());
            this.matchedPositions_.add(vCol.getPosition());
            this.isResolved_ = true;
            return true;
        }
        return false;
    }

    public static StructType getTypeAsStruct(Type t) {
        Preconditions.checkState((boolean)t.isComplexType());
        if (t.isStructType()) {
            return (StructType)t;
        }
        if (t.isArrayType()) {
            return CollectionStructType.createArrayStructType((ArrayType)t);
        }
        Preconditions.checkState((boolean)t.isMapType());
        return CollectionStructType.createMapStructType((MapType)t);
    }

    public static List<TableName> getCandidateTables(List<String> path, String sessionDb) {
        Preconditions.checkArgument((path != null && !path.isEmpty() ? 1 : 0) != 0);
        ArrayList<TableName> result = new ArrayList<TableName>();
        int end = Math.min(2, path.size());
        for (int tblNameIdx = 0; tblNameIdx < end; ++tblNameIdx) {
            String dbName = tblNameIdx == 0 ? sessionDb : path.get(0);
            String tblName = path.get(tblNameIdx);
            String vTblName = null;
            if (IcebergMetadataTable.canBeIcebergMetadataTable(path)) {
                vTblName = path.get(2);
            }
            result.add(new TableName(dbName, tblName, vTblName));
        }
        return result;
    }

    public FeTable getRootTable() {
        return this.rootTable_;
    }

    public TupleDescriptor getRootDesc() {
        return this.rootDesc_;
    }

    public boolean isRootedAtTable() {
        return this.rootTable_ != null;
    }

    public boolean isRootedAtTuple() {
        return this.rootDesc_ != null;
    }

    public List<String> getRawPath() {
        return this.rawPath_;
    }

    public boolean isResolved() {
        return this.isResolved_;
    }

    public TVirtualColumnType getVirtualColumnType() {
        return this.virtualColType_;
    }

    public boolean isVirtualColumn() {
        return this.virtualColType_ != TVirtualColumnType.NONE;
    }

    public boolean isMaskedPath() {
        return this.pathBeforeMasking_ != null;
    }

    public Path getPathBeforeMasking() {
        return this.pathBeforeMasking_;
    }

    public void setPathBeforeMasking(Path p) {
        Preconditions.checkState((boolean)p.isResolved());
        this.pathBeforeMasking_ = p;
    }

    public List<Type> getMatchedTypes() {
        Preconditions.checkState((boolean)this.isResolved_);
        return this.matchedTypes_;
    }

    public boolean hasNonDestCollection() {
        Preconditions.checkState((boolean)this.isResolved_);
        return this.firstCollectionPathIdx_ != -1 && this.firstCollectionPathIdx_ != this.rawPath_.size() - 1;
    }

    public String getFirstCollectionName() {
        Preconditions.checkState((boolean)this.isResolved_);
        if (this.firstCollectionPathIdx_ == -1) {
            return null;
        }
        return this.rawPath_.get(this.firstCollectionPathIdx_);
    }

    public Type getFirstCollectionType() {
        Preconditions.checkState((boolean)this.isResolved_);
        if (this.firstCollectionTypeIdx_ == -1) {
            return null;
        }
        return this.matchedTypes_.get(this.firstCollectionTypeIdx_);
    }

    public int getFirstCollectionIndex() {
        Preconditions.checkState((boolean)this.isResolved_);
        return this.firstCollectionTypeIdx_;
    }

    public Type destType() {
        Preconditions.checkState((boolean)this.isResolved_);
        if (!this.matchedTypes_.isEmpty()) {
            return this.matchedTypes_.get(this.matchedTypes_.size() - 1);
        }
        if (this.rootDesc_ != null) {
            return this.rootDesc_.getType();
        }
        if (this.rootTable_ != null) {
            return this.rootTable_.getType();
        }
        return null;
    }

    public FeTable destTable() {
        Preconditions.checkState((boolean)this.isResolved_);
        if (this.rootTable_ != null && this.rootDesc_ == null && this.matchedTypes_.isEmpty()) {
            return this.rootTable_;
        }
        return null;
    }

    public Column destColumn() {
        Preconditions.checkState((boolean)this.isResolved_);
        if (this.rootTable_ == null || this.rawPath_.size() != 1) {
            return null;
        }
        return this.rootTable_.getColumn(this.rawPath_.get(this.rawPath_.size() - 1));
    }

    public TupleDescriptor destTupleDesc() {
        Preconditions.checkState((boolean)this.isResolved_);
        if (this.rootDesc_ != null && this.matchedTypes_.isEmpty()) {
            return this.rootDesc_;
        }
        return null;
    }

    public List<String> getFullyQualifiedRawPath() {
        Preconditions.checkState((this.rootTable_ != null || this.rootDesc_ != null ? 1 : 0) != 0);
        ArrayList result = Lists.newArrayListWithCapacity((int)(this.rawPath_.size() + 2));
        if (this.rootDesc_ != null) {
            result.addAll(Lists.newArrayList((Object[])this.rootDesc_.getAlias().split("\\.")));
        } else {
            result.add(this.rootTable_.getDb().getName());
            result.add(this.rootTable_.getName());
            if (this.rootTable_ instanceof VirtualTable) {
                result.add(((IcebergMetadataTable)this.rootTable_).getMetadataTableName());
            }
        }
        result.addAll(this.rawPath_);
        return result;
    }

    public boolean comesFromIcebergMetadataTable() {
        Preconditions.checkState((this.rootTable_ != null || this.rootDesc_ != null ? 1 : 0) != 0);
        if (this.rootDesc_ != null) {
            return this.rootDesc_.getTable() instanceof IcebergMetadataTable;
        }
        return this.rootTable_ instanceof IcebergMetadataTable;
    }

    public List<String> getCanonicalPath() {
        ArrayList<String> result = new ArrayList<String>();
        this.getCanonicalPath(result);
        return result;
    }

    private void getCanonicalPath(List<String> result) {
        Type currentType = null;
        if (this.isRootedAtTuple()) {
            this.rootDesc_.getPath().getCanonicalPath(result);
            currentType = this.rootDesc_.getType();
        } else {
            Preconditions.checkState((boolean)this.isRootedAtTable());
            result.add(this.rootTable_.getTableName().getDb());
            result.add(this.rootTable_.getTableName().getTbl());
            currentType = this.rootTable_.getType().getItemType();
        }
        for (int i = 0; i < this.matchedPositions_.size(); ++i) {
            StructType structType = Path.getTypeAsStruct(currentType);
            int matchPos = this.matchedPositions_.get(i);
            Preconditions.checkState((matchPos < structType.getFields().size() ? 1 : 0) != 0);
            StructField match = structType.getFields().get(matchPos);
            result.add(match.getName());
            currentType = match.getType();
        }
    }

    public List<Integer> getAbsolutePath() {
        if (this.absolutePath_ != null) {
            return this.absolutePath_;
        }
        Preconditions.checkState((boolean)this.isResolved_);
        this.absolutePath_ = new ArrayList<Integer>();
        if (this.rootDesc_ != null) {
            this.absolutePath_.addAll(this.rootDesc_.getPath().getAbsolutePath());
        }
        this.absolutePath_.addAll(this.matchedPositions_);
        if (!this.absolutePath_.isEmpty() && this.matchedPositions_.size() == this.absolutePath_.size() && this.rootTable_ != null && AcidUtils.isFullAcidTable(this.rootTable_.getMetaStoreTable().getParameters())) {
            this.convertToFullAcidFilePath();
        }
        return this.absolutePath_;
    }

    private void convertToFullAcidFilePath() {
        if (this.virtualColType_ != TVirtualColumnType.NONE) {
            return;
        }
        int numPartitions = this.rootTable_.getNumClusteringCols();
        if (this.absolutePath_.get(0) == numPartitions) {
            Preconditions.checkState((this.absolutePath_.size() == 2 ? 1 : 0) != 0);
            this.absolutePath_.remove(0);
            this.absolutePath_.set(0, this.absolutePath_.get(0) + numPartitions);
        } else if (this.absolutePath_.get(0) > numPartitions) {
            this.absolutePath_.add(0, numPartitions + 5);
            this.absolutePath_.set(1, this.absolutePath_.get(1) - numPartitions - 1);
        }
    }

    public String toString() {
        Preconditions.checkState((this.rootTable_ != null || this.rootDesc_ != null ? 1 : 0) != 0);
        String pathRoot = null;
        pathRoot = this.rootDesc_ != null ? this.rootDesc_.getAlias() : this.rootTable_.getFullName();
        if (this.rawPath_.isEmpty()) {
            return pathRoot;
        }
        return pathRoot + "." + Joiner.on((String)".").join(this.rawPath_);
    }

    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("rootTable", (Object)this.rootTable_).add("rootDesc", (Object)this.rootDesc_).add("rawPath", this.rawPath_).toString();
    }

    public static List<String> createRawPath(String rootAlias, String fieldName) {
        ArrayList result = Lists.newArrayList((Object[])rootAlias.split("\\."));
        result.add(fieldName);
        return result;
    }

    public static Path createRelPath(Path rootPath, String ... fieldNames) {
        Preconditions.checkState((boolean)rootPath.isResolved());
        Path result = new Path(rootPath, (List<String>)Lists.newArrayList((Object[])fieldNames));
        return result;
    }

    public static enum PathType {
        SLOT_REF,
        TABLE_REF,
        STAR,
        ANY;

    }
}

