/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;

public abstract class PartitionSpecBase
extends StmtNode {
    protected FeFsTable table_;
    protected TableName tableName_;
    protected Boolean partitionShouldExist_;
    protected Privilege privilegeRequirement_;
    protected String nullPartitionKeyValue_;

    public void setTableName(TableName tableName) {
        this.tableName_ = tableName;
    }

    public TableName getTableName() {
        return this.tableName_;
    }

    public String getNullPartitionKeyValue() {
        Preconditions.checkNotNull((Object)this.nullPartitionKeyValue_);
        return this.nullPartitionKeyValue_;
    }

    public void setPartitionShouldExist() {
        this.partitionShouldExist_ = Boolean.TRUE;
    }

    public void setPartitionShouldNotExist() {
        this.partitionShouldExist_ = Boolean.FALSE;
    }

    public boolean getPartitionShouldExist() {
        return this.partitionShouldExist_ != null && this.partitionShouldExist_ != false;
    }

    public void setPrivilegeRequirement(Privilege privilege) {
        this.privilegeRequirement_ = privilege;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        FeTable table;
        Preconditions.checkNotNull((Object)this.tableName_);
        Preconditions.checkNotNull((Object)((Object)this.privilegeRequirement_));
        try {
            table = analyzer.getTable(this.tableName_, false, false, this.privilegeRequirement_);
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(e.getMessage(), e);
        }
        if (!this.isPartitioned(table)) {
            throw new AnalysisException("Table is not partitioned: " + this.tableName_);
        }
        Preconditions.checkState((boolean)(table instanceof FeFsTable));
        this.table_ = (FeFsTable)table;
        this.nullPartitionKeyValue_ = this.table_.getNullPartitionKeyValue();
    }

    private boolean isPartitioned(FeTable table) {
        if (table instanceof FeIcebergTable) {
            return ((FeIcebergTable)table).isPartitioned();
        }
        return table.getMetaStoreTable().getPartitionKeysSize() != 0;
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public abstract String toSql(ToSqlOptions var1);
}

