/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.analysis.PartitionSpecBase;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Reference;
import org.apache.impala.planner.HdfsPartitionPruner;
import org.apache.impala.thrift.TPartitionKeyValue;

public class PartitionSet
extends PartitionSpecBase {
    private final List<Expr> partitionExprs_;
    private List<? extends FeFsPartition> partitions_;

    public PartitionSet(List<Expr> partitionExprs) {
        this.partitionExprs_ = ImmutableList.copyOf(partitionExprs);
    }

    public List<? extends FeFsPartition> getPartitions() {
        return this.partitions_;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (this.table_ instanceof FeIcebergTable) {
            return;
        }
        ArrayList<Expr> conjuncts = new ArrayList<Expr>();
        analyzer.setEnablePrivChecks(false);
        for (Expr e : this.partitionExprs_) {
            e.analyze(analyzer);
            e.checkReturnsBool("Partition expr", false);
            conjuncts.addAll(e.getConjuncts());
        }
        TupleDescriptor desc = analyzer.getDescriptor(this.tableName_.toString());
        List<SlotId> partitionSlots = desc.getPartitionSlots();
        for (Expr e : conjuncts) {
            analyzer.getConstantFolder().rewrite(e, analyzer);
            if (e.isConstant()) {
                throw new AnalysisException(String.format("Invalid partition expr %s. A partition spec may not contain constant predicates.", e.toSql()));
            }
            if (e.isBoundBySlotIds(partitionSlots)) continue;
            throw new AnalysisException("Partition exprs cannot contain non-partition column(s): " + e.toSql() + ".");
        }
        List<Expr> transformedConjuncts = this.transformPartitionConjuncts(analyzer, conjuncts);
        this.addIfExists(analyzer, this.table_, transformedConjuncts);
        try {
            HdfsPartitionPruner pruner = new HdfsPartitionPruner(desc);
            this.partitions_ = (List)pruner.prunePartitions((Analyzer)analyzer, transformedConjuncts, (boolean)true, null).first;
        }
        catch (ImpalaException e) {
            if (e instanceof AnalysisException) {
                throw (AnalysisException)e;
            }
            throw new AnalysisException("Partition expr evaluation failed in the backend.", e);
        }
        if (this.partitionShouldExist_ != null) {
            if (this.partitionShouldExist_.booleanValue() && this.partitions_.isEmpty()) {
                throw new AnalysisException("No matching partition(s) found.");
            }
            if (!this.partitionShouldExist_.booleanValue() && !this.partitions_.isEmpty()) {
                throw new AnalysisException("Partition already exists.");
            }
        }
        analyzer.setEnablePrivChecks(true);
    }

    private void addIfExists(Analyzer analyzer, FeTable table, List<Expr> conjuncts) {
        boolean add = false;
        HashSet<String> partColNames = new HashSet<String>();
        Reference<SlotRef> slotRef = new Reference<SlotRef>();
        for (Expr e : conjuncts) {
            Column partColumn;
            if (e instanceof BinaryPredicate) {
                BinaryPredicate bp = (BinaryPredicate)e;
                if (bp.getOp() != BinaryPredicate.Operator.EQ || !bp.isSingleColumnPredicate(slotRef, null)) {
                    add = true;
                    break;
                }
                partColumn = slotRef.getRef().getDesc().getColumn();
                Preconditions.checkState((boolean)table.isClusteringColumn(partColumn));
                partColNames.add(partColumn.getName());
                continue;
            }
            if (e instanceof IsNullPredicate) {
                IsNullPredicate nullPredicate = (IsNullPredicate)e;
                partColumn = nullPredicate.getBoundSlot().getDesc().getColumn();
                Preconditions.checkState((boolean)table.isClusteringColumn(partColumn));
                partColNames.add(partColumn.getName());
                continue;
            }
            add = true;
            break;
        }
        if (add || partColNames.size() < table.getNumClusteringCols()) {
            this.partitionShouldExist_ = null;
        }
    }

    private List<Expr> transformPartitionConjuncts(Analyzer analyzer, List<Expr> conjuncts) throws AnalysisException {
        ArrayList<Expr> transformedConjuncts = new ArrayList<Expr>();
        Iterator<Expr> iterator = conjuncts.iterator();
        while (iterator.hasNext()) {
            BinaryPredicate bp;
            Expr e;
            Expr result = e = iterator.next();
            if (e instanceof BinaryPredicate && (bp = (BinaryPredicate)e).getOp() == BinaryPredicate.Operator.EQ) {
                StringLiteral stringChild;
                SlotRef leftChild = bp.getChild(0) instanceof SlotRef ? (SlotRef)bp.getChild(0) : null;
                NullLiteral nullChild = Expr.IS_NULL_LITERAL.apply(bp.getChild(1)) ? (NullLiteral)bp.getChild(1) : null;
                StringLiteral stringLiteral = stringChild = bp.getChild(1) instanceof StringLiteral ? (StringLiteral)bp.getChild(1) : null;
                if (leftChild != null && nullChild != null) {
                    result = new IsNullPredicate(leftChild, false);
                } else if (leftChild != null && stringChild != null && stringChild.getStringValue().isEmpty()) {
                    result = new IsNullPredicate(leftChild, false);
                }
            }
            result.analyze(analyzer);
            transformedConjuncts.add(result);
        }
        return transformedConjuncts;
    }

    public List<List<TPartitionKeyValue>> toThrift() {
        ArrayList<List<TPartitionKeyValue>> thriftPartitionSet = new ArrayList<List<TPartitionKeyValue>>();
        for (FeFsPartition feFsPartition : this.partitions_) {
            ArrayList<TPartitionKeyValue> thriftPartitionSpec = new ArrayList<TPartitionKeyValue>();
            for (int i = 0; i < this.table_.getNumClusteringCols(); ++i) {
                String key = this.table_.getColumns().get(i).getName();
                String value = PartitionKeyValue.getPartitionKeyValueString(feFsPartition.getPartitionValue(i), this.nullPartitionKeyValue_);
                thriftPartitionSpec.add(new TPartitionKeyValue(key, value));
            }
            thriftPartitionSet.add(thriftPartitionSpec);
        }
        return thriftPartitionSet;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        ArrayList<String> partitionExprStr = new ArrayList<String>();
        for (Expr e : this.partitionExprs_) {
            partitionExprStr.add(e.toSql(options));
        }
        return String.format("PARTITION (%s)", Joiner.on((String)", ").join(partitionExprStr));
    }
}

