/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.common.AnalysisException;

public class PartitionKeyValue {
    private final String colName_;
    private final Expr value_;
    private LiteralExpr literalValue_;

    public PartitionKeyValue(String colName, Expr value) {
        this.colName_ = colName.toLowerCase();
        this.value_ = value;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.value_ == null) {
            return;
        }
        if (this.isStatic() && !this.value_.isConstant()) {
            throw new AnalysisException(String.format("Non-constant expressions are not supported as static partition-key values in '%s'.", this.toString()));
        }
        this.value_.analyze(analyzer);
        this.literalValue_ = LiteralExpr.createBounded(this.value_, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
    }

    public String getColName() {
        return this.colName_;
    }

    public Expr getValue() {
        return this.value_;
    }

    public LiteralExpr getLiteralValue() {
        return this.literalValue_;
    }

    public boolean isDynamic() {
        return this.value_ == null;
    }

    public boolean isStatic() {
        return !this.isDynamic();
    }

    public String toString() {
        return this.isStatic() ? this.colName_ + "=" + this.value_.toSql() : this.colName_;
    }

    public String toPredicateSql() {
        String ident = ToSqlUtils.getIdentSql(this.colName_);
        if (Expr.IS_NULL_LITERAL.apply((Object)this.literalValue_) || this.literalValue_.getStringValue().isEmpty()) {
            return ident + " IS NULL";
        }
        return this.isStatic() ? ident + "=" + this.value_.toSql() : ident;
    }

    public static String getPartitionKeyValueString(LiteralExpr literalValue, String nullPartitionKeyValue) {
        Preconditions.checkNotNull((Object)literalValue);
        if (Expr.IS_NULL_LITERAL.apply((Object)literalValue) || literalValue.getStringValue().isEmpty()) {
            return nullPartitionKeyValue;
        }
        return literalValue.getStringValue();
    }

    public static List<String> getPartitionKeyValueStringList(List<LiteralExpr> literals, String nullPartitionKeyValue) {
        ArrayList<String> partValues = new ArrayList<String>();
        for (LiteralExpr partValue : literals) {
            partValues.add(PartitionKeyValue.getPartitionKeyValueString(partValue, nullPartitionKeyValue));
        }
        return partValues;
    }

    public static Comparator<PartitionKeyValue> getColNameComparator() {
        return new Comparator<PartitionKeyValue>(){

            @Override
            public int compare(PartitionKeyValue t, PartitionKeyValue o) {
                return t.colName_.compareTo(o.colName_);
            }
        };
    }
}

