/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsCachingOp;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.PartitionSpec;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TPartitionDef;

public class PartitionDef
extends StmtNode {
    private final PartitionSpec partitionSpec_;
    private final HdfsUri location_;
    private final HdfsCachingOp cacheOp_;

    public PartitionDef(PartitionSpec partitionSpec, HdfsUri location, HdfsCachingOp cacheOp) {
        Preconditions.checkNotNull((Object)partitionSpec);
        this.partitionSpec_ = partitionSpec;
        this.location_ = location;
        this.cacheOp_ = cacheOp;
    }

    public void setTableName(TableName tableName) {
        this.partitionSpec_.setTableName(tableName);
    }

    public void setPartitionShouldNotExist() {
        this.partitionSpec_.setPartitionShouldNotExist();
    }

    public HdfsUri getLocation() {
        return this.location_;
    }

    public PartitionSpec getPartitionSpec() {
        return this.partitionSpec_;
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder(this.partitionSpec_.toSql(options));
        if (this.location_ != null) {
            sb.append(String.format(" LOCATION '%s'", this.location_));
        }
        if (this.cacheOp_ != null) {
            sb.append(" " + this.cacheOp_.toSql(options));
        }
        return sb.toString();
    }

    public TPartitionDef toThrift() {
        TPartitionDef params = new TPartitionDef();
        params.setPartition_spec(this.partitionSpec_.toThrift());
        if (this.location_ != null) {
            params.setLocation(this.location_.toString());
        }
        if (this.cacheOp_ != null) {
            params.setCache_op(this.cacheOp_.toThrift());
        }
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        boolean shouldCache;
        FeTable table;
        this.partitionSpec_.setPrivilegeRequirement(Privilege.ALTER);
        this.partitionSpec_.analyze(analyzer);
        if (this.location_ != null) {
            this.location_.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE);
        }
        try {
            table = analyzer.getTable(this.partitionSpec_.getTableName(), false, false, Privilege.ALTER);
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(e.getMessage(), e);
        }
        Preconditions.checkState((boolean)(table instanceof FeFsTable));
        FeFsTable hdfsTable = (FeFsTable)table;
        if (this.cacheOp_ != null) {
            this.cacheOp_.analyze(analyzer);
            shouldCache = this.cacheOp_.shouldCache();
        } else {
            shouldCache = hdfsTable.isMarkedCached();
        }
        if (shouldCache && (this.location_ != null && !FileSystemUtil.isPathCacheable(this.location_.getPath()) || this.location_ == null && !hdfsTable.isLocationCacheable())) {
            throw new AnalysisException(String.format("Location '%s' cannot be cached. Please retry without caching: ALTER TABLE %s ADD PARTITION ... UNCACHED", this.location_ != null ? this.location_.toString() : hdfsTable.getLocation(), hdfsTable.getFullName()));
        }
    }
}

