/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.ToSqlOptions;

public class OrderByElement {
    private Expr expr_;
    private final boolean isAsc_;
    private final Boolean nullsFirstParam_;

    public OrderByElement(Expr expr, boolean isAsc, Boolean nullsFirstParam) {
        this.expr_ = expr;
        this.isAsc_ = isAsc;
        this.nullsFirstParam_ = nullsFirstParam;
    }

    private OrderByElement(OrderByElement other) {
        this.expr_ = other.expr_.clone();
        this.isAsc_ = other.isAsc_;
        this.nullsFirstParam_ = other.nullsFirstParam_ != null ? Boolean.valueOf(other.nullsFirstParam_) : null;
    }

    public Expr getExpr() {
        return this.expr_;
    }

    public void setExpr(Expr e) {
        this.expr_ = e;
    }

    public boolean isAsc() {
        return this.isAsc_;
    }

    public Boolean getNullsFirstParam() {
        return this.nullsFirstParam_;
    }

    public boolean nullsFirst() {
        return OrderByElement.nullsFirst(this.nullsFirstParam_, this.isAsc_);
    }

    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    public String toSql(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.expr_.toSql(options));
        strBuilder.append(this.isAsc_ ? " ASC" : " DESC");
        if (this.nullsFirstParam_ != null) {
            if (this.isAsc_ && this.nullsFirstParam_.booleanValue()) {
                strBuilder.append(" NULLS FIRST");
            } else if (!this.isAsc_ && !this.nullsFirstParam_.booleanValue()) {
                strBuilder.append(" NULLS LAST");
            }
        }
        return strBuilder.toString();
    }

    public boolean equals(Object obj) {
        boolean nullsFirstEqual;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OrderByElement o = (OrderByElement)obj;
        boolean bl = nullsFirstEqual = this.nullsFirstParam_ == null == (o.nullsFirstParam_ == null);
        if (this.nullsFirstParam_ != null && nullsFirstEqual) {
            nullsFirstEqual = this.nullsFirstParam_.equals(o.nullsFirstParam_);
        }
        return this.expr_.equals(o.expr_) && this.isAsc_ == o.isAsc_ && nullsFirstEqual;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.nullsFirstParam_, this.expr_, this.isAsc_);
    }

    public OrderByElement clone() {
        return new OrderByElement(this);
    }

    public static boolean nullsFirst(Boolean nullsFirstParam, boolean isAsc) {
        return nullsFirstParam == null ? !isAsc : nullsFirstParam;
    }

    public static List<OrderByElement> substitute(List<OrderByElement> src, ExprSubstitutionMap smap, Analyzer analyzer) {
        ArrayList result = Lists.newArrayListWithCapacity((int)src.size());
        for (OrderByElement element : src) {
            result.add(new OrderByElement(element.getExpr().substitute(smap, analyzer, false), element.isAsc_, element.nullsFirstParam_));
        }
        return result;
    }

    public static List<Expr> getOrderByExprs(List<OrderByElement> src) {
        ArrayList result = Lists.newArrayListWithCapacity((int)src.size());
        for (OrderByElement element : src) {
            result.add(element.getExpr());
        }
        return result;
    }

    public static List<OrderByElement> reverse(List<OrderByElement> src) {
        ArrayList result = Lists.newArrayListWithCapacity((int)src.size());
        for (int i = 0; i < src.size(); ++i) {
            OrderByElement element = src.get(i);
            OrderByElement reverseElement = new OrderByElement(element.getExpr().clone(), !element.isAsc_, !OrderByElement.nullsFirst(element.nullsFirstParam_, element.isAsc_));
            result.add(reverseElement);
        }
        return result;
    }
}

