/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.TableSink;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.IcebergUtil;

public class OptimizeStmt
extends DmlStatementBase {
    private final TableName originalTableName_;
    private TableName tableName_;
    private TableRef tableRef_;
    private SelectStmt sourceStmt_;
    private List<Expr> resultExprs_ = new ArrayList<Expr>();
    private List<Expr> sortExprs_ = new ArrayList<Expr>();
    private List<Integer> sortColumns_;
    private TSortingOrder sortingOrder_ = TSortingOrder.LEXICAL;
    protected List<Expr> partitionKeyExprs_ = new ArrayList<Expr>();

    public OptimizeStmt(TableName tableName) {
        this.originalTableName_ = this.tableName_ = tableName;
    }

    private OptimizeStmt(OptimizeStmt other) {
        super(other);
        this.tableName_ = other.tableName_;
        this.originalTableName_ = other.originalTableName_;
    }

    @Override
    public OptimizeStmt clone() {
        return new OptimizeStmt(this);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        Preconditions.checkState((this.table_ == null ? 1 : 0) != 0);
        if (!this.tableName_.isFullyQualified()) {
            this.tableName_ = new TableName(analyzer.getDefaultDb(), this.tableName_.getTbl());
        }
        this.tableRef_ = TableRef.newTableRef(analyzer, this.tableName_.toPath(), null);
        this.table_ = analyzer.getTable(this.tableName_, Privilege.ALL);
        if (!(this.table_ instanceof FeIcebergTable)) {
            throw new AnalysisException("OPTIMIZE is only supported for Iceberg tables.");
        }
        if (((FeIcebergTable)this.table_).getContentFileStore().getNumFiles() == 0L) {
            throw new AnalysisException(String.format("Table '%s' is empty.", this.table_.getFullName()));
        }
        IcebergUtil.validateIcebergTableForInsert((FeIcebergTable)this.table_);
        this.prepareExpressions(analyzer);
        this.createSourceStmt(analyzer);
        this.setMaxTableSinks(this.analyzer_.getQueryOptions().getMax_fs_writers());
        this.analyzeSortColumns();
        analyzer.getDescTbl().setTargetTable(this.table_);
    }

    @Override
    public void reset() {
        super.reset();
        this.tableName_ = this.originalTableName_;
        this.tableRef_.reset();
        this.sourceStmt_.reset();
        this.resultExprs_.clear();
        this.sortExprs_.clear();
        this.sortColumns_.clear();
        this.sortingOrder_ = TSortingOrder.LEXICAL;
        this.partitionKeyExprs_.clear();
    }

    @Override
    public DataSink createDataSink() {
        TableSink tableSink = TableSink.create(this.table_, TableSink.Op.INSERT, this.partitionKeyExprs_, this.resultExprs_, new ArrayList<Integer>(), false, false, new Pair<List<Integer>, TSortingOrder>(this.sortColumns_, this.sortingOrder_), -1L, null, this.maxTableSinks_);
        return tableSink;
    }

    private void createSourceStmt(Analyzer analyzer) throws AnalysisException {
        List<TableRef> tableRefs = Arrays.asList(this.tableRef_);
        List<Column> columns = this.table_.getColumns();
        ArrayList<SelectListItem> selectListItems = new ArrayList<SelectListItem>();
        for (Column col : columns) {
            selectListItems.add(new SelectListItem(this.createSlotRef(analyzer, col.getName()), null));
        }
        SelectList selectList = new SelectList(selectListItems);
        this.sourceStmt_ = new SelectStmt(selectList, new FromClause(tableRefs), null, null, null, null, null);
        this.sourceStmt_.analyze(analyzer);
        this.sourceStmt_.getSelectList().getItems().addAll(ExprUtil.exprsAsSelectList(this.partitionKeyExprs_));
    }

    private void prepareExpressions(Analyzer analyzer) throws AnalysisException {
        List<Column> columns = this.table_.getColumns();
        for (Column col : columns) {
            this.resultExprs_.add(this.createSlotRef(analyzer, col.getName()));
        }
        IcebergUtil.populatePartitionExprs(analyzer, null, columns, this.resultExprs_, (FeIcebergTable)this.table_, this.partitionKeyExprs_, null);
    }

    private SlotRef createSlotRef(Analyzer analyzer, String colName) throws AnalysisException {
        List<String> path = Path.createRawPath(this.tableRef_.getUniqueAlias(), colName);
        SlotRef ref = new SlotRef(path);
        ref.analyze(analyzer);
        return ref;
    }

    private void analyzeSortColumns() throws AnalysisException {
        Pair<List<Integer>, TSortingOrder> sortProperties = AlterTableSetTblProperties.analyzeSortColumns(this.table_, this.table_.getMetaStoreTable().getParameters());
        this.sortColumns_ = (List)sortProperties.first;
        this.sortingOrder_ = (TSortingOrder)((Object)sortProperties.second);
        for (Integer colIdx : this.sortColumns_) {
            this.sortExprs_.add(this.resultExprs_.get(colIdx));
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (options == ToSqlOptions.DEFAULT) {
            return "OPTIMIZE TABLE" + this.originalTableName_.toSql();
        }
        return "OPTIMIZE TABLE" + this.tableName_.toSql();
    }

    public QueryStmt getQueryStmt() {
        return this.sourceStmt_;
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.sourceStmt_.substituteResultExprs(smap, analyzer);
        this.resultExprs_ = Expr.substituteList(this.resultExprs_, smap, analyzer, true);
        this.partitionKeyExprs_ = Expr.substituteList(this.partitionKeyExprs_, smap, analyzer, true);
        this.sortExprs_ = Expr.substituteList(this.sortExprs_, smap, analyzer, true);
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.sortingOrder_;
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.sortExprs_;
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.partitionKeyExprs_;
    }

    @Override
    public List<Expr> getResultExprs() {
        return this.resultExprs_;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.sourceStmt_.rewriteExprs(rewriter);
    }
}

