/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TypesUtil;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.SqlCastException;
import org.apache.impala.thrift.TDecimalLiteral;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TFloatLiteral;
import org.apache.impala.thrift.TIntLiteral;

public class NumericLiteral
extends LiteralExpr {
    public static final BigDecimal MIN_TINYINT = BigDecimal.valueOf(-128L);
    public static final BigDecimal MAX_TINYINT = BigDecimal.valueOf(127L);
    public static final BigDecimal MIN_SMALLINT = BigDecimal.valueOf(-32768L);
    public static final BigDecimal MAX_SMALLINT = BigDecimal.valueOf(32767L);
    public static final BigDecimal MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    public static final BigDecimal MIN_BIGINT = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MAX_BIGINT = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    public static final BigDecimal MIN_FLOAT = MAX_FLOAT.negate();
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate();
    private BigDecimal value_;
    private Type explicitType_;

    public NumericLiteral(BigDecimal value) throws SqlCastException {
        this.value_ = value;
        this.explicitType_ = this.type_ = NumericLiteral.inferType(value);
        this.analysisDone();
    }

    public NumericLiteral(String value, Type type) throws SqlCastException {
        this(new BigDecimal(value), type);
    }

    public NumericLiteral(BigInteger value, Type type) throws SqlCastException {
        this(new BigDecimal(value), type);
    }

    public NumericLiteral(BigDecimal value, Type type) throws SqlCastException {
        this.value_ = NumericLiteral.convertValue(value, type);
        this.explicitType_ = this.type_ = type;
        this.analysisDone();
    }

    public NumericLiteral(double value, Type type) throws SqlCastException {
        Preconditions.checkArgument((type == Type.DOUBLE || type == Type.FLOAT ? 1 : 0) != 0);
        if (!NumericLiteral.isImpalaDouble(value)) {
            throw new SqlCastException("Value " + Double.toString(value) + " cannot be cast to " + type.toSql());
        }
        this.value_ = new BigDecimal(value);
        if (type == Type.FLOAT && !NumericLiteral.fitsInFloat(this.value_)) {
            throw new SqlCastException(this.value_, type);
        }
        this.explicitType_ = this.type_ = type;
        this.analysisDone();
    }

    protected NumericLiteral(NumericLiteral other) {
        super(other);
        this.value_ = other.value_;
        this.explicitType_ = other.explicitType_;
    }

    public static NumericLiteral create(BigDecimal value) {
        try {
            return new NumericLiteral(value);
        }
        catch (SqlCastException e) {
            throw new IllegalStateException(e);
        }
    }

    public static NumericLiteral create(BigDecimal value, Type type) {
        try {
            return new NumericLiteral(value, type);
        }
        catch (AnalysisException e) {
            throw new IllegalStateException(e);
        }
    }

    public static NumericLiteral create(long value) {
        return NumericLiteral.create(new BigDecimal(value));
    }

    public static NumericLiteral create(long value, Type type) {
        return NumericLiteral.create(new BigDecimal(value), type);
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value_).add("type", (Object)this.type_).toString();
    }

    @Override
    public String toString() {
        return this.value_.toString() + ":" + this.type_.toSql();
    }

    public Type getExplicitType() {
        return this.explicitType_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        NumericLiteral other = (NumericLiteral)that;
        return other.value_.compareTo(this.value_) == 0;
    }

    @Override
    public int hashCode() {
        return this.value_.hashCode();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (options.showImplictCasts()) {
            return "CAST(" + this.getStringValue() + " AS " + this.type_.toSql() + ")";
        }
        return this.getStringValue();
    }

    @Override
    public String getStringValue() {
        return this.value_.compareTo(BigDecimal.ZERO) == 0 ? "0" : this.value_.toString();
    }

    public double getDoubleValue() {
        return this.value_.doubleValue();
    }

    public long getLongValue() {
        return this.value_.longValue();
    }

    public int getIntValue() {
        return this.value_.intValue();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        switch (this.type_.getPrimitiveType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                msg.node_type = TExprNodeType.INT_LITERAL;
                msg.int_literal = new TIntLiteral(this.value_.longValue());
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                msg.node_type = TExprNodeType.FLOAT_LITERAL;
                msg.float_literal = new TFloatLiteral(this.value_.doubleValue());
                break;
            }
            case DECIMAL: {
                msg.node_type = TExprNodeType.DECIMAL_LITERAL;
                TDecimalLiteral literal = new TDecimalLiteral();
                literal.setValue(this.getUnscaledValue().toByteArray());
                msg.decimal_literal = literal;
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
            }
        }
    }

    public BigDecimal getValue() {
        return this.value_;
    }

    public static boolean isBetween(BigDecimal value, BigDecimal low, BigDecimal high) {
        return value.compareTo(low) >= 0 && value.compareTo(high) <= 0;
    }

    public static boolean fitsInTinyInt(BigDecimal value) {
        return NumericLiteral.isBetween(value, MIN_TINYINT, MAX_TINYINT);
    }

    public static boolean fitsInSmallInt(BigDecimal value) {
        return NumericLiteral.isBetween(value, MIN_SMALLINT, MAX_SMALLINT);
    }

    public static boolean fitsInInt(BigDecimal value) {
        return NumericLiteral.isBetween(value, MIN_INT, MAX_INT);
    }

    public static boolean fitsInBigInt(BigDecimal value) {
        return NumericLiteral.isBetween(value, MIN_BIGINT, MAX_BIGINT);
    }

    public static boolean fitsInFloat(BigDecimal value) {
        return NumericLiteral.isBetween(value, MIN_FLOAT, MAX_FLOAT);
    }

    public static boolean fitsInDouble(BigDecimal value) {
        return !Double.isInfinite(value.doubleValue());
    }

    public static boolean isImpalaDouble(double v) {
        if (Double.isNaN(v) || Double.isInfinite(v)) {
            return false;
        }
        return v != 0.0 || 1.0 / v != Double.NEGATIVE_INFINITY;
    }

    public static boolean isImpalaDecimal(BigDecimal value) {
        return TypesUtil.computeDecimalType(value) != null;
    }

    public static ScalarType inferType(BigDecimal value) throws SqlCastException {
        Type type = TypesUtil.computeDecimalType(value);
        if (type == null) {
            double d = value.doubleValue();
            if (!NumericLiteral.fitsInDouble(value)) {
                throw new SqlCastException("Numeric literal '" + value.toString() + "' exceeds maximum range of DOUBLE.");
            }
            if (d == 0.0 && value != BigDecimal.ZERO) {
                throw new SqlCastException("Numeric literal '" + value.toString() + "' underflows minimum resolution of DOUBLE.");
            }
            return Type.DOUBLE;
        }
        Preconditions.checkState((boolean)type.isScalarType());
        ScalarType scalarType = (ScalarType)type;
        if (scalarType.decimalScale() != 0) {
            return scalarType;
        }
        if (NumericLiteral.fitsInTinyInt(value)) {
            return Type.TINYINT;
        }
        if (NumericLiteral.fitsInSmallInt(value)) {
            return Type.SMALLINT;
        }
        if (NumericLiteral.fitsInInt(value)) {
            return Type.INT;
        }
        if (NumericLiteral.fitsInBigInt(value)) {
            return Type.BIGINT;
        }
        return scalarType;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.type_ = this.explicitType_;
    }

    @Override
    public Expr reset() {
        this.type_ = this.explicitType_;
        return this;
    }

    @Override
    protected void resetAnalysisState() {
        this.type_ = this.explicitType_;
    }

    protected void explicitlyCastToFloat(Type targetType) {
        Preconditions.checkState((boolean)targetType.isFloatingPointType());
        this.type_ = targetType;
        this.explicitType_ = targetType;
    }

    public static BigDecimal convertValue(BigDecimal value, Type targetType) throws SqlCastException {
        Preconditions.checkState((boolean)targetType.isNumericType());
        if (NumericLiteral.isOverflow(value, targetType)) {
            throw new SqlCastException(value, targetType);
        }
        if (targetType.isIntegerType() && value.scale() != 0) {
            return value.setScale(0, RoundingMode.HALF_UP);
        }
        if (!targetType.isDecimal()) {
            return value;
        }
        ScalarType decimalType = (ScalarType)targetType;
        int valLeftDigits = value.precision() - value.scale();
        int typeLeftDigits = decimalType.decimalPrecision() - decimalType.decimalScale();
        if (typeLeftDigits < valLeftDigits && value.compareTo(BigDecimal.ZERO) != 0) {
            throw new SqlCastException(value, targetType);
        }
        if (value.scale() > decimalType.decimalScale()) {
            return value.setScale(decimalType.decimalScale(), RoundingMode.HALF_UP);
        }
        return value;
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws SqlCastException {
        Preconditions.checkState((targetType.isNumericType() || targetType.isStringType() ? 1 : 0) != 0);
        if (targetType.isStringType()) {
            return new CastExpr(targetType, (Expr)this, compatibility);
        }
        if (this.type_ == targetType) {
            return this;
        }
        try {
            BigDecimal converted = NumericLiteral.convertValue(this.value_, targetType);
            if (converted == this.value_) {
                this.type_ = targetType;
                return this;
            }
            return new NumericLiteral(converted, targetType);
        }
        catch (SqlCastException e) {
            return new CastExpr(targetType, (Expr)this, compatibility);
        }
    }

    @Override
    public void swapSign() {
        this.value_ = this.value_.negate();
        try {
            this.explicitType_ = this.type_ = NumericLiteral.inferType(this.value_);
        }
        catch (SqlCastException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(LiteralExpr o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        NumericLiteral other = (NumericLiteral)o;
        return this.value_.compareTo(other.value_);
    }

    private BigInteger getUnscaledValue() {
        Preconditions.checkState((boolean)this.type_.isDecimal());
        BigInteger result = this.value_.unscaledValue();
        int valueScale = this.value_.scale();
        ScalarType decimalType = (ScalarType)this.type_;
        return result.multiply(BigInteger.TEN.pow(decimalType.decimalScale() - valueScale));
    }

    @Override
    public Expr clone() {
        return new NumericLiteral(this);
    }

    public static boolean isOverflow(BigDecimal value, Type type) {
        switch (type.getPrimitiveType()) {
            case TINYINT: {
                return !NumericLiteral.fitsInTinyInt(value);
            }
            case SMALLINT: {
                return !NumericLiteral.fitsInSmallInt(value);
            }
            case INT: {
                return !NumericLiteral.fitsInInt(value);
            }
            case BIGINT: {
                return !NumericLiteral.fitsInBigInt(value);
            }
            case FLOAT: {
                return !NumericLiteral.fitsInFloat(value);
            }
            case DOUBLE: {
                return !NumericLiteral.fitsInDouble(value);
            }
            case DECIMAL: {
                return !NumericLiteral.isImpalaDecimal(value);
            }
        }
        throw new IllegalArgumentException("Overflow check on " + type.toSql() + " isn't supported.");
    }
}

