/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CaseWhenClause;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.ValidTupleIdExpr;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAggregateInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MultiAggregateInfo.class);
    private final List<Expr> groupingExprs_;
    private final List<FunctionCallExpr> aggExprs_;
    private List<Expr> substGroupingExprs_;
    private List<List<FunctionCallExpr>> aggClasses_;
    private List<AggregateInfo> aggInfos_;
    private AggregateInfo transposeAggInfo_;
    private ExprSubstitutionMap outputSmap_;
    private boolean isAnalyzed_;
    private List<AggregateInfo> materializedAggInfos_;
    private ExprSubstitutionMap simplifiedAggSmap_;
    private boolean isGroupingSet_;
    private List<List<Expr>> groupingSets_;

    public MultiAggregateInfo(List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs, List<List<Expr>> groupingSets) {
        this.groupingExprs_ = Expr.cloneList((List)Preconditions.checkNotNull(groupingExprs));
        this.aggExprs_ = Expr.cloneList((List)Preconditions.checkNotNull(aggExprs));
        this.groupingSets_ = groupingSets == null ? null : Expr.deepCopy(groupingSets);
        this.isGroupingSet_ = groupingSets != null;
    }

    private MultiAggregateInfo(AggregateInfo distinctAggInfo) {
        Preconditions.checkState((boolean)distinctAggInfo.getAggregateExprs().isEmpty());
        this.groupingExprs_ = distinctAggInfo.getGroupingExprs();
        this.aggExprs_ = distinctAggInfo.getAggregateExprs();
        this.aggInfos_ = Lists.newArrayList((Object[])new AggregateInfo[]{distinctAggInfo});
        this.outputSmap_ = distinctAggInfo.getResultSmap();
        this.isAnalyzed_ = true;
    }

    private MultiAggregateInfo(MultiAggregateInfo other) {
        this.groupingExprs_ = Expr.cloneList(other.groupingExprs_);
        this.aggExprs_ = Expr.cloneList(other.aggExprs_);
        if (other.aggInfos_ != null) {
            this.aggInfos_ = new ArrayList<AggregateInfo>();
            for (AggregateInfo aggInfo : other.aggInfos_) {
                this.aggInfos_.add(aggInfo.clone());
            }
        }
        if (other.transposeAggInfo_ != null) {
            this.transposeAggInfo_ = other.transposeAggInfo_.clone();
        }
        if (other.outputSmap_ != null) {
            this.outputSmap_ = other.outputSmap_.clone();
        }
        this.isGroupingSet_ = other.isGroupingSet_;
    }

    public static MultiAggregateInfo createDistinct(List<Expr> groupingExprs, TupleDescriptor tupleDesc, Analyzer analyzer) throws AnalysisException {
        AggregateInfo distinctAggInfo = AggregateInfo.create(groupingExprs, null, tupleDesc, analyzer);
        return new MultiAggregateInfo(distinctAggInfo);
    }

    /*
     * WARNING - void declaration
     */
    public void analyze(Analyzer analyzer) throws AnalysisException {
        void var8_17;
        void var8_15;
        boolean hasNonDistinctAggExprs;
        if (this.isAnalyzed_) {
            return;
        }
        if (this.groupingSets_ != null) {
            this.analyzeGroupingSets(analyzer);
            return;
        }
        this.isAnalyzed_ = true;
        ArrayList<List<Expr>> distinctExprs = new ArrayList<List<Expr>>();
        ArrayList<ArrayList<FunctionCallExpr>> groupedDistinctAggExprs = new ArrayList<ArrayList<FunctionCallExpr>>();
        ArrayList<FunctionCallExpr> nonDistinctAggExprs = new ArrayList<FunctionCallExpr>();
        ArrayList<FunctionCallExpr> groupingBuiltinExprs = new ArrayList<FunctionCallExpr>();
        for (FunctionCallExpr aggExpr : this.aggExprs_) {
            if (aggExpr.isGroupingBuiltin() || aggExpr.isGroupingIdBuiltin()) {
                if (!this.hasGrouping()) {
                    throw new AnalysisException("grouping() or grouping_id() function requires a GROUP BY clause: '" + aggExpr.toSql() + "'");
                }
                groupingBuiltinExprs.add(aggExpr);
                continue;
            }
            if (aggExpr.isDistinct()) {
                ArrayList<FunctionCallExpr> groupAggFns;
                List<Expr> list = AggregateFunction.getCanonicalDistinctAggChildren(aggExpr);
                MultiAggregateInfo.checkComplexDistinctParams(aggExpr, list);
                int groupIdx = distinctExprs.indexOf(list);
                if (groupIdx == -1) {
                    distinctExprs.add(list);
                    groupAggFns = new ArrayList<FunctionCallExpr>();
                    groupedDistinctAggExprs.add(groupAggFns);
                } else {
                    groupAggFns = (ArrayList<FunctionCallExpr>)groupedDistinctAggExprs.get(groupIdx);
                }
                groupAggFns.add(aggExpr);
                continue;
            }
            nonDistinctAggExprs.add(aggExpr);
        }
        Preconditions.checkState((distinctExprs.size() == groupedDistinctAggExprs.size() ? 1 : 0) != 0);
        this.aggClasses_ = new ArrayList<List<FunctionCallExpr>>();
        boolean bl = hasNonDistinctAggExprs = !nonDistinctAggExprs.isEmpty();
        if (groupedDistinctAggExprs.size() == 0) {
            if (hasNonDistinctAggExprs) {
                this.aggClasses_.add(nonDistinctAggExprs);
            } else {
                Preconditions.checkState((!this.groupingExprs_.isEmpty() ? 1 : 0) != 0);
                this.aggClasses_.add(null);
            }
        } else if (groupedDistinctAggExprs.size() == 1) {
            Iterator aggClass = Lists.newArrayList((Iterable)((Iterable)groupedDistinctAggExprs.get(0)));
            aggClass.addAll(nonDistinctAggExprs);
            this.aggClasses_.add((List<FunctionCallExpr>)((Object)aggClass));
        } else {
            this.aggClasses_.addAll(groupedDistinctAggExprs);
            if (hasNonDistinctAggExprs) {
                this.aggClasses_.add(nonDistinctAggExprs);
            }
        }
        this.aggInfos_ = Lists.newArrayListWithCapacity((int)this.aggClasses_.size());
        for (List list : this.aggClasses_) {
            this.aggInfos_.add(AggregateInfo.create(this.groupingExprs_, list, analyzer));
        }
        ExprSubstitutionMap exprSubstitutionMap = this.outputSmap_ = this.aggInfos_.size() == 1 ? this.aggInfos_.get(0).getResultSmap().clone() : new ExprSubstitutionMap();
        if (groupingBuiltinExprs.size() > 0) {
            for (FunctionCallExpr functionCallExpr : groupingBuiltinExprs) {
                this.outputSmap_.put(functionCallExpr.clone(), MultiAggregateInfo.getGroupingId(functionCallExpr, this.aggInfos_.get(0), this.groupingExprs_));
            }
        }
        if (this.aggInfos_.size() == 1) {
            return;
        }
        this.transposeAggInfo_ = this.createTransposeAggInfo(this.groupingExprs_, this.aggInfos_, analyzer);
        List<SlotDescriptor> outputSlots = this.transposeAggInfo_.getResultTupleDesc().getSlots();
        Preconditions.checkState((this.groupingExprs_.size() <= outputSlots.size() ? 1 : 0) != 0);
        boolean bl2 = false;
        while (var8_15 < this.groupingExprs_.size()) {
            analyzer.createAuxEqPredicate(new SlotRef(outputSlots.get((int)var8_15)), this.groupingExprs_.get((int)var8_15));
            ++var8_15;
        }
        boolean bl3 = false;
        while (var8_17 < this.groupingExprs_.size()) {
            this.outputSmap_.put(this.groupingExprs_.get((int)var8_17).clone(), new SlotRef(outputSlots.get((int)var8_17)));
            ++var8_17;
        }
        int n = this.groupingExprs_.size();
        for (AggregateInfo aggInfo : this.aggInfos_) {
            ExprSubstitutionMap aggSmap = aggInfo.getResultSmap();
            for (int i2 = this.groupingExprs_.size(); i2 < aggSmap.size(); ++i2) {
                void var8_19;
                this.outputSmap_.put(aggSmap.getLhs().get(i2).clone(), new SlotRef(outputSlots.get((int)var8_19)));
                ++var8_19;
            }
        }
    }

    private static void checkComplexDistinctParams(FunctionCallExpr aggExpr, List<Expr> params) throws AnalysisException {
        for (Expr child : params) {
            if (!child.getType().isComplexType()) continue;
            throw new AnalysisException("Complex types are not supported as DISTINCT parameters of aggregate functions. Distinct parameter: '" + child.toSql() + "', type: '" + child.getType().toSql() + "' in aggregate function '" + aggExpr.toSql() + "'.");
        }
    }

    private void analyzeGroupingSets(Analyzer analyzer) throws AnalysisException {
        ArrayList<FunctionCallExpr> inputAggExprs = new ArrayList<FunctionCallExpr>();
        for (FunctionCallExpr aggExpr : this.aggExprs_) {
            if (aggExpr.isDistinct()) {
                throw new AnalysisException("Distinct aggregate functions and grouping sets are not supported in the same query block.");
            }
            if (aggExpr.isGroupingBuiltin() || aggExpr.isGroupingIdBuiltin()) continue;
            inputAggExprs.add(aggExpr);
        }
        ArrayList<List<FunctionCallExpr>> aggClasses = new ArrayList<List<FunctionCallExpr>>(this.groupingSets_.size());
        ArrayList<AggregateInfo> aggInfos = new ArrayList<AggregateInfo>(this.groupingSets_.size());
        for (List<Expr> groupingSet : this.groupingSets_) {
            aggClasses.add(inputAggExprs);
            aggInfos.add(AggregateInfo.create(groupingSet, inputAggExprs, analyzer));
        }
        this.analyzeCustomClasses(analyzer, aggClasses, aggInfos);
    }

    public void analyzeCustomClasses(Analyzer analyzer, List<List<FunctionCallExpr>> aggClasses, List<AggregateInfo> aggInfos) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        this.isAnalyzed_ = true;
        if (aggClasses.size() == 0) {
            return;
        }
        Preconditions.checkState((boolean)this.isGroupingSet_);
        Preconditions.checkState((aggClasses.size() == aggInfos.size() ? 1 : 0) != 0);
        this.aggClasses_ = new ArrayList<List<FunctionCallExpr>>();
        this.aggInfos_ = new ArrayList<AggregateInfo>();
        this.aggClasses_.addAll(aggClasses);
        this.aggInfos_.addAll(aggInfos);
        if (this.aggInfos_.size() == 1) {
            for (FunctionCallExpr aggExpr : this.aggExprs_) {
                if (!aggExpr.isGroupingBuiltin() && !aggExpr.isGroupingIdBuiltin()) continue;
                if (this.outputSmap_ == null) {
                    this.outputSmap_ = this.aggInfos_.get(0).getResultSmap().clone();
                }
                this.outputSmap_.put(aggExpr.clone(), MultiAggregateInfo.getGroupingId(aggExpr, this.aggInfos_.get(0), this.groupingExprs_));
            }
            if (this.outputSmap_ == null) {
                this.outputSmap_ = this.aggInfos_.get(0).getResultSmap();
            }
            return;
        }
        this.transposeAggInfo_ = this.createTransposeAggInfoForGroupingSet(this.groupingExprs_, this.aggExprs_, this.aggInfos_, analyzer);
        List<SlotDescriptor> outputSlots = this.transposeAggInfo_.getResultTupleDesc().getSlots();
        Preconditions.checkState((this.groupingExprs_.size() <= outputSlots.size() ? 1 : 0) != 0);
        this.outputSmap_ = new ExprSubstitutionMap();
        for (int i = 0; i < this.groupingExprs_.size(); ++i) {
            this.outputSmap_.put(this.groupingExprs_.get(i).clone(), new SlotRef(outputSlots.get(i)));
        }
        int outputSlotIdx = this.groupingExprs_.size() + 1;
        for (int i = 0; i < this.aggExprs_.size(); ++i) {
            this.outputSmap_.put(this.aggExprs_.get(i).clone(), new SlotRef(outputSlots.get(outputSlotIdx)));
            ++outputSlotIdx;
        }
    }

    private AggregateInfo createTransposeAggInfo(List<Expr> groupingExprs, List<AggregateInfo> aggInfos, Analyzer analyzer) throws AnalysisException {
        ArrayList<TupleId> aggTids = new ArrayList<TupleId>();
        for (AggregateInfo aggregateInfo : aggInfos) {
            aggTids.add(aggregateInfo.getResultTupleId());
        }
        ArrayList<FunctionCallExpr> transAggExprs = new ArrayList<FunctionCallExpr>();
        for (AggregateInfo aggInfo : aggInfos) {
            int numGroupingExprs;
            TupleDescriptor aggTuple = aggInfo.getResultTupleDesc();
            for (int i = numGroupingExprs = groupingExprs.size(); i < aggTuple.getSlots().size(); ++i) {
                BinaryPredicate tidCmp = new BinaryPredicate(BinaryPredicate.Operator.EQ, new ValidTupleIdExpr(aggTids), new NumericLiteral(new BigDecimal(aggTuple.getId().asInt())));
                SlotRef matchSlotRef = new SlotRef(aggTuple.getSlots().get(i));
                ArrayList aggFnParams = Lists.newArrayList((Object[])new Expr[]{tidCmp, matchSlotRef});
                FunctionCallExpr aggExpr = new FunctionCallExpr("aggif", (List<Expr>)aggFnParams);
                aggExpr.analyze(analyzer);
                transAggExprs.add(aggExpr);
            }
        }
        List<Expr> list = this.getTransposeGroupingExprs(groupingExprs, aggInfos, analyzer);
        AggregateInfo result = AggregateInfo.create(list, transAggExprs, analyzer);
        return result;
    }

    private AggregateInfo createTransposeAggInfoForGroupingSet(List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs, List<AggregateInfo> aggInfos, Analyzer analyzer) throws AnalysisException {
        ArrayList<TupleId> aggTids = new ArrayList<TupleId>();
        for (AggregateInfo aggInfo : aggInfos) {
            Preconditions.checkState((aggInfo.getGroupingExprs().size() <= 64 ? 1 : 0) != 0, (Object)"Exceeded the limit of 64 grouping exprs in a grouping set");
            aggTids.add(aggInfo.getResultTupleId());
        }
        ArrayList<FunctionCallExpr> transAggExprs = new ArrayList<FunctionCallExpr>();
        int numGroupingExprs = groupingExprs.size();
        int numSlots = numGroupingExprs + aggExprs.size();
        ArrayList<Expr> inList = new ArrayList<Expr>();
        for (TupleId tid : aggTids) {
            inList.add(NumericLiteral.create(tid.asInt()));
        }
        InPredicate tidInPred = new InPredicate((Expr)new ValidTupleIdExpr(aggTids), inList, false);
        ArrayList<CaseWhenClause> caseWhenClauses = new ArrayList<CaseWhenClause>();
        int inputAggSlotIdx = numGroupingExprs;
        for (int i = 0; i < aggExprs.size(); ++i) {
            boolean isGroupingFn;
            caseWhenClauses.clear();
            FunctionCallExpr aggExpr = aggExprs.get(i);
            boolean bl = isGroupingFn = aggExpr.isGroupingBuiltin() || aggExpr.isGroupingIdBuiltin();
            if (isGroupingFn) {
                for (Expr childExpr : aggExpr.getChildren()) {
                    if (groupingExprs.contains(childExpr)) continue;
                    throw new AnalysisException(childExpr.toSql() + " is not a grouping expression in " + aggExpr.toSql());
                }
            }
            for (int j = 0; j < aggInfos.size(); ++j) {
                Expr thenExpr;
                AggregateInfo aggInfo = aggInfos.get(j);
                TupleDescriptor aggTuple = aggInfo.getResultTupleDesc();
                NumericLiteral whenExpr = NumericLiteral.create(aggTuple.getId().asInt());
                if (isGroupingFn) {
                    thenExpr = MultiAggregateInfo.getGroupingId(aggExpr, aggInfo, groupingExprs);
                } else {
                    Preconditions.checkState((inputAggSlotIdx < aggTuple.getSlots().size() ? 1 : 0) != 0, (Object)(inputAggSlotIdx + " >= " + aggTuple.getSlots().size() + ": " + aggTuple.debugString()));
                    thenExpr = new SlotRef(aggTuple.getSlots().get(inputAggSlotIdx));
                }
                caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
            }
            CaseExpr caseExpr = new CaseExpr(new ValidTupleIdExpr(aggTids), caseWhenClauses, null);
            caseExpr.analyzeNoThrow(analyzer);
            ArrayList aggFnParams = Lists.newArrayList((Object[])new Expr[]{tidInPred, caseExpr});
            FunctionCallExpr transAggExpr = new FunctionCallExpr("aggif", (List<Expr>)aggFnParams);
            transAggExpr.analyzeNoThrow(analyzer);
            transAggExprs.add(transAggExpr);
            if (isGroupingFn) continue;
            ++inputAggSlotIdx;
        }
        ArrayList<Expr> transGroupingExprs = new ArrayList<Expr>();
        for (int gbIndex = 0; gbIndex < groupingExprs.size(); ++gbIndex) {
            caseWhenClauses.clear();
            for (AggregateInfo aggInfo : aggInfos) {
                TupleDescriptor aggTuple = aggInfo.getResultTupleDesc();
                Preconditions.checkState((gbIndex < aggTuple.getSlots().size() ? 1 : 0) != 0, (Object)(groupingExprs.toString() + " " + aggTuple.debugString()));
                NumericLiteral whenExpr = NumericLiteral.create(aggTuple.getId().asInt());
                if (aggInfo.getGroupingExprs().size() == 0) {
                    Type nullType = groupingExprs.get(gbIndex).getType();
                    NullLiteral nullLiteral = new NullLiteral();
                    Expr thenExpr = nullLiteral.uncheckedCastTo(nullType);
                    caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
                    continue;
                }
                SlotRef thenExpr = new SlotRef(aggTuple.getSlots().get(gbIndex));
                caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
            }
            CaseExpr caseExpr = new CaseExpr(new ValidTupleIdExpr(aggTids), caseWhenClauses, null);
            caseExpr.analyzeNoThrow(analyzer);
            transGroupingExprs.add(caseExpr);
        }
        caseWhenClauses.clear();
        for (AggregateInfo aggInfo : aggInfos) {
            NumericLiteral whenExpr;
            TupleDescriptor aggTuple = aggInfo.getResultTupleDesc();
            NumericLiteral thenExpr = whenExpr = NumericLiteral.create(aggTuple.getId().asInt(), (Type)Type.INT);
            caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
        }
        CaseExpr caseExprForTids = new CaseExpr(new ValidTupleIdExpr(aggTids), caseWhenClauses, null);
        caseExprForTids.analyzeNoThrow(analyzer);
        transGroupingExprs.add(caseExprForTids);
        AggregateInfo result = AggregateInfo.create(transGroupingExprs, transAggExprs, analyzer);
        return result;
    }

    private static NumericLiteral getGroupingId(FunctionCallExpr aggExpr, AggregateInfo aggInfo, List<Expr> groupingExprs) {
        if (aggExpr.isGroupingBuiltin()) {
            boolean inSet = aggInfo.getGroupingExprs().contains(aggExpr.getChild(0));
            return NumericLiteral.create(inSet ? 0L : 1L, (Type)Type.TINYINT);
        }
        Preconditions.checkState((boolean)aggExpr.isGroupingIdBuiltin());
        List<Expr> inputExprs = aggExpr.getChildren().size() > 0 ? aggExpr.getChildren() : groupingExprs;
        long val = 0L;
        for (Expr child : inputExprs) {
            val <<= 1;
            val |= aggInfo.getGroupingExprs().contains(child) ? 0L : 1L;
        }
        return NumericLiteral.create(val, (Type)Type.BIGINT);
    }

    private List<Expr> getTransposeGroupingExprs(List<Expr> groupingExprs, List<AggregateInfo> aggInfos, Analyzer analyzer) {
        ArrayList<TupleId> resultTids = new ArrayList<TupleId>();
        for (AggregateInfo aggInfo : aggInfos) {
            resultTids.add(aggInfo.getResultTupleId());
        }
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (int i = 0; i < groupingExprs.size(); ++i) {
            ArrayList<CaseWhenClause> caseWhenClauses = new ArrayList<CaseWhenClause>();
            for (AggregateInfo aggInfo : aggInfos) {
                TupleDescriptor tupleDesc = aggInfo.getResultTupleDesc();
                NumericLiteral whenExpr = NumericLiteral.create(tupleDesc.getId().asInt());
                SlotRef thenExpr = new SlotRef(tupleDesc.getSlots().get(i));
                caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
            }
            CaseExpr caseExpr = new CaseExpr(new ValidTupleIdExpr(resultTids), caseWhenClauses, null);
            caseExpr.analyzeNoThrow(analyzer);
            result.add(caseExpr);
        }
        return result;
    }

    public void setIsGroupingSet(boolean isGroupingSet) {
        this.isGroupingSet_ = isGroupingSet;
    }

    public boolean getIsGroupingSet() {
        return this.isGroupingSet_;
    }

    public void materializeRequiredSlots(Analyzer analyzer, ExprSubstitutionMap smap) {
        if (this.aggInfos_.size() == 1) {
            this.aggInfos_.get(0).materializeRequiredSlots(analyzer, smap);
            this.materializedAggInfos_ = Lists.newArrayList((Object[])new AggregateInfo[]{this.aggInfos_.get(0)});
            return;
        }
        Preconditions.checkNotNull((Object)this.transposeAggInfo_);
        this.transposeAggInfo_.materializeRequiredSlots(analyzer, smap);
        if (this.isGroupingSet_) {
            this.materializedAggInfos_ = new ArrayList<AggregateInfo>();
            for (AggregateInfo aggInfo : this.aggInfos_) {
                aggInfo.materializeRequiredSlots(analyzer, smap);
            }
            this.materializedAggInfos_.addAll(this.aggInfos_);
            return;
        }
        ArrayList classIdxByAggExprIdx = Lists.newArrayListWithCapacity((int)this.aggClasses_.size());
        for (int i = 0; i < this.aggClasses_.size(); ++i) {
            classIdxByAggExprIdx.addAll(Collections.nCopies(this.aggClasses_.get(i).size(), i));
        }
        ArrayList materializedClassIdxs = Lists.newArrayListWithCapacity((int)this.aggClasses_.size());
        this.materializedAggInfos_ = Lists.newArrayListWithCapacity((int)this.aggClasses_.size());
        for (Integer n : this.transposeAggInfo_.getMaterializedSlots()) {
            Integer classIdx = (Integer)classIdxByAggExprIdx.get(n);
            int size = materializedClassIdxs.size();
            if (size != 0 && materializedClassIdxs.get(size - 1) == classIdx) continue;
            materializedClassIdxs.add(classIdx);
            this.aggInfos_.get(classIdx).materializeRequiredSlots(analyzer, smap);
            this.materializedAggInfos_.add(this.aggInfos_.get(classIdx));
        }
        if (!(this.materializedAggInfos_.size() != 2 || this.materializedAggInfos_.get(0).isDistinctAgg() && this.materializedAggInfos_.get(1).isDistinctAgg())) {
            AggregateInfo aggregateInfo;
            ArrayList<FunctionCallExpr> newAggExprs = new ArrayList<FunctionCallExpr>();
            for (Integer classIdx : materializedClassIdxs) {
                List<FunctionCallExpr> aggClass = this.aggClasses_.get(classIdx);
                AggregateInfo aggInfo = this.aggInfos_.get(classIdx);
                if (aggInfo.getSecondPhaseDistinctAggInfo() != null) {
                    aggInfo = aggInfo.getSecondPhaseDistinctAggInfo();
                }
                Preconditions.checkState((aggInfo.getAggregateExprs().size() == aggClass.size() ? 1 : 0) != 0);
                for (Integer aggExprIdx : aggInfo.getMaterializedSlots()) {
                    newAggExprs.add(aggClass.get(aggExprIdx));
                }
            }
            Object var6_11 = null;
            try {
                aggregateInfo = AggregateInfo.create(this.groupingExprs_, newAggExprs, analyzer);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to simplify aggregation", e);
            }
            aggregateInfo.getResultTupleDesc().materializeSlots();
            aggregateInfo.materializeRequiredSlots(analyzer, smap);
            this.materializedAggInfos_.clear();
            this.materializedAggInfos_.add(aggregateInfo);
        }
        if (this.materializedAggInfos_.size() == 0) {
            AggregateInfo lastAggInfo = this.aggInfos_.get(this.aggInfos_.size() - 1);
            lastAggInfo.materializeRequiredSlots(analyzer, smap);
            this.materializedAggInfos_.add(lastAggInfo);
        }
        if (this.materializedAggInfos_.size() == 1) {
            this.simplifiedAggSmap_ = this.createSimplifiedAggSmap(this.groupingExprs_, this.transposeAggInfo_, this.materializedAggInfos_.get(0));
        } else if (this.materializedAggInfos_.size() != this.aggInfos_.size()) {
            List<Expr> newGroupingExprs = this.getTransposeGroupingExprs(this.groupingExprs_, this.materializedAggInfos_, analyzer);
            List<Expr> list = this.transposeAggInfo_.getGroupingExprs();
            Preconditions.checkState((list.size() == newGroupingExprs.size() ? 1 : 0) != 0);
            for (int i = 0; i < list.size(); ++i) {
                Type newType = newGroupingExprs.get(i).getType();
                Type oldType = list.get(i).getType();
                Preconditions.checkState((boolean)newType.equals(oldType));
            }
            list.clear();
            list.addAll(newGroupingExprs);
        }
    }

    private ExprSubstitutionMap createSimplifiedAggSmap(List<Expr> groupingExprs, AggregateInfo transposeAggInfo, AggregateInfo simplifiedAggInfo) {
        TupleDescriptor transTupleDesc = transposeAggInfo.getResultTupleDesc();
        TupleDescriptor matAggClassTupleDesc = simplifiedAggInfo.getResultTupleDesc();
        ArrayList<Expr> lhsExprs = new ArrayList<Expr>();
        ArrayList<Expr> rhsExprs = new ArrayList<Expr>();
        int numGroupingExprs = groupingExprs.size();
        for (int i = 0; i < numGroupingExprs; ++i) {
            lhsExprs.add(new SlotRef(transTupleDesc.getSlots().get(i)));
            rhsExprs.add(new SlotRef(matAggClassTupleDesc.getSlots().get(i)));
        }
        for (Integer idx : transposeAggInfo.getMaterializedSlots()) {
            lhsExprs.add(new SlotRef(transTupleDesc.getSlots().get(numGroupingExprs + idx)));
        }
        if (simplifiedAggInfo.getSecondPhaseDistinctAggInfo() != null) {
            simplifiedAggInfo = simplifiedAggInfo.getSecondPhaseDistinctAggInfo();
        }
        for (Integer idx : simplifiedAggInfo.getMaterializedSlots()) {
            rhsExprs.add(new SlotRef(matAggClassTupleDesc.getSlots().get(numGroupingExprs + idx)));
        }
        Preconditions.checkState((lhsExprs.size() == rhsExprs.size() ? 1 : 0) != 0);
        return new ExprSubstitutionMap(lhsExprs, rhsExprs);
    }

    public void substitute(ExprSubstitutionMap smap, Analyzer analyzer) throws InternalException {
        Preconditions.checkState((this.substGroupingExprs_ == null ? 1 : 0) != 0);
        this.substGroupingExprs_ = Expr.substituteList(this.groupingExprs_, smap, analyzer, true);
    }

    public List<AggregateInfo> getMaterializedAggInfos(AggPhase aggPhase) {
        Preconditions.checkNotNull(this.materializedAggInfos_);
        ArrayList<AggregateInfo> result = new ArrayList<AggregateInfo>();
        switch (aggPhase) {
            case FIRST: {
                result.addAll(this.materializedAggInfos_);
                break;
            }
            case FIRST_MERGE: {
                result.addAll(this.getMergeAggInfos(this.materializedAggInfos_));
                break;
            }
            case SECOND: {
                for (AggregateInfo aggInfo : this.materializedAggInfos_) {
                    if (aggInfo.getSecondPhaseDistinctAggInfo() != null) {
                        result.add(aggInfo.getSecondPhaseDistinctAggInfo());
                        continue;
                    }
                    result.add(aggInfo.getMergeAggInfo());
                }
                break;
            }
            case SECOND_MERGE: {
                result.addAll(this.getMergeAggInfos(this.getMaterializedAggInfos(AggPhase.SECOND)));
                break;
            }
            case TRANSPOSE: {
                result.add((AggregateInfo)Preconditions.checkNotNull((Object)this.transposeAggInfo_));
            }
        }
        return result;
    }

    private List<AggregateInfo> getMergeAggInfos(List<AggregateInfo> aggInfos) {
        ArrayList<AggregateInfo> result = new ArrayList<AggregateInfo>();
        for (AggregateInfo aggInfo : aggInfos) {
            if (!aggInfo.isMerge()) {
                result.add((AggregateInfo)Preconditions.checkNotNull((Object)aggInfo.getMergeAggInfo()));
                continue;
            }
            result.add(aggInfo);
        }
        return result;
    }

    public boolean hasFirstPhase() {
        Preconditions.checkNotNull(this.materializedAggInfos_);
        return this.materializedAggInfos_.size() > 0;
    }

    public boolean hasSecondPhase() {
        Preconditions.checkNotNull(this.materializedAggInfos_);
        for (AggregateInfo aggInfo : this.materializedAggInfos_) {
            if (!aggInfo.isDistinctAgg()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTransposePhase() {
        Preconditions.checkNotNull(this.materializedAggInfos_);
        if (this.materializedAggInfos_.size() > 1) {
            Preconditions.checkNotNull((Object)this.transposeAggInfo_);
            return true;
        }
        return false;
    }

    public boolean hasAllDistinctAgg() {
        for (AggregateInfo ai : this.materializedAggInfos_) {
            if (ai.hasAllDistinctAgg()) continue;
            return false;
        }
        return true;
    }

    public List<Expr> collectConjuncts(Analyzer analyzer, boolean markAssigned) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        TupleId tid = this.getResultTupleId();
        TupleDescriptor tupleDesc = analyzer.getTupleDesc(tid);
        HashSet<SlotId> groupBySids = new HashSet<SlotId>();
        for (int i = 0; i < this.groupingExprs_.size(); ++i) {
            if (this.groupingExprs_.get(i).unwrapSlotRef(true) == null) continue;
            groupBySids.add(tupleDesc.getSlots().get(i).getId());
        }
        List<Expr> bindingPredicates = analyzer.getBoundPredicates(tid, groupBySids, markAssigned);
        List<Expr> unassignedConjuncts = analyzer.getUnassignedConjuncts(tid.asList());
        if (markAssigned) {
            analyzer.markConjunctsAssigned(unassignedConjuncts);
        }
        result.addAll(bindingPredicates);
        result.addAll(unassignedConjuncts);
        analyzer.createEquivConjuncts(tid, result, groupBySids);
        Expr.removeDuplicates(result);
        return result;
    }

    public AggPhase getConjunctAssignmentPhase() {
        if (this.transposeAggInfo_ != null) {
            return AggPhase.TRANSPOSE;
        }
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (!aggInfo.isDistinctAgg()) continue;
            return AggPhase.SECOND;
        }
        Preconditions.checkState((this.aggInfos_.size() == 1 ? 1 : 0) != 0);
        return AggPhase.FIRST;
    }

    public List<AggregateInfo> getAggClasses() {
        return this.aggInfos_;
    }

    public AggregateInfo getAggClass(int i) {
        return this.aggInfos_.get(i);
    }

    public AggregateInfo getTransposeAggInfo() {
        return this.transposeAggInfo_;
    }

    public boolean hasGrouping() {
        return !this.groupingExprs_.isEmpty();
    }

    public List<Expr> getGroupingExprs() {
        return this.groupingExprs_;
    }

    public List<Expr> getSubstGroupingExprs() {
        return this.substGroupingExprs_;
    }

    public List<FunctionCallExpr> getAggExprs() {
        return this.aggExprs_;
    }

    public ExprSubstitutionMap getOutputSmap() {
        return this.outputSmap_;
    }

    public List<AggregateInfo> getMaterializedAggClasses() {
        return this.materializedAggInfos_;
    }

    public AggregateInfo getMaterializedAggClass(int i) {
        return this.materializedAggInfos_.get(i);
    }

    public ExprSubstitutionMap getSimplifiedAggSmap() {
        return this.simplifiedAggSmap_;
    }

    public boolean hasAggregateExprs() {
        return !this.aggExprs_.isEmpty();
    }

    public TupleId getResultTupleId() {
        if (this.transposeAggInfo_ != null) {
            return this.transposeAggInfo_.getResultTupleId();
        }
        Preconditions.checkState((this.aggInfos_.size() == 1 ? 1 : 0) != 0);
        return this.getAggClass(0).getResultTupleId();
    }

    public MultiAggregateInfo clone() {
        return new MultiAggregateInfo(this);
    }

    public static enum AggPhase {
        FIRST,
        FIRST_MERGE,
        SECOND,
        SECOND_MERGE,
        TRANSPOSE;


        public boolean isFirstPhase() {
            return this == FIRST || this == FIRST_MERGE;
        }

        public boolean isMerge() {
            return this == FIRST_MERGE || this == SECOND_MERGE;
        }

        public boolean isTranspose() {
            return this == TRANSPOSE;
        }
    }
}

