/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;

class LimitElement {
    private final Expr limitExpr_;
    private final Expr offsetExpr_;
    private long limit_;
    private long offset_;
    private boolean isAnalyzed_;

    public LimitElement(Expr limitExpr, Expr offsetExpr) {
        this.limitExpr_ = limitExpr;
        this.offsetExpr_ = offsetExpr;
        this.isAnalyzed_ = false;
        this.limit_ = -1L;
        this.offset_ = 0L;
    }

    protected LimitElement(LimitElement other) {
        this.limitExpr_ = other.limitExpr_ != null ? other.limitExpr_.clone() : null;
        this.offsetExpr_ = other.offsetExpr_ != null ? other.offsetExpr_.clone() : null;
        this.limit_ = other.limit_;
        this.offset_ = other.offset_;
        this.isAnalyzed_ = other.isAnalyzed_;
    }

    public Expr getLimitExpr() {
        return this.limitExpr_;
    }

    public Expr getOffsetExpr() {
        return this.offsetExpr_;
    }

    public long getLimit() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.limit_;
    }

    public long getOffset() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.offset_;
    }

    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        if (this.limitExpr_ != null) {
            sb.append(" LIMIT ");
            sb.append(this.limitExpr_.toSql(options));
        }
        if (!(this.offsetExpr_ == null || this.offset_ == 0L && this.isAnalyzed_)) {
            sb.append(" OFFSET ");
            sb.append(this.offsetExpr_.toSql(options));
        }
        return sb.toString();
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.isAnalyzed_ = true;
        if (this.limitExpr_ != null) {
            this.limit_ = this.limitExpr_.evalToNonNegativeInteger(analyzer, "LIMIT");
        }
        if (this.limit_ == 0L) {
            analyzer.setHasEmptyResultSet();
        }
        if (this.offsetExpr_ != null) {
            this.offset_ = this.offsetExpr_.evalToNonNegativeInteger(analyzer, "OFFSET");
        }
    }

    public LimitElement clone() {
        return new LimitElement(this);
    }

    public void reset() {
        this.isAnalyzed_ = false;
        this.limit_ = -1L;
        this.offset_ = 0L;
        if (this.limitExpr_ != null) {
            this.limitExpr_.reset();
        }
        if (this.offsetExpr_ != null) {
            this.offsetExpr_.reset();
        }
    }
}

