/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.RangePartition;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TKuduPartitionByHashParam;
import org.apache.impala.thrift.TKuduPartitionByRangeParam;
import org.apache.impala.thrift.TKuduPartitionParam;

public class KuduPartitionParam
extends StmtNode {
    private static final int NO_HASH_PARTITIONS = -1;
    private final List<String> colNames_ = new ArrayList<String>();
    private Map<String, ColumnDef> pkColumnDefByName_;
    private final Type type_;
    private final int numHashPartitions_;
    private List<RangePartition> rangePartitions_;

    public static KuduPartitionParam createHashParam(List<String> cols, int numPartitions) {
        return new KuduPartitionParam(Type.HASH, cols, numPartitions, null);
    }

    public static KuduPartitionParam createRangeParam(List<String> cols, List<RangePartition> rangePartitions) {
        return new KuduPartitionParam(Type.RANGE, cols, -1, rangePartitions);
    }

    private KuduPartitionParam(Type t, List<String> colNames, int numHashPartitions, List<RangePartition> partitions) {
        this.type_ = t;
        for (String name : colNames) {
            this.colNames_.add(name.toLowerCase());
        }
        this.rangePartitions_ = partitions;
        this.numHashPartitions_ = numHashPartitions;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull(this.pkColumnDefByName_);
        Preconditions.checkState((!this.pkColumnDefByName_.isEmpty() ? 1 : 0) != 0);
        if (!this.hasColumnNames()) {
            this.setColumnNames(this.pkColumnDefByName_.keySet());
        }
        for (String colName : this.colNames_) {
            if (this.pkColumnDefByName_.containsKey(colName)) continue;
            throw new AnalysisException(String.format("Column '%s' in '%s' is not a key column. Only key columns can be used in PARTITION BY.", colName, this.toSql()));
        }
        if (this.type_ == Type.RANGE) {
            this.analyzeRangeParam(analyzer);
        }
    }

    public void analyzeRangeParam(Analyzer analyzer) throws AnalysisException {
        ArrayList pkColDefs = Lists.newArrayListWithCapacity((int)this.colNames_.size());
        for (String colName : this.colNames_) {
            pkColDefs.add(this.pkColumnDefByName_.get(colName));
        }
        for (RangePartition rangePartition : this.rangePartitions_) {
            rangePartition.analyze(analyzer, pkColDefs);
        }
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder builder = new StringBuilder(this.type_.toString());
        if (!this.colNames_.isEmpty()) {
            builder.append(" (");
            Joiner.on((String)", ").appendTo(builder, this.colNames_).append(")");
        }
        if (this.type_ == Type.HASH) {
            Preconditions.checkState((this.numHashPartitions_ != -1 ? 1 : 0) != 0);
            builder.append(" PARTITIONS ").append(this.numHashPartitions_);
        } else {
            builder.append(" (");
            if (this.rangePartitions_ != null) {
                ArrayList<String> partsSql = new ArrayList<String>();
                for (RangePartition rangePartition : this.rangePartitions_) {
                    partsSql.add(rangePartition.toSql(options));
                }
                builder.append(Joiner.on((String)", ").join(partsSql));
            } else {
                builder.append("...");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    public TKuduPartitionParam toThrift() {
        TKuduPartitionParam result = new TKuduPartitionParam();
        if (this.type_ == Type.HASH) {
            TKuduPartitionByHashParam hash = new TKuduPartitionByHashParam();
            Preconditions.checkState((this.numHashPartitions_ != -1 ? 1 : 0) != 0);
            hash.setNum_partitions(this.numHashPartitions_);
            hash.setColumns(this.colNames_);
            result.setBy_hash_param(hash);
        } else {
            Preconditions.checkState((this.type_ == Type.RANGE ? 1 : 0) != 0);
            TKuduPartitionByRangeParam rangeParam = new TKuduPartitionByRangeParam();
            rangeParam.setColumns(this.colNames_);
            if (this.rangePartitions_ == null) {
                result.setBy_range_param(rangeParam);
                return result;
            }
            for (RangePartition rangePartition : this.rangePartitions_) {
                rangeParam.addToRange_partitions(rangePartition.toThrift());
            }
            result.setBy_range_param(rangeParam);
        }
        return result;
    }

    void setPkColumnDefMap(Map<String, ColumnDef> pkColumnDefByName) {
        this.pkColumnDefByName_ = pkColumnDefByName;
        if (this.rangePartitions_ != null) {
            for (RangePartition rangePartition : this.rangePartitions_) {
                rangePartition.setPkColumnDefMap(pkColumnDefByName);
            }
        }
    }

    boolean hasColumnNames() {
        return !this.colNames_.isEmpty();
    }

    public List<String> getColumnNames() {
        return ImmutableList.copyOf(this.colNames_);
    }

    void setColumnNames(Collection<String> colNames) {
        Preconditions.checkState((boolean)this.colNames_.isEmpty());
        this.colNames_.addAll(colNames);
    }

    public Type getType() {
        return this.type_;
    }

    public static enum Type {
        HASH,
        RANGE;

    }
}

