/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TKuduPartitionExpr;

public class KuduPartitionExpr
extends Expr {
    private final int targetTableId_;
    private final FeKuduTable targetTable_;
    private List<Integer> partitionColPos_;

    public KuduPartitionExpr(int targetTableId, FeKuduTable targetTable, List<Expr> partitionKeyExprs, List<Integer> partitionKeyIdxs) {
        Preconditions.checkState((partitionKeyExprs.size() == partitionKeyIdxs.size() ? 1 : 0) != 0);
        this.targetTableId_ = targetTableId;
        this.targetTable_ = targetTable;
        this.partitionColPos_ = partitionKeyIdxs;
        this.children_.addAll(Expr.cloneList(partitionKeyExprs));
    }

    protected KuduPartitionExpr(KuduPartitionExpr other) {
        super(other);
        this.targetTableId_ = other.targetTableId_;
        this.targetTable_ = other.targetTable_;
        this.partitionColPos_ = other.partitionColPos_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.type_ = Type.INT;
        for (int i = 0; i < this.children_.size(); ++i) {
            this.children_.set(i, ((Expr)this.children_.get(i)).castTo(this.targetTable_.getColumns().get(this.partitionColPos_.get(i)).getType()));
        }
    }

    @Override
    protected float computeEvalCost() {
        return -1.0f;
    }

    @Override
    protected String toSqlImpl(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("KuduPartition(");
        for (int i = 0; i < this.children_.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(((Expr)this.children_.get(i)).toSql(options));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.KUDU_PARTITION_EXPR;
        msg.kudu_partition_expr = new TKuduPartitionExpr();
        for (int i = 0; i < this.children_.size(); ++i) {
            msg.kudu_partition_expr.addToReferenced_columns(this.partitionColPos_.get(i));
        }
        msg.kudu_partition_expr.setTarget_table_id(this.targetTableId_);
    }

    @Override
    public Expr clone() {
        return new KuduPartitionExpr(this);
    }
}

