/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.ModifyImpl;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.util.ExprUtil;

abstract class KuduModifyImpl
extends ModifyImpl {
    FeKuduTable kuduTable_;
    protected List<Expr> resultExprs_ = new ArrayList<Expr>();
    protected List<Integer> referencedColumns_ = new ArrayList<Integer>();

    public KuduModifyImpl(ModifyStmt modifyStmt) {
        super(modifyStmt);
        this.kuduTable_ = (FeKuduTable)modifyStmt.getTargetTable();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
    }

    @Override
    protected void buildAndValidateSelectExprs(Analyzer analyzer, List<SelectListItem> selectList) throws AnalysisException {
        HashSet<SlotId> uniqueSlots = new HashSet<SlotId>();
        HashSet<SlotId> keySlots = new HashSet<SlotId>();
        List<Column> cols = this.modifyStmt_.table_.getColumnsInHiveOrder();
        HashMap<String, Integer> colIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < cols.size(); ++i) {
            colIndexMap.put(cols.get(i).getName(), i);
        }
        this.addKeyColumns(analyzer, selectList, this.referencedColumns_, uniqueSlots, keySlots, colIndexMap);
        boolean convertToUtc = analyzer.getQueryOptions().isWrite_kudu_utc_timestamps();
        for (Pair<SlotRef, Expr> valueAssignment : this.modifyStmt_.assignments_) {
            SlotRef lhsSlotRef = (SlotRef)valueAssignment.first;
            lhsSlotRef.analyze(analyzer);
            Expr rhsExpr = (Expr)valueAssignment.second;
            this.checkSubQuery(lhsSlotRef, rhsExpr);
            rhsExpr.analyze(analyzer);
            this.checkCorrectTargetTable(lhsSlotRef, rhsExpr);
            this.checkLhsIsColumnRef(lhsSlotRef, rhsExpr);
            Column c = lhsSlotRef.getResolvedPath().destColumn();
            if (keySlots.contains(lhsSlotRef.getSlotId())) {
                boolean isSystemGeneratedColumn = c instanceof KuduColumn && ((KuduColumn)c).isAutoIncrementing();
                throw new AnalysisException(String.format("%s column '%s' cannot be updated.", isSystemGeneratedColumn ? "System generated key" : "Key", lhsSlotRef.toSql()));
            }
            if (uniqueSlots.contains(lhsSlotRef.getSlotId())) {
                throw new AnalysisException(String.format("Duplicate value assignment to column: '%s'", lhsSlotRef.toSql()));
            }
            rhsExpr = StatementBase.checkTypeCompatibility(this.modifyStmt_.targetTableRef_.getDesc().getTable().getFullName(), c, rhsExpr, analyzer, null);
            if (convertToUtc && rhsExpr.getType().isTimestamp()) {
                rhsExpr = ExprUtil.toUtcTimestampExpr(analyzer, rhsExpr, true);
            }
            uniqueSlots.add(lhsSlotRef.getSlotId());
            selectList.add(new SelectListItem(rhsExpr, null));
            this.referencedColumns_.add((Integer)colIndexMap.get(c.getName()));
        }
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return Collections.emptyList();
    }

    public List<Integer> getReferencedColumns() {
        return this.referencedColumns_;
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        super.substituteResultExprs(smap, analyzer);
        this.resultExprs_ = Expr.substituteList(this.resultExprs_, smap, analyzer, true);
    }

    protected void addKeyColumn(Analyzer analyzer, List<SelectListItem> selectList, List<Integer> referencedColumns, Set<SlotId> uniqueSlots, Set<SlotId> keySlots, Map<String, Integer> colIndexMap, String colName) throws AnalysisException {
        Expr ref = this.addSlotRef(analyzer, selectList, referencedColumns, uniqueSlots, keySlots, colIndexMap, colName);
        this.resultExprs_.add(ref);
    }

    private Expr addSlotRef(Analyzer analyzer, List<SelectListItem> selectList, List<Integer> referencedColumns, Set<SlotId> uniqueSlots, Set<SlotId> keySlots, Map<String, Integer> colIndexMap, String colName) throws AnalysisException {
        List<String> path = Path.createRawPath(this.modifyStmt_.targetTableRef_.getUniqueAlias(), colName);
        SlotRef ref = new SlotRef(path);
        ref.analyze(analyzer);
        Expr expr = ref;
        boolean convertToUtc = analyzer.getQueryOptions().isWrite_kudu_utc_timestamps();
        if (convertToUtc && expr.getType().isTimestamp()) {
            expr = ExprUtil.toUtcTimestampExpr(analyzer, expr, true);
        }
        selectList.add(new SelectListItem(expr, null));
        uniqueSlots.add(ref.getSlotId());
        keySlots.add(ref.getSlotId());
        referencedColumns.add(colIndexMap.get(colName));
        return expr;
    }

    @Override
    public void addCastsToAssignmentsInSourceStmt(Analyzer analyzer) throws AnalysisException {
        int keyColumnsOffset;
        List<Pair<SlotRef, Expr>> assignments = this.modifyStmt_.getAssignments();
        for (int i = keyColumnsOffset = this.kuduTable_.getPrimaryKeyColumnNames().size(); i < this.sourceStmt_.resultExprs_.size(); ++i) {
            this.sourceStmt_.resultExprs_.set(i, ((Expr)this.sourceStmt_.resultExprs_.get(i)).castTo(((SlotRef)assignments.get((int)(i - keyColumnsOffset)).first).getType()));
        }
    }

    public void addKeyColumns(Analyzer analyzer, List<SelectListItem> selectList, List<Integer> referencedColumns, Set<SlotId> uniqueSlots, Set<SlotId> keySlots, Map<String, Integer> colIndexMap) throws AnalysisException {
        for (String k : this.kuduTable_.getPrimaryKeyColumnNames()) {
            this.addKeyColumn(analyzer, selectList, referencedColumns, uniqueSlots, keySlots, colIndexMap, k);
        }
    }
}

