/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SetOperationStmt;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.ValuesStmt;
import org.apache.impala.analysis.WithClause;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.View;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.HdfsTableSink;
import org.apache.impala.planner.TableSink;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.IcebergUtil;

public class InsertStmt
extends DmlStatementBase {
    private final TableName originalTableName_;
    private final boolean overwrite_;
    private final List<PartitionKeyValue> partitionKeyValues_;
    private List<PlanHint> planHints_ = new ArrayList<PlanHint>();
    private HintLocation hintLoc_;
    private final boolean needsGeneratedQueryStatement_;
    private final List<String> columnPermutation_;
    private final WithClause withClause_;
    private TableName targetTableName_;
    private QueryStmt queryStmt_;
    private List<Expr> partitionKeyExprs_ = new ArrayList<Expr>();
    private final List<Integer> partitionColPos_ = new ArrayList<Integer>();
    private boolean hasShuffleHint_ = false;
    private boolean hasNoShuffleHint_ = false;
    private boolean hasClusteredHint_ = false;
    private boolean hasNoClusteredHint_ = false;
    private List<Expr> sortExprs_ = new ArrayList<Expr>();
    private List<Integer> sortColumns_ = new ArrayList<Integer>();
    private TSortingOrder sortingOrder_ = TSortingOrder.LEXICAL;
    private List<Expr> resultExprs_ = new ArrayList<Expr>();
    private final List<Integer> mentionedColumns_ = new ArrayList<Integer>();
    private List<Expr> primaryKeyExprs_ = new ArrayList<Expr>();
    private long writeId_ = -1L;
    private final boolean isUpsert_;

    public static InsertStmt createInsert(WithClause withClause, TableName targetTable, boolean overwrite, List<PartitionKeyValue> partitionKeyValues, List<PlanHint> planHints, HintLocation hintLoc, QueryStmt queryStmt, List<String> columnPermutation) {
        return new InsertStmt(withClause, targetTable, overwrite, partitionKeyValues, planHints, hintLoc, queryStmt, columnPermutation, false);
    }

    public static InsertStmt createUpsert(WithClause withClause, TableName targetTable, List<PlanHint> planHints, HintLocation hintLoc, QueryStmt queryStmt, List<String> columnPermutation) {
        return new InsertStmt(withClause, targetTable, false, null, planHints, hintLoc, queryStmt, columnPermutation, true);
    }

    protected InsertStmt(WithClause withClause, TableName targetTable, boolean overwrite, List<PartitionKeyValue> partitionKeyValues, List<PlanHint> planHints, HintLocation hintLoc, QueryStmt queryStmt, List<String> columnPermutation, boolean isUpsert) {
        Preconditions.checkState((!isUpsert || !overwrite && partitionKeyValues == null ? 1 : 0) != 0);
        this.withClause_ = withClause;
        this.originalTableName_ = this.targetTableName_ = targetTable;
        this.overwrite_ = overwrite;
        this.partitionKeyValues_ = partitionKeyValues;
        this.planHints_ = planHints != null ? planHints : new ArrayList();
        this.hintLoc_ = hintLoc != null ? hintLoc : HintLocation.End;
        this.queryStmt_ = queryStmt;
        this.needsGeneratedQueryStatement_ = queryStmt == null;
        this.columnPermutation_ = columnPermutation;
        this.table_ = null;
        this.isUpsert_ = isUpsert;
    }

    private InsertStmt(InsertStmt other) {
        super(other);
        this.withClause_ = other.withClause_ != null ? other.withClause_.clone() : null;
        this.targetTableName_ = other.targetTableName_;
        this.originalTableName_ = other.originalTableName_;
        this.overwrite_ = other.overwrite_;
        this.partitionKeyValues_ = other.partitionKeyValues_;
        this.planHints_ = other.planHints_;
        this.hintLoc_ = other.hintLoc_;
        this.queryStmt_ = other.queryStmt_ != null ? other.queryStmt_.clone() : null;
        this.needsGeneratedQueryStatement_ = other.needsGeneratedQueryStatement_;
        this.columnPermutation_ = other.columnPermutation_;
        this.isUpsert_ = other.isUpsert_;
        this.writeId_ = other.writeId_;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.withClause_ != null) {
            this.withClause_.reset();
        }
        this.targetTableName_ = this.originalTableName_;
        this.queryStmt_.reset();
        this.partitionKeyExprs_.clear();
        this.partitionColPos_.clear();
        this.hasShuffleHint_ = false;
        this.hasNoShuffleHint_ = false;
        this.hasClusteredHint_ = false;
        this.hasNoClusteredHint_ = false;
        this.sortExprs_.clear();
        this.sortColumns_.clear();
        this.sortingOrder_ = TSortingOrder.LEXICAL;
        this.resultExprs_.clear();
        this.mentionedColumns_.clear();
        this.primaryKeyExprs_.clear();
        this.writeId_ = -1L;
    }

    @Override
    public InsertStmt clone() {
        return new InsertStmt(this);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        if (this.withClause_ != null) {
            this.withClause_.analyze(analyzer);
        }
        List<Object> selectListExprs = null;
        if (!this.needsGeneratedQueryStatement_) {
            Analyzer queryStmtAnalyzer = new Analyzer(analyzer);
            this.queryStmt_.analyze(queryStmtAnalyzer);
            selectListExprs = Expr.cloneList(this.queryStmt_.getResultExprs());
        } else {
            selectListExprs = new ArrayList();
        }
        if (this.partitionKeyValues_ != null) {
            for (PartitionKeyValue kv : this.partitionKeyValues_) {
                kv.analyze(analyzer);
            }
        }
        this.analyzeTargetTable(analyzer);
        boolean isHBaseTable = this.table_ instanceof FeHBaseTable;
        int numClusteringCols = isHBaseTable ? 0 : this.table_.getNumClusteringCols();
        List<String> analysisColumnPermutation = this.columnPermutation_;
        if (analysisColumnPermutation == null) {
            analysisColumnPermutation = new ArrayList<String>();
            List<Column> tableColumns = this.table_.getColumns();
            for (int i = numClusteringCols; i < tableColumns.size(); ++i) {
                Column c = tableColumns.get(i);
                if (c instanceof KuduColumn && ((KuduColumn)c).isAutoIncrementing()) continue;
                analysisColumnPermutation.add(c.getName());
            }
        }
        ArrayList<Column> selectExprTargetColumns = new ArrayList<Column>();
        HashSet<String> mentionedColumnNames = new HashSet<String>();
        for (String columnName : analysisColumnPermutation) {
            Column column = this.table_.getColumn(columnName);
            if (column == null) {
                throw new AnalysisException("Unknown column '" + columnName + "' in column permutation");
            }
            if (!mentionedColumnNames.add(column.getName())) {
                throw new AnalysisException("Duplicate column '" + columnName + "' in column permutation");
            }
            selectExprTargetColumns.add(column);
        }
        int numStaticPartitionExprs = 0;
        if (this.partitionKeyValues_ != null && !this.isIcebergTarget()) {
            for (PartitionKeyValue pkv : this.partitionKeyValues_) {
                Column column = this.table_.getColumn(pkv.getColName());
                if (column == null) {
                    throw new AnalysisException("Unknown column '" + pkv.getColName() + "' in partition clause");
                }
                if (column.getPosition() >= numClusteringCols) {
                    throw new AnalysisException("Column '" + pkv.getColName() + "' is not a partition column");
                }
                if (!mentionedColumnNames.add(pkv.getColName())) {
                    throw new AnalysisException("Duplicate column '" + pkv.getColName() + "' in partition clause");
                }
                if (!pkv.isDynamic()) {
                    ++numStaticPartitionExprs;
                    continue;
                }
                selectExprTargetColumns.add(column);
            }
        }
        this.checkColumnCoverage(selectExprTargetColumns, mentionedColumnNames, selectListExprs.size(), numStaticPartitionExprs);
        this.analyzeWriteAccess();
        this.prepareExpressions(selectExprTargetColumns, selectListExprs, this.table_, analyzer);
        this.analyzeSortColumns();
        this.analyzePlanHints(analyzer);
        if (this.hasNoClusteredHint_ && !this.sortExprs_.isEmpty()) {
            analyzer.addWarning(String.format("Insert statement has 'noclustered' hint, but table has '%s' property. The 'noclustered' hint will be ignored.", "sort.columns"));
        }
    }

    private void analyzeTargetTable(Analyzer analyzer) throws AnalysisException {
        Privilege privilegeRequired;
        Privilege privilege = privilegeRequired = this.isUpsert_ ? Privilege.ALL : Privilege.INSERT;
        if (this.table_ == null) {
            if (!this.targetTableName_.isFullyQualified()) {
                this.targetTableName_ = new TableName(analyzer.getDefaultDb(), this.targetTableName_.getTbl());
            }
            this.table_ = analyzer.getTable(this.targetTableName_, privilegeRequired);
        } else {
            this.targetTableName_ = new TableName(this.table_.getDb().getName(), this.table_.getName());
            analyzer.registerPrivReq(builder -> builder.onTable(this.table_).allOf(privilegeRequired).build());
        }
        if (this.table_ instanceof FeView || this.table_ instanceof MaterializedViewHdfsTable) {
            throw new AnalysisException(String.format("Impala does not support %sing into views: %s", this.getOpName(), this.table_.getFullName()));
        }
        Analyzer.ensureTableNotFullAcid(this.table_, "INSERT");
        Analyzer.checkTableCapability(this.table_, Analyzer.OperationType.WRITE);
        for (Column c : this.table_.getColumns()) {
            if (!c.getType().isSupported()) {
                throw new AnalysisException(String.format("Unable to %s into target table (%s) because the column '%s' has an unsupported type '%s'.", this.getOpName(), this.targetTableName_, c.getName(), c.getType().toSql()));
            }
            if (!c.getType().isComplexType()) continue;
            throw new AnalysisException(String.format("Unable to %s into target table (%s) because the column '%s' has a complex type '%s' and Impala doesn't support inserting into tables containing complex type columns", this.getOpName(), this.targetTableName_, c.getName(), c.getType().toSql()));
        }
        if (this.isUpsert_) {
            if (!(this.table_ instanceof FeKuduTable)) {
                throw new AnalysisException("UPSERT is only supported for Kudu tables");
            }
            if (((FeKuduTable)this.table_).hasAutoIncrementingColumn()) {
                throw new AnalysisException("UPSERT is not supported for Kudu tables with auto-incrementing column");
            }
        } else {
            this.analyzeTableForInsert(analyzer);
        }
        analyzer.getDescTbl().setTargetTable(this.table_);
    }

    private void analyzeTableForInsert(Analyzer analyzer) throws AnalysisException {
        int numClusteringCols;
        boolean isHBaseTable = this.table_ instanceof FeHBaseTable;
        int n = numClusteringCols = isHBaseTable ? 0 : this.table_.getNumClusteringCols();
        if (this.partitionKeyValues_ != null && numClusteringCols == 0) {
            if (isHBaseTable) {
                throw new AnalysisException("PARTITION clause is not valid for INSERT into HBase tables. '" + this.targetTableName_ + "' is an HBase table");
            }
            if (this.isIcebergTarget()) {
                IcebergPartitionSpec partSpec = ((FeIcebergTable)this.table_).getDefaultPartitionSpec();
                if (partSpec == null || !partSpec.hasPartitionFields()) {
                    throw new AnalysisException("PARTITION clause is only valid for INSERT into partitioned table. '" + this.targetTableName_ + "' is not partitioned");
                }
                for (PartitionKeyValue pkv : this.partitionKeyValues_) {
                    if (!pkv.isStatic()) continue;
                    throw new AnalysisException("Static partitioning is not supported for Iceberg tables.");
                }
            } else {
                throw new AnalysisException("PARTITION clause is only valid for INSERT into partitioned table. '" + this.targetTableName_ + "' is not partitioned");
            }
        }
        if (this.table_ instanceof FeFsTable) {
            this.setMaxTableSinks(this.analyzer_.getQueryOptions().getMax_fs_writers());
            FeFsTable fsTable = (FeFsTable)this.table_;
            StringBuilder error = new StringBuilder();
            fsTable.parseSkipHeaderLineCount(error);
            if (error.length() > 0) {
                throw new AnalysisException(error.toString());
            }
            try {
                if (!FileSystemUtil.isImpalaWritableFilesystem(fsTable.getLocation())) {
                    throw new AnalysisException(String.format("Unable to INSERT into target table (%s) because %s is not a supported filesystem.", this.targetTableName_, fsTable.getLocation()));
                }
            }
            catch (IOException e) {
                throw new AnalysisException(String.format("Unable to INSERT into target table (%s): %s.", this.targetTableName_, e.getMessage()), e);
            }
            for (int colIdx = 0; colIdx < numClusteringCols; ++colIdx) {
                Column col = fsTable.getColumns().get(colIdx);
                if (col.getType() != Type.BOOLEAN) continue;
                throw new AnalysisException(String.format("INSERT into table with BOOLEAN partition column (%s) is not supported: %s", col.getName(), this.targetTableName_));
            }
            if (this.isStaticPartitionTarget()) {
                HdfsFileFormat fileFormat;
                Boolean notSupported;
                PrunablePartition partition = HdfsTable.getPartition(fsTable, this.partitionKeyValues_);
                if (partition != null && partition instanceof FeFsPartition && (notSupported = Boolean.valueOf(!HdfsTableSink.SUPPORTED_FILE_FORMATS.contains((Object)(fileFormat = ((FeFsPartition)((Object)partition)).getFileFormat())))).booleanValue()) {
                    throw new AnalysisException(String.format("Writing the destination partition format '" + (Object)((Object)fileFormat) + "' is not supported.", new Object[0]));
                }
            } else {
                Set<HdfsFileFormat> formats = fsTable.getFileFormats();
                Sets.SetView unsupportedFormats = Sets.difference(formats, HdfsTableSink.SUPPORTED_FILE_FORMATS);
                if (!unsupportedFormats.isEmpty()) {
                    throw new AnalysisException(String.format("Destination table '" + fsTable.getFullName() + "' contains partition format(s) that are not supported to write: '" + Joiner.on((char)',').join((Iterable)unsupportedFormats) + "', dynamic partition clauses are forbidden.", new Object[0]));
                }
            }
        }
        if (this.table_ instanceof FeKuduTable) {
            if (this.overwrite_) {
                throw new AnalysisException("INSERT OVERWRITE not supported for Kudu tables.");
            }
            if (this.partitionKeyValues_ != null && !this.partitionKeyValues_.isEmpty()) {
                throw new AnalysisException("Partition specifications are not supported for Kudu tables.");
            }
        }
        if (this.table_ instanceof FeIcebergTable) {
            FeIcebergTable iceTable = (FeIcebergTable)this.table_;
            if (this.overwrite_) {
                if (iceTable.getPartitionSpecs().size() > 1) {
                    throw new AnalysisException("The Iceberg table has multiple partition specs. This means the outcome of dynamic partition overwrite is unforeseeable. Consider using TRUNCATE then INSERT INTO from the previous snapshot to overwrite your table.");
                }
                this.validateBucketTransformForOverwrite(iceTable);
            }
            IcebergUtil.validateIcebergTableForInsert(iceTable);
        }
        if (isHBaseTable && this.overwrite_) {
            throw new AnalysisException("HBase doesn't have a way to perform INSERT OVERWRITE");
        }
    }

    private void validateBucketTransformForOverwrite(FeIcebergTable iceTable) throws AnalysisException {
        Preconditions.checkState((this.overwrite_ ? 1 : 0) != 0);
        IcebergPartitionSpec spec = iceTable.getDefaultPartitionSpec();
        if (!spec.hasPartitionFields()) {
            return;
        }
        for (IcebergPartitionField field : spec.getIcebergPartitionFields()) {
            if (field.getTransformType() != TIcebergPartitionTransformType.BUCKET) continue;
            if (this.queryStmt_ instanceof ValuesStmt) {
                throw new AnalysisException("The Iceberg table has BUCKET partitioning. The outcome of static partition overwrite is unforeseeable. Consider using TRUNCATE and INSERT INTO to overwrite your table.");
            }
            List<TableRef> tblRefs = this.queryStmt_.collectTableRefs();
            ArrayList sourceTableAliases = tblRefs.size() <= 0 ? new ArrayList(0) : Arrays.asList(tblRefs.get(0).getAliases());
            String targetTableName = iceTable.getFullName();
            if (tblRefs.size() != 1 || !sourceTableAliases.contains(targetTableName)) {
                throw new AnalysisException("The Iceberg table has BUCKET partitioning and the source table does not match the target table. This means the outcome of dynamic partition overwrite is unforeseeable. Consider using TRUNCATE and INSERT INTO to overwrite your table.");
            }
            SelectList selectList = ((SelectStmt)this.queryStmt_).selectList_;
            if (selectList.getItems().size() != 1 && !selectList.getItems().get(0).isStar()) {
                throw new AnalysisException("The Iceberg table has BUCKET partitioning. The outcome of dynamic partition overwrite is unforeseeable with the given select list, only '*' allowed. Otherwise consider using TRUNCATE and INSERT INTO to overwrite your table.");
            }
            if (((SelectStmt)this.queryStmt_).whereClause_ == null) continue;
            throw new AnalysisException("The Iceberg table has BUCKET partitioning. The outcome of dynamic partition overwrite is unforeseeable with the given select query with WHERE clause, selective overwrite is not supported. Consider using TRUNCATE and INSERT INTO to overwrite your table.");
        }
    }

    private void analyzeWriteAccess() throws AnalysisException {
        if (!(this.table_ instanceof FeFsTable)) {
            return;
        }
        FeFsTable fsTable = (FeFsTable)this.table_;
        FeFsTable.Utils.checkWriteAccess(fsTable, this.isStaticPartitionTarget() ? this.partitionKeyValues_ : null, "INSERT");
    }

    public boolean isStaticPartitionTarget() {
        if (this.partitionKeyValues_ == null) {
            return false;
        }
        for (PartitionKeyValue pkv : this.partitionKeyValues_) {
            if (!pkv.isDynamic()) continue;
            return false;
        }
        return true;
    }

    public List<PartitionKeyValue> getPartitionKeyValues() {
        return this.partitionKeyValues_;
    }

    private boolean isIcebergTarget() {
        return this.table_ instanceof FeIcebergTable;
    }

    private void checkColumnCoverage(List<Column> selectExprTargetColumns, Set<String> mentionedColumnNames, int numSelectListExprs, int numStaticPartitionExprs) throws AnalysisException {
        if (selectExprTargetColumns.size() + numStaticPartitionExprs != this.table_.getColumns().size()) {
            if (this.table_ instanceof FeKuduTable) {
                this.checkRequiredKuduColumns(mentionedColumnNames);
            } else if (this.table_ instanceof FeHBaseTable) {
                this.checkRequiredHBaseColumns(mentionedColumnNames);
            } else if (this.table_.getNumClusteringCols() > 0) {
                this.checkRequiredPartitionedColumns(mentionedColumnNames);
            }
        }
        if (selectExprTargetColumns.size() != numSelectListExprs) {
            String partitionClause;
            String comparator = selectExprTargetColumns.size() < numSelectListExprs ? "fewer" : "more";
            String string = partitionClause = this.partitionKeyValues_ == null ? "returns" : "and PARTITION clause return";
            if (this.columnPermutation_ == null) {
                int totalColumnsMentioned = numSelectListExprs + numStaticPartitionExprs;
                throw new AnalysisException(String.format("Target table '%s' has %s columns (%s) than the SELECT / VALUES clause %s (%s)", this.table_.getFullName(), comparator, this.table_.getColumns().size(), partitionClause, totalColumnsMentioned));
            }
            String partitionPrefix = this.partitionKeyValues_ == null ? "mentions" : "and PARTITION clause mention";
            throw new AnalysisException(String.format("Column permutation %s %s columns (%s) than the SELECT / VALUES clause %s (%s)", partitionPrefix, comparator, selectExprTargetColumns.size(), partitionClause, numSelectListExprs));
        }
    }

    private void checkRequiredKuduColumns(Set<String> mentionedColumnNames) throws AnalysisException {
        Preconditions.checkState((boolean)(this.table_ instanceof FeKuduTable));
        List<String> keyColumns = ((FeKuduTable)this.table_).getPrimaryKeyColumnNames();
        ArrayList<String> missingKeyColumnNames = new ArrayList<String>();
        for (Column column : this.table_.getColumns()) {
            Preconditions.checkState((boolean)(column instanceof KuduColumn));
            if (mentionedColumnNames.contains(column.getName()) || !keyColumns.contains(column.getName()) || ((KuduColumn)column).isAutoIncrementing()) continue;
            missingKeyColumnNames.add(column.getName());
        }
        if (!missingKeyColumnNames.isEmpty()) {
            throw new AnalysisException(String.format("All primary key columns must be specified for %sing into Kudu tables. Missing columns are: %s", this.getOpName(), Joiner.on((String)", ").join(missingKeyColumnNames)));
        }
    }

    private void checkRequiredHBaseColumns(Set<String> mentionedColumnNames) throws AnalysisException {
        Preconditions.checkState((boolean)(this.table_ instanceof FeHBaseTable));
        Column column = this.table_.getColumns().get(0);
        if (!mentionedColumnNames.contains(column.getName())) {
            throw new AnalysisException("Row-key column '" + column.getName() + "' must be explicitly mentioned in column permutation.");
        }
    }

    private void checkRequiredPartitionedColumns(Set<String> mentionedColumnNames) throws AnalysisException {
        int numClusteringCols = this.table_.getNumClusteringCols();
        ArrayList<String> missingPartitionColumnNames = new ArrayList<String>();
        for (Column column : this.table_.getColumns()) {
            if (mentionedColumnNames.contains(column.getName()) || column.getPosition() >= numClusteringCols) continue;
            missingPartitionColumnNames.add(column.getName());
        }
        if (!missingPartitionColumnNames.isEmpty()) {
            throw new AnalysisException("Not enough partition columns mentioned in query. Missing columns are: " + Joiner.on((String)", ").join(missingPartitionColumnNames));
        }
    }

    private void prepareExpressions(List<Column> selectExprTargetColumns, List<Expr> selectListExprs, FeTable tbl, Analyzer analyzer) throws AnalysisException {
        Expr compatibleExpr;
        int i;
        ArrayList<Expr> tmpPartitionKeyExprs = new ArrayList<Expr>();
        ArrayList<String> tmpPartitionKeyNames = new ArrayList<String>();
        int numClusteringCols = tbl instanceof FeHBaseTable ? 0 : tbl.getNumClusteringCols();
        boolean isKuduTable = this.table_ instanceof FeKuduTable;
        Set<String> kuduPartitionColumnNames = null;
        if (isKuduTable) {
            kuduPartitionColumnNames = InsertStmt.getKuduPartitionColumnNames((FeKuduTable)this.table_);
        }
        IcebergPartitionSpec icebergPartSpec = null;
        if (this.isIcebergTarget()) {
            icebergPartSpec = ((FeIcebergTable)this.table_).getDefaultPartitionSpec();
        }
        SetOperationStmt unionStmt = this.queryStmt_ instanceof SetOperationStmt ? (SetOperationStmt)this.queryStmt_ : null;
        List<Expr> widestTypeExprList = null;
        if (unionStmt != null && unionStmt.getWidestExprs() != null && unionStmt.getWidestExprs().size() > 0) {
            widestTypeExprList = unionStmt.getWidestExprs();
        }
        boolean convertToUtc = isKuduTable && analyzer.getQueryOptions().isWrite_kudu_utc_timestamps();
        for (i = 0; i < selectListExprs.size(); ++i) {
            Column targetColumn = selectExprTargetColumns.get(i);
            Expr widestTypeExpr = widestTypeExprList != null ? widestTypeExprList.get(i) : null;
            compatibleExpr = InsertStmt.checkTypeCompatibility(this.targetTableName_.toString(), targetColumn, selectListExprs.get(i), analyzer, widestTypeExpr);
            if (targetColumn.getPosition() < numClusteringCols) {
                tmpPartitionKeyExprs.add(compatibleExpr);
                tmpPartitionKeyNames.add(targetColumn.getName());
            } else if (isKuduTable && kuduPartitionColumnNames.contains(targetColumn.getName())) {
                tmpPartitionKeyExprs.add(compatibleExpr);
                tmpPartitionKeyNames.add(targetColumn.getName());
            }
            selectListExprs.set(i, compatibleExpr);
        }
        if (this.partitionKeyValues_ != null) {
            for (PartitionKeyValue pkv : this.partitionKeyValues_) {
                if (!pkv.isStatic()) continue;
                Column tableColumn = this.table_.getColumn(pkv.getColName());
                compatibleExpr = InsertStmt.checkTypeCompatibility(this.targetTableName_.toString(), tableColumn, pkv.getLiteralValue(), analyzer, null);
                tmpPartitionKeyExprs.add(compatibleExpr);
                tmpPartitionKeyNames.add(pkv.getColName());
            }
        }
        if (this.isIcebergTarget()) {
            IcebergUtil.populatePartitionExprs(analyzer, widestTypeExprList, selectExprTargetColumns, selectListExprs, (FeIcebergTable)this.table_, this.partitionKeyExprs_, this.partitionColPos_);
        } else {
            block2: for (i = 0; i < this.table_.getColumns().size(); ++i) {
                Column c = this.table_.getColumns().get(i);
                for (int j = 0; j < tmpPartitionKeyNames.size(); ++j) {
                    if (!c.getName().equals(tmpPartitionKeyNames.get(j))) continue;
                    Expr expr = (Expr)tmpPartitionKeyExprs.get(j);
                    if (convertToUtc && expr.getType().isTimestamp()) {
                        expr = ExprUtil.toUtcTimestampExpr(analyzer, expr, true);
                    }
                    this.partitionKeyExprs_.add(expr);
                    this.partitionColPos_.add(i);
                    continue block2;
                }
            }
        }
        if (this.isIcebergTarget() && icebergPartSpec.hasPartitionFields()) {
            int parts = 0;
            for (IcebergPartitionField pField : icebergPartSpec.getIcebergPartitionFields()) {
                if (pField.getTransformType() == TIcebergPartitionTransformType.VOID) continue;
                ++parts;
            }
            if (CollectionUtils.isEmpty(this.columnPermutation_)) {
                Preconditions.checkState((this.partitionKeyExprs_.size() == parts ? 1 : 0) != 0);
            }
        } else if (isKuduTable) {
            Preconditions.checkState((this.partitionKeyExprs_.size() == kuduPartitionColumnNames.size() ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((this.partitionKeyExprs_.size() == numClusteringCols ? 1 : 0) != 0);
        }
        for (Expr expr : this.partitionKeyExprs_) {
            expr.analyze(analyzer);
        }
        List<Column> columns = this.table_.getColumnsInHiveOrder();
        for (int col = 0; col < columns.size(); ++col) {
            FeKuduTable kuduTable;
            Column tblColumn = columns.get(col);
            boolean matchFound = false;
            for (int i2 = 0; i2 < selectListExprs.size(); ++i2) {
                if (!selectExprTargetColumns.get(i2).getName().equals(tblColumn.getName())) continue;
                Expr expr = selectListExprs.get(i2);
                if (convertToUtc && expr.getType().isTimestamp()) {
                    expr = ExprUtil.toUtcTimestampExpr(analyzer, expr, true);
                }
                this.resultExprs_.add(expr);
                if (isKuduTable) {
                    this.mentionedColumns_.add(col);
                }
                matchFound = true;
                break;
            }
            if (!matchFound && tblColumn.getPosition() >= numClusteringCols) {
                if (isKuduTable) {
                    Preconditions.checkState((boolean)(tblColumn instanceof KuduColumn));
                    KuduColumn kuduCol = (KuduColumn)tblColumn;
                    if (!(kuduCol.hasDefaultValue() || kuduCol.isNullable() || kuduCol.isAutoIncrementing())) {
                        throw new AnalysisException("Missing values for column that is not nullable and has no default value " + kuduCol.getName());
                    }
                } else {
                    IcebergColumn targetColumn;
                    NullLiteral nullExpr = NullLiteral.create(tblColumn.getType());
                    this.resultExprs_.add(nullExpr);
                    if (this.isIcebergTarget() && !CollectionUtils.isEmpty(this.columnPermutation_) && icebergPartSpec != null && IcebergUtil.isPartitionColumn(targetColumn = (IcebergColumn)tblColumn, icebergPartSpec)) {
                        this.partitionKeyExprs_.add(nullExpr);
                        this.partitionColPos_.add(targetColumn.getPosition());
                    }
                }
            }
            if (!matchFound || !isKuduTable || !(kuduTable = (FeKuduTable)this.table_).getPrimaryKeyColumnNames().contains(tblColumn.getName())) continue;
            this.primaryKeyExprs_.add((Expr)Iterables.getLast(this.resultExprs_));
        }
        if (this.isIcebergTarget() && !CollectionUtils.isEmpty(this.columnPermutation_)) {
            ArrayList exprPairs = Lists.newArrayList();
            for (int i3 = 0; i3 < this.partitionColPos_.size(); ++i3) {
                exprPairs.add(Pair.create(this.partitionColPos_.get(i3), this.partitionKeyExprs_.get(i3)));
            }
            exprPairs.sort(Comparator.comparingInt(p -> (Integer)p.first));
            this.partitionColPos_.clear();
            this.partitionKeyExprs_.clear();
            for (Pair exprPair : exprPairs) {
                this.partitionColPos_.add((Integer)exprPair.first);
                this.partitionKeyExprs_.add((Expr)exprPair.second);
            }
        }
        if (this.table_ instanceof FeKuduTable) {
            Preconditions.checkState((!this.primaryKeyExprs_.isEmpty() ? 1 : 0) != 0);
        }
        if (this.needsGeneratedQueryStatement_) {
            ArrayList<SelectListItem> selectListItems = new ArrayList<SelectListItem>();
            for (Expr e : this.resultExprs_) {
                selectListItems.add(new SelectListItem(e, null));
            }
            SelectList selectList = new SelectList(selectListItems);
            this.queryStmt_ = new SelectStmt(selectList, null, null, null, null, null, null);
            this.queryStmt_.analyze(analyzer);
        }
    }

    private static Set<String> getKuduPartitionColumnNames(FeKuduTable table) {
        HashSet<String> ret = new HashSet<String>();
        for (KuduPartitionParam partitionParam : table.getPartitionBy()) {
            ret.addAll(partitionParam.getColumnNames());
        }
        return ret;
    }

    private void analyzeSortColumns() throws AnalysisException {
        if (!(this.table_ instanceof FeFsTable)) {
            return;
        }
        Pair<List<Integer>, TSortingOrder> sortProperties = AlterTableSetTblProperties.analyzeSortColumns(this.table_, this.table_.getMetaStoreTable().getParameters());
        this.sortColumns_ = (List)sortProperties.first;
        this.sortingOrder_ = (TSortingOrder)((Object)sortProperties.second);
        for (Integer colIdx : this.sortColumns_) {
            this.sortExprs_.add(this.resultExprs_.get(colIdx));
        }
    }

    private void analyzePlanHints(Analyzer analyzer) throws AnalysisException {
        if (this.planHints_.isEmpty() && !analyzer.getQueryOptions().isSetDefault_hints_insert_statement()) {
            return;
        }
        if (this.table_ instanceof FeHBaseTable) {
            if (!this.planHints_.isEmpty()) {
                throw new AnalysisException(String.format("INSERT hints are only supported for inserting into Hdfs and Kudu tables: %s", this.getTargetTableName()));
            }
            return;
        }
        if (this.planHints_.isEmpty() && analyzer.getQueryOptions().isSetDefault_hints_insert_statement()) {
            String defaultHints = analyzer.getQueryOptions().getDefault_hints_insert_statement();
            for (String hint : defaultHints.trim().split(":")) {
                this.planHints_.add(new PlanHint(hint.trim()));
            }
        }
        for (PlanHint hint : this.planHints_) {
            if (hint.is("SHUFFLE")) {
                this.hasShuffleHint_ = true;
                analyzer.setHasPlanHints();
                continue;
            }
            if (hint.is("NOSHUFFLE")) {
                this.hasNoShuffleHint_ = true;
                analyzer.setHasPlanHints();
                continue;
            }
            if (hint.is("CLUSTERED")) {
                this.hasClusteredHint_ = true;
                analyzer.setHasPlanHints();
                continue;
            }
            if (hint.is("NOCLUSTERED")) {
                this.hasNoClusteredHint_ = true;
                analyzer.setHasPlanHints();
                continue;
            }
            analyzer.addWarning("INSERT hint not recognized: " + hint);
        }
        if (this.hasShuffleHint_ && this.hasNoShuffleHint_) {
            throw new AnalysisException("Conflicting INSERT hints: shuffle and noshuffle");
        }
        if (this.hasClusteredHint_ && this.hasNoClusteredHint_) {
            throw new AnalysisException("Conflicting INSERT hints: clustered and noclustered");
        }
    }

    @Override
    public List<Expr> getResultExprs() {
        return this.resultExprs_;
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.queryStmt_.rewriteExprs(rewriter);
    }

    private String getOpName() {
        return this.isUpsert_ ? "UPSERT" : "INSERT";
    }

    public List<PlanHint> getPlanHints() {
        return this.planHints_;
    }

    public TableName getTargetTableName() {
        return this.targetTableName_;
    }

    @Override
    public void setTargetTable(FeTable table) {
        this.table_ = table;
    }

    public boolean isTargetTableKuduTable() {
        return this.table_ instanceof FeKuduTable;
    }

    public void setWriteId(long writeId) {
        this.writeId_ = writeId;
    }

    public boolean isOverwrite() {
        return this.overwrite_;
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.sortingOrder_;
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.partitionKeyExprs_;
    }

    public List<Integer> getPartitionColPos() {
        return this.partitionColPos_;
    }

    @Override
    public boolean hasShuffleHint() {
        return this.hasShuffleHint_;
    }

    @Override
    public boolean hasNoShuffleHint() {
        return this.hasNoShuffleHint_;
    }

    @Override
    public boolean hasClusteredHint() {
        return this.hasClusteredHint_;
    }

    @Override
    public boolean hasNoClusteredHint() {
        return this.hasNoClusteredHint_;
    }

    public List<Expr> getPrimaryKeyExprs() {
        return this.primaryKeyExprs_;
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.sortExprs_;
    }

    public long getWriteId() {
        return this.writeId_;
    }

    public boolean requiresClustering() {
        return !this.hasNoClusteredHint_ || !this.sortExprs_.isEmpty();
    }

    public List<String> getMentionedColumns() {
        ArrayList<String> result = new ArrayList<String>();
        List<Column> columns = this.table_.getColumns();
        for (Integer i : this.mentionedColumns_) {
            result.add(columns.get(i).getName());
        }
        return result;
    }

    @Override
    public DataSink createDataSink() {
        Preconditions.checkState((this.table_ != null ? 1 : 0) != 0);
        return TableSink.create(this.table_, this.isUpsert_ ? TableSink.Op.UPSERT : TableSink.Op.INSERT, this.partitionKeyExprs_, this.resultExprs_, this.mentionedColumns_, this.overwrite_, this.requiresClustering(), new Pair<List<Integer>, TSortingOrder>(this.sortColumns_, this.sortingOrder_), this.writeId_, this.kuduTxnToken_, this.maxTableSinks_);
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.resultExprs_ = Expr.substituteList(this.resultExprs_, smap, analyzer, true);
        this.partitionKeyExprs_ = Expr.substituteList(this.partitionKeyExprs_, smap, analyzer, true);
        this.primaryKeyExprs_ = Expr.substituteList(this.primaryKeyExprs_, smap, analyzer, true);
        this.sortExprs_ = Expr.substituteList(this.sortExprs_, smap, analyzer, true);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        if (this.withClause_ != null) {
            strBuilder.append(this.withClause_.toSql(options) + " ");
        }
        strBuilder.append(this.getOpName());
        if (!this.planHints_.isEmpty() && this.hintLoc_ == HintLocation.Start) {
            strBuilder.append(" " + ToSqlUtils.getPlanHintsSql(options, this.getPlanHints()));
        }
        if (this.overwrite_) {
            strBuilder.append(" OVERWRITE");
        } else {
            strBuilder.append(" INTO");
        }
        strBuilder.append(" TABLE " + this.originalTableName_);
        if (this.columnPermutation_ != null) {
            strBuilder.append("(");
            String sep = "";
            for (String col : this.columnPermutation_) {
                strBuilder.append(sep);
                strBuilder.append(ToSqlUtils.getIdentSql(col));
                sep = ", ";
            }
            strBuilder.append(")");
        }
        if (this.partitionKeyValues_ != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (PartitionKeyValue pkv : this.partitionKeyValues_) {
                values.add(ToSqlUtils.getIdentSql(pkv.getColName()) + (pkv.getValue() != null ? "=" + pkv.getValue().toSql(options) : ""));
            }
            strBuilder.append(" PARTITION (" + Joiner.on((String)", ").join(values) + ")");
        }
        if (!this.planHints_.isEmpty() && this.hintLoc_ == HintLocation.End) {
            strBuilder.append(" " + ToSqlUtils.getPlanHintsSql(options, this.getPlanHints()));
        }
        if (!this.needsGeneratedQueryStatement_) {
            strBuilder.append(" " + this.queryStmt_.toSql(options));
        }
        return strBuilder.toString();
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        if (this.withClause_ != null) {
            for (View v : this.withClause_.getViews()) {
                v.getQueryStmt().collectTableRefs(tblRefs);
            }
        }
        tblRefs.add(new TableRef(this.targetTableName_.toPath(), null));
        if (this.queryStmt_ != null) {
            this.queryStmt_.collectTableRefs(tblRefs);
        }
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChange = false;
        if (this.withClause_ != null) {
            hasChange = this.withClause_.resolveTableMask(analyzer);
        }
        if (this.queryStmt_ != null) {
            hasChange |= this.queryStmt_.resolveTableMask(analyzer);
        }
        return hasChange;
    }

    public static enum HintLocation {
        Start,
        End;

    }
}

