/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.impala.analysis.AnalyticInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TableSampleClause;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.PrivilegeRequestBuilder;
import org.apache.impala.authorization.TableMask;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.rewrite.ExprRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineViewRef
extends TableRef {
    private static final Logger LOG = LoggerFactory.getLogger(InlineViewRef.class);
    private final FeView view_;
    private List<String> explicitColLabels_;
    protected QueryStmt queryStmt_;
    protected Analyzer inlineViewAnalyzer_;
    protected final List<TupleId> materializedTupleIds_ = new ArrayList<TupleId>();
    protected final ExprSubstitutionMap smap_;
    protected final ExprSubstitutionMap baseTblSmap_;
    private boolean isTableMaskingView_ = false;
    private boolean isNonCorrelatedScalarSubquery_ = false;

    public InlineViewRef(String alias, QueryStmt queryStmt, TableSampleClause sampleParams) {
        super(null, alias, sampleParams);
        Preconditions.checkNotNull((Object)queryStmt);
        this.queryStmt_ = queryStmt;
        this.view_ = null;
        this.smap_ = new ExprSubstitutionMap();
        this.baseTblSmap_ = new ExprSubstitutionMap();
    }

    public InlineViewRef(String alias, QueryStmt queryStmt, List<String> colLabels) {
        this(alias, queryStmt, (TableSampleClause)null);
        this.explicitColLabels_ = Lists.newArrayList(colLabels);
    }

    public InlineViewRef(FeView view, TableRef origTblRef) {
        super(view.getTableName().toPath(), origTblRef.getExplicitAlias(), origTblRef.getPrivilege(), origTblRef.requireGrantOption());
        this.queryStmt_ = view.getQueryStmt().clone();
        this.queryStmt_.reset();
        if (view.isLocalView()) {
            this.queryStmt_.reset();
        }
        this.view_ = view;
        this.smap_ = new ExprSubstitutionMap();
        this.baseTblSmap_ = new ExprSubstitutionMap();
        this.setJoinAttrs(origTblRef);
        this.explicitColLabels_ = view.getColLabels();
        if (this.hasExplicitAlias()) {
            return;
        }
        this.aliases_ = new String[]{this.view_.getTableName().toString().toLowerCase(), this.view_.getName().toLowerCase()};
        this.sampleParams_ = origTblRef.getSampleParams();
    }

    public InlineViewRef(InlineViewRef other) {
        super(other);
        Preconditions.checkNotNull((Object)other.queryStmt_);
        this.view_ = other.view_;
        this.queryStmt_ = other.queryStmt_.clone();
        this.inlineViewAnalyzer_ = other.inlineViewAnalyzer_;
        if (other.explicitColLabels_ != null) {
            this.explicitColLabels_ = Lists.newArrayList(other.explicitColLabels_);
        }
        this.materializedTupleIds_.addAll(other.materializedTupleIds_);
        this.smap_ = other.smap_.clone();
        this.baseTblSmap_ = other.baseTblSmap_.clone();
        this.isTableMaskingView_ = other.isTableMaskingView_;
    }

    static InlineViewRef createTableMaskView(TableRef tableRef, TableMask tableMask, AuthorizationContext authzCtx) throws AnalysisException, InternalException {
        Preconditions.checkNotNull((Object)tableRef);
        Preconditions.checkNotNull((Object)authzCtx);
        Preconditions.checkState((tableRef instanceof InlineViewRef || tableRef instanceof BaseTableRef ? 1 : 0) != 0);
        List<Column> columns = tableMask.getRequiredColumns();
        ArrayList items = Lists.newArrayListWithCapacity((int)columns.size());
        for (Column col : columns) {
            Expr maskExpr = tableMask.createColumnMask(col.getName(), col.getType(), authzCtx);
            boolean isHidden = col.isVirtual();
            items.add(new SelectListItem(maskExpr, col.getName(), isHidden));
        }
        if (tableMask.hasComplexColumnMask()) {
            throw new AnalysisException("Column masking is not supported for complex types");
        }
        if (columns.isEmpty()) {
            items.add(new SelectListItem(NumericLiteral.create(1L), null));
        }
        SelectList selectList = new SelectList(items);
        FromClause fromClause = new FromClause(Lists.newArrayList((Object[])new TableRef[]{tableRef}));
        Expr wherePredicate = tableMask.createRowFilter(authzCtx);
        SelectStmt tableMaskStmt = new SelectStmt(selectList, fromClause, wherePredicate, null, null, null, null);
        InlineViewRef viewRef = new InlineViewRef(null, (QueryStmt)tableMaskStmt, (TableSampleClause)null);
        tableRef.migratePropertiesTo(viewRef);
        viewRef.isTableMaskingView_ = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Replacing '{}' with subquery: {}", (Object)tableRef.toSql(), (Object)tableMaskStmt.toSql());
        }
        return viewRef;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        this.inlineViewAnalyzer_ = new Analyzer(analyzer);
        if (this.isCatalogView()) {
            analyzer.registerAuthAndAuditEvent(this.view_, this.priv_, this.requireGrantOption_);
            if (!PrivilegeRequestBuilder.isViewCreatedByNonSuperuser(this.view_)) {
                if (this.inlineViewAnalyzer_.isExplain()) {
                    this.inlineViewAnalyzer_.setMaskPrivChecks(String.format("User '%s' does not have privileges to EXPLAIN this statement.", analyzer.getUser().getName()));
                } else {
                    this.inlineViewAnalyzer_.setMaskPrivChecks(null);
                }
            }
        }
        this.inlineViewAnalyzer_.setUseHiveColLabels(this.isCatalogView() ? true : analyzer.useHiveColLabels());
        this.queryStmt_.analyze(this.inlineViewAnalyzer_);
        this.correlatedTupleIds_.addAll(this.queryStmt_.getCorrelatedTupleIds());
        if (this.explicitColLabels_ != null) {
            Preconditions.checkState((this.explicitColLabels_.size() == this.queryStmt_.getColLabels().size() ? 1 : 0) != 0);
        }
        this.inlineViewAnalyzer_.setHasLimitOffsetClause(this.queryStmt_.hasLimit() || this.queryStmt_.hasOffset());
        this.queryStmt_.getMaterializedTupleIds(this.materializedTupleIds_);
        this.desc_ = analyzer.registerTableRef(this);
        this.desc_.setSourceView(this);
        this.isAnalyzed_ = true;
        if (this.materializedTupleIds_.isEmpty()) {
            Preconditions.checkState((boolean)(this.queryStmt_ instanceof SelectStmt));
            Preconditions.checkState((boolean)((SelectStmt)this.queryStmt_).getTableRefs().isEmpty());
            this.desc_.setIsMaterialized(true);
            this.materializedTupleIds_.add(this.desc_.getId());
        }
        for (int i = 0; i < this.getColLabels().size(); ++i) {
            String colName = this.getColLabels().get(i).toLowerCase();
            Expr colExpr = this.queryStmt_.getResultExprs().get(i);
            Expr baseTableExpr = this.queryStmt_.getBaseTblResultExprs().get(i);
            this.addColumnToSubstitutionMaps(analyzer, colName, colExpr, baseTableExpr);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("inline view " + this.getUniqueAlias() + " smap: " + this.smap_.debugString());
            LOG.trace("inline view " + this.getUniqueAlias() + " baseTblSmap: " + this.baseTblSmap_.debugString());
            Preconditions.checkState((boolean)this.baseTblSmap_.checkComposedFrom(this.smap_));
        }
        this.analyzeTableSample(analyzer);
        this.analyzeHints(analyzer);
        this.analyzeJoin(analyzer);
    }

    private void addColumnToSubstitutionMaps(Analyzer analyzer, String colName, Expr colExpr, Expr baseTableExpr) throws AnalysisException {
        Path p = new Path(this.desc_, (List<String>)Lists.newArrayList((Object[])new String[]{colName}));
        Preconditions.checkState((boolean)p.resolve());
        SlotDescriptor slotDesc = analyzer.registerSlotRef(p, false);
        slotDesc.setSourceExpr(colExpr);
        slotDesc.setStats(ColumnStats.fromExpr(colExpr));
        this.putExprsIntoSmaps(analyzer, slotDesc, colExpr, baseTableExpr);
    }

    private void putExprsIntoSmaps(Analyzer analyzer, SlotDescriptor slotDesc, Expr colExpr, Expr baseTableExpr, boolean recurse) {
        SlotRef key = new SlotRef(slotDesc);
        this.smap_.put(key, colExpr);
        this.baseTblSmap_.put(key, baseTableExpr);
        if (this.createAuxPredicate(colExpr)) {
            analyzer.createAuxEqPredicate(new SlotRef(slotDesc), colExpr.clone());
        }
        if (recurse) {
            if (colExpr.getType().isCollectionType()) {
                Preconditions.checkState((boolean)(colExpr instanceof SlotRef));
                Preconditions.checkState((boolean)(baseTableExpr instanceof SlotRef));
                this.putCollectionItemsIntoSmaps(analyzer, slotDesc, (SlotRef)colExpr, (SlotRef)baseTableExpr);
            } else if (colExpr.getType().isStructType()) {
                Preconditions.checkState((boolean)(colExpr instanceof SlotRef));
                Preconditions.checkState((boolean)(baseTableExpr instanceof SlotRef));
                this.putStructMembersIntoSmaps(analyzer, slotDesc, (SlotRef)colExpr, (SlotRef)baseTableExpr);
            }
        }
    }

    private void putExprsIntoSmaps(Analyzer analyzer, SlotDescriptor slotDesc, Expr colExpr, Expr baseTableExpr) {
        this.putExprsIntoSmaps(analyzer, slotDesc, colExpr, baseTableExpr, true);
    }

    private void putCollectionItemsIntoSmaps(Analyzer analyzer, SlotDescriptor slotDesc, SlotRef colExpr, SlotRef baseTableExpr) {
        SlotDescriptor srcSlotDesc = colExpr.getDesc();
        SlotDescriptor baseTableSlotDesc = baseTableExpr.getDesc();
        TupleDescriptor itemTupleDesc = slotDesc.getItemTupleDesc();
        TupleDescriptor srcItemTupleDesc = srcSlotDesc.getItemTupleDesc();
        TupleDescriptor baseTableItemTupleDesc = baseTableSlotDesc.getItemTupleDesc();
        if (itemTupleDesc != null) {
            Preconditions.checkState((srcItemTupleDesc != null ? 1 : 0) != 0);
            Preconditions.checkState((baseTableItemTupleDesc != null ? 1 : 0) != 0);
            int num_slots = itemTupleDesc.getSlots().size();
            Preconditions.checkState((num_slots == 1 || num_slots == 2 ? 1 : 0) != 0);
            Preconditions.checkState((srcItemTupleDesc.getSlots().size() == num_slots ? 1 : 0) != 0);
            Preconditions.checkState((baseTableItemTupleDesc.getSlots().size() == num_slots ? 1 : 0) != 0);
            for (int i = 0; i < num_slots; ++i) {
                SlotDescriptor itemSlotDesc = itemTupleDesc.getSlots().get(i);
                SlotDescriptor srcItemSlotDesc = srcItemTupleDesc.getSlots().get(i);
                SlotDescriptor baseTableItemSlotDesc = baseTableItemTupleDesc.getSlots().get(i);
                SlotRef srcItemSlotRef = new SlotRef(srcItemSlotDesc);
                SlotRef baseTableItemSlotRef = new SlotRef(baseTableItemSlotDesc);
                Preconditions.checkState((boolean)itemSlotDesc.getType().equals(srcItemSlotRef.getType()));
                Preconditions.checkState((boolean)itemSlotDesc.getType().equals(baseTableItemSlotRef.getType()));
                this.putExprsIntoSmaps(analyzer, itemSlotDesc, srcItemSlotRef, baseTableItemSlotRef, false);
            }
        }
    }

    private void putStructMembersIntoSmaps(Analyzer analyzer, SlotDescriptor slotDesc, SlotRef colExpr, SlotRef baseTableExpr) {
        Preconditions.checkState((boolean)slotDesc.getType().isStructType());
        Preconditions.checkState((boolean)colExpr.getType().isStructType());
        Preconditions.checkState((boolean)baseTableExpr.getType().isStructType());
        Preconditions.checkState((boolean)slotDesc.getType().equals(colExpr.getType()));
        Preconditions.checkState((boolean)slotDesc.getType().equals(baseTableExpr.getType()));
        TupleDescriptor itemTupleDesc = slotDesc.getItemTupleDesc();
        Preconditions.checkNotNull((Object)itemTupleDesc);
        List<SlotDescriptor> childSlotDescs = itemTupleDesc.getSlots();
        Preconditions.checkState((childSlotDescs.size() == colExpr.getChildren().size() ? 1 : 0) != 0);
        Preconditions.checkState((childSlotDescs.size() == baseTableExpr.getChildren().size() ? 1 : 0) != 0);
        for (int i = 0; i < childSlotDescs.size(); ++i) {
            SlotDescriptor childSlotDesc = childSlotDescs.get(i);
            Expr childColExpr = (Expr)colExpr.getChildren().get(i);
            Preconditions.checkState((boolean)(childColExpr instanceof SlotRef));
            SlotRef childColExprSlotRef = (SlotRef)childColExpr;
            Expr childBaseTableExpr = (Expr)baseTableExpr.getChildren().get(i);
            Preconditions.checkState((boolean)(childBaseTableExpr instanceof SlotRef));
            SlotRef childBaseTableExprSlotRef = (SlotRef)childBaseTableExpr;
            Path childColExprPath = childColExprSlotRef.getResolvedPath();
            Path childBaseTableExprPath = childBaseTableExprSlotRef.getResolvedPath();
            if (childColExprPath == null) continue;
            InlineViewRef.verifySameChild(childSlotDesc.getPath(), childColExprPath, childBaseTableExprPath);
            this.putExprsIntoSmaps(analyzer, childSlotDesc, childColExprSlotRef, childBaseTableExprSlotRef);
        }
    }

    private static void verifySameChild(Path childSlotDescPath, Path childColExprPath, Path childBaseTableExprPath) {
        List<String> childSlotDescRawPath = childSlotDescPath.getRawPath();
        List<String> childColExprRawPath = childColExprPath.getRawPath();
        List<String> childBaseTableExprRawPath = childBaseTableExprPath.getRawPath();
        String childSlotDescPathEnd = childSlotDescRawPath.get(childSlotDescRawPath.size() - 1);
        String childColExprPathEnd = childColExprRawPath.get(childColExprRawPath.size() - 1);
        String childBaseTableExprPathEnd = childBaseTableExprRawPath.get(childBaseTableExprRawPath.size() - 1);
        Preconditions.checkState((boolean)childSlotDescPathEnd.equals(childColExprPathEnd));
        Preconditions.checkState((boolean)childSlotDescPathEnd.equals(childBaseTableExprPathEnd));
    }

    private boolean createAuxPredicate(Expr e) {
        if (!(this.queryStmt_ instanceof SelectStmt) || !((SelectStmt)this.queryStmt_).hasAnalyticInfo()) {
            return true;
        }
        AnalyticInfo analyticInfo = ((SelectStmt)this.queryStmt_).getAnalyticInfo();
        return analyticInfo.getCommonPartitionExprs().contains(e);
    }

    @Override
    public TupleDescriptor createTupleDescriptor(Analyzer analyzer) throws AnalysisException {
        TableRef tblRef;
        int numColLabels = this.getColLabels().size();
        Preconditions.checkState((numColLabels > 0 ? 1 : 0) != 0);
        HashSet uniqueColAliases = Sets.newHashSetWithExpectedSize((int)numColLabels);
        LinkedHashSet fields = Sets.newLinkedHashSetWithExpectedSize((int)numColLabels);
        for (int i = 0; i < numColLabels; ++i) {
            SelectStmt selectStmt;
            List<SelectListItem> itemList;
            Expr selectItemExpr = this.queryStmt_.getResultExprs().get(i);
            String colAlias = this.getColLabels().get(i).toLowerCase();
            if (!uniqueColAliases.add(colAlias)) {
                throw new AnalysisException("duplicated inline view column alias: '" + colAlias + "' in inline view '" + this.getUniqueAlias() + "'");
            }
            boolean isHidden = false;
            if (this.queryStmt_ instanceof SelectStmt && (itemList = (selectStmt = (SelectStmt)this.queryStmt_).getSelectList().getItems()).size() == numColLabels) {
                isHidden = itemList.get(i).isHidden();
            }
            fields.add(new StructField(colAlias, selectItemExpr.getType(), null, isHidden));
        }
        TupleDescriptor result = analyzer.getDescTbl().createTupleDescriptor(this.getClass().getSimpleName() + " " + this.getUniqueAlias());
        result.setIsMaterialized(false);
        if (this.isTableMaskingView_ && (tblRef = this.getUnMaskedTableRef()) instanceof BaseTableRef) {
            BaseTableRef baseTbl = (BaseTableRef)tblRef;
            FeTable tbl = baseTbl.resolvedPath_.getRootTable();
            boolean exposeNestedColumn = false;
            for (Column col : tbl.getColumnsInHiveOrder()) {
                if (!col.getType().isComplexType()) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Add {} (type={}) to output type of table mask view", (Object)col.getName(), (Object)col.getType().toSql());
                }
                fields.add(new StructField(col.getName(), col.getType(), null));
                exposeNestedColumn = true;
            }
            if (exposeNestedColumn) {
                baseTbl.setExposeNestedColumnsByTableMaskView();
            }
            result.setMaskedTable(baseTbl);
        }
        result.setType(new StructType(Lists.newArrayList((Iterable)fields)));
        return result;
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter, Analyzer analyzer) throws AnalysisException {
        super.rewriteExprs(rewriter, analyzer);
        this.queryStmt_.rewriteExprs(rewriter);
    }

    @Override
    public List<TupleId> getMaterializedTupleIds() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        Preconditions.checkState((this.materializedTupleIds_.size() > 0 ? 1 : 0) != 0);
        return this.materializedTupleIds_;
    }

    public Analyzer getAnalyzer() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.inlineViewAnalyzer_;
    }

    public ExprSubstitutionMap getSmap() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.smap_;
    }

    public ExprSubstitutionMap getBaseTblSmap() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.baseTblSmap_;
    }

    public QueryStmt getViewStmt() {
        return this.queryStmt_;
    }

    public List<String> getExplicitColLabels() {
        return this.explicitColLabels_;
    }

    public List<String> getColLabels() {
        if (this.explicitColLabels_ != null) {
            return this.explicitColLabels_;
        }
        return this.queryStmt_.getColLabels();
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        return this.view_.getColumnsInHiveOrder();
    }

    public FeView getView() {
        return this.view_;
    }

    @Override
    public boolean isTableMaskingView() {
        return this.isTableMaskingView_;
    }

    public boolean isCatalogView() {
        return this.view_ != null && !this.view_.isLocalView();
    }

    public TableRef getUnMaskedTableRef() {
        Preconditions.checkState((boolean)this.isTableMaskingView_);
        Preconditions.checkState((boolean)(this.queryStmt_ instanceof SelectStmt));
        SelectStmt selectStmt = (SelectStmt)this.queryStmt_;
        Preconditions.checkNotNull((Object)selectStmt.fromClause_);
        Preconditions.checkState((selectStmt.fromClause_.size() > 0 ? 1 : 0) != 0);
        return selectStmt.fromClause_.get(0);
    }

    @Override
    protected TableRef clone() {
        return new InlineViewRef(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.queryStmt_.reset();
        this.inlineViewAnalyzer_ = null;
        this.materializedTupleIds_.clear();
        this.smap_.clear();
        this.baseTblSmap_.clear();
    }

    @Override
    protected String tableRefToSql(ToSqlOptions options) {
        String alias = this.getExplicitAlias();
        if (this.view_ != null) {
            return this.view_.getTableName().toSql() + ToSqlUtils.formatAlias(alias);
        }
        StringBuilder sql = new StringBuilder().append("(").append(this.queryStmt_.toSql(options)).append(")").append(ToSqlUtils.formatAlias(alias));
        if (this.explicitColLabels_ != null) {
            sql.append(" (");
            for (int i = 0; i < this.getExplicitColLabels().size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(ToSqlUtils.getIdentSql(this.getExplicitColLabels().get(i)));
            }
            sql.append(")");
        }
        return sql.toString();
    }

    public void setIsNonCorrelatedScalarSubquery() {
        this.isNonCorrelatedScalarSubquery_ = true;
    }

    public boolean isNonCorrelatedScalarSubquery() {
        return this.isNonCorrelatedScalarSubquery_;
    }
}

