/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.IcebergModifyImpl;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.IcebergBufferedDeleteSink;
import org.apache.impala.planner.MultiDataSink;
import org.apache.impala.planner.TableSink;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.IcebergUtil;

public class IcebergUpdateImpl
extends IcebergModifyImpl {
    private int deleteTableId_ = -1;
    private List<Expr> insertResultExprs_ = new ArrayList<Expr>();
    private List<Expr> insertPartitionKeyExprs_ = new ArrayList<Expr>();
    private List<Integer> sortColumns_ = new ArrayList<Integer>();
    private TSortingOrder sortingOrder_ = TSortingOrder.LEXICAL;

    public IcebergUpdateImpl(ModifyStmt modifyStmt) {
        super(modifyStmt);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.deleteTableId_ = analyzer.getDescTbl().addTargetTable(this.icePosDelTable_);
        IcebergUtil.validateIcebergTableForInsert(this.originalTargetTable_);
    }

    @Override
    protected void buildAndValidateSelectExprs(Analyzer analyzer, List<SelectListItem> selectList) throws AnalysisException {
        HashMap<Integer, Expr> colToExprs = new HashMap<Integer, Expr>();
        for (Pair<SlotRef, Expr> valueAssignment : this.modifyStmt_.assignments_) {
            SlotRef lhsSlotRef = (SlotRef)valueAssignment.first;
            lhsSlotRef.analyze(analyzer);
            Expr rhsExpr = (Expr)valueAssignment.second;
            this.checkSubQuery(lhsSlotRef, rhsExpr);
            rhsExpr.analyze(analyzer);
            this.checkCorrectTargetTable(lhsSlotRef, rhsExpr);
            this.checkLhsIsColumnRef(lhsSlotRef, rhsExpr);
            IcebergColumn c = (IcebergColumn)lhsSlotRef.getResolvedPath().destColumn();
            rhsExpr = this.checkTypeCompatiblity(analyzer, c, rhsExpr);
            if (IcebergUtil.isPartitionColumn(c, this.originalTargetTable_.getDefaultPartitionSpec()) && this.modifyStmt_.fromClause_ != null && this.modifyStmt_.fromClause_.size() > 1 && !rhsExpr.isConstant()) {
                throw new AnalysisException(String.format("Cannot UPDATE partitioning column '%s' via UPDATE FROM statement with multiple table refs, and when right-hand side '%s' is non-constant. ", lhsSlotRef.toSql(), rhsExpr.toSql()));
            }
            this.checkLhsOnlyAppearsOnce(colToExprs, c, lhsSlotRef, rhsExpr);
            colToExprs.put(c.getPosition(), rhsExpr);
        }
        List<Column> columns = this.modifyStmt_.table_.getColumns();
        for (Column col : columns) {
            Expr expr = (Expr)colToExprs.get(col.getPosition());
            if (expr == null) {
                expr = this.createSlotRef(analyzer, col.getName());
            }
            this.insertResultExprs_.add(expr);
        }
        IcebergUtil.populatePartitionExprs(analyzer, null, columns, this.insertResultExprs_, this.originalTargetTable_, this.insertPartitionKeyExprs_, null);
        this.deletePartitionKeyExprs_ = this.getDeletePartitionExprs(analyzer);
        this.deleteResultExprs_ = this.getDeleteResultExprs(analyzer);
        selectList.addAll(ExprUtil.exprsAsSelectList(this.insertResultExprs_));
        selectList.addAll(ExprUtil.exprsAsSelectList(this.insertPartitionKeyExprs_));
        selectList.addAll(ExprUtil.exprsAsSelectList(this.deleteResultExprs_));
        selectList.addAll(ExprUtil.exprsAsSelectList(this.deletePartitionKeyExprs_));
        this.addSortColumns();
    }

    private void addSortColumns() throws AnalysisException {
        Pair<List<Integer>, TSortingOrder> sortProperties = AlterTableSetTblProperties.analyzeSortColumns(this.originalTargetTable_, this.originalTargetTable_.getMetaStoreTable().getParameters());
        this.sortColumns_ = (List)sortProperties.first;
        this.sortingOrder_ = (TSortingOrder)((Object)sortProperties.second);
        for (Integer colIdx : this.sortColumns_) {
            this.sortExprs_.add(this.insertResultExprs_.get(colIdx));
        }
    }

    @Override
    public void addCastsToAssignmentsInSourceStmt(Analyzer analyzer) throws AnalysisException {
        List<Column> columns = this.modifyStmt_.table_.getColumns();
        for (int i = 0; i < this.insertResultExprs_.size(); ++i) {
            Column col = columns.get(i);
            Expr resultExpr = (Expr)this.sourceStmt_.resultExprs_.get(i);
            if (col.getType().equals(resultExpr.getType())) continue;
            Expr castTo = resultExpr.castTo(col.getType());
            this.sourceStmt_.resultExprs_.set(i, castTo);
        }
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.insertPartitionKeyExprs_;
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.sortingOrder_;
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        super.substituteResultExprs(smap, analyzer);
        this.insertResultExprs_ = Expr.substituteList(this.insertResultExprs_, smap, analyzer, true);
        this.insertPartitionKeyExprs_ = Expr.substituteList(this.insertPartitionKeyExprs_, smap, analyzer, true);
    }

    @Override
    public DataSink createDataSink() {
        Preconditions.checkState((boolean)(this.modifyStmt_.table_ instanceof FeIcebergTable));
        TableSink insertSink = TableSink.create(this.modifyStmt_.table_, TableSink.Op.INSERT, this.insertPartitionKeyExprs_, this.insertResultExprs_, Collections.emptyList(), false, false, new Pair<List<Integer>, TSortingOrder>(this.sortColumns_, this.sortingOrder_), -1L, null, this.modifyStmt_.maxTableSinks_);
        IcebergBufferedDeleteSink deleteSink = new IcebergBufferedDeleteSink(this.icePosDelTable_, this.deletePartitionKeyExprs_, this.deleteResultExprs_, this.deleteTableId_);
        MultiDataSink ret = new MultiDataSink();
        ret.addDataSink(insertSink);
        ret.addDataSink(deleteSink);
        return ret;
    }

    @Override
    String getModifyMode() {
        return "write.update.mode";
    }
}

