/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TIcebergPartitionTransform;
import org.apache.impala.thrift.TIcebergPartitionTransformType;

public class IcebergPartitionTransform
extends StmtNode {
    private TIcebergPartitionTransformType transformType_;
    private Integer transformParam_;

    public IcebergPartitionTransform(TIcebergPartitionTransformType transformType) {
        this(transformType, null);
    }

    public IcebergPartitionTransform(TIcebergPartitionTransformType transformType, Integer transformParam) {
        this.transformType_ = transformType;
        this.transformParam_ = transformParam;
    }

    public TIcebergPartitionTransformType getTransformType() {
        return this.transformType_;
    }

    public Integer getTransformParam() {
        return this.transformParam_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.transformType_ == TIcebergPartitionTransformType.BUCKET || this.transformType_ == TIcebergPartitionTransformType.TRUNCATE) {
            if (this.transformParam_ == null) {
                throw new AnalysisException("BUCKET and TRUNCATE partition transforms should have a parameter.");
            }
            if (this.transformParam_ <= 0) {
                throw new AnalysisException("The parameter of a partition transform should be greater than zero.");
            }
        } else if (this.transformParam_ != null) {
            throw new AnalysisException("Only BUCKET and TRUNCATE partition transforms accept a parameter.");
        }
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.transformType_.toString());
        if (this.transformParam_ != null) {
            builder.append("[").append(this.transformParam_).append("]");
        }
        return builder.toString();
    }

    public final String toSql(String colName) {
        return this.toSql(colName, ToSqlOptions.DEFAULT);
    }

    public String toSql(String colName, ToSqlOptions options) {
        StringBuilder builder = new StringBuilder();
        if (this.transformType_ != TIcebergPartitionTransformType.IDENTITY) {
            builder.append(this.transformType_.toString()).append("(");
            if (this.transformParam_ != null) {
                builder.append(this.transformParam_.toString()).append(", ");
            }
        }
        builder.append(colName);
        if (this.transformType_ != TIcebergPartitionTransformType.IDENTITY) {
            builder.append(")");
        }
        return builder.toString();
    }

    public TIcebergPartitionTransform toThrift() {
        TIcebergPartitionTransform transform = new TIcebergPartitionTransform();
        transform.setTransform_type(this.transformType_);
        if (this.transformParam_ != null) {
            transform.setTransform_param(this.transformParam_);
        }
        return transform;
    }
}

