/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TIcebergPartitionSpec;

public class IcebergPartitionSpec
extends StmtNode {
    private int specId_;
    private List<IcebergPartitionField> icebergPartitionFields_;

    public IcebergPartitionSpec(int partitionId, List<IcebergPartitionField> fields) {
        this.specId_ = partitionId;
        this.icebergPartitionFields_ = fields;
    }

    public IcebergPartitionSpec(List<IcebergPartitionField> fields) {
        this(0, fields);
    }

    public List<IcebergPartitionField> getIcebergPartitionFields() {
        return this.icebergPartitionFields_;
    }

    public boolean hasPartitionFields() {
        return this.icebergPartitionFields_ != null && !this.icebergPartitionFields_.isEmpty();
    }

    public int getSpecId() {
        return this.specId_;
    }

    public int getIcebergPartitionFieldsSize() {
        if (!this.hasPartitionFields()) {
            return 0;
        }
        return this.getIcebergPartitionFields().size();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!this.hasPartitionFields()) {
            return;
        }
        for (IcebergPartitionField field : this.icebergPartitionFields_) {
            field.analyze(analyzer);
        }
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.hasPartitionFields()) {
            builder.append("\n  ");
            ArrayList<String> fieldsSql = new ArrayList<String>();
            for (IcebergPartitionField field : this.icebergPartitionFields_) {
                fieldsSql.add(field.toSql());
            }
            builder.append(Joiner.on((String)",\n  ").join(fieldsSql));
        }
        builder.append("\n)");
        return builder.toString();
    }

    public TIcebergPartitionSpec toThrift() {
        TIcebergPartitionSpec result = new TIcebergPartitionSpec();
        result.setSpec_id(this.specId_);
        if (!this.hasPartitionFields()) {
            return result;
        }
        for (IcebergPartitionField field : this.icebergPartitionFields_) {
            result.addToPartition_fields(field.toThrift());
        }
        return result;
    }
}

