/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.PartitionSpec;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.IcebergPartitionExpr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.util.IcebergUtil;

class IcebergPartitionExpressionRewriter {
    private final Analyzer analyzer_;
    private final PartitionSpec partitionSpec_;

    public IcebergPartitionExpressionRewriter(Analyzer analyzer, PartitionSpec partitionSpec) {
        this.analyzer_ = analyzer;
        this.partitionSpec_ = partitionSpec;
    }

    public Expr rewrite(Expr expr) throws AnalysisException {
        if (expr instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)expr;
            return this.rewrite(binaryPredicate);
        }
        if (expr instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)expr;
            return this.rewrite(compoundPredicate);
        }
        if (expr instanceof SlotRef) {
            SlotRef slotRef = (SlotRef)expr;
            return this.rewrite(slotRef);
        }
        if (expr instanceof FunctionCallExpr) {
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)expr;
            return this.rewrite(functionCallExpr);
        }
        if (expr instanceof IsNullPredicate) {
            IsNullPredicate isNullPredicate = (IsNullPredicate)expr;
            return this.rewrite(isNullPredicate);
        }
        if (expr instanceof InPredicate) {
            InPredicate isNullPredicate = (InPredicate)expr;
            return this.rewrite(isNullPredicate);
        }
        throw new AnalysisException("Invalid partition filtering expression: " + expr.toSql());
    }

    private BinaryPredicate rewrite(BinaryPredicate binaryPredicate) throws AnalysisException {
        IcebergPartitionExpr partitionExpr;
        Expr term = (Expr)binaryPredicate.getChild(0);
        Expr literal = (Expr)binaryPredicate.getChild(1);
        if (term instanceof SlotRef) {
            partitionExpr = this.rewrite((SlotRef)term);
            binaryPredicate.getChildren().set(0, partitionExpr);
        } else if (term instanceof FunctionCallExpr) {
            partitionExpr = this.rewrite((FunctionCallExpr)term);
            binaryPredicate.getChildren().set(0, partitionExpr);
        } else {
            return binaryPredicate;
        }
        if (!(literal instanceof LiteralExpr)) {
            return binaryPredicate;
        }
        TIcebergPartitionTransformType transformType = partitionExpr.getTransform().getTransformType();
        if (!IcebergUtil.isDateTimeTransformType(transformType)) {
            return binaryPredicate;
        }
        this.rewriteDateTransformConstants((LiteralExpr)literal, transformType, numericLiteral -> binaryPredicate.getChildren().set(1, numericLiteral));
        return binaryPredicate;
    }

    private InPredicate rewrite(InPredicate inPredicate) throws AnalysisException {
        IcebergPartitionExpr partitionExpr;
        Expr term = (Expr)inPredicate.getChild(0);
        List literals = inPredicate.getChildren().subList(1, inPredicate.getChildCount());
        if (term instanceof SlotRef) {
            partitionExpr = this.rewrite((SlotRef)term);
            inPredicate.getChildren().set(0, partitionExpr);
        } else if (term instanceof FunctionCallExpr) {
            partitionExpr = this.rewrite((FunctionCallExpr)term);
            inPredicate.getChildren().set(0, partitionExpr);
        } else {
            return inPredicate;
        }
        TIcebergPartitionTransformType transformType = partitionExpr.getTransform().getTransformType();
        for (int i = 0; i < literals.size(); ++i) {
            if (!(literals.get(i) instanceof LiteralExpr)) {
                return inPredicate;
            }
            LiteralExpr literal = (LiteralExpr)literals.get(i);
            int affectedChildId = i + 1;
            if (!IcebergUtil.isDateTimeTransformType(transformType)) continue;
            this.rewriteDateTransformConstants(literal, transformType, numericLiteral -> inPredicate.getChildren().set(affectedChildId, numericLiteral));
        }
        return inPredicate;
    }

    private void rewriteDateTransformConstants(LiteralExpr literal, TIcebergPartitionTransformType transformType, Function<NumericLiteral, ?> rewrite) {
        Preconditions.checkState((boolean)IcebergUtil.isDateTimeTransformType(transformType));
        if (transformType.equals((Object)TIcebergPartitionTransformType.YEAR) && literal instanceof NumericLiteral) {
            NumericLiteral numericLiteral = (NumericLiteral)literal;
            long longValue = numericLiteral.getLongValue();
            long target = longValue + 1970L;
            this.analyzer_.addWarning(String.format("The YEAR transform expects years normalized to %d: %d is targeting year %d", 1970, longValue, target));
            return;
        }
        if (!(literal instanceof StringLiteral)) {
            return;
        }
        try {
            Integer dateTimeTransformValue = IcebergUtil.getDateTimeTransformValue(transformType, literal.getStringValue());
            rewrite.apply(NumericLiteral.create(dateTimeTransformValue.intValue()));
        }
        catch (ImpalaRuntimeException impalaRuntimeException) {
            // empty catch block
        }
    }

    private CompoundPredicate rewrite(CompoundPredicate compoundPredicate) throws AnalysisException {
        Expr left = (Expr)compoundPredicate.getChild(0);
        Expr right = (Expr)compoundPredicate.getChild(1);
        compoundPredicate.setChild(0, this.rewrite(left));
        compoundPredicate.setChild(1, this.rewrite(right));
        return compoundPredicate;
    }

    private IcebergPartitionExpr rewrite(SlotRef slotRef) {
        return new IcebergPartitionExpr(slotRef, this.partitionSpec_);
    }

    private IcebergPartitionExpr rewrite(FunctionCallExpr functionCallExpr) throws AnalysisException {
        return new IcebergPartitionExpr(functionCallExpr, this.partitionSpec_);
    }

    private IsNullPredicate rewrite(IsNullPredicate isNullPredicate) throws AnalysisException {
        Expr child = (Expr)isNullPredicate.getChild(0);
        if (child instanceof SlotRef) {
            isNullPredicate.getChildren().set(0, this.rewrite(child));
        }
        if (child instanceof FunctionCallExpr) {
            isNullPredicate.getChildren().set(0, new IcebergPartitionExpr((FunctionCallExpr)child, this.partitionSpec_));
        }
        return isNullPredicate;
    }
}

