/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.transforms.Transforms;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.analysis.IcebergPartitionTransform;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.util.IcebergUtil;

public class IcebergPartitionExpr
extends Expr {
    private final IcebergPartitionTransform transform_;
    private final SlotRef slotRef_;
    private final PartitionSpec partitionSpec_;

    public IcebergPartitionExpr(SlotRef slotRef, PartitionSpec partitionSpec) {
        this(new IcebergPartitionTransform(TIcebergPartitionTransformType.IDENTITY), slotRef, partitionSpec);
    }

    protected IcebergPartitionExpr(IcebergPartitionTransform transform, SlotRef slotRef, PartitionSpec partitionSpec) {
        this.transform_ = transform;
        this.slotRef_ = slotRef;
        this.partitionSpec_ = partitionSpec;
    }

    public IcebergPartitionExpr(FunctionCallExpr callExpr, PartitionSpec partitionSpec) throws AnalysisException {
        Expr slotRefExpr;
        this.partitionSpec_ = partitionSpec;
        FunctionParams params = callExpr.getParams();
        if (params.size() > 2 && params.size() < 1) {
            throw new AnalysisException("Invalid partition predicate: " + callExpr.toSql());
        }
        Optional<Object> transformParam = Optional.empty();
        if (params.size() == 1) {
            slotRefExpr = params.exprs().get(0);
        } else {
            Expr transformParamExpr = params.exprs().get(0);
            slotRefExpr = params.exprs().get(1);
            if (!(transformParamExpr instanceof LiteralExpr)) {
                throw new AnalysisException("Invalid transform parameter: " + transformParamExpr);
            }
            LiteralExpr literal = (LiteralExpr)transformParamExpr;
            String stringValue = literal.getStringValue();
            try {
                int parsedInt = Integer.parseInt(stringValue);
                transformParam = Optional.of(parsedInt);
            }
            catch (NumberFormatException e) {
                throw new AnalysisException("Invalid transform parameter value: " + stringValue);
            }
        }
        if (!(slotRefExpr instanceof SlotRef)) {
            throw new AnalysisException("Invalid partition predicate: " + callExpr.toSql());
        }
        String functionName = callExpr.getFnName().getFunction();
        if (functionName == null) {
            List<String> fnNamePath = callExpr.getFnName().getFnNamePath();
            if (fnNamePath.size() > 1) {
                throw new AnalysisException("Invalid partition transform: " + fnNamePath);
            }
            functionName = fnNamePath.get(0);
        }
        String transformString = functionName.toUpperCase();
        this.slotRef_ = (SlotRef)slotRefExpr;
        try {
            this.transform_ = transformParam.isPresent() ? IcebergUtil.getPartitionTransform(transformString, (Integer)transformParam.get()) : IcebergUtil.getPartitionTransform(transformString);
        }
        catch (ImpalaRuntimeException e) {
            throw new AnalysisException(e.getMessage());
        }
        if (this.transform_.getTransformType().equals((Object)TIcebergPartitionTransformType.VOID)) {
            throw new AnalysisException("VOID transform is not supported for partition selection");
        }
    }

    public SlotRef getSlotRef() {
        return this.slotRef_;
    }

    public IcebergPartitionTransform getTransform() {
        return this.transform_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.slotRef_.analyze(analyzer);
        this.transform_.analyze(analyzer);
        SlotDescriptor desc = this.slotRef_.getDesc();
        IcebergColumn icebergColumn = (IcebergColumn)desc.getColumn();
        List partitionFields = this.partitionSpec_.getFieldsBySourceId(icebergColumn.getFieldId());
        partitionFields = partitionFields.stream().filter(partitionField -> !partitionField.transform().equals(Transforms.alwaysNull())).collect(Collectors.toList());
        if (partitionFields.isEmpty()) {
            throw new AnalysisException("Partition exprs cannot contain non-partition column(s): " + this.toSql());
        }
        TIcebergPartitionTransformType transformType = this.transform_.getTransformType();
        if (!transformType.equals((Object)TIcebergPartitionTransformType.IDENTITY)) {
            for (PartitionField field : partitionFields) {
                TIcebergPartitionTransformType transformTypeFromSpec;
                try {
                    transformTypeFromSpec = IcebergUtil.getPartitionTransformType(field.transform().toString());
                }
                catch (ImpalaRuntimeException e) {
                    throw new AnalysisException(e.getCause());
                }
                if (transformTypeFromSpec.equals((Object)transformType)) continue;
                throw new AnalysisException(String.format("Can't filter column '%s' with transform type: '%s'", new Object[]{this.slotRef_.toSql(), transformType}));
            }
        }
        if (transformType.equals((Object)TIcebergPartitionTransformType.TRUNCATE) || transformType.equals((Object)TIcebergPartitionTransformType.IDENTITY)) {
            this.type_ = this.slotRef_.type_;
        }
        if (transformType.equals((Object)TIcebergPartitionTransformType.YEAR) || transformType.equals((Object)TIcebergPartitionTransformType.BUCKET) || transformType.equals((Object)TIcebergPartitionTransformType.MONTH) || transformType.equals((Object)TIcebergPartitionTransformType.DAY) || transformType.equals((Object)TIcebergPartitionTransformType.HOUR)) {
            this.type_ = Type.INT;
        }
    }

    @Override
    protected float computeEvalCost() {
        return -1.0f;
    }

    @Override
    protected String toSqlImpl(ToSqlOptions options) {
        return this.transform_.toSql(this.slotRef_.toSql());
    }

    @Override
    protected void toThrift(TExprNode msg) {
    }

    @Override
    public Expr clone() {
        return new IcebergPartitionExpr(this.transform_, this.slotRef_, this.partitionSpec_);
    }
}

