/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.AnalysisException;

public class IcebergMetadataTableRef
extends TableRef {
    private String metadataTableName_;

    public IcebergMetadataTableRef(TableRef tableRef, Path resolvedPath) {
        super(tableRef);
        Preconditions.checkState((boolean)resolvedPath.isResolved());
        Preconditions.checkState((boolean)resolvedPath.isRootedAtTable());
        Preconditions.checkState((boolean)(resolvedPath.getRootTable() instanceof IcebergMetadataTable));
        this.resolvedPath_ = resolvedPath;
        IcebergMetadataTable iceMTbl = (IcebergMetadataTable)resolvedPath.getRootTable();
        FeIcebergTable iceTbl = iceMTbl.getBaseTable();
        this.metadataTableName_ = iceMTbl.getMetadataTableName();
        if (this.hasExplicitAlias()) {
            return;
        }
        this.aliases_ = new String[]{iceTbl.getTableName().toString().toLowerCase(), iceTbl.getName().toLowerCase()};
    }

    public String getMetadataTableName() {
        return this.metadataTableName_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        IcebergMetadataTable rootTable = (IcebergMetadataTable)this.resolvedPath_.getRootTable();
        FeIcebergTable iceRootTable = rootTable.getBaseTable();
        analyzer.registerAuthAndAuditEvent(iceRootTable, this.priv_, this.requireGrantOption_);
        this.analyzeTimeTravel(analyzer);
        this.desc_ = analyzer.registerTableRef(this);
        this.isAnalyzed_ = true;
        this.analyzeHints(analyzer);
        this.analyzeJoin(analyzer);
    }
}

