/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.IcebergModifyImpl;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.IcebergBufferedDeleteSink;
import org.apache.impala.util.ExprUtil;

public class IcebergDeleteImpl
extends IcebergModifyImpl {
    public IcebergDeleteImpl(ModifyStmt modifyStmt) {
        super(modifyStmt);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.modifyStmt_.setTargetTable(this.icePosDelTable_);
        Expr wherePredicate = this.modifyStmt_.getWherePredicate();
        if (wherePredicate == null || Expr.IS_TRUE_LITERAL.apply((Object)wherePredicate)) {
            throw new AnalysisException("For deleting every row, please use TRUNCATE.");
        }
    }

    @Override
    protected void buildAndValidateSelectExprs(Analyzer analyzer, List<SelectListItem> selectList) throws AnalysisException {
        this.deletePartitionKeyExprs_ = this.getDeletePartitionExprs(analyzer);
        this.deleteResultExprs_ = this.getDeleteResultExprs(analyzer);
        selectList.addAll(ExprUtil.exprsAsSelectList(this.deletePartitionKeyExprs_));
        selectList.addAll(ExprUtil.exprsAsSelectList(this.deleteResultExprs_));
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.deletePartitionKeyExprs_;
    }

    @Override
    public void addCastsToAssignmentsInSourceStmt(Analyzer analyzer) throws AnalysisException {
    }

    @Override
    public DataSink createDataSink() {
        Preconditions.checkState((boolean)(this.modifyStmt_.table_ instanceof FeIcebergTable));
        return new IcebergBufferedDeleteSink(this.icePosDelTable_, this.deletePartitionKeyExprs_, (List<Expr>)this.deleteResultExprs_);
    }

    @Override
    String getModifyMode() {
        return "write.delete.mode";
    }
}

