/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.util.FsPermissionChecker;

public class HdfsUri {
    private final String location_;
    private Path uriPath_;

    public HdfsUri(String location) {
        Preconditions.checkNotNull((Object)location);
        this.location_ = location.trim();
    }

    public Path getPath() {
        Preconditions.checkNotNull((Object)this.uriPath_);
        return this.uriPath_;
    }

    public void analyze(Analyzer analyzer, Privilege privilege) throws AnalysisException {
        this.analyze(analyzer, privilege, FsAction.NONE, true, false);
    }

    public void analyze(Analyzer analyzer, Privilege privilege, FsAction perm) throws AnalysisException {
        this.analyze(analyzer, privilege, perm, true, false);
    }

    public void analyze(Analyzer analyzer, Privilege privilege, boolean registerPrivReq) throws AnalysisException {
        this.analyze(analyzer, privilege, FsAction.NONE, registerPrivReq, false);
    }

    public void analyze(Analyzer analyzer, Privilege privilege, FsAction perm, boolean registerPrivReq, boolean pathMustExist) throws AnalysisException {
        if (this.location_.isEmpty()) {
            throw new AnalysisException("URI path cannot be empty.");
        }
        this.uriPath_ = new Path(this.location_);
        if (!this.uriPath_.isUriPathAbsolute()) {
            throw new AnalysisException("URI path must be absolute: " + this.uriPath_);
        }
        this.uriPath_ = FileSystemUtil.createFullyQualifiedPath(this.uriPath_);
        Path parentPath = this.uriPath_.getParent();
        try {
            FsPermissionChecker checker;
            FileSystem fs = this.uriPath_.getFileSystem(FileSystemUtil.getConfiguration());
            if (pathMustExist && !fs.exists(this.uriPath_)) {
                throw new AnalysisException(String.format("Path does not exist: %s", this.uriPath_));
            }
            boolean parentPathExists = false;
            StringBuilder errorMsg = new StringBuilder();
            try {
                parentPathExists = fs.exists(parentPath);
                if (!parentPathExists) {
                    errorMsg.append("Path does not exist.");
                }
            }
            catch (Exception e) {
                errorMsg.append(e.getMessage());
            }
            if (!parentPathExists) {
                analyzer.addWarning(String.format("Path '%s' cannot be reached: %s", parentPath, errorMsg.toString()));
            } else if (perm != FsAction.NONE && !(checker = FsPermissionChecker.getInstance()).getPermissions(fs, parentPath).checkPermissions(perm)) {
                analyzer.addWarning(String.format("Impala does not have %s access to path '%s'", perm.toString(), parentPath));
            }
        }
        catch (IOException e) {
            throw new AnalysisException(e.getMessage(), e);
        }
        if (registerPrivReq) {
            analyzer.registerPrivReq(builder -> builder.onUri(this.uriPath_.toString()).allOf(privilege).build());
        }
    }

    public String toString() {
        return this.uriPath_ == null ? this.location_ : this.uriPath_.toString();
    }

    public String getLocation() {
        return this.location_;
    }
}

