/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.THdfsCachingOp;

public class HdfsCachingOp
extends StmtNode {
    private final THdfsCachingOp cacheOp_;
    private final BigDecimal parsedReplication_;

    public HdfsCachingOp() {
        this.cacheOp_ = new THdfsCachingOp(false);
        this.parsedReplication_ = null;
    }

    public HdfsCachingOp(String cachePoolName, BigDecimal replication) {
        this.cacheOp_ = new THdfsCachingOp(true);
        this.cacheOp_.setCache_pool_name(cachePoolName);
        this.parsedReplication_ = replication;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.cacheOp_.isSet_cached()) {
            String poolName = this.cacheOp_.getCache_pool_name();
            Preconditions.checkNotNull((Object)poolName);
            if (poolName.isEmpty()) {
                throw new AnalysisException("Cache pool name cannot be empty.");
            }
            HdfsCachePool cachePool = analyzer.getCatalog().getHdfsCachePool(poolName);
            if (cachePool == null) {
                throw new AnalysisException("The specified cache pool does not exist: " + poolName);
            }
            if (this.parsedReplication_ != null && (this.parsedReplication_.longValue() <= 0L || this.parsedReplication_.longValue() > 32767L)) {
                throw new AnalysisException("Cache replication factor must be between 0 and Short.MAX_VALUE");
            }
            if (this.parsedReplication_ != null) {
                this.cacheOp_.setReplication(this.parsedReplication_.shortValue());
            }
        }
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (!this.shouldCache()) {
            return "UNCACHED";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CACHED IN '" + this.getCachePoolName() + "'");
        if (this.parsedReplication_ != null) {
            sb.append(" WITH REPLICATION = " + this.parsedReplication_.longValue());
        }
        return sb.toString();
    }

    public THdfsCachingOp toThrift() {
        return this.cacheOp_;
    }

    public boolean shouldCache() {
        return this.cacheOp_.isSet_cached();
    }

    public String getCachePoolName() {
        return this.shouldCache() ? this.cacheOp_.getCache_pool_name() : null;
    }
}

