/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByClause {
    private static final Logger LOG = LoggerFactory.getLogger(GroupByClause.class);
    private static final int GROUPING_SET_LIMIT = 64;
    private final List<Expr> origGroupingExprs_;
    private final GroupingSetsType groupingSetsType_;
    private final List<List<Integer>> groupingSetsList_;
    boolean isAnalyzed_ = false;
    private final List<Long> groupingIDs_;
    private final List<List<Expr>> analyzedGroupingSets_;

    GroupByClause(List<Expr> groupingExprs, GroupingSetsType groupingSetsType) {
        Preconditions.checkNotNull((Object)((Object)groupingSetsType));
        Preconditions.checkState((groupingSetsType != GroupingSetsType.SETS ? 1 : 0) != 0);
        this.origGroupingExprs_ = groupingExprs;
        this.groupingSetsType_ = groupingSetsType;
        this.groupingSetsList_ = null;
        this.groupingIDs_ = new ArrayList<Long>();
        this.analyzedGroupingSets_ = new ArrayList<List<Expr>>();
    }

    GroupByClause(List<List<Expr>> groupingSetsList) {
        this.groupingSetsType_ = GroupingSetsType.SETS;
        this.groupingIDs_ = new ArrayList<Long>();
        this.groupingSetsList_ = new ArrayList<List<Integer>>();
        this.analyzedGroupingSets_ = new ArrayList<List<Expr>>();
        this.origGroupingExprs_ = new ArrayList<Expr>();
        for (List<Expr> groupingSetExprs : groupingSetsList) {
            ArrayList<Integer> exprIndices = new ArrayList<Integer>();
            this.groupingSetsList_.add(exprIndices);
            for (Expr e : groupingSetExprs) {
                int idx = this.origGroupingExprs_.indexOf(e);
                if (idx < 0) {
                    idx = this.origGroupingExprs_.size();
                    this.origGroupingExprs_.add(e);
                }
                exprIndices.add(idx);
            }
        }
    }

    GroupByClause(List<Expr> groupingExprs, List<List<Integer>> groupingSetsList) {
        this.groupingSetsType_ = GroupingSetsType.SETS;
        this.groupingIDs_ = new ArrayList<Long>();
        this.groupingSetsList_ = groupingSetsList;
        this.origGroupingExprs_ = groupingExprs;
        this.analyzedGroupingSets_ = new ArrayList<List<Expr>>();
    }

    public List<Expr> getOrigGroupingExprs() {
        return this.origGroupingExprs_;
    }

    public List<List<Expr>> getAnalyzedGroupingSets() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.analyzedGroupingSets_;
    }

    private void addGroupingID(long id, List<Expr> groupingExprs, List<Expr> addtlGroupingExprs) throws AnalysisException {
        Preconditions.checkState((id >= 0L && id < 1L << groupingExprs.size() ? 1 : 0) != 0, (Object)("bad id: " + id));
        if (this.groupingIDs_.contains(id)) {
            return;
        }
        if (this.groupingIDs_.size() >= 64) {
            throw new AnalysisException("Limit of 64 grouping sets exceeded");
        }
        this.groupingIDs_.add(id);
        ArrayList<Expr> groupingSet = new ArrayList<Expr>();
        for (int i = 0; i < groupingExprs.size(); ++i) {
            Expr groupingExpr = groupingExprs.get(i);
            if ((id & 1L << i) != 0L) {
                groupingSet.add(groupingExpr);
                continue;
            }
            groupingSet.add(NullLiteral.create(groupingExpr.getType()));
        }
        groupingSet.addAll(addtlGroupingExprs);
        this.analyzedGroupingSets_.add(groupingSet);
    }

    public boolean hasGroupingSets() {
        Preconditions.checkState((this.groupingSetsType_ != null ? 1 : 0) != 0);
        return this.groupingSetsType_ != GroupingSetsType.NONE;
    }

    public String getTypeString() {
        return this.hasGroupingSets() ? this.groupingSetsType_.toString() : "";
    }

    public GroupByClause clone() {
        List<Expr> groupingExprsClone = Expr.cloneList(this.origGroupingExprs_);
        if (this.groupingSetsType_ == GroupingSetsType.SETS) {
            return new GroupByClause(groupingExprsClone, this.groupingSetsList_);
        }
        return new GroupByClause(groupingExprsClone, this.groupingSetsType_);
    }

    public void analyzeGroupingSets(List<Expr> groupingExprs) throws AnalysisException {
        Preconditions.checkState((boolean)this.hasGroupingSets());
        Preconditions.checkState((groupingExprs.size() >= this.origGroupingExprs_.size() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.groupingIDs_.isEmpty());
        Preconditions.checkState((boolean)this.analyzedGroupingSets_.isEmpty());
        int numOrigGroupingExprs = this.origGroupingExprs_.size();
        HashMap<Integer, Integer> firstEquivExpr = new HashMap<Integer, Integer>();
        ArrayList<Expr> dedupedGroupingSetExprs = new ArrayList<Expr>();
        for (int i = 0; i < numOrigGroupingExprs; ++i) {
            int j = dedupedGroupingSetExprs.indexOf(groupingExprs.get(i));
            if (j == -1) {
                firstEquivExpr.put(i, dedupedGroupingSetExprs.size());
                dedupedGroupingSetExprs.add(groupingExprs.get(i));
                continue;
            }
            firstEquivExpr.put(i, j);
        }
        List<Expr> addtlGroupingExprs = groupingExprs.subList(numOrigGroupingExprs, groupingExprs.size());
        Expr.removeDuplicates(addtlGroupingExprs);
        int numGroupingSetExprs = dedupedGroupingSetExprs.size();
        if (numGroupingSetExprs >= 63) {
            throw new AnalysisException("Number of grouping columns (" + numGroupingSetExprs + ") exceeds GROUP BY with " + this.getTypeString() + " limit of " + 63);
        }
        if (this.groupingSetsType_ == GroupingSetsType.CUBE) {
            for (long id = (1L << numGroupingSetExprs) - 1L; id >= 0L; --id) {
                this.addGroupingID(id, dedupedGroupingSetExprs, addtlGroupingExprs);
            }
        } else if (this.groupingSetsType_ == GroupingSetsType.ROLLUP) {
            Preconditions.checkState((numGroupingSetExprs > 0 ? 1 : 0) != 0);
            long bit = 1L << numGroupingSetExprs;
            long id = bit - 1L;
            while (bit != 0L) {
                this.addGroupingID(id, dedupedGroupingSetExprs, addtlGroupingExprs);
                id &= (bit >>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            Preconditions.checkState((id == 0L ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((this.groupingSetsType_ == GroupingSetsType.SETS ? 1 : 0) != 0);
            for (List<Integer> set : this.groupingSetsList_) {
                long mask = 0L;
                for (int origPos : set) {
                    Preconditions.checkState((origPos >= 0 ? 1 : 0) != 0, (Object)("bad pos" + origPos));
                    Preconditions.checkState((origPos < numOrigGroupingExprs ? 1 : 0) != 0, (Object)("bad pos " + origPos));
                    int dedupedPos = (Integer)firstEquivExpr.get(origPos);
                    Preconditions.checkState((dedupedPos >= 0 ? 1 : 0) != 0, (Object)("bad pos" + dedupedPos));
                    Preconditions.checkState((dedupedPos < numGroupingSetExprs ? 1 : 0) != 0, (Object)("bad pos" + dedupedPos));
                    mask |= 1L << dedupedPos;
                }
                this.addGroupingID(mask, dedupedGroupingSetExprs, addtlGroupingExprs);
            }
        }
        this.isAnalyzed_ = true;
    }

    void reset() {
        this.groupingIDs_.clear();
        this.analyzedGroupingSets_.clear();
        this.isAnalyzed_ = false;
    }

    public String toSql(List<Expr> groupingExprs, ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append(" GROUP BY ");
        if (this.groupingSetsType_ == GroupingSetsType.NONE) {
            sb.append(Expr.toSql(groupingExprs, options));
        } else if (this.groupingSetsType_ == GroupingSetsType.CUBE) {
            sb.append("CUBE(");
            sb.append(Expr.toSql(this.origGroupingExprs_, options));
            sb.append(")");
        } else if (this.groupingSetsType_ == GroupingSetsType.ROLLUP) {
            sb.append("ROLLUP(");
            sb.append(Expr.toSql(this.origGroupingExprs_, options));
            sb.append(")");
        } else {
            Preconditions.checkState((this.groupingSetsType_ == GroupingSetsType.SETS ? 1 : 0) != 0);
            sb.append("GROUPING SETS(");
            for (int i = 0; i < this.groupingSetsList_.size(); ++i) {
                sb.append("(");
                ArrayList<Expr> groupingSetExprs = new ArrayList<Expr>();
                for (int exprIdx : this.groupingSetsList_.get(i)) {
                    groupingSetExprs.add(this.origGroupingExprs_.get(exprIdx));
                }
                sb.append(Expr.toSql(groupingSetExprs, options));
                sb.append(")");
                sb.append(i < this.groupingSetsList_.size() - 1 ? ", " : "");
            }
            sb.append(")");
            if (groupingExprs.size() > this.origGroupingExprs_.size()) {
                sb.append(", ");
                sb.append(Expr.toSql(groupingExprs.subList(this.origGroupingExprs_.size(), groupingExprs.size()), options));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql(this.origGroupingExprs_, ToSqlOptions.DEFAULT);
    }

    public String debugString() {
        return this.toSql(this.origGroupingExprs_, ToSqlOptions.SHOW_IMPLICIT_CASTS);
    }

    public static enum GroupingSetsType {
        NONE,
        CUBE,
        SETS,
        ROLLUP;

    }
}

