/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AuthorizationStmt;
import org.apache.impala.analysis.PrivilegeSpec;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TGrantRevokePrivParams;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TPrivilege;

public class GrantRevokePrivStmt
extends AuthorizationStmt {
    private final PrivilegeSpec privilegeSpec_;
    private final String principalName_;
    private final boolean isGrantPrivStmt_;
    private final boolean hasGrantOpt_;
    private final TPrincipalType principalType_;

    public GrantRevokePrivStmt(String roleName, PrivilegeSpec privilegeSpec, boolean isGrantPrivStmt, boolean hasGrantOpt, TPrincipalType principalType) {
        Preconditions.checkNotNull((Object)privilegeSpec);
        Preconditions.checkNotNull((Object)roleName);
        this.privilegeSpec_ = privilegeSpec;
        this.principalName_ = roleName;
        this.isGrantPrivStmt_ = isGrantPrivStmt;
        this.hasGrantOpt_ = hasGrantOpt;
        this.principalType_ = principalType;
    }

    public TGrantRevokePrivParams toThrift() {
        TGrantRevokePrivParams params = new TGrantRevokePrivParams();
        params.setPrincipal_name(this.principalName_);
        params.setIs_grant(this.isGrantPrivStmt_);
        List<TPrivilege> privileges = this.privilegeSpec_.toThrift();
        for (TPrivilege privilege : privileges) {
            privilege.setPrincipal_type(this.principalType_);
            privilege.setHas_grant_opt(this.hasGrantOpt_);
        }
        params.setPrincipal_type(this.principalType_);
        params.setHas_grant_opt(this.hasGrantOpt_);
        params.setPrivileges(privileges);
        String ownerName = this.privilegeSpec_.getOwnerName();
        if (ownerName != null) {
            params.setOwner_name(ownerName);
        }
        return params;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder(this.isGrantPrivStmt_ ? "GRANT " : "REVOKE ");
        if (!this.isGrantPrivStmt_ && this.hasGrantOpt_) {
            sb.append("GRANT OPTION FOR ");
        }
        sb.append(this.privilegeSpec_.toSql(options));
        sb.append(this.isGrantPrivStmt_ ? " TO " : " FROM ");
        sb.append((Object)this.principalType_);
        sb.append(" ");
        sb.append(this.principalName_);
        if (this.isGrantPrivStmt_ && this.hasGrantOpt_) {
            sb.append(" WITH GRANT OPTION");
        }
        return sb.toString();
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        if (this.privilegeSpec_ != null) {
            this.privilegeSpec_.collectTableRefs(tblRefs);
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.principalName_)) {
            throw new AnalysisException("Principal name in GRANT/REVOKE privilege cannot be empty.");
        }
        this.privilegeSpec_.analyze(analyzer);
    }
}

