/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TFunctionName;

public class FunctionName {
    private final List<String> fnNamePath_;
    private String db_;
    private String fn_;
    private boolean isBuiltin_ = false;
    private boolean isAnalyzed_ = false;

    public FunctionName(List<String> fnNamePath) {
        this.fnNamePath_ = fnNamePath;
    }

    public FunctionName(String dbName, String fn) {
        this.db_ = dbName != null ? dbName.toLowerCase() : null;
        this.fn_ = fn.toLowerCase();
        this.fnNamePath_ = null;
    }

    public FunctionName(String fn) {
        this(null, fn);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionName)) {
            return false;
        }
        FunctionName o = (FunctionName)obj;
        if ((this.db_ == null || o.db_ == null) && this.db_ != o.db_) {
            if (this.db_ == null && o.db_ != null) {
                return false;
            }
            if (this.db_ != null && o.db_ == null) {
                return false;
            }
            if (!this.db_.equalsIgnoreCase(o.db_)) {
                return false;
            }
        }
        return this.fn_.equalsIgnoreCase(o.fn_);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.db_.toLowerCase(), this.fn_.toLowerCase());
    }

    public String getDb() {
        return this.db_;
    }

    public void setDb(String db) {
        this.db_ = db;
    }

    public String getFunction() {
        return this.fn_;
    }

    public void setFunction(String fn) {
        this.fn_ = fn;
    }

    public boolean isFullyQualified() {
        return this.db_ != null;
    }

    public boolean isBuiltin() {
        return this.isBuiltin_;
    }

    public List<String> getFnNamePath() {
        return this.fnNamePath_;
    }

    public String toString() {
        if (!this.isAnalyzed_ && this.fnNamePath_ != null) {
            return Joiner.on((String)".").join(this.fnNamePath_);
        }
        if (this.db_ == null || this.isBuiltin_) {
            return this.fn_;
        }
        return this.db_ + "." + this.fn_;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.analyze(analyzer, true);
    }

    public void analyze(Analyzer analyzer, boolean preferBuiltinsDb) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        this.analyzeFnNamePath();
        if (this.fn_.isEmpty()) {
            throw new AnalysisException("Function name cannot be empty.");
        }
        for (int i = 0; i < this.fn_.length(); ++i) {
            if (this.isValidCharacter(this.fn_.charAt(i))) continue;
            throw new AnalysisException("Function names must be all alphanumeric or underscore. Invalid name: " + this.fn_);
        }
        if (Character.isDigit(this.fn_.charAt(0))) {
            throw new AnalysisException("Function cannot start with a digit: " + this.fn_);
        }
        Db builtinDb = BuiltinsDb.getInstance();
        if (!this.isFullyQualified()) {
            this.db_ = preferBuiltinsDb && builtinDb.containsFunction(this.fn_) ? "_impala_builtins" : (preferBuiltinsDb && this.fallbackDbContainsFn(analyzer) ? analyzer.getFallbackDbForFunctions() : analyzer.getDefaultDb());
        }
        Preconditions.checkNotNull((Object)this.db_);
        this.isBuiltin_ = this.db_.equals("_impala_builtins") && builtinDb.containsFunction(this.fn_);
        this.isAnalyzed_ = true;
    }

    private boolean fallbackDbContainsFn(Analyzer analyzer) throws AnalysisException {
        String dbName = analyzer.getFallbackDbForFunctions();
        if (StringUtils.isEmpty((String)dbName)) {
            return false;
        }
        analyzer.registerPrivReq(builder -> builder.allOf(Privilege.SELECT).onFunction(dbName, this.getFunction()).build());
        FeDb feDb = analyzer.getDb(dbName, Privilege.VIEW_METADATA, false);
        return feDb != null && feDb.containsFunction(this.fn_);
    }

    private void analyzeFnNamePath() throws AnalysisException {
        if (this.fnNamePath_ == null) {
            return;
        }
        if (this.fnNamePath_.size() > 2 || this.fnNamePath_.isEmpty()) {
            throw new AnalysisException(String.format("Invalid function name: '%s'. Expected [dbname].funcname.", Joiner.on((String)".").join(this.fnNamePath_)));
        }
        if (this.fnNamePath_.size() > 1) {
            this.db_ = this.fnNamePath_.get(0).toLowerCase();
            this.fn_ = this.fnNamePath_.get(1).toLowerCase();
        } else {
            Preconditions.checkState((this.fnNamePath_.size() == 1 ? 1 : 0) != 0);
            this.fn_ = this.fnNamePath_.get(0).toLowerCase();
        }
    }

    private boolean isValidCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public TFunctionName toThrift() {
        TFunctionName name = new TFunctionName(this.fn_);
        name.setDb_name(this.db_);
        return name;
    }

    public static FunctionName fromThrift(TFunctionName fnName) {
        return new FunctionName(fnName.getDb_name(), fnName.getFunction_name());
    }

    public static String thriftToString(TFunctionName fnName) {
        return FunctionName.fromThrift(fnName).toString();
    }
}

