/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.TreeNode;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.thrift.TAggregateExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionCallExpr
extends Expr {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionCallExpr.class);
    private final FunctionName fnName_;
    private final FunctionParams params_;
    private boolean isAnalyticFnCall_ = false;
    private boolean isInternalFnCall_ = false;
    protected Optional<Boolean> shouldConvertToCNF_ = Optional.empty();
    private static Set<String> builtinMathScalarFunctionNames_ = new HashSet<String>(Arrays.asList("abs", "acos", "asin", "atan", "atan2", "bin", "ceil", "ceiling", "conv", "cos", "cosh", "cot", "dceil", "degrees", "dexp", "dfloor", "dlog1", "dlog10", "dpow", "dround", "dsqrt", "dtrunc", "e", "exp", "floor", "fmod", "fpow", "hex", "ln", "log", "log10", "log2", "mod", "pi", "pmod", "pow", "power", "quotient", "radians", "rand", "random", "round", "sign", "sin", "sinh", "sqrt", "tan", "tanh", "trunc", "truncate", "unhex"));
    private FunctionCallExpr mergeAggInputFn_;
    private String label_;

    public FunctionCallExpr(String functionName, List<Expr> params) {
        this(new FunctionName(functionName), new FunctionParams(false, params));
    }

    public FunctionCallExpr(FunctionName fnName, List<Expr> params) {
        this(fnName, new FunctionParams(false, params));
    }

    public FunctionCallExpr(FunctionName fnName, FunctionParams params) {
        this(fnName, params, null);
    }

    private FunctionCallExpr(FunctionName fnName, FunctionParams params, FunctionCallExpr mergeAggInputFn) {
        this.fnName_ = fnName;
        this.params_ = params;
        FunctionCallExpr functionCallExpr = this.mergeAggInputFn_ = mergeAggInputFn == null ? null : (FunctionCallExpr)mergeAggInputFn.clone();
        if (params.exprs() != null) {
            this.children_ = Lists.newArrayList(this.params_.exprs());
        }
    }

    public static Expr createExpr(FunctionName fnName, FunctionParams params, TQueryOptions options) {
        FunctionCallExpr functionCallExpr = new FunctionCallExpr(fnName, params);
        if (FunctionCallExpr.functionNameEqualsBuiltin(fnName, "decode")) {
            return new CaseExpr(functionCallExpr);
        }
        if (FunctionCallExpr.functionNameEqualsBuiltin(fnName, "nvl2")) {
            ArrayList plist = Lists.newArrayList(params.exprs());
            if (!plist.isEmpty()) {
                plist.set(0, new IsNullPredicate((Expr)plist.get(0), true));
            }
            return new FunctionCallExpr("if", (List<Expr>)plist);
        }
        if (FunctionCallExpr.functionNameEqualsBuiltin(fnName, "nullif") && params.size() == 2) {
            return new FunctionCallExpr("if", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{new BinaryPredicate(BinaryPredicate.Operator.DISTINCT_FROM, params.exprs().get(0), params.exprs().get(1)), params.exprs().get(0), new NullLiteral()}));
        }
        Preconditions.checkArgument((options != null ? 1 : 0) != 0);
        if (options.isDecimal_v2() && FunctionCallExpr.functionNameEqualsBuiltin(fnName, "mod")) {
            ArrayList plist = Lists.newArrayList(params.exprs());
            Preconditions.checkArgument((plist.size() == 2 ? 1 : 0) != 0);
            return new ArithmeticExpr(ArithmeticExpr.Operator.MOD, (Expr)plist.get(0), (Expr)plist.get(1));
        }
        return functionCallExpr;
    }

    private static boolean functionNameEqualsBuiltin(FunctionName fnName, String name) {
        if (fnName.getFnNamePath() != null) {
            return fnName.getFnNamePath().size() == 1 && fnName.getFnNamePath().get(0).equalsIgnoreCase(name) || fnName.getFnNamePath().size() == 2 && fnName.getFnNamePath().get(0).equals("_impala_builtins") && fnName.getFnNamePath().get(1).equalsIgnoreCase(name);
        }
        return (fnName.getDb() == null || fnName.getDb().equals("_impala_builtins")) && fnName.getFunction().equalsIgnoreCase(name);
    }

    public static FunctionCallExpr createMergeAggCall(FunctionCallExpr agg, List<Expr> params) {
        Preconditions.checkState((boolean)agg.isAnalyzed());
        Preconditions.checkState((boolean)agg.isAggregateFunction());
        FunctionCallExpr mergeAggInputFn = agg.isMergeAggFn() ? agg.mergeAggInputFn_ : agg;
        FunctionCallExpr result = new FunctionCallExpr(agg.fnName_, new FunctionParams(false, params), mergeAggInputFn);
        result.fn_ = agg.fn_;
        result.type_ = agg.type_;
        result.label_ = agg.isMergeAggFn() ? agg.label_ : agg.toSql().replaceFirst(agg.fnName_.toString(), agg.fnName_.toString() + ":merge");
        Preconditions.checkState((!result.type_.isWildcardDecimal() ? 1 : 0) != 0);
        return result;
    }

    public static boolean isCountStarFunctionCallExpr(Expr expr) {
        if (!(expr instanceof FunctionCallExpr)) {
            return false;
        }
        FunctionCallExpr func = (FunctionCallExpr)expr;
        if (!func.getFnName().getFunction().equalsIgnoreCase("count")) {
            return false;
        }
        if (func.getParams().isStar()) {
            return true;
        }
        if (func.getParams().isDistinct()) {
            return false;
        }
        if (func.getParams().exprs().size() != 1) {
            return false;
        }
        Expr child = (Expr)func.getChild(0);
        if (!Expr.IS_LITERAL.apply((Object)child)) {
            return false;
        }
        return !Expr.IS_NULL_VALUE.apply((Object)child);
    }

    protected FunctionCallExpr(FunctionCallExpr other) {
        super(other);
        this.fnName_ = other.fnName_;
        this.isAnalyticFnCall_ = other.isAnalyticFnCall_;
        this.isInternalFnCall_ = other.isInternalFnCall_;
        FunctionCallExpr functionCallExpr = this.mergeAggInputFn_ = other.mergeAggInputFn_ == null ? null : (FunctionCallExpr)other.mergeAggInputFn_.clone();
        if (other.params_.isStar()) {
            Preconditions.checkState((boolean)this.children_.isEmpty());
            this.params_ = FunctionParams.createStarParam();
        } else {
            this.params_ = new FunctionParams(other.params_.isDistinct(), other.params_.isIgnoreNulls(), this.children_);
        }
        this.label_ = other.label_;
    }

    public boolean isMergeAggFn() {
        return this.mergeAggInputFn_ != null;
    }

    public boolean isBuiltinCastFunction() {
        return this.fnName_.isBuiltin() && this.fnName_.getFunction().startsWith("castto");
    }

    @Override
    public void resetAnalysisState() {
        super.resetAnalysisState();
        if (!this.isMergeAggFn()) {
            this.fn_ = null;
        }
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        FunctionCallExpr o = (FunctionCallExpr)that;
        return this.fnName_.equals(o.fnName_) && this.params_.isDistinct() == o.params_.isDistinct() && this.params_.isIgnoreNulls() == o.params_.isIgnoreNulls() && this.params_.isStar() == o.params_.isStar();
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.fnName_, this.params_.isDistinct(), this.params_.isIgnoreNulls(), this.params_.isStar());
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.label_ != null) {
            return this.label_;
        }
        Preconditions.checkState((!this.isMergeAggFn() ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        sb.append(this.fnName_).append("(");
        if (this.params_.isStar()) {
            sb.append("*");
        }
        if (this.params_.isDistinct()) {
            sb.append("DISTINCT ");
        }
        sb.append(Joiner.on((String)", ").join(this.childrenToSql(options)));
        if (this.params_.isIgnoreNulls()) {
            sb.append(" IGNORE NULLS");
        }
        sb.append(")");
        if (this.fn_ != null && !this.fnName_.isBuiltin()) {
            sb.append(" /* ");
            sb.append((Object)this.fn_.getBinaryType());
            sb.append(" UDF */");
        }
        return sb.toString();
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.fnName_).add("isStar", this.params_.isStar()).add("isDistinct", this.params_.isDistinct()).add("isIgnoreNulls", this.params_.isIgnoreNulls()).addValue((Object)super.debugString()).toString();
    }

    public boolean isScalarFunction() {
        Preconditions.checkNotNull((Object)this.fn_);
        return this.fn_ instanceof ScalarFunction;
    }

    public Type getReturnType() {
        Preconditions.checkNotNull((Object)this.fn_);
        return this.fn_.getReturnType();
    }

    public boolean isAggregateFunction() {
        Preconditions.checkNotNull((Object)this.fn_);
        return this.fn_ instanceof AggregateFunction && !this.isAnalyticFnCall_;
    }

    public boolean isAnalyticFunction() {
        Preconditions.checkNotNull((Object)this.fn_);
        return this.fn_ instanceof AggregateFunction && this.isAnalyticFnCall_;
    }

    public boolean isGroupingBuiltin() {
        return FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "grouping");
    }

    public boolean isGroupingIdBuiltin() {
        return FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "grouping_id");
    }

    public boolean returnsNonNullOnEmpty() {
        Preconditions.checkNotNull((Object)this.fn_);
        return this.fn_ instanceof AggregateFunction && ((AggregateFunction)this.fn_).returnsNonNullOnEmpty();
    }

    public boolean isDistinct() {
        Preconditions.checkState((boolean)this.isAggregateFunction());
        return this.params_.isDistinct();
    }

    public boolean ignoresDistinct() {
        Preconditions.checkState((boolean)this.isAggregateFunction());
        return ((AggregateFunction)this.fn_).ignoresDistinct();
    }

    public FunctionParams getParams() {
        return this.params_;
    }

    public FunctionName getFnName() {
        return this.fnName_;
    }

    public void setIsAnalyticFnCall(boolean v) {
        this.isAnalyticFnCall_ = v;
    }

    public void setIsInternalFnCall(boolean v) {
        this.isInternalFnCall_ = v;
    }

    public boolean isNondeterministicBuiltinFn() {
        return FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "rand") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "random") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "uuid");
    }

    public boolean isConditionalBuiltinFn() {
        return FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "coalesce") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "decode") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "if") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "ifnull") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "isfalse") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "isnotfalse") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "isnottrue") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "isnull") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "istrue") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "nonnullvalue") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "nullif") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "nullifzero") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "nullvalue") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "nvl") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "nvl2") || FunctionCallExpr.functionNameEqualsBuiltin(this.fnName_, "zeroifnull");
    }

    @Override
    protected void toThrift(TExprNode msg) {
        if (this.isAggregateFunction() || this.isAnalyticFnCall_) {
            msg.node_type = TExprNodeType.AGGREGATE_EXPR;
            ArrayList aggFnArgTypes = Lists.newArrayList();
            FunctionCallExpr inputAggFn = this.isMergeAggFn() ? this.mergeAggInputFn_ : this;
            for (Expr child : inputAggFn.children_) {
                aggFnArgTypes.add(child.getType().toThrift());
            }
            msg.setAgg_expr(new TAggregateExpr(this.isMergeAggFn(), aggFnArgTypes));
        } else {
            msg.node_type = TExprNodeType.FUNCTION_CALL;
        }
    }

    @Override
    protected boolean isConstantImpl() {
        if (this.fn_ instanceof AggregateFunction) {
            return false;
        }
        String fnName = this.fnName_.getFunction();
        if (fnName == null) {
            List<String> path = this.fnName_.getFnNamePath();
            fnName = path.get(path.size() - 1);
        }
        if (this.isNondeterministicBuiltinFn()) {
            return false;
        }
        if (fnName.equalsIgnoreCase("sleep")) {
            return false;
        }
        return super.isConstantImpl();
    }

    protected String getFunctionNotFoundError(Type[] argTypes) {
        if (this.fnName_.isBuiltin()) {
            if (this.params_.isStar()) {
                return "'*' can only be used in conjunction with COUNT";
            }
            if (this.fnName_.getFunction().equalsIgnoreCase("count") && !this.params_.isDistinct() && argTypes.length > 1) {
                return "COUNT must have DISTINCT for multiple arguments: " + this.toSql();
            }
            if (this.fnName_.getFunction().equalsIgnoreCase("sum")) {
                return "SUM requires a numeric parameter: " + this.toSql();
            }
            if (this.fnName_.getFunction().equalsIgnoreCase("avg")) {
                return "AVG requires a numeric or timestamp parameter: " + this.toSql();
            }
        }
        Object[] argTypesSql = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypesSql[i] = argTypes[i].toSql();
        }
        return String.format("No matching function with signature: %s(%s).", this.fnName_, this.params_.isStar() ? "*" : Joiner.on((String)", ").join(argTypesSql));
    }

    private Type resolveDecimalReturnType(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)this.type_.isWildcardDecimal());
        Preconditions.checkState((this.fn_.getBinaryType() == TFunctionBinaryType.BUILTIN ? 1 : 0) != 0);
        Preconditions.checkState((this.children_.size() > 0 ? 1 : 0) != 0);
        ScalarType childType = null;
        for (Expr child : this.children_) {
            if (!child.type_.isDecimal()) continue;
            childType = (ScalarType)child.type_;
            break;
        }
        Preconditions.checkState((childType != null && !childType.isWildcardDecimal() ? 1 : 0) != 0);
        ScalarType returnType = childType;
        if (this.fnName_.getFunction().equalsIgnoreCase("sum")) {
            return childType.getMaxResolutionType();
        }
        int digitsBefore = childType.decimalPrecision() - childType.decimalScale();
        int digitsAfter = childType.decimalScale();
        if (this.fnName_.getFunction().equalsIgnoreCase("avg") && analyzer.getQueryOptions().isDecimal_v2()) {
            int resultScale = Math.max(6, digitsAfter);
            int resultPrecision = digitsBefore + resultScale;
            return ScalarType.createAdjustedDecimalType(resultPrecision, resultScale);
        }
        if (this.fnName_.getFunction().equalsIgnoreCase("ceil") || this.fnName_.getFunction().equalsIgnoreCase("ceiling") || this.fnName_.getFunction().equals("floor") || this.fnName_.getFunction().equals("dfloor")) {
            ++digitsBefore;
            digitsAfter = 0;
        } else if (this.fnName_.getFunction().equalsIgnoreCase("truncate") || this.fnName_.getFunction().equalsIgnoreCase("dtrunc") || this.fnName_.getFunction().equalsIgnoreCase("trunc") || this.fnName_.getFunction().equalsIgnoreCase("round") || this.fnName_.getFunction().equalsIgnoreCase("dround")) {
            if (this.children_.size() > 1) {
                Preconditions.checkState((this.children_.size() == 2 ? 1 : 0) != 0);
                if (IS_NULL_VALUE.apply(this.children_.get(1))) {
                    throw new AnalysisException(this.fnName_.getFunction() + "() cannot be called with a NULL second argument.");
                }
                if (!((Expr)this.children_.get(1)).isConstant()) {
                    throw new AnalysisException(this.fnName_.getFunction() + "() must be called with a constant second argument.");
                }
                NumericLiteral scaleLiteral = (NumericLiteral)LiteralExpr.create((Expr)this.children_.get(1), analyzer.getQueryCtx());
                Preconditions.checkState(((digitsAfter = Math.min(digitsAfter, (int)scaleLiteral.getLongValue())) <= 38 ? 1 : 0) != 0);
                digitsAfter = Math.max(digitsAfter, 0);
            } else {
                digitsAfter = 0;
            }
            if ((this.fnName_.getFunction().equalsIgnoreCase("round") || this.fnName_.getFunction().equalsIgnoreCase("dround")) && digitsAfter < childType.decimalScale()) {
                ++digitsBefore;
            }
        }
        Preconditions.checkState((returnType.isDecimal() && !((Type)returnType).isWildcardDecimal() ? 1 : 0) != 0);
        if (analyzer.isDecimalV2()) {
            if (digitsBefore + digitsAfter > 38) {
                return Type.INVALID;
            }
            return ScalarType.createDecimalType(digitsBefore + digitsAfter, digitsAfter);
        }
        return ScalarType.createClippedDecimalType(digitsBefore + digitsAfter, digitsAfter);
    }

    private int ComputeHllLengthFromScale(int scale) {
        return 1 << scale + 8;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Function searchDesc;
        this.fnName_.analyze(analyzer);
        if (!this.fnName_.isBuiltin()) {
            FrontendProfile profile = FrontendProfile.getCurrentOrNull();
            if (profile != null) {
                String udfInfoStringKey = "User Defined Functions (UDFs)";
                String functionName = this.fnName_.toString();
                if (!profile.getInfoString(udfInfoStringKey).contains(functionName)) {
                    profile.appendInfoString(udfInfoStringKey, functionName);
                }
            }
            analyzer.registerPrivReq(builder -> builder.allOf(Privilege.SELECT).onFunction(this.fnName_.getDb(), this.fnName_.getFunction()).build());
        }
        if (this.isMergeAggFn()) {
            AggregateFunction aggFn = (AggregateFunction)this.fn_;
            Preconditions.checkNotNull((Object)aggFn);
            Type intermediateType = aggFn.getIntermediateType();
            if (intermediateType == null) {
                intermediateType = this.type_;
            }
            Preconditions.checkState((!this.type_.isWildcardDecimal() ? 1 : 0) != 0);
            return;
        }
        FeDb db = analyzer.getDb(this.fnName_.getDb(), Privilege.VIEW_METADATA, true);
        if (!db.containsFunction(this.fnName_.getFunction())) {
            throw new AnalysisException(this.fnName_ + "() unknown for database " + db.getName() + ". Currently this db has " + db.numFunctions() + " functions.");
        }
        if (this.isBuiltinCastFunction()) {
            throw new AnalysisException(this.toSql() + " is reserved for internal use only. Use 'cast(expr AS type)' instead.");
        }
        if (this.fnName_.getFunction().equals("count") && this.params_.isDistinct()) {
            searchDesc = new Function(this.fnName_, new Type[0], (Type)Type.INVALID, false);
            this.fn_ = db.getFunction(searchDesc, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            this.type_ = this.fn_.getReturnType();
            for (int i = 0; i < this.children_.size(); ++i) {
                if (!((Expr)this.getChild(i)).getType().isNull()) continue;
                this.uncheckedCastChild(ScalarType.BOOLEAN, i);
            }
            return;
        }
        if (this.isGroupingIdBuiltin()) {
            searchDesc = new Function(this.fnName_, new Type[0], (Type)Type.INVALID, false);
            this.fn_ = db.getFunction(searchDesc, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            this.type_ = this.fn_.getReturnType();
            return;
        }
        if (this.fnName_.getFunction().equalsIgnoreCase("avg") && this.children_.size() == 1 && ((Expr)this.children_.get(0)).getType().isStringType()) {
            throw new AnalysisException("AVG requires a numeric or timestamp parameter: " + this.toSql());
        }
        if (this.fnName_.getFunction().equalsIgnoreCase("sampled_ndv") && this.children_.size() == 2) {
            if (!(this.children_.get(1) instanceof NumericLiteral)) {
                throw new AnalysisException("Second parameter of SAMPLED_NDV() must be a numeric literal in [0,1]: " + ((Expr)this.children_.get(1)).toSql());
            }
            NumericLiteral samplePerc = (NumericLiteral)this.children_.get(1);
            if (samplePerc.getDoubleValue() < 0.0 || samplePerc.getDoubleValue() > 1.0) {
                throw new AnalysisException("Second parameter of SAMPLED_NDV() must be a numeric literal in [0,1]: " + samplePerc.toSql());
            }
            this.children_.set(1, samplePerc.uncheckedCastTo(Type.DOUBLE));
        }
        Type[] argTypes = this.collectChildReturnTypes();
        Function searchDesc2 = new Function(this.fnName_, argTypes, (Type)Type.INVALID, false);
        this.fn_ = db.getFunction(searchDesc2, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        if (this.fn_ == null || !this.isInternalFnCall_ && !this.fn_.userVisible()) {
            throw new AnalysisException(this.getFunctionNotFoundError(argTypes));
        }
        if (this.fnName_.getFunction().equalsIgnoreCase("ndv") && this.children_.size() == 2) {
            if (!(this.children_.get(1) instanceof NumericLiteral)) {
                throw new AnalysisException("Second parameter of NDV() must be an integer literal: " + ((Expr)this.children_.get(1)).toSql());
            }
            NumericLiteral scale = (NumericLiteral)this.children_.get(1);
            if (scale.getValue().scale() != 0 || !NumericLiteral.fitsInInt(scale.getValue()) || scale.getIntValue() < 1 || scale.getIntValue() > 10) {
                throw new AnalysisException("Second parameter of NDV() must be an integer literal in [1,10]: " + scale.toSql());
            }
            this.children_.set(1, scale.uncheckedCastTo(Type.INT));
            BuiltinsDb builtinDb = (BuiltinsDb)db;
            int size = this.ComputeHllLengthFromScale(scale.getIntValue());
            this.fn_ = builtinDb.resolveNdvIntermediateType((AggregateFunction)this.fn_, size);
            if (this.fn_ == null) {
                throw new AnalysisException("A suitable intermediate data type cannot be found for the second parameter " + ((Expr)this.children_.get(1)).toSql() + " in NDV()");
            }
        }
        if (this.isAggregateFunction()) {
            AggregateFunction aggFn;
            if (TreeNode.contains(this.children_, Expr.IS_AGGREGATE)) {
                throw new AnalysisException("aggregate function must not contain aggregate parameters: " + this.toSql());
            }
            if (Expr.contains(this.children_, AnalyticExpr.class)) {
                throw new AnalysisException("aggregate function must not contain analytic parameters: " + this.toSql());
            }
            if (this.fnName_.getFunction().equalsIgnoreCase("count") && !this.params_.isStar() && this.children_.size() == 0) {
                throw new AnalysisException("count() is not allowed.");
            }
            if (this.params_.isDistinct()) {
                if (this.fnName_.getFunction().equalsIgnoreCase("group_concat") && this.getChildren().size() == 2 && !((Expr)this.getChild(1)).isConstant()) {
                    throw new AnalysisException("Second parameter in GROUP_CONCAT(DISTINCT) must be a constant expression that returns a string.");
                }
                if (this.fn_.getBinaryType() != TFunctionBinaryType.BUILTIN) {
                    throw new AnalysisException("User defined aggregates do not support DISTINCT.");
                }
            }
            if ((aggFn = (AggregateFunction)this.fn_).ignoresDistinct()) {
                this.params_.setIsDistinct(false);
            }
            if (aggFn.isUnsupported()) {
                throw new AnalysisException(this.getFunctionNotFoundError(argTypes));
            }
        }
        if (this.params_.isIgnoreNulls() && !this.isAnalyticFnCall_) {
            throw new AnalysisException("Function " + this.fnName_.getFunction().toUpperCase() + " does not accept the keyword IGNORE NULLS.");
        }
        if (this.isScalarFunction()) {
            FunctionCallExpr.validateScalarFnParams(this.params_);
        }
        if (this.fn_ instanceof AggregateFunction && ((AggregateFunction)this.fn_).isAnalyticFn() && !((AggregateFunction)this.fn_).isAggregateFn() && !this.isAnalyticFnCall_) {
            throw new AnalysisException("Analytic function requires an OVER clause: " + this.toSql());
        }
        this.castForFunctionCall(false, analyzer.getRegularCompatibilityLevel());
        this.type_ = this.fn_.getReturnType();
        if (this.type_.isDecimal() && this.type_.isWildcardDecimal()) {
            this.type_ = this.resolveDecimalReturnType(analyzer);
        }
        if (this.type_.isWildcardChar() || this.type_.isWildcardVarchar()) {
            this.type_ = ScalarType.STRING;
        }
    }

    @Override
    protected float computeEvalCost() {
        return this.hasChildCosts() ? this.getChildCosts() + 10.0f : -1.0f;
    }

    public FunctionCallExpr getMergeAggInputFn() {
        return this.mergeAggInputFn_;
    }

    public void setMergeAggInputFn(FunctionCallExpr fn) {
        this.mergeAggInputFn_ = fn;
    }

    static void validateScalarFnParams(FunctionParams params) throws AnalysisException {
        if (params.isStar()) {
            throw new AnalysisException("Cannot pass '*' to scalar function.");
        }
        if (params.isDistinct()) {
            throw new AnalysisException("Cannot pass 'DISTINCT' to scalar function.");
        }
    }

    void validateMergeAggFn(FunctionCallExpr inputAggFn) {
        Preconditions.checkState((boolean)this.isMergeAggFn());
        List copiedInputExprs = this.mergeAggInputFn_.getChildren();
        List inputExprs = inputAggFn.isMergeAggFn() ? inputAggFn.mergeAggInputFn_.getChildren() : inputAggFn.getChildren();
        Preconditions.checkState((copiedInputExprs.size() == inputExprs.size() ? 1 : 0) != 0);
        for (int i = 0; i < inputExprs.size(); ++i) {
            Type copiedInputType = ((Expr)copiedInputExprs.get(i)).getType();
            Type inputType = ((Expr)inputExprs.get(i)).getType();
            Preconditions.checkState((boolean)copiedInputType.equals(inputType), (Object)String.format("Copied expr %s arg type %s differs from input expr type %s in original expr %s", this.toSql(), copiedInputType.toSql(), inputType.toSql(), inputAggFn.toSql()));
        }
    }

    @Override
    public Expr clone() {
        return new FunctionCallExpr(this);
    }

    protected FunctionCallExpr cloneWithNewParams(FunctionParams params) {
        return new FunctionCallExpr(this.getFnName(), params);
    }

    @Override
    protected Expr substituteImpl(ExprSubstitutionMap smap, Analyzer analyzer) {
        Expr e = super.substituteImpl(smap, analyzer);
        if (!(e instanceof FunctionCallExpr)) {
            return e;
        }
        FunctionCallExpr fn = (FunctionCallExpr)e;
        FunctionCallExpr mergeFn = fn.getMergeAggInputFn();
        if (mergeFn != null) {
            Expr substitutedFn = mergeFn.substitute(smap, analyzer, true);
            Preconditions.checkState((boolean)(substitutedFn instanceof FunctionCallExpr));
            fn.setMergeAggInputFn((FunctionCallExpr)substitutedFn);
        }
        return e;
    }

    public boolean isBuiltinMathScalarFunction() {
        return this.fnName_.isBuiltin() && builtinMathScalarFunctionNames_.contains(this.fnName_.getFunction());
    }

    private boolean lookupShouldConvertToCNF() {
        if (this.isBuiltinCastFunction() || this.isBuiltinMathScalarFunction()) {
            for (int i = 0; i < this.children_.size(); ++i) {
                if (((Expr)this.getChild(i)).shouldConvertToCNF()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldConvertToCNF() {
        if (this.shouldConvertToCNF_.isPresent()) {
            return this.shouldConvertToCNF_.get();
        }
        boolean result = this.lookupShouldConvertToCNF();
        this.shouldConvertToCNF_ = Optional.of(result);
        return result;
    }
}

